/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class EnvironmentVariables {
    private Properties variables = new Properties();
    private Map nameMap = new HashMap();

    public EnvironmentVariables() throws IOException {
        this.retrieveEnvironmentVariables();
    }

    public boolean containsVariable(String name) {
        return this.getVariable(name) != null;
    }

    public String[] convertToStrings() {
        String[] strings = new String[this.variables.size()];
        int index = 0;
        Iterator<Map.Entry<Object, Object>> entries = this.variables.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<Object, Object> entry = entries.next();
            strings[index++] = entry.getKey() + "=" + entry.getValue();
        }
        return strings;
    }

    public String getVariable(String name) {
        String caseSpecificName = (String)this.nameMap.get(name.toUpperCase());
        return caseSpecificName == null ? null : (String)this.variables.get(caseSpecificName);
    }

    public void setVariable(String name, String value) {
        String caseSpecificName = (String)this.nameMap.get(name.toUpperCase());
        if (caseSpecificName == null) {
            caseSpecificName = name;
            this.nameMap.put(caseSpecificName, caseSpecificName);
        }
        this.variables.setProperty(caseSpecificName, value);
    }

    private void retrieveEnvironmentVariables() throws IOException {
        String envVarsCommand = this.getEnvironmentVariablesCommand();
        Process process = Runtime.getRuntime().exec(envVarsCommand);
        InputStreamReader isr = new InputStreamReader(process.getInputStream());
        BufferedReader br = new BufferedReader(isr);
        String line = null;
        while ((line = br.readLine()) != null) {
            int equalsIndex = line.indexOf(61);
            if (equalsIndex == -1) continue;
            String key = line.substring(0, equalsIndex);
            String value = line.substring(equalsIndex + 1);
            this.variables.setProperty(key, value);
            this.nameMap.put(key.toUpperCase(), key);
        }
    }

    private String getEnvironmentVariablesCommand() {
        String command = null;
        String os = System.getProperty("os.name").toLowerCase();
        command = os.indexOf("windows 9") > -1 ? "command.com /c set" : (os.indexOf("nt") > -1 || os.indexOf("windows 2000") > -1 || os.indexOf("windows xp") > -1 ? "cmd.exe /c set" : "env");
        return command;
    }
}

