/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.utils;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class EntryTrackingJarOutputStream
extends JarOutputStream {
    private Set addedEntryNames = new HashSet();

    public EntryTrackingJarOutputStream(OutputStream out) throws IOException {
        super(out);
    }

    public EntryTrackingJarOutputStream(OutputStream out, Manifest man) throws IOException {
        super(out);
        this.addManifest(man);
    }

    public boolean alreadyAdded(ZipEntry ze) {
        return this.addedEntryNames.contains(ze.getName());
    }

    public void putNextEntry(ZipEntry ze) throws IOException {
        super.putNextEntry(ze);
        this.addedEntryNames.add(ze.getName());
    }

    private void addManifest(Manifest man) throws IOException {
        if (man == null) {
            throw new NullPointerException("man");
        }
        ZipEntry e = new ZipEntry("META-INF/MANIFEST.MF");
        this.putNextEntry(e);
        man.write(new BufferedOutputStream(this));
        this.closeEntry();
    }
}

