/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.wizards;

import eclipseme.EclipseMEPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class NewMidletWizardPage
extends NewTypeWizardPage {
    public static final String PAGE_NAME = "NewMidletClass";
    private static final String SETTINGS_ADD_TO_JAD = "addToJad";
    private static final String SETTINGS_CONSTRUCTORS = "constructors";
    private static final String SETTINGS_UNIMPLEMENTED = "unimplemented";
    private Button addToJadButton;
    private Button constructorsButton;
    private Button unimplementedButton;

    public NewMidletWizardPage() {
        super(true, PAGE_NAME);
        this.setTitle(EclipseMEPlugin.getResourceString("wiz.newmidlet.title"));
        this.setDescription(EclipseMEPlugin.getResourceString("wiz.newmidlet.description"));
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createEnclosingTypeControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.createSuperInterfacesControls(composite, nColumns);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.createAddToJADSelectionControl(composite, nColumns);
        boolean addToJad = true;
        boolean constructors = true;
        boolean unimplemented = true;
        IDialogSettings section = this.getDialogSettings().getSection(PAGE_NAME);
        if (section != null) {
            addToJad = section.getBoolean(SETTINGS_ADD_TO_JAD);
            constructors = section.getBoolean(SETTINGS_CONSTRUCTORS);
            unimplemented = section.getBoolean(SETTINGS_UNIMPLEMENTED);
        }
        this.addToJadButton.setSelection(addToJad);
        this.constructorsButton.setSelection(constructors);
        this.unimplementedButton.setSelection(unimplemented);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public void init(IStructuredSelection selection) {
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
        this.setSuperClass("javax.microedition.midlet.MIDlet", true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    boolean isAddToJadSelected() {
        return this.addToJadButton.getSelection();
    }

    protected void createTypeMembers(IType newType, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.createInheritedMethods(newType, this.constructorsButton.getSelection(), this.unimplementedButton.getSelection(), imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        IDialogSettings section = this.getDialogSettings().getSection(PAGE_NAME);
        if (section == null) {
            section = this.getDialogSettings().addNewSection(PAGE_NAME);
        }
        section.put(SETTINGS_ADD_TO_JAD, this.addToJadButton.getSelection());
        section.put(SETTINGS_CONSTRUCTORS, this.constructorsButton.getSelection());
        section.put(SETTINGS_UNIMPLEMENTED, this.unimplementedButton.getSelection());
    }

    private void createAddToJADSelectionControl(Composite parent, int numColumns) {
        new Label(parent, 0);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = numColumns - 1;
        composite.setLayoutData((Object)gridData);
        this.addToJadButton = new Button(composite, 32);
        this.addToJadButton.setText("Add To Application Descriptor?");
    }

    private void createMethodStubSelectionControls(Composite parent, int numColumns) {
        new Label(parent, 0);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = numColumns - 1;
        composite.setLayoutData((Object)gridData);
        Label l = new Label(composite, 0);
        l.setText(EclipseMEPlugin.getResourceString("wiz.newmidlet.which_methods"));
        this.constructorsButton = new Button(composite, 32);
        this.constructorsButton.setText(EclipseMEPlugin.getResourceString("wiz.newmidlet.super_const"));
        this.constructorsButton.setSelection(true);
        this.unimplementedButton = new Button(composite, 32);
        this.unimplementedButton.setText(EclipseMEPlugin.getResourceString("wiz.newmidlet.unimplemented"));
        this.unimplementedButton.setSelection(true);
    }
}

