/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.view.platformcomponents;

import eclipseme.EclipseMEPlugin;
import eclipseme.model.IWirelessToolkit;
import eclipseme.model.IWirelessToolkitType;
import eclipseme.model.InvalidWirelessToolkitException;
import eclipseme.ui.utils.PlatformComponentAction;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class AddWirelessToolkitAction
extends PlatformComponentAction {
    private static final String ADD_TOOLKIT_PAGE = "page.toolkit.add";

    public AddWirelessToolkitAction() {
        super("Add Wireless Toolkit");
    }

    public void run() {
        WizardDialog wd = new WizardDialog(null, (IWizard)new AddWirelessToolkitWizard());
        wd.create();
        wd.open();
    }

    private class AddWirelessToolkitWizardPage
    extends WizardPage {
        private Text toolkitDir;
        private Label toolkitLabel;

        protected AddWirelessToolkitWizardPage() {
            super(AddWirelessToolkitAction.ADD_TOOLKIT_PAGE, "Wireless Toolkit Directory", null);
            this.setDescription("Specify the root directory of the wireless toolkit");
        }

        public void createControl(Composite parent) {
            Composite grid = new Composite(parent, 0);
            grid.setLayout((Layout)new GridLayout(2, false));
            this.setControl((Control)grid);
            Label text = new Label(grid, 0);
            text.setText("Wireless Toolkit Directory");
            new Label(grid, 0);
            this.toolkitDir = new Text(grid, 2048);
            this.toolkitDir.setLayoutData((Object)new GridData(768));
            this.toolkitDir.addKeyListener((KeyListener)new KeyAdapter(this){
                final /* synthetic */ AddWirelessToolkitWizardPage this$1;
                {
                    this.this$1 = addWirelessToolkitWizardPage;
                }

                public void keyReleased(KeyEvent event) {
                    AddWirelessToolkitWizardPage.access$0(this.this$1);
                }
            });
            Button browseButton = new Button(grid, 0);
            browseButton.setText("Browse...");
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ AddWirelessToolkitWizardPage this$1;
                {
                    this.this$1 = addWirelessToolkitWizardPage;
                }

                public void widgetSelected(SelectionEvent evt) {
                    String newValue = AddWirelessToolkitWizardPage.access$1(this.this$1);
                    if (newValue != null) {
                        AddWirelessToolkitWizardPage.access$2(this.this$1).setText(newValue);
                        AddWirelessToolkitWizardPage.access$0(this.this$1);
                    }
                }
            });
            this.toolkitLabel = new Label(grid, 0);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            this.toolkitLabel.setLayoutData((Object)gridData);
        }

        File getToolkitDirectory() {
            return new File(this.toolkitDir.getText());
        }

        private String browsePressed() {
            File d;
            File f = new File(this.toolkitDir.getText());
            if (!f.exists()) {
                f = null;
            }
            if ((d = this.getDirectory(f)) == null) {
                return null;
            }
            return d.getAbsolutePath();
        }

        private File getDirectory(File startingDirectory) {
            String dir;
            DirectoryDialog fileDialog = new DirectoryDialog(this.getShell(), 4096);
            if (startingDirectory != null) {
                fileDialog.setFilterPath(startingDirectory.getPath());
            }
            if ((dir = fileDialog.open()) != null && (dir = dir.trim()).length() > 0) {
                return new File(dir);
            }
            return null;
        }

        private void updateStatus() {
            File root = new File(this.toolkitDir.getText());
            IWirelessToolkitType handler = EclipseMEPlugin.findToolkitType(root);
            String errorMessage = handler == null ? "Invalid wireless toolkit root" : null;
            this.setErrorMessage(errorMessage);
            this.setPageComplete(errorMessage == null);
            String toolkitLabelText = handler == null ? "" : handler.getName();
            this.toolkitLabel.setText(toolkitLabelText);
        }

        static /* synthetic */ void access$0(AddWirelessToolkitWizardPage addWirelessToolkitWizardPage) {
            addWirelessToolkitWizardPage.updateStatus();
        }

        static /* synthetic */ String access$1(AddWirelessToolkitWizardPage addWirelessToolkitWizardPage) {
            return addWirelessToolkitWizardPage.browsePressed();
        }

        static /* synthetic */ Text access$2(AddWirelessToolkitWizardPage addWirelessToolkitWizardPage) {
            return addWirelessToolkitWizardPage.toolkitDir;
        }
    }

    private class AddWirelessToolkitWizard
    extends Wizard {
        private AddWirelessToolkitWizardPage addPage;

        public AddWirelessToolkitWizard() {
            this.addPage = new AddWirelessToolkitWizardPage();
            this.addPage((IWizardPage)this.addPage);
            this.setWindowTitle("Add Wireless Toolkit");
        }

        public boolean performFinish() {
            boolean finished = false;
            NullProgressMonitor progressMonitor = new NullProgressMonitor();
            try {
                File toolkitRoot = this.addPage.getToolkitDirectory();
                IWirelessToolkitType type = EclipseMEPlugin.findToolkitType(toolkitRoot);
                IWirelessToolkit toolkit = type.createToolkit(toolkitRoot, (IProgressMonitor)progressMonitor);
                AddWirelessToolkitAction.this.getRegistry().add(toolkit);
                finished = AddWirelessToolkitAction.this.updateComponentsStore((IProgressMonitor)progressMonitor);
            }
            catch (InvalidWirelessToolkitException e) {
                EclipseMEPlugin.log(2, "performFinish", e);
            }
            return finished;
        }
    }
}

