/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.utils;

import eclipseme.EclipseMEPlugin;
import eclipseme.model.persistence.PersistenceException;
import eclipseme.model.persistence.PlatformComponentsStore;
import eclipseme.model.registry.PlatformComponentRegistry;
import eclipseme.ui.utils.ITreeNode;
import java.io.IOException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractTreeNode
implements ITreeNode {
    private ITreeNode parent;
    private ITreeNode[] children;

    public AbstractTreeNode() {
        this(null);
    }

    public AbstractTreeNode(ITreeNode parent) {
        this.parent = parent;
    }

    public Action[] getActions() {
        return null;
    }

    public ITreeNode[] getChildren() {
        if (this.children == null) {
            this.children = this.calculateChildren();
        }
        return this.children;
    }

    public Image getImage() {
        return null;
    }

    public ITreeNode getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    protected abstract ITreeNode[] calculateChildren();

    protected PlatformComponentRegistry getRegistry() {
        return PlatformComponentRegistry.getInstance();
    }

    protected boolean updateComponentsStore(IProgressMonitor monitor) {
        boolean successful = false;
        try {
            PlatformComponentsStore.getInstance().storeComponents(monitor);
            successful = true;
        }
        catch (IOException e) {
            EclipseMEPlugin.log(2, "updateComponentsStore", e);
        }
        catch (PersistenceException e) {
            EclipseMEPlugin.log(2, "updateComponentsStore", e);
        }
        catch (TransformerException e) {
            EclipseMEPlugin.log(2, "updateComponentsStore", e);
        }
        return successful;
    }
}

