/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.editor.jad;

import eclipseme.EclipseMEPlugin;
import eclipseme.ui.editor.jad.JADMidletsEditorPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class NewMidletDialog
extends Dialog {
    private static final String PLUGIN_ID = "eclipseme";
    private static final IStatus OK = new Status(0, "eclipseme", 0, "", null);
    private static final IStatus ERROR = new Status(0, "eclipseme", 0, "", null);
    private IProject project;
    private Text nameText;
    private Text iconText;
    private Text classText;
    private JADMidletsEditorPage.MidletDefinition midletDefinition;

    public NewMidletDialog(Shell parentShell, IProject project) {
        super(parentShell);
        this.project = project;
    }

    public JADMidletsEditorPage.MidletDefinition getMidletDefinition() {
        return this.midletDefinition;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(EclipseMEPlugin.getResourceString("dialog.newmidlet.title"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(EclipseMEPlugin.getResourceString("property.jad.midlet.name"));
        this.nameText = new Text(composite, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        this.nameText.setLayoutData((Object)gridData);
        Label spacer = new Label(composite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        spacer.setLayoutData((Object)gridData);
        Label iconLabel = new Label(composite, 0);
        iconLabel.setText(EclipseMEPlugin.getResourceString("property.jad.midlet.icon"));
        this.iconText = new Text(composite, 2048);
        this.iconText.setLayoutData((Object)new GridData(768));
        Composite box = new Composite(composite, 0);
        box.setLayout((Layout)new GridLayout(1, false));
        Button iconBrowseButton = new Button(box, 0);
        iconBrowseButton.setText(EclipseMEPlugin.getResourceString("property.jad.midlet.icon_browse"));
        iconBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewMidletDialog.this.promptForIcon();
            }
        });
        spacer = new Label(composite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        spacer.setLayoutData((Object)gridData);
        Label classLabel = new Label(composite, 0);
        classLabel.setText(EclipseMEPlugin.getResourceString("property.jad.midlet.class"));
        this.classText = new Text(composite, 2048);
        this.classText.setLayoutData((Object)new GridData(768));
        Composite vBox = new Composite(composite, 0);
        vBox.setLayout((Layout)new GridLayout(1, false));
        Button classBrowseButton = new Button(vBox, 0);
        classBrowseButton.setText(EclipseMEPlugin.getResourceString("property.jad.midlet.class_browse"));
        Button classCreateButton = new Button(vBox, 0);
        classCreateButton.setEnabled(false);
        classCreateButton.setText(EclipseMEPlugin.getResourceString("property.jad.midlet.new_class"));
        return composite;
    }

    protected void okPressed() {
        this.midletDefinition = new JADMidletsEditorPage.MidletDefinition(this.nameText.getText(), this.iconText.getText(), this.classText.getText());
        super.okPressed();
    }

    private boolean isPNGFile(Object element) {
        return element instanceof IFile && ((IFile)element).getFileExtension().equals("png");
    }

    private void promptForIcon() {
        String title = EclipseMEPlugin.getResourceString("property.jad.midlet.browse_dialog_title");
        String message = EclipseMEPlugin.getResourceString("property.jad.midlet.browse_dialog_message");
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setAllowMultiple(false);
        dialog.setValidator((ISelectionStatusValidator)new IconFileValidator());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter((ViewerFilter)new IconViewerFilter());
        dialog.setInput((Object)this.project);
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            int i = 0;
            while (i < elements.length) {
                IFile file = (IFile)elements[i];
                this.iconText.setText(file.getFullPath().toString());
                ++i;
            }
        }
    }

    private class IconFileValidator
    implements ISelectionStatusValidator {
        IconFileValidator() {
        }

        public IStatus validate(Object[] selection) {
            return selection.length == 1 && NewMidletDialog.this.isPNGFile(selection[0]) ? OK : ERROR;
        }
    }

    private class IconViewerFilter
    extends ViewerFilter {
        IconViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return NewMidletDialog.this.isPNGFile(element) || element instanceof IContainer;
        }
    }
}

