/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.registry;

import eclipseme.model.IConfiguration;
import eclipseme.model.IPlatformComponent;
import eclipseme.model.IPlatformDefinition;
import eclipseme.model.IProfile;
import eclipseme.model.IWirelessToolkit;
import eclipseme.model.impl.generic.UnspecifiedPlatformDefinition;
import eclipseme.model.registry.IRegistryUpdateListener;
import eclipseme.model.registry.RegistryUpdateEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PlatformComponentRegistry {
    private static final PlatformComponentRegistry instance = new PlatformComponentRegistry();
    private Map configurationRegistry;
    private Map platformDefinitionRegistry;
    private Map profileRegistry;
    private Map wirelessToolkitRegistry;
    private ArrayList updateListeners = new ArrayList();

    public static PlatformComponentRegistry getInstance() {
        return instance;
    }

    private PlatformComponentRegistry() {
        this.configurationRegistry = new HashMap();
        this.platformDefinitionRegistry = new HashMap();
        this.profileRegistry = new HashMap();
        this.wirelessToolkitRegistry = new HashMap();
    }

    public void add(IConfiguration configuration) {
        this.configurationRegistry.put(configuration.getName(), configuration);
        this.fireComponentAddedEvent(configuration);
    }

    public void add(IPlatformDefinition platformDefinition) {
        this.platformDefinitionRegistry.put(platformDefinition.getName(), platformDefinition);
        this.fireComponentAddedEvent(platformDefinition);
    }

    public void add(IProfile profile) {
        this.profileRegistry.put(profile.getName(), profile);
        this.fireComponentAddedEvent(profile);
    }

    public void add(IWirelessToolkit toolkit) {
        this.wirelessToolkitRegistry.put(toolkit.getName(), toolkit);
        this.fireComponentAddedEvent(toolkit);
    }

    public void addUpdateListener(IRegistryUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    public IConfiguration getConfiguration(String name) {
        return (IConfiguration)this.configurationRegistry.get(name);
    }

    public IPlatformDefinition getPlatformDefinition(String name) {
        IPlatformDefinition platformDef = (IPlatformDefinition)this.platformDefinitionRegistry.get(name);
        if (platformDef == null) {
            platformDef = UnspecifiedPlatformDefinition.singleton;
        }
        return platformDef;
    }

    public IProfile getProfile(String name) {
        return (IProfile)this.profileRegistry.get(name);
    }

    public Iterator getRegisteredConfigurations() {
        return this.configurationRegistry.values().iterator();
    }

    public Iterator getRegisteredPlatformDefinitions() {
        return this.platformDefinitionRegistry.values().iterator();
    }

    public Iterator getRegisteredProfiles() {
        return this.profileRegistry.values().iterator();
    }

    public Iterator getRegisteredWirelessToolkits() {
        return this.wirelessToolkitRegistry.values().iterator();
    }

    public IWirelessToolkit getWirelessToolkit(String name) {
        return (IWirelessToolkit)this.wirelessToolkitRegistry.get(name);
    }

    public boolean isConfigurationRegistered(String name) {
        return this.configurationRegistry.containsKey(name);
    }

    public boolean isPlatformDefinitionRegistered(String name) {
        return this.platformDefinitionRegistry.containsKey(name);
    }

    public boolean isProfileRegistered(String name) {
        return this.profileRegistry.containsKey(name);
    }

    public boolean isWirelessToolkitRegistered(String name) {
        return this.wirelessToolkitRegistry.containsKey(name);
    }

    public void removeUpdateListener(IRegistryUpdateListener listener) {
        this.updateListeners.remove(listener);
    }

    public void remove(IConfiguration configuration) {
        this.configurationRegistry.remove(configuration.getName());
        this.fireComponentRemovedEvent(configuration);
    }

    public void remove(IPlatformDefinition platformDefinition) {
        this.platformDefinitionRegistry.remove(platformDefinition.getName());
        this.fireComponentRemovedEvent(platformDefinition);
    }

    public void remove(IProfile profile) {
        this.profileRegistry.remove(profile.getName());
        this.fireComponentRemovedEvent(profile);
    }

    public void remove(IWirelessToolkit toolkit) {
        this.wirelessToolkitRegistry.remove(toolkit.getName());
        this.fireComponentRemovedEvent(toolkit);
    }

    protected void fireComponentAddedEvent(IPlatformComponent component) {
        if (this.updateListeners.size() > 0) {
            RegistryUpdateEvent event = new RegistryUpdateEvent(this, component);
            Iterator iterator = this.updateListeners.iterator();
            while (iterator.hasNext()) {
                IRegistryUpdateListener listener = (IRegistryUpdateListener)iterator.next();
                listener.componentAdded(event);
            }
        }
    }

    protected void fireComponentRemovedEvent(IPlatformComponent component) {
        if (this.updateListeners.size() > 0) {
            RegistryUpdateEvent event = new RegistryUpdateEvent(this, component);
            Iterator iterator = this.updateListeners.iterator();
            while (iterator.hasNext()) {
                IRegistryUpdateListener listener = (IRegistryUpdateListener)iterator.next();
                listener.componentRemoved(event);
            }
        }
    }
}

