/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.impl.se;

import eclipseme.EclipseMEPlugin;
import eclipseme.model.IWirelessToolkit;
import eclipseme.model.InvalidWirelessToolkitException;
import eclipseme.model.impl.se.SonyEricssonWTK;
import eclipseme.model.impl.sun.AbstractSunWirelessToolkitType;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;

public class SonyEricssonWTKType
extends AbstractSunWirelessToolkitType {
    static final String WTK1_VERSION_STRING = "Sony Ericsson J2ME SDK (WTK 1.0.4)";
    static final String WTK20_VERSION_STRING = "Sony Ericsson J2ME SDK (WTK 2.0)";
    static final String WTK21_VERSION_STRING = "Sony Ericsson J2ME SDK (WTK 2.1)";
    static final String WTK1_TEST_VERSION_STRING = "Sony Ericsson J2ME SDK 1.2";
    static final String WTK20_TEST_VERSION_STRING = "J2ME Wireless Toolkit 2.0";
    static final String WTK21_TEST_VERSION_STRING = "Sony Ericsson J2ME SDK 2.1";
    static final String WTK1_ROOT = "J2ME_SDK/PC_Emulation/WTK1";
    static final String WTK2_ROOT = "J2ME_SDK/PC_Emulation/WTK2";

    static String getWTK2VersionString(File toolkitRoot) throws IOException {
        String versionString = "";
        File rootx = new File(toolkitRoot, WTK2_ROOT);
        versionString = AbstractSunWirelessToolkitType.getVersionString(rootx);
        return versionString;
    }

    public IWirelessToolkit createToolkit(File toolkitRoot, IProgressMonitor monitor) throws InvalidWirelessToolkitException {
        return new SonyEricssonWTK(toolkitRoot, monitor);
    }

    public String getName() {
        return "SonyEricsson J2ME SDK 2.x (Beta)";
    }

    public boolean isThisType(File toolkitRoot) {
        boolean thisType = false;
        if ((toolkitRoot = new File(toolkitRoot, WTK1_ROOT)).exists() && AbstractSunWirelessToolkitType.hasToolsLibraryFile(toolkitRoot)) {
            try {
                String versionString = AbstractSunWirelessToolkitType.getVersionString(toolkitRoot);
                thisType = versionString.startsWith(WTK1_TEST_VERSION_STRING);
            }
            catch (Exception e) {
                EclipseMEPlugin.log(2, "isThisType", e);
            }
        }
        return thisType;
    }
}

