/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.impl.se;

import eclipseme.EclipseMEPlugin;
import eclipseme.model.IConfiguration;
import eclipseme.model.IPlatformDefinition;
import eclipseme.model.IProfile;
import eclipseme.model.InvalidWirelessToolkitException;
import eclipseme.model.Version;
import eclipseme.model.impl.generic.Configuration;
import eclipseme.model.impl.generic.Profile;
import eclipseme.model.impl.generic.UEIEmulator;
import eclipseme.model.impl.se.SonyEricssonWTKType;
import eclipseme.model.impl.sun.AbstractSunWirelessToolkit;
import eclipseme.model.impl.sun.Sun21Preverifier;
import eclipseme.model.impl.sun.SunPreverifier;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;

public class SonyEricssonWTK
extends AbstractSunWirelessToolkit {
    public static final String ROOT_VAR = "SE_WTK";
    private static final String TOOLKIT_NAME = "Sony Ericsson J2ME SDK";
    private static final Version TOOLKIT_VERSION = new Version("1.0");
    public static final String MIDP1_API_LIB = "SE_WTK/J2ME_SDK/PC_Emulation/WTK1/lib/midpapi.zip";
    public static final String[] MIDP1_LIBS = new String[]{"SE_WTK/J2ME_SDK/PC_Emulation/WTK1/lib/midpapi.zip"};
    public static final String WTK20_MIDP2_API_LIB = "SE_WTK/J2ME_SDK/PC_Emulation/WTK2/lib/midpapi.zip";
    public static final String WTK20_MIDP2_MSGAPI_LIB = "SE_WTK/J2ME_SDK/PC_Emulation/WTK2/lib/wma.zip";
    public static final String WTK20_MIDP2_MMAPI_LIB = "SE_WTK/J2ME_SDK/PC_Emulation/WTK2/lib/mmapi.zip";
    public static final String[] WTK20_MIDP2_LIBS = new String[]{"SE_WTK/J2ME_SDK/PC_Emulation/WTK2/lib/midpapi.zip", "SE_WTK/J2ME_SDK/PC_Emulation/WTK2/lib/wma.zip", "SE_WTK/J2ME_SDK/PC_Emulation/WTK2/lib/mmapi.zip"};
    public static final String WTK21_CLDC10_API_LIB = "SE_WTK/J2ME_SDK/PC_Emulation/WTK2/lib/cldcapi10.jar";
    public static final String WTK21_CLDC11_API_LIB = "SE_WTK/J2ME_SDK/PC_Emulation/WTK2/lib/cldcapi11.jar";
    public static final String WTK21_MIDP1_API_LIB = "SE_WTK/J2ME_SDK/PC_Emulation/WTK2/lib/midpapi10.jar";
    public static final String WTK21_MIDP2_API_LIB = "SE_WTK/J2ME_SDK/PC_Emulation/WTK2/lib/midpapi20.jar";
    public static final String WTK21_MIDP_MSGAPI_LIB = "SE_WTK/J2ME_SDK/PC_Emulation/WTK2/lib/wma.jar";
    public static final String WTK21_MIDP_MMAPI_LIB = "SE_WTK/J2ME_SDK/PC_Emulation/WTK2/lib/mmapi.jar";
    public static final String[] WTK21_MIDP1_LIBS = new String[]{"SE_WTK/J2ME_SDK/PC_Emulation/WTK2/lib/midpapi10.jar"};
    public static final String[] WTK21_MIDP2_LIBS = new String[]{"SE_WTK/J2ME_SDK/PC_Emulation/WTK2/lib/midpapi20.jar", "SE_WTK/J2ME_SDK/PC_Emulation/WTK2/lib/wma.jar", "SE_WTK/J2ME_SDK/PC_Emulation/WTK2/lib/mmapi.jar"};

    public SonyEricssonWTK(File root, IProgressMonitor monitor) throws InvalidWirelessToolkitException {
        super(root, monitor);
    }

    protected String getRootClasspathVariableName() {
        return ROOT_VAR;
    }

    protected void initializeToolkit(IProgressMonitor monitor) {
        this.name = TOOLKIT_NAME;
        this.version = TOOLKIT_VERSION;
        ArrayList<IPlatformDefinition> defs = new ArrayList<IPlatformDefinition>();
        defs.add(this.getMIDP1Definition());
        if (this.isWTK21()) {
            defs.add(this.getWTK21_MIDP2Definition());
        } else {
            defs.add(this.getWTK20_MIDP2Definition());
        }
        this.configurations = new IConfiguration[defs.size()];
        this.profiles = new IProfile[defs.size()];
        int i = 0;
        while (i < defs.size()) {
            IPlatformDefinition def = (IPlatformDefinition)defs.get(i);
            this.configurations[i] = def.getConfiguration();
            this.profiles[i] = def.getProfiles()[0];
            ++i;
        }
        this.updateClasspathVariable(monitor);
    }

    private IPlatformDefinition getMIDP1Definition() {
        File definitionRoot = new File(this.root, "J2ME_SDK/PC_Emulation/WTK1");
        Configuration config = this.createNewConfiguration("CLDC", "1.0", null);
        Profile profile = this.createNewProfile("MIDP", "1.0", MIDP1_LIBS);
        return this.createNewPlatformDefinition("Sony Ericsson J2ME SDK (WTK 1.0.4) Platform", definitionRoot, new UEIEmulator(definitionRoot), new SunPreverifier(), config, new IProfile[]{profile});
    }

    private IPlatformDefinition getWTK20_MIDP2Definition() {
        File definitionRoot = new File(this.root, "J2ME_SDK/PC_Emulation/WTK2");
        Configuration config = this.createNewConfiguration("CLDC", "1.1", null);
        Profile profile = this.createNewProfile("MIDP", "2.0", WTK20_MIDP2_LIBS);
        return this.createNewPlatformDefinition("Sony Ericsson J2ME SDK (WTK 2.0) Platform", definitionRoot, new UEIEmulator(definitionRoot), new SunPreverifier(), config, new IProfile[]{profile});
    }

    private IPlatformDefinition getWTK21_MIDP2Definition() {
        File definitionRoot = new File(this.root, "J2ME_SDK/PC_Emulation/WTK2");
        Configuration config = this.createNewConfiguration("CLDC", "1.1", WTK21_CLDC11_API_LIB);
        Profile profile = this.createNewProfile("MIDP", "2.0", WTK21_MIDP2_LIBS);
        return this.createNewPlatformDefinition(String.valueOf(this.name) + " (WTK 2.1) Platform", definitionRoot, new UEIEmulator(definitionRoot), new Sun21Preverifier(), config, new IProfile[]{profile});
    }

    private boolean isWTK21() {
        boolean is21 = false;
        try {
            String versionString = SonyEricssonWTKType.getWTK2VersionString(this.root);
            is21 = versionString.startsWith("Sony Ericsson J2ME SDK 2.1");
        }
        catch (IOException e) {
            EclipseMEPlugin.log(4, "isWTK21", e);
        }
        return is21;
    }
}

