/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.impl.generic;

import eclipseme.model.IPlatformComponent;
import eclipseme.model.IProfile;
import eclipseme.model.IWirelessToolkit;
import eclipseme.model.Version;
import eclipseme.model.impl.generic.PlatformComponent;
import eclipseme.model.persistence.AbstractPersistenceDelegate;
import eclipseme.model.persistence.IPersistenceDelegate;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Profile
extends PlatformComponent
implements IProfile {
    protected List libraries;
    private String specificationVersion;
    protected IWirelessToolkit toolkit;

    public Profile(IWirelessToolkit toolkit, String name, Version version) {
        super(name, version);
        this.toolkit = toolkit;
        this.libraries = new ArrayList();
    }

    public Profile(IWirelessToolkit toolkit, String name) {
        this(toolkit, name, toolkit.getVersion());
    }

    public void addLibrary(IClasspathEntry library) {
        this.libraries.add(library);
    }

    public void addLibraries(IClasspathEntry[] libraries) {
        int i = 0;
        while (i < libraries.length) {
            this.addLibrary(libraries[i]);
            ++i;
        }
    }

    public IClasspathEntry[] getLibraries() {
        return this.libraries.toArray(new IClasspathEntry[this.libraries.size()]);
    }

    public IPersistenceDelegate getPersistenceDelegate() {
        return new ProfilePersistenceDelegate();
    }

    public String getSpecificationVersion() {
        return this.specificationVersion;
    }

    public IWirelessToolkit getWirelessToolkit() {
        return this.toolkit;
    }

    public void setSpecificationVersion(String specVersion) {
        this.specificationVersion = specVersion;
    }

    public static class ProfilePersistenceDelegate
    extends AbstractPersistenceDelegate {
        private static final String ELEMENT_LIBRARIES = "libraries";

        public IPlatformComponent readObject(Element element, IProgressMonitor progressMonitor) {
            IWirelessToolkit toolkit = this.getToolkit(element);
            String name = element.getAttribute("name");
            Profile profile = new Profile(toolkit, name);
            NodeList libraryElements = element.getElementsByTagName("library");
            int i = 0;
            while (i < libraryElements.getLength()) {
                Element libraryElement = (Element)libraryElements.item(i);
                this.addParsedLibrary(profile, libraryElement);
                ++i;
            }
            return profile;
        }

        public void writeObject(Element element, IPlatformComponent toStore, IProgressMonitor progressMonitor) {
            IProfile profile = (IProfile)toStore;
            element.setAttribute("name", profile.getName());
            element.setAttribute("toolkitName", profile.getWirelessToolkit().getName());
            Element librariesElement = this.addChildElement(element, ELEMENT_LIBRARIES);
            IClasspathEntry[] libs = profile.getLibraries();
            int i = 0;
            while (i < libs.length) {
                this.addClasspathEntry(librariesElement, libs[i]);
                ++i;
            }
        }
    }
}

