/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.impl.generic;

import eclipseme.model.IPlatformComponent;
import eclipseme.model.Version;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class PlatformComponent
implements IPlatformComponent,
Serializable {
    protected String name;
    protected Version version;
    protected boolean derived;
    protected List dependents;

    public PlatformComponent(String name, Version version) {
        this.name = name;
        this.version = version;
        this.dependents = new ArrayList();
    }

    protected PlatformComponent() {
        this("Unnamed");
    }

    protected PlatformComponent(String name) {
        this(name, new Version("1.0"));
    }

    public void addDependentComponent(IPlatformComponent component) {
        this.dependents.add(component);
    }

    public Iterator getDependentComponents() {
        return this.dependents.iterator();
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean isDerived() {
        return this.derived;
    }

    public boolean hasDependentComponents() {
        return this.dependents.size() > 0;
    }

    public void removeDependentComponent(IPlatformComponent component) {
        this.dependents.remove(component);
    }

    public void setDerived(boolean derived) {
        this.derived = derived;
    }
}

