/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.migration;

import eclipseme.model.IMidletSuiteProject;
import eclipseme.model.IPlatformDefinition;
import eclipseme.model.impl.generic.MidletSuiteProject;
import eclipseme.model.registry.PlatformComponentRegistry;
import eclipseme.nature.J2MENature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class V003To005Migrator {
    private static final String[] ORIGINAL_DEFS = new String[]{"Generic MIDP-1.0 Platform", "Generic MIDP-2.0 Platform"};
    private static final String[] NEW_DEFS = new String[]{"J2ME Wireless Toolkit 1.0.4 Platform", "J2ME Wireless Toolkit 2.0 Platform"};
    private IWorkspaceRoot workspaceRoot;

    public V003To005Migrator(IWorkspaceRoot workspaceRoot) {
        this.workspaceRoot = workspaceRoot;
    }

    public void doMigration() throws CoreException {
        IProject[] projects = this.workspaceRoot.getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isOpen() && J2MENature.hasJ2MENature(projects[i])) {
                this.migrateProjectPlatformDefinition(projects[i]);
            }
            ++i;
        }
    }

    private String getMappedName(String platformDefName) {
        String mapped = null;
        int i = 0;
        while (i < ORIGINAL_DEFS.length) {
            if (ORIGINAL_DEFS[i].equals(platformDefName)) {
                mapped = NEW_DEFS[i];
                break;
            }
            ++i;
        }
        return mapped;
    }

    private PlatformComponentRegistry getRegistry() {
        return PlatformComponentRegistry.getInstance();
    }

    private void migrateMidletSuiteProject(IMidletSuiteProject suite) throws CoreException {
        IPlatformDefinition def;
        String mapped;
        String platformDefName = suite.getPlatformDefinitionName();
        if (!this.platformDefinitionExists(platformDefName) && (mapped = this.getMappedName(platformDefName)) != null && (def = this.getRegistry().getPlatformDefinition(mapped)) != null) {
            suite.setPlatformDefinition(def);
        }
    }

    private void migrateProjectPlatformDefinition(IProject project) throws CoreException {
        IMidletSuiteProject suite;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null && (suite = MidletSuiteProject.getMidletSuiteProject(javaProject)) != null) {
            this.migrateMidletSuiteProject(suite);
        }
    }

    private boolean platformDefinitionExists(String platformDefName) {
        IPlatformDefinition def = this.getRegistry().getPlatformDefinition(platformDefName);
        return def != null;
    }
}

