/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.builder;

import eclipseme.model.IMidletSuiteProject;
import eclipseme.model.IResourceFilter;
import eclipseme.model.impl.generic.MidletSuiteProject;
import eclipseme.model.impl.generic.SourceResourcesFilter;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

class BuildInfo {
    private int buildKind;
    private Map buildArgs;
    private IMidletSuiteProject midletSuite;
    private IJavaProject baseJavaProject;
    private IJavaProject currentJavaProject;
    private IResourceDelta currentResourceDelta;
    private IResourceFilter resourceFilter;
    private IFolder verifiedFolder;
    private IFolder verifiedClassesFolder;
    private IFolder verifiedLibsFolder;

    BuildInfo(int kind, Map args, IJavaProject baseJavaProject) throws JavaModelException {
        this.buildKind = kind;
        this.buildArgs = args;
        this.baseJavaProject = baseJavaProject;
        this.midletSuite = MidletSuiteProject.getMidletSuiteProject(baseJavaProject);
        this.setCurrentJavaProject(baseJavaProject);
    }

    public IJavaProject getBaseJavaProject() {
        return this.baseJavaProject;
    }

    public Map getBuildArgs() {
        return this.buildArgs;
    }

    public int getBuildKind() {
        return this.buildKind;
    }

    public IJavaProject getCurrentJavaProject() {
        return this.currentJavaProject;
    }

    public IResourceDelta getCurrentResourceDelta() {
        return this.currentResourceDelta;
    }

    public IMidletSuiteProject getMidletSuite() {
        return this.midletSuite;
    }

    public IResourceFilter getResourceFilter() {
        return this.resourceFilter;
    }

    public boolean isCurrentProjectMidletSuite() {
        return this.currentJavaProject.equals(this.baseJavaProject);
    }

    IFolder getVerifiedClassesFolder(IProgressMonitor monitor) throws CoreException {
        if (this.verifiedClassesFolder == null) {
            this.verifiedClassesFolder = this.midletSuite.getVerifiedClassesOutputFolder(monitor);
            if (!this.verifiedClassesFolder.exists()) {
                this.verifiedClassesFolder.create(true, true, monitor);
            }
        }
        return this.verifiedClassesFolder;
    }

    IFolder getVerifiedFolder(IProgressMonitor monitor) throws CoreException {
        if (this.verifiedFolder == null) {
            this.verifiedFolder = this.midletSuite.getVerifiedOutputFolder(monitor);
            if (!this.verifiedFolder.exists()) {
                this.verifiedFolder.create(true, true, monitor);
            }
        }
        return this.verifiedFolder;
    }

    IFolder getVerifiedLibsFolder(IProgressMonitor monitor) throws CoreException {
        if (this.verifiedLibsFolder == null) {
            this.verifiedLibsFolder = this.midletSuite.getVerifiedLibrariesOutputFolder(monitor);
            if (!this.verifiedLibsFolder.exists()) {
                this.verifiedLibsFolder.create(true, true, monitor);
            }
        }
        return this.verifiedLibsFolder;
    }

    public void setCurrentJavaProject(IJavaProject currentJavaProject) throws JavaModelException {
        this.currentJavaProject = currentJavaProject;
        this.resourceFilter = new SourceResourcesFilter(currentJavaProject);
    }

    public void setCurrentResourceDelta(IResourceDelta currentResourceDelta) {
        this.currentResourceDelta = currentResourceDelta;
    }
}

