/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.tools.internal.CleanupClass;

public class LockGenerator
extends CleanupClass {
    String getParams(Method method) {
        int parantesesStart;
        int n_args = method.getParameterTypes().length;
        if (n_args == 0) {
            return "";
        }
        String name = method.getName();
        String params = "";
        int index = 0;
        while (true) {
            if (!Character.isWhitespace(this.classSource.charAt((index = this.classSource.indexOf(name, index + 1)) - 1))) {
                continue;
            }
            if (index == -1) {
                return null;
            }
            parantesesStart = this.classSource.indexOf("(", index);
            if (this.classSource.substring(index + name.length(), parantesesStart).trim().length() == 0) break;
        }
        int parantesesEnd = this.classSource.indexOf(")", parantesesStart);
        params = this.classSource.substring(parantesesStart + 1, parantesesEnd);
        return params;
    }

    String getReturn(Method method) {
        String methodStr;
        int index;
        Class<?> returnType = method.getReturnType();
        if (returnType != Integer.TYPE) {
            return LockGenerator.getTypeSignature3(returnType);
        }
        String modifierStr = Modifier.toString(method.getModifiers());
        String name = method.getName();
        Pattern p = Pattern.compile(String.valueOf(modifierStr) + ".*" + name + ".*(.*)");
        Matcher m = p.matcher(this.classSource);
        if (m.find() && (index = (methodStr = this.classSource.substring(m.start(), m.end())).indexOf("/*long*/")) != -1 && index < methodStr.indexOf(name)) {
            return String.valueOf(LockGenerator.getTypeSignature3(Integer.TYPE)) + " /*long*/";
        }
        return LockGenerator.getTypeSignature3(Integer.TYPE);
    }

    public void generate(Class clazz) {
        super.generate(clazz);
        Method[] methods = clazz.getDeclaredMethods();
        this.generate(methods);
    }

    public void generate(Method[] methods) {
        LockGenerator.sort(methods);
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if ((method.getModifiers() & 0x100) != 0) {
                this.generate(method);
            }
            ++i;
        }
    }

    public void generate(Method method) {
        String modifiersStr;
        int modifiers = method.getModifiers();
        boolean lock = (modifiers & 0x20) != 0;
        String returnStr = this.getReturn(method);
        String paramsStr = this.getParams(method);
        if (lock) {
            modifiersStr = Modifier.toString(modifiers & 0xFFFFFFDF);
            this.output(modifiersStr);
            if (modifiersStr.length() > 0) {
                this.output(" ");
            }
            this.output(returnStr);
            this.output(" _");
            this.output(method.getName());
            this.output("(");
            this.output(paramsStr);
            this.outputln(");");
        }
        modifiersStr = Modifier.toString(modifiers & ~(0x20 | (lock ? 256 : 0)));
        this.output(modifiersStr);
        if (modifiersStr.length() > 0) {
            this.output(" ");
        }
        this.output(returnStr);
        this.output(" ");
        this.output(method.getName());
        this.output("(");
        this.output(paramsStr);
        this.output(")");
        if (lock) {
            this.outputln(" {");
            this.outputln("\tlock.lock();");
            this.outputln("\ttry {");
            this.output("\t\t");
            if (method.getReturnType() != Void.TYPE) {
                this.output("return ");
            }
            this.output("_");
            this.output(method.getName());
            this.output("(");
            String[] paramNames = this.getArgNames(method);
            int i = 0;
            while (i < paramNames.length) {
                if (i != 0) {
                    this.output(", ");
                }
                this.output(paramNames[i]);
                ++i;
            }
            this.outputln(");");
            this.outputln("\t} finally {");
            this.outputln("\t\tlock.unlock();");
            this.outputln("\t}");
            this.outputln("}");
        } else {
            this.outputln(";");
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: java LockGenerator <OS className> <OS class source>");
            return;
        }
        try {
            LockGenerator gen = new LockGenerator();
            String clazzName = args[0];
            String classSource = args[1];
            Class<?> clazz = Class.forName(clazzName);
            gen.setClassSourcePath(classSource);
            gen.generate(clazz);
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }
}

