/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.layoutexample;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.examples.layoutexample.LayoutExample;
import org.eclipse.swt.examples.layoutexample.Tab;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

class GridLayoutTab
extends Tab {
    Text numColumns;
    Button makeColumnsEqualWidth;
    Combo marginHeight;
    Combo marginWidth;
    Combo horizontalSpacing;
    Combo verticalSpacing;
    GridLayout gridLayout;
    TableEditor comboEditor;
    TableEditor widthEditor;
    TableEditor heightEditor;
    TableEditor vAlignEditor;
    TableEditor hAlignEditor;
    TableEditor hIndentEditor;
    TableEditor hSpanEditor;
    TableEditor vSpanEditor;
    TableEditor hGrabEditor;
    TableEditor vGrabEditor;
    CCombo combo;
    CCombo vAlign;
    CCombo hAlign;
    CCombo hGrab;
    CCombo vGrab;
    Text widthText;
    Text heightText;
    Text hIndent;
    Text hSpan;
    Text vSpan;
    final int COMBO_COL = 1;
    final int WIDTH_COL = 2;
    final int HEIGHT_COL = 3;
    final int HALIGN_COL = 4;
    final int VALIGN_COL = 5;
    final int HINDENT_COL = 6;
    final int HSPAN_COL = 7;
    final int VSPAN_COL = 8;
    final int HGRAB_COL = 9;
    final int VGRAB_COL = 10;
    final int TOTAL_COLS = 11;

    GridLayoutTab(LayoutExample instance) {
        super(instance);
    }

    void createChildWidgets() {
        final TraverseListener traverseListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4 || e.detail == 16) {
                    GridLayoutTab.this.resetEditors();
                }
                if (e.detail == 2) {
                    GridLayoutTab.this.disposeEditors();
                }
            }
        };
        super.createChildWidgets();
        this.comboEditor = new TableEditor(this.table);
        this.widthEditor = new TableEditor(this.table);
        this.heightEditor = new TableEditor(this.table);
        this.vAlignEditor = new TableEditor(this.table);
        this.hAlignEditor = new TableEditor(this.table);
        this.hIndentEditor = new TableEditor(this.table);
        this.hSpanEditor = new TableEditor(this.table);
        this.vSpanEditor = new TableEditor(this.table);
        this.hGrabEditor = new TableEditor(this.table);
        this.vGrabEditor = new TableEditor(this.table);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                GridLayoutTab.this.resetEditors();
                GridLayoutTab.this.index = GridLayoutTab.this.table.getSelectionIndex();
                Point pt = new Point(e.x, e.y);
                GridLayoutTab.this.newItem = GridLayoutTab.this.table.getItem(pt);
                if (GridLayoutTab.this.newItem == null) {
                    return;
                }
                TableItem oldItem = GridLayoutTab.this.comboEditor.getItem();
                if (GridLayoutTab.this.newItem == oldItem || GridLayoutTab.this.newItem != GridLayoutTab.this.lastSelected) {
                    GridLayoutTab.this.lastSelected = GridLayoutTab.this.newItem;
                    return;
                }
                GridLayoutTab.this.table.showSelection();
                GridLayoutTab.this.combo = new CCombo((Composite)GridLayoutTab.this.table, 8);
                GridLayoutTab.this.createComboEditor(GridLayoutTab.this.combo, GridLayoutTab.this.comboEditor);
                GridLayoutTab.this.widthText = new Text((Composite)GridLayoutTab.this.table, 4);
                GridLayoutTab.this.widthText.setText(((String[])GridLayoutTab.this.data.elementAt(GridLayoutTab.this.index))[2]);
                GridLayoutTab.this.createTextEditor(GridLayoutTab.this.widthText, GridLayoutTab.this.widthEditor, 2);
                GridLayoutTab.this.heightText = new Text((Composite)GridLayoutTab.this.table, 4);
                GridLayoutTab.this.heightText.setText(((String[])GridLayoutTab.this.data.elementAt(GridLayoutTab.this.index))[3]);
                GridLayoutTab.this.createTextEditor(GridLayoutTab.this.heightText, GridLayoutTab.this.heightEditor, 3);
                String[] alignValues = new String[]{"BEGINNING", "CENTER", "END", "FILL"};
                GridLayoutTab.this.hAlign = new CCombo((Composite)GridLayoutTab.this.table, 0);
                GridLayoutTab.this.hAlign.setItems(alignValues);
                GridLayoutTab.this.hAlign.setText(GridLayoutTab.this.newItem.getText(4));
                GridLayoutTab.this.hAlignEditor.horizontalAlignment = 16384;
                GridLayoutTab.this.hAlignEditor.grabHorizontal = true;
                GridLayoutTab.this.hAlignEditor.minimumWidth = 50;
                GridLayoutTab.this.hAlignEditor.setEditor((Control)GridLayoutTab.this.hAlign, GridLayoutTab.this.newItem, 4);
                GridLayoutTab.this.hAlign.addTraverseListener(traverseListener);
                GridLayoutTab.this.vAlign = new CCombo((Composite)GridLayoutTab.this.table, 0);
                GridLayoutTab.this.vAlign.setItems(alignValues);
                GridLayoutTab.this.vAlign.setText(GridLayoutTab.this.newItem.getText(5));
                GridLayoutTab.this.vAlignEditor.horizontalAlignment = 16384;
                GridLayoutTab.this.vAlignEditor.grabHorizontal = true;
                GridLayoutTab.this.vAlignEditor.minimumWidth = 50;
                GridLayoutTab.this.vAlignEditor.setEditor((Control)GridLayoutTab.this.vAlign, GridLayoutTab.this.newItem, 5);
                GridLayoutTab.this.vAlign.addTraverseListener(traverseListener);
                GridLayoutTab.this.hIndent = new Text((Composite)GridLayoutTab.this.table, 4);
                GridLayoutTab.this.hIndent.setText(((String[])GridLayoutTab.this.data.elementAt(GridLayoutTab.this.index))[6]);
                GridLayoutTab.this.createTextEditor(GridLayoutTab.this.hIndent, GridLayoutTab.this.hIndentEditor, 6);
                GridLayoutTab.this.hSpan = new Text((Composite)GridLayoutTab.this.table, 4);
                GridLayoutTab.this.hSpan.setText(((String[])GridLayoutTab.this.data.elementAt(GridLayoutTab.this.index))[7]);
                GridLayoutTab.this.createTextEditor(GridLayoutTab.this.hSpan, GridLayoutTab.this.hSpanEditor, 7);
                GridLayoutTab.this.vSpan = new Text((Composite)GridLayoutTab.this.table, 4);
                GridLayoutTab.this.vSpan.setText(((String[])GridLayoutTab.this.data.elementAt(GridLayoutTab.this.index))[8]);
                GridLayoutTab.this.createTextEditor(GridLayoutTab.this.vSpan, GridLayoutTab.this.vSpanEditor, 8);
                String[] boolValues = new String[]{"false", "true"};
                GridLayoutTab.this.hGrab = new CCombo((Composite)GridLayoutTab.this.table, 0);
                GridLayoutTab.this.hGrab.setItems(boolValues);
                GridLayoutTab.this.hGrab.setText(GridLayoutTab.this.newItem.getText(9));
                GridLayoutTab.this.hGrabEditor.horizontalAlignment = 16384;
                GridLayoutTab.this.hGrabEditor.grabHorizontal = true;
                GridLayoutTab.this.hGrabEditor.minimumWidth = 50;
                GridLayoutTab.this.hGrabEditor.setEditor((Control)GridLayoutTab.this.hGrab, GridLayoutTab.this.newItem, 9);
                GridLayoutTab.this.hGrab.addTraverseListener(traverseListener);
                GridLayoutTab.this.vGrab = new CCombo((Composite)GridLayoutTab.this.table, 0);
                GridLayoutTab.this.vGrab.setItems(boolValues);
                GridLayoutTab.this.vGrab.setText(GridLayoutTab.this.newItem.getText(10));
                GridLayoutTab.this.vGrabEditor.horizontalAlignment = 16384;
                GridLayoutTab.this.vGrabEditor.grabHorizontal = true;
                GridLayoutTab.this.vGrabEditor.minimumWidth = 50;
                GridLayoutTab.this.vGrabEditor.setEditor((Control)GridLayoutTab.this.vGrab, GridLayoutTab.this.newItem, 10);
                GridLayoutTab.this.vGrab.addTraverseListener(traverseListener);
                int i = 0;
                while (i < GridLayoutTab.this.table.getColumnCount()) {
                    Rectangle rect = GridLayoutTab.this.newItem.getBounds(i);
                    if (rect.contains(pt)) {
                        switch (i) {
                            case 1: {
                                GridLayoutTab.this.combo.setFocus();
                                break;
                            }
                            case 2: {
                                GridLayoutTab.this.widthText.setFocus();
                                break;
                            }
                            case 3: {
                                GridLayoutTab.this.heightText.setFocus();
                                break;
                            }
                            case 4: {
                                GridLayoutTab.this.hAlign.setFocus();
                                break;
                            }
                            case 5: {
                                GridLayoutTab.this.vAlign.setFocus();
                                break;
                            }
                            case 6: {
                                GridLayoutTab.this.hIndent.setFocus();
                                break;
                            }
                            case 7: {
                                GridLayoutTab.this.hSpan.setFocus();
                                break;
                            }
                            case 8: {
                                GridLayoutTab.this.vSpan.setFocus();
                                break;
                            }
                            case 9: {
                                GridLayoutTab.this.hGrab.setFocus();
                                break;
                            }
                            case 10: {
                                GridLayoutTab.this.vGrab.setFocus();
                                break;
                            }
                            default: {
                                GridLayoutTab.this.resetEditors();
                            }
                        }
                    }
                    ++i;
                }
            }
        });
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = new TableItem(GridLayoutTab.this.table, 0);
                String[] insert = new String[]{String.valueOf(GridLayoutTab.this.table.indexOf(item)), "Button", "-1", "-1", "BEGINNING", "CENTER", "0", "1", "1", "false", "false"};
                item.setText(insert);
                GridLayoutTab.this.data.addElement(insert);
                GridLayoutTab.this.resetEditors();
            }
        });
    }

    void createControlWidgets() {
        this.size.setLayoutData((Object)new GridData());
        String[] marginValues = new String[]{"0", "3", "5", "10"};
        Group marginGroup = new Group((Composite)this.controlGroup, 0);
        marginGroup.setText(LayoutExample.getResourceString("Margins_Spacing"));
        GridData data = new GridData(768);
        data.verticalSpan = 2;
        marginGroup.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        marginGroup.setLayout((Layout)layout);
        new Label((Composite)marginGroup, 0).setText("marginHeight");
        this.marginHeight = new Combo((Composite)marginGroup, 0);
        this.marginHeight.setItems(marginValues);
        this.marginHeight.select(2);
        data = new GridData(768);
        data.widthHint = 60;
        this.marginHeight.setLayoutData((Object)data);
        this.marginHeight.addSelectionListener(this.selectionListener);
        this.marginHeight.addTraverseListener(this.traverseListener);
        new Label((Composite)marginGroup, 0).setText("marginWidth");
        this.marginWidth = new Combo((Composite)marginGroup, 0);
        this.marginWidth.setItems(marginValues);
        this.marginWidth.select(2);
        data = new GridData(768);
        data.widthHint = 60;
        this.marginWidth.setLayoutData((Object)data);
        this.marginWidth.addSelectionListener(this.selectionListener);
        this.marginWidth.addTraverseListener(this.traverseListener);
        new Label((Composite)marginGroup, 0).setText("horizontalSpacing");
        this.horizontalSpacing = new Combo((Composite)marginGroup, 0);
        this.horizontalSpacing.setItems(marginValues);
        this.horizontalSpacing.select(2);
        data = new GridData(768);
        data.widthHint = 60;
        this.horizontalSpacing.setLayoutData((Object)data);
        this.horizontalSpacing.addSelectionListener(this.selectionListener);
        this.horizontalSpacing.addTraverseListener(this.traverseListener);
        new Label((Composite)marginGroup, 0).setText("verticalSpacing");
        this.verticalSpacing = new Combo((Composite)marginGroup, 0);
        this.verticalSpacing.setItems(marginValues);
        this.verticalSpacing.select(2);
        data = new GridData(768);
        data.widthHint = 60;
        this.verticalSpacing.setLayoutData((Object)data);
        this.verticalSpacing.addSelectionListener(this.selectionListener);
        this.verticalSpacing.addTraverseListener(this.traverseListener);
        Group columnGroup = new Group((Composite)this.controlGroup, 0);
        columnGroup.setText(LayoutExample.getResourceString("Columns"));
        layout = new GridLayout();
        layout.numColumns = 2;
        columnGroup.setLayout((Layout)layout);
        data = new GridData(16);
        columnGroup.setLayoutData((Object)data);
        this.numColumns = new Text((Composite)columnGroup, 2048);
        this.numColumns.setText("1");
        this.numColumns.addSelectionListener(this.selectionListener);
        this.numColumns.addTraverseListener(this.traverseListener);
        data = new GridData(768);
        data.widthHint = 15;
        this.numColumns.setLayoutData((Object)data);
        new Label((Composite)columnGroup, 0).setText("numColumns");
        this.makeColumnsEqualWidth = new Button((Composite)columnGroup, 32);
        this.makeColumnsEqualWidth.setText("makeColumnsEqualWidth");
        this.makeColumnsEqualWidth.addSelectionListener(this.selectionListener);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.horizontalIndent = 14;
        this.makeColumnsEqualWidth.setLayoutData((Object)data);
        super.createControlWidgets();
        this.controlGroup.pack();
    }

    void createLayout() {
        this.gridLayout = new GridLayout();
        this.layoutComposite.setLayout((Layout)this.gridLayout);
    }

    void disposeEditors() {
        this.comboEditor.setEditor(null, null, -1);
        this.combo.dispose();
        this.widthText.dispose();
        this.heightText.dispose();
        this.hAlign.dispose();
        this.vAlign.dispose();
        this.hIndent.dispose();
        this.hSpan.dispose();
        this.vSpan.dispose();
        this.hGrab.dispose();
        this.vGrab.dispose();
    }

    StringBuffer generateLayoutCode() {
        StringBuffer code = new StringBuffer();
        code.append("\t\tGridLayout gridLayout = new GridLayout ();\n");
        if (this.gridLayout.numColumns != 1) {
            code.append("\t\tgridLayout.numColumns = " + this.gridLayout.numColumns + ";\n");
        }
        if (this.gridLayout.makeColumnsEqualWidth) {
            code.append("\t\tgridLayout.makeColumnsEqualWidth = true;\n");
        }
        if (this.gridLayout.marginHeight != 5) {
            code.append("\t\tgridLayout.marginHeight = " + this.gridLayout.marginHeight + ";\n");
        }
        if (this.gridLayout.marginWidth != 5) {
            code.append("\t\tgridLayout.marginWidth = " + this.gridLayout.marginWidth + ";\n");
        }
        if (this.gridLayout.horizontalSpacing != 5) {
            code.append("\t\tgridLayout.horizontalSpacing = " + this.gridLayout.horizontalSpacing + ";\n");
        }
        if (this.gridLayout.verticalSpacing != 5) {
            code.append("\t\tgridLayout.verticalSpacing = " + this.gridLayout.verticalSpacing + ";\n");
        }
        code.append("\t\tshell.setLayout (gridLayout);\n");
        boolean first = true;
        int i = 0;
        while (i < this.children.length) {
            Control control = this.children[i];
            code.append(this.getChildCode(control, i));
            GridData data = (GridData)control.getLayoutData();
            if (data != null) {
                String alignment;
                code.append("\t\t");
                if (first) {
                    code.append("GridData ");
                    first = false;
                }
                code.append("data = new GridData ();\n");
                if (data.widthHint != -1) {
                    code.append("\t\tdata.widthHint = " + data.widthHint + ";\n");
                }
                if (data.heightHint != -1) {
                    code.append("\t\tdata.heightHint = " + data.heightHint + ";\n");
                }
                if (data.horizontalAlignment != 1) {
                    int hAlignment = data.horizontalAlignment;
                    alignment = hAlignment == 2 ? "GridData.CENTER" : (hAlignment == 3 ? "GridData.END" : "GridData.FILL");
                    code.append("\t\tdata.horizontalAlignment = " + alignment + ";\n");
                }
                if (data.verticalAlignment != 2) {
                    int vAlignment = data.verticalAlignment;
                    alignment = vAlignment == 1 ? "GridData.BEGINNING" : (vAlignment == 3 ? "GridData.END" : "GridData.FILL");
                    code.append("\t\tdata.verticalAlignment = " + alignment + ";\n");
                }
                if (data.horizontalIndent != 0) {
                    code.append("\t\tdata.horizontalIndent = " + data.horizontalIndent + ";\n");
                }
                if (data.horizontalSpan != 1) {
                    code.append("\t\tdata.horizontalSpan = " + data.horizontalSpan + ";\n");
                }
                if (data.verticalSpan != 1) {
                    code.append("\t\tdata.verticalSpan = " + data.verticalSpan + ";\n");
                }
                if (data.grabExcessHorizontalSpace) {
                    code.append("\t\tdata.grabExcessHorizontalSpace = true;\n");
                }
                if (data.grabExcessVerticalSpace) {
                    code.append("\t\tdata.grabExcessVerticalSpace = true;\n");
                }
                if (code.substring(code.length() - 33).equals("GridData data = new GridData ();\n")) {
                    code.delete(code.length() - 33, code.length());
                    first = true;
                } else if (code.substring(code.length() - 24).equals("data = new GridData ();\n")) {
                    code.delete(code.length() - 24, code.length());
                } else {
                    code.append("\t\t" + this.names[i] + ".setLayoutData (data);\n");
                }
            }
            ++i;
        }
        return code;
    }

    String[] getLayoutDataFieldNames() {
        return new String[]{"", "Control", "width", "height", "horizontalAlignment", "verticalAlignment", "horizontalIndent", "horizontalSpan", "verticalSpan", "grabExcessHorizontalSpace", "grabExcessVerticalSpace"};
    }

    String getTabText() {
        return "GridLayout";
    }

    void resetEditors() {
        this.resetEditors(false);
    }

    void resetEditors(boolean tab) {
        TableItem oldItem = this.comboEditor.getItem();
        if (oldItem != null) {
            int row = this.table.indexOf(oldItem);
            try {
                new Integer(this.widthText.getText()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.widthText.setText(oldItem.getText(2));
            }
            try {
                new Integer(this.heightText.getText()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.heightText.setText(oldItem.getText(3));
            }
            try {
                new Integer(this.hIndent.getText()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.hIndent.setText(oldItem.getText(6));
            }
            try {
                new Integer(this.hSpan.getText()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.hSpan.setText(oldItem.getText(7));
            }
            try {
                new Integer(this.vSpan.getText()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.vSpan.setText(oldItem.getText(8));
            }
            String[] insert = new String[]{String.valueOf(row), this.combo.getText(), this.widthText.getText(), this.heightText.getText(), this.hAlign.getText(), this.vAlign.getText(), this.hIndent.getText(), this.hSpan.getText(), this.vSpan.getText(), this.hGrab.getText(), this.vGrab.getText()};
            this.data.setElementAt(insert, row);
            int i = 0;
            while (i < 11) {
                oldItem.setText(i, ((String[])this.data.elementAt(row))[i]);
                ++i;
            }
            if (!tab) {
                this.disposeEditors();
            }
        }
        this.setLayoutState();
        this.refreshLayoutComposite();
        this.setLayoutData();
        this.layoutComposite.layout(true);
        this.layoutGroup.layout(true);
    }

    void setLayoutData() {
        Control[] children = this.layoutComposite.getChildren();
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < children.length) {
            int vSpan;
            int hSpan;
            int hIndent;
            GridData data = new GridData();
            data.widthHint = new Integer(items[i].getText(2));
            data.heightHint = new Integer(items[i].getText(3));
            String hAlign = items[i].getText(4);
            data.horizontalAlignment = hAlign.equals("CENTER") ? 2 : (hAlign.equals("END") ? 3 : (hAlign.equals("FILL") ? 4 : 1));
            String vAlign = items[i].getText(5);
            data.verticalAlignment = vAlign.equals("BEGINNING") ? 1 : (vAlign.equals("END") ? 3 : (vAlign.equals("FILL") ? 4 : 2));
            data.horizontalIndent = hIndent = new Integer(items[i].getText(6)).intValue();
            data.horizontalSpan = hSpan = new Integer(items[i].getText(7)).intValue();
            data.verticalSpan = vSpan = new Integer(items[i].getText(8)).intValue();
            String hGrab = items[i].getText(9);
            data.grabExcessHorizontalSpace = hGrab.equals("true");
            String vGrab = items[i].getText(10);
            data.grabExcessVerticalSpace = vGrab.equals("true");
            children[i].setLayoutData((Object)data);
            ++i;
        }
    }

    void setLayoutState() {
        try {
            this.gridLayout.numColumns = new Integer(this.numColumns.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.gridLayout.numColumns = 1;
        }
        this.gridLayout.makeColumnsEqualWidth = this.makeColumnsEqualWidth.getSelection();
        try {
            this.gridLayout.marginHeight = new Integer(this.marginHeight.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.gridLayout.marginHeight = 5;
            this.marginHeight.select(2);
        }
        try {
            this.gridLayout.marginWidth = new Integer(this.marginWidth.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.gridLayout.marginWidth = 5;
            this.marginWidth.select(2);
        }
        try {
            this.gridLayout.horizontalSpacing = new Integer(this.horizontalSpacing.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.gridLayout.horizontalSpacing = 5;
            this.horizontalSpacing.select(2);
        }
        try {
            this.gridLayout.verticalSpacing = new Integer(this.verticalSpacing.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.gridLayout.verticalSpacing = 5;
            this.verticalSpacing.select(2);
        }
    }
}

