/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.fileviewer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TreeAdapter;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.examples.fileviewer.IconCache;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class FileViewer {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("examples_fileviewer");
    private static final String DRIVE_A = "a:" + File.separator;
    private static final String DRIVE_B = "b:" + File.separator;
    private Display display;
    private Shell shell;
    private ToolBar toolBar;
    private Label numObjectsLabel;
    private Label diskSpaceLabel;
    private File currentDirectory = null;
    private boolean initial = true;
    private boolean isDragging = false;
    private boolean isDropping = false;
    private File[] processedDropFiles = null;
    private File[] deferredRefreshFiles = null;
    private boolean deferredRefreshRequested = false;
    private ProgressDialog progressDialog = null;
    private static final String COMBODATA_ROOTS = "Combo.roots";
    private static final String COMBODATA_LASTTEXT = "Combo.lastText";
    private Combo combo;
    private IconCache iconCache = new IconCache();
    private static final String TREEITEMDATA_FILE = "TreeItem.file";
    private static final String TREEITEMDATA_IMAGEEXPANDED = "TreeItem.imageExpanded";
    private static final String TREEITEMDATA_IMAGECOLLAPSED = "TreeItem.imageCollapsed";
    private static final String TREEITEMDATA_STUB = "TreeItem.stub";
    private Tree tree;
    private Label treeScopeLabel;
    private static final DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
    private static final String TABLEITEMDATA_FILE = "TableItem.file";
    private static final String TABLEDATA_DIR = "Table.dir";
    private static final int[] tableWidths = new int[]{150, 60, 75, 150};
    private final String[] tableTitles = new String[]{FileViewer.getResourceString("table.Name.title"), FileViewer.getResourceString("table.Size.title"), FileViewer.getResourceString("table.Type.title"), FileViewer.getResourceString("table.Modified.title")};
    private Table table;
    private Label tableContentsOfLabel;
    private final Object workerLock = new Object();
    private volatile Thread workerThread = null;
    private volatile boolean workerStopped = false;
    private volatile boolean workerCancelled = false;
    private volatile File workerStateDir = null;
    private volatile File workerNextDir = null;
    private boolean simulateOnly = true;
    private final Runnable workerRunnable = new Runnable(){

        public void run() {
            while (!FileViewer.this.workerStopped) {
                Object object = FileViewer.this.workerLock;
                synchronized (object) {
                    FileViewer.this.workerCancelled = false;
                    FileViewer.this.workerStateDir = FileViewer.this.workerNextDir;
                }
                FileViewer.this.workerExecute();
                object = FileViewer.this.workerLock;
                synchronized (object) {
                    try {
                        if (!FileViewer.this.workerCancelled && FileViewer.this.workerStateDir == FileViewer.this.workerNextDir) {
                            FileViewer.this.workerLock.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            FileViewer.this.workerThread = null;
            FileViewer.this.display.wake();
        }
    };

    public static void main(String[] args) {
        Display display = new Display();
        FileViewer application = new FileViewer();
        Shell shell = application.open(display);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        application.close();
        display.dispose();
    }

    public Shell open(Display display) {
        this.display = display;
        this.iconCache.initResources(display);
        this.shell = new Shell();
        this.createShellContents();
        this.notifyRefreshFiles(null);
        this.shell.open();
        return this.shell;
    }

    void close() {
        this.workerStop();
        this.iconCache.freeResources();
    }

    static String getResourceString(String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    static String getResourceString(String key, Object[] args) {
        try {
            return MessageFormat.format(FileViewer.getResourceString(key), args);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    private void createShellContents() {
        this.shell.setText(FileViewer.getResourceString("Title", new Object[]{""}));
        Image[] imageArray = this.iconCache.stockImages;
        this.iconCache.getClass();
        this.shell.setImage(imageArray[0]);
        Menu bar = new Menu((Decorations)this.shell, 2);
        this.shell.setMenuBar(bar);
        this.createFileMenu(bar);
        this.createHelpMenu(bar);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.shell.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(256);
        gridData.widthHint = 185;
        this.createComboView((Composite)this.shell, gridData);
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        this.createToolBar(this.shell, gridData);
        SashForm sashForm = new SashForm((Composite)this.shell, 0);
        sashForm.setOrientation(256);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        sashForm.setLayoutData((Object)gridData);
        this.createTreeView((Composite)sashForm);
        this.createTableView((Composite)sashForm);
        sashForm.setWeights(new int[]{2, 5});
        this.numObjectsLabel = new Label((Composite)this.shell, 2048);
        gridData = new GridData(784);
        gridData.widthHint = 185;
        this.numObjectsLabel.setLayoutData((Object)gridData);
        this.diskSpaceLabel = new Label((Composite)this.shell, 2048);
        gridData = new GridData(784);
        gridData.horizontalSpan = 2;
        this.diskSpaceLabel.setLayoutData((Object)gridData);
    }

    private void createFileMenu(Menu parent) {
        Menu menu = new Menu(parent);
        MenuItem header = new MenuItem(parent, 64);
        header.setText(FileViewer.getResourceString("menu.File.text"));
        header.setMenu(menu);
        final MenuItem simulateItem = new MenuItem(menu, 32);
        simulateItem.setText(FileViewer.getResourceString("menu.File.SimulateOnly.text"));
        simulateItem.setSelection(this.simulateOnly);
        simulateItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileViewer.this.simulateOnly = simulateItem.getSelection();
            }
        });
        MenuItem item = new MenuItem(menu, 8);
        item.setText(FileViewer.getResourceString("menu.File.Close.text"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileViewer.this.shell.close();
            }
        });
    }

    private void createHelpMenu(Menu parent) {
        Menu menu = new Menu(parent);
        MenuItem header = new MenuItem(parent, 64);
        header.setText(FileViewer.getResourceString("menu.Help.text"));
        header.setMenu(menu);
        MenuItem item = new MenuItem(menu, 8);
        item.setText(FileViewer.getResourceString("menu.Help.About.text"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox box = new MessageBox(FileViewer.this.shell, 34);
                box.setText(FileViewer.getResourceString("dialog.About.title"));
                box.setMessage(FileViewer.getResourceString("dialog.About.description", new Object[]{System.getProperty("os.name")}));
                box.open();
            }
        });
    }

    private void createToolBar(final Shell shell, Object layoutData) {
        this.toolBar = new ToolBar((Composite)shell, 0);
        this.toolBar.setLayoutData(layoutData);
        ToolItem item = new ToolItem(this.toolBar, 2);
        item = new ToolItem(this.toolBar, 8);
        item.setImage(this.iconCache.stockImages[this.iconCache.cmdParent]);
        item.setToolTipText(FileViewer.getResourceString("tool.Parent.tiptext"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileViewer.this.doParent();
            }
        });
        item = new ToolItem(this.toolBar, 8);
        item.setImage(this.iconCache.stockImages[this.iconCache.cmdRefresh]);
        item.setToolTipText(FileViewer.getResourceString("tool.Refresh.tiptext"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileViewer.this.doRefresh();
            }
        });
        SelectionAdapter unimplementedListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox box = new MessageBox(shell, 34);
                box.setText(FileViewer.getResourceString("dialog.NotImplemented.title"));
                box.setMessage(FileViewer.getResourceString("dialog.ActionNotImplemented.description"));
                box.open();
            }
        };
        item = new ToolItem(this.toolBar, 2);
        item = new ToolItem(this.toolBar, 8);
        item.setImage(this.iconCache.stockImages[this.iconCache.cmdCut]);
        item.setToolTipText(FileViewer.getResourceString("tool.Cut.tiptext"));
        item.addSelectionListener((SelectionListener)unimplementedListener);
        item = new ToolItem(this.toolBar, 8);
        item.setImage(this.iconCache.stockImages[this.iconCache.cmdCopy]);
        item.setToolTipText(FileViewer.getResourceString("tool.Copy.tiptext"));
        item.addSelectionListener((SelectionListener)unimplementedListener);
        item = new ToolItem(this.toolBar, 8);
        item.setImage(this.iconCache.stockImages[this.iconCache.cmdPaste]);
        item.setToolTipText(FileViewer.getResourceString("tool.Paste.tiptext"));
        item.addSelectionListener((SelectionListener)unimplementedListener);
        item = new ToolItem(this.toolBar, 2);
        item = new ToolItem(this.toolBar, 8);
        item.setImage(this.iconCache.stockImages[this.iconCache.cmdDelete]);
        item.setToolTipText(FileViewer.getResourceString("tool.Delete.tiptext"));
        item.addSelectionListener((SelectionListener)unimplementedListener);
        item = new ToolItem(this.toolBar, 8);
        item.setImage(this.iconCache.stockImages[this.iconCache.cmdRename]);
        item.setToolTipText(FileViewer.getResourceString("tool.Rename.tiptext"));
        item.addSelectionListener((SelectionListener)unimplementedListener);
        item = new ToolItem(this.toolBar, 2);
        item = new ToolItem(this.toolBar, 8);
        item.setImage(this.iconCache.stockImages[this.iconCache.cmdSearch]);
        item.setToolTipText(FileViewer.getResourceString("tool.Search.tiptext"));
        item.addSelectionListener((SelectionListener)unimplementedListener);
        item = new ToolItem(this.toolBar, 8);
        item.setImage(this.iconCache.stockImages[this.iconCache.cmdPrint]);
        item.setToolTipText(FileViewer.getResourceString("tool.Print.tiptext"));
        item.addSelectionListener((SelectionListener)unimplementedListener);
    }

    private void createComboView(Composite parent, Object layoutData) {
        this.combo = new Combo(parent, 0);
        this.combo.setLayoutData(layoutData);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File[] roots = (File[])FileViewer.this.combo.getData(FileViewer.COMBODATA_ROOTS);
                if (roots == null) {
                    return;
                }
                int selection = FileViewer.this.combo.getSelectionIndex();
                if (selection >= 0 && selection < roots.length) {
                    FileViewer.this.notifySelectedDirectory(roots[selection]);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                String lastText = (String)FileViewer.this.combo.getData(FileViewer.COMBODATA_LASTTEXT);
                String text = FileViewer.this.combo.getText();
                if (text == null) {
                    return;
                }
                if (lastText != null && lastText.equals(text)) {
                    return;
                }
                FileViewer.this.combo.setData(FileViewer.COMBODATA_LASTTEXT, (Object)text);
                FileViewer.this.notifySelectedDirectory(new File(text));
            }
        });
    }

    private void createTreeView(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.treeScopeLabel = new Label(composite, 2048);
        this.treeScopeLabel.setText(FileViewer.getResourceString("details.AllFolders.text"));
        this.treeScopeLabel.setLayoutData((Object)new GridData(784));
        this.tree = new Tree(composite, 2820);
        this.tree.setLayoutData((Object)new GridData(1808));
        this.tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                TreeItem[] selection = FileViewer.this.tree.getSelection();
                if (selection != null && selection.length != 0) {
                    TreeItem item = selection[0];
                    File file = (File)item.getData(FileViewer.TREEITEMDATA_FILE);
                    FileViewer.this.notifySelectedDirectory(file);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                TreeItem[] selection = FileViewer.this.tree.getSelection();
                if (selection != null && selection.length != 0) {
                    TreeItem item = selection[0];
                    item.setExpanded(true);
                    FileViewer.this.treeExpandItem(item);
                }
            }
        });
        this.tree.addTreeListener((TreeListener)new TreeAdapter(){

            public void treeExpanded(TreeEvent event) {
                TreeItem item = (TreeItem)event.item;
                Image image = (Image)item.getData(FileViewer.TREEITEMDATA_IMAGEEXPANDED);
                if (image != null) {
                    item.setImage(image);
                }
                FileViewer.this.treeExpandItem(item);
            }

            public void treeCollapsed(TreeEvent event) {
                TreeItem item = (TreeItem)event.item;
                Image image = (Image)item.getData(FileViewer.TREEITEMDATA_IMAGECOLLAPSED);
                if (image != null) {
                    item.setImage(image);
                }
            }
        });
        this.createTreeDragSource(this.tree);
        this.createTreeDropTarget(this.tree);
    }

    private DragSource createTreeDragSource(final Tree tree) {
        DragSource dragSource = new DragSource((Control)tree, 3);
        dragSource.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){
            TreeItem[] dndSelection = null;
            String[] sourceNames = null;

            public void dragStart(DragSourceEvent event) {
                this.dndSelection = tree.getSelection();
                this.sourceNames = null;
                event.doit = this.dndSelection.length > 0;
                FileViewer.this.isDragging = true;
                FileViewer.this.processedDropFiles = null;
            }

            public void dragFinished(DragSourceEvent event) {
                FileViewer.this.dragSourceHandleDragFinished(event, this.sourceNames);
                this.dndSelection = null;
                this.sourceNames = null;
                FileViewer.this.isDragging = false;
                FileViewer.this.processedDropFiles = null;
                FileViewer.this.handleDeferredRefresh();
            }

            public void dragSetData(DragSourceEvent event) {
                if (this.dndSelection == null || this.dndSelection.length == 0) {
                    return;
                }
                if (!FileTransfer.getInstance().isSupportedType(event.dataType)) {
                    return;
                }
                this.sourceNames = new String[this.dndSelection.length];
                int i = 0;
                while (i < this.dndSelection.length) {
                    File file = (File)this.dndSelection[i].getData(FileViewer.TREEITEMDATA_FILE);
                    this.sourceNames[i] = file.getAbsolutePath();
                    ++i;
                }
                event.data = this.sourceNames;
            }
        });
        return dragSource;
    }

    private DropTarget createTreeDropTarget(final Tree tree) {
        DropTarget dropTarget = new DropTarget((Control)tree, 3);
        dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                FileViewer.this.isDropping = true;
            }

            public void dragLeave(DropTargetEvent event) {
                FileViewer.this.isDropping = false;
                FileViewer.this.handleDeferredRefresh();
            }

            public void dragOver(DropTargetEvent event) {
                FileViewer.this.dropTargetValidate(event, this.getTargetFile(event));
                event.feedback |= 0x18;
            }

            public void drop(DropTargetEvent event) {
                File targetFile = this.getTargetFile(event);
                if (FileViewer.this.dropTargetValidate(event, targetFile)) {
                    FileViewer.this.dropTargetHandleDrop(event, targetFile);
                }
            }

            private File getTargetFile(DropTargetEvent event) {
                TreeItem item = tree.getItem(tree.toControl(new Point(event.x, event.y)));
                File targetFile = null;
                if (item != null) {
                    targetFile = (File)item.getData(FileViewer.TREEITEMDATA_FILE);
                }
                return targetFile;
            }
        });
        return dropTarget;
    }

    private void treeExpandItem(TreeItem item) {
        Cursor[] cursorArray = this.iconCache.stockCursors;
        this.iconCache.getClass();
        this.shell.setCursor(cursorArray[1]);
        Object stub = item.getData(TREEITEMDATA_STUB);
        if (stub == null) {
            this.treeRefreshItem(item, true);
        }
        Cursor[] cursorArray2 = this.iconCache.stockCursors;
        this.iconCache.getClass();
        this.shell.setCursor(cursorArray2[0]);
    }

    private void treeRefresh(File[] masterFiles) {
        TreeItem[] items = this.tree.getItems();
        int masterIndex = 0;
        int itemIndex = 0;
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            File itemFile = (File)item.getData(TREEITEMDATA_FILE);
            if (itemFile == null || masterIndex == masterFiles.length) {
                item.dispose();
            } else {
                File masterFile = masterFiles[masterIndex];
                int compare = FileViewer.compareFiles(masterFile, itemFile);
                if (compare == 0) {
                    this.treeRefreshItem(item, false);
                    ++itemIndex;
                    ++masterIndex;
                } else if (compare < 0) {
                    TreeItem newItem = new TreeItem(this.tree, 0, itemIndex);
                    this.treeInitVolume(newItem, masterFile);
                    new TreeItem(newItem, 0);
                    ++itemIndex;
                    ++masterIndex;
                    --i;
                } else {
                    item.dispose();
                }
            }
            ++i;
        }
        while (masterIndex < masterFiles.length) {
            File masterFile = masterFiles[masterIndex];
            TreeItem newItem = new TreeItem(this.tree, 0);
            this.treeInitVolume(newItem, masterFile);
            new TreeItem(newItem, 0);
            ++masterIndex;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void treeRefreshItem(TreeItem dirItem, boolean forcePopulate) {
        dir = (File)dirItem.getData("TreeItem.file");
        if (!forcePopulate && !dirItem.getExpanded()) {
            if (dirItem.getData("TreeItem.stub") != null) {
                FileViewer.treeItemRemoveAll(dirItem);
                new TreeItem(dirItem, 0);
                dirItem.setData("TreeItem.stub", null);
            }
            return;
        }
        dirItem.setData("TreeItem.stub", (Object)this);
        v0 = subFiles = dir != null ? FileViewer.getDirectoryList(dir) : null;
        if (subFiles == null || subFiles.length == 0) {
            FileViewer.treeItemRemoveAll(dirItem);
            dirItem.setExpanded(false);
            return;
        }
        items = dirItem.getItems();
        masterFiles = subFiles;
        masterIndex = 0;
        itemIndex = 0;
        masterFile = null;
        i = 0;
        ** GOTO lbl46
        {
            if (!(masterFile = masterFiles[masterIndex++]).isDirectory()) {
                masterFile = null;
            }
            do {
                if (masterFile == null && masterIndex < masterFiles.length) continue block0;
                item = items[i];
                itemFile = (File)item.getData("TreeItem.file");
                if (itemFile == null || masterFile == null) {
                    item.dispose();
                } else {
                    compare = FileViewer.compareFiles(masterFile, itemFile);
                    if (compare == 0) {
                        this.treeRefreshItem(item, false);
                        masterFile = null;
                        ++itemIndex;
                    } else if (compare < 0) {
                        newItem = new TreeItem(dirItem, 0, itemIndex);
                        this.treeInitFolder(newItem, masterFile);
                        new TreeItem(newItem, 0);
                        masterFile = null;
                        ++itemIndex;
                        --i;
                    } else {
                        item.dispose();
                    }
                }
                ++i;
lbl46:
                // 2 sources

            } while (i < items.length);
        }
        while (masterFile != null || masterIndex < masterFiles.length) {
            if (masterFile != null) {
                newItem = new TreeItem(dirItem, 0);
                this.treeInitFolder(newItem, masterFile);
                new TreeItem(newItem, 0);
                if (masterIndex == masterFiles.length) break;
            }
            if ((masterFile = masterFiles[masterIndex++]).isDirectory()) continue;
            masterFile = null;
        }
    }

    private static void treeItemRemoveAll(TreeItem treeItem) {
        TreeItem[] children = treeItem.getItems();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
    }

    private void treeInitFolder(TreeItem item, File folder) {
        item.setText(folder.getName());
        item.setImage(this.iconCache.stockImages[this.iconCache.iconClosedFolder]);
        item.setData(TREEITEMDATA_FILE, (Object)folder);
        item.setData(TREEITEMDATA_IMAGEEXPANDED, (Object)this.iconCache.stockImages[this.iconCache.iconOpenFolder]);
        item.setData(TREEITEMDATA_IMAGECOLLAPSED, (Object)this.iconCache.stockImages[this.iconCache.iconClosedFolder]);
    }

    private void treeInitVolume(TreeItem item, File volume) {
        item.setText(volume.getPath());
        Image[] imageArray = this.iconCache.stockImages;
        this.iconCache.getClass();
        item.setImage(imageArray[1]);
        item.setData(TREEITEMDATA_FILE, (Object)volume);
        item.setData(TREEITEMDATA_IMAGEEXPANDED, (Object)this.iconCache.stockImages[this.iconCache.iconOpenDrive]);
        Image[] imageArray2 = this.iconCache.stockImages;
        this.iconCache.getClass();
        item.setData(TREEITEMDATA_IMAGECOLLAPSED, (Object)imageArray2[1]);
    }

    private void createTableView(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.tableContentsOfLabel = new Label(composite, 2048);
        this.tableContentsOfLabel.setLayoutData((Object)new GridData(784));
        this.table = new Table(composite, 68354);
        this.table.setLayoutData((Object)new GridData(1808));
        int i = 0;
        while (i < this.tableTitles.length) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(this.tableTitles[i]);
            column.setWidth(tableWidths[i]);
            ++i;
        }
        this.table.setHeaderVisible(true);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileViewer.this.notifySelectedFiles(this.getSelectedFiles());
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                FileViewer.this.doDefaultFileAction(this.getSelectedFiles());
            }

            private File[] getSelectedFiles() {
                TableItem[] items = FileViewer.this.table.getSelection();
                File[] files = new File[items.length];
                int i = 0;
                while (i < items.length) {
                    files[i] = (File)items[i].getData(FileViewer.TABLEITEMDATA_FILE);
                    ++i;
                }
                return files;
            }
        });
        this.createTableDragSource(this.table);
        this.createTableDropTarget(this.table);
    }

    private DragSource createTableDragSource(final Table table) {
        DragSource dragSource = new DragSource((Control)table, 3);
        dragSource.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){
            TableItem[] dndSelection = null;
            String[] sourceNames = null;

            public void dragStart(DragSourceEvent event) {
                this.dndSelection = table.getSelection();
                this.sourceNames = null;
                event.doit = this.dndSelection.length > 0;
                FileViewer.this.isDragging = true;
            }

            public void dragFinished(DragSourceEvent event) {
                FileViewer.this.dragSourceHandleDragFinished(event, this.sourceNames);
                this.dndSelection = null;
                this.sourceNames = null;
                FileViewer.this.isDragging = false;
                FileViewer.this.handleDeferredRefresh();
            }

            public void dragSetData(DragSourceEvent event) {
                if (this.dndSelection == null || this.dndSelection.length == 0) {
                    return;
                }
                if (!FileTransfer.getInstance().isSupportedType(event.dataType)) {
                    return;
                }
                this.sourceNames = new String[this.dndSelection.length];
                int i = 0;
                while (i < this.dndSelection.length) {
                    File file = (File)this.dndSelection[i].getData(FileViewer.TABLEITEMDATA_FILE);
                    this.sourceNames[i] = file.getAbsolutePath();
                    ++i;
                }
                event.data = this.sourceNames;
            }
        });
        return dragSource;
    }

    private DropTarget createTableDropTarget(final Table table) {
        DropTarget dropTarget = new DropTarget((Control)table, 3);
        dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                FileViewer.this.isDropping = true;
            }

            public void dragLeave(DropTargetEvent event) {
                FileViewer.this.isDropping = false;
                FileViewer.this.handleDeferredRefresh();
            }

            public void dragOver(DropTargetEvent event) {
                FileViewer.this.dropTargetValidate(event, this.getTargetFile(event));
                event.feedback |= 0x18;
            }

            public void drop(DropTargetEvent event) {
                File targetFile = this.getTargetFile(event);
                if (FileViewer.this.dropTargetValidate(event, targetFile)) {
                    FileViewer.this.dropTargetHandleDrop(event, targetFile);
                }
            }

            private File getTargetFile(DropTargetEvent event) {
                TableItem item = table.getItem(table.toControl(new Point(event.x, event.y)));
                File targetFile = null;
                if (item == null) {
                    if (event.detail == 1) {
                        targetFile = (File)table.getData(FileViewer.TABLEDATA_DIR);
                    }
                } else {
                    targetFile = (File)item.getData(FileViewer.TABLEITEMDATA_FILE);
                }
                return targetFile;
            }
        });
        return dropTarget;
    }

    void notifySelectedDirectory(File dir) {
        TreeItem[] treeItemArray;
        if (dir == null) {
            return;
        }
        if (this.currentDirectory != null && dir.equals(this.currentDirectory)) {
            return;
        }
        this.currentDirectory = dir;
        this.notifySelectedFiles(null);
        this.shell.setText(FileViewer.getResourceString("Title", new Object[]{this.currentDirectory.getPath()}));
        this.workerUpdate(dir, false);
        File[] comboRoots = (File[])this.combo.getData(COMBODATA_ROOTS);
        int comboEntry = -1;
        if (comboRoots != null) {
            int i = 0;
            while (i < comboRoots.length) {
                if (dir.equals(comboRoots[i])) {
                    comboEntry = i;
                    break;
                }
                ++i;
            }
        }
        if (comboEntry == -1) {
            this.combo.setText(dir.getPath());
        } else {
            this.combo.select(comboEntry);
        }
        Vector<File> path = new Vector<File>();
        while (dir != null) {
            path.add(dir);
            dir = dir.getParentFile();
        }
        TreeItem[] items = this.tree.getItems();
        TreeItem lastItem = null;
        int i = path.size() - 1;
        while (i >= 0) {
            File pathElement = (File)path.elementAt(i);
            TreeItem item = null;
            int k = 0;
            while (k < items.length) {
                File itemFile;
                item = items[k];
                if (!item.isDisposed() && (itemFile = (File)item.getData(TREEITEMDATA_FILE)) != null && itemFile.equals(pathElement)) break;
                ++k;
            }
            if (item == null) break;
            lastItem = item;
            if (i != 0 && !item.getExpanded()) {
                this.treeExpandItem(item);
                item.setExpanded(true);
            }
            items = item.getItems();
            --i;
        }
        if (lastItem != null) {
            TreeItem[] treeItemArray2 = new TreeItem[1];
            treeItemArray = treeItemArray2;
            treeItemArray2[0] = lastItem;
        } else {
            treeItemArray = new TreeItem[]{};
        }
        this.tree.setSelection(treeItemArray);
    }

    void notifySelectedFiles(File[] files) {
        if (files != null && files.length != 0) {
            this.numObjectsLabel.setText(FileViewer.getResourceString("details.NumberOfSelectedFiles.text", new Object[]{new Integer(files.length)}));
            long fileSize = 0L;
            int i = 0;
            while (i < files.length) {
                fileSize += files[i].length();
                ++i;
            }
            this.diskSpaceLabel.setText(FileViewer.getResourceString("details.FileSize.text", new Object[]{new Long(fileSize)}));
        } else {
            this.diskSpaceLabel.setText("");
            if (this.currentDirectory != null) {
                int numObjects = FileViewer.getDirectoryList(this.currentDirectory).length;
                this.numObjectsLabel.setText(FileViewer.getResourceString("details.DirNumberOfObjects.text", new Object[]{new Integer(numObjects)}));
            } else {
                this.numObjectsLabel.setText("");
            }
        }
    }

    void notifyRefreshFiles(File[] files) {
        if (files != null && files.length == 0) {
            return;
        }
        if (this.deferredRefreshRequested && this.deferredRefreshFiles != null && files != null) {
            File[] newRequest = new File[this.deferredRefreshFiles.length + files.length];
            System.arraycopy(this.deferredRefreshFiles, 0, newRequest, 0, this.deferredRefreshFiles.length);
            System.arraycopy(files, 0, newRequest, this.deferredRefreshFiles.length, files.length);
            this.deferredRefreshFiles = newRequest;
        } else {
            this.deferredRefreshFiles = files;
            this.deferredRefreshRequested = true;
        }
        this.handleDeferredRefresh();
    }

    void handleDeferredRefresh() {
        if (this.isDragging || this.isDropping || !this.deferredRefreshRequested) {
            return;
        }
        if (this.progressDialog != null) {
            this.progressDialog.close();
            this.progressDialog = null;
        }
        this.deferredRefreshRequested = false;
        File[] files = this.deferredRefreshFiles;
        this.deferredRefreshFiles = null;
        Cursor[] cursorArray = this.iconCache.stockCursors;
        this.iconCache.getClass();
        this.shell.setCursor(cursorArray[1]);
        boolean refreshTable = false;
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.equals(this.currentDirectory)) {
                    refreshTable = true;
                    break;
                }
                File parentFile = file.getParentFile();
                if (parentFile != null && parentFile.equals(this.currentDirectory)) {
                    refreshTable = true;
                    break;
                }
                ++i;
            }
        } else {
            refreshTable = true;
        }
        if (refreshTable) {
            this.workerUpdate(this.currentDirectory, true);
        }
        File[] roots = this.getRoots();
        if (files == null) {
            int i;
            boolean refreshCombo = false;
            File[] comboRoots = (File[])this.combo.getData(COMBODATA_ROOTS);
            if (comboRoots != null && comboRoots.length == roots.length) {
                i = 0;
                while (i < roots.length) {
                    if (!roots[i].equals(comboRoots[i])) {
                        refreshCombo = true;
                        break;
                    }
                    ++i;
                }
            } else {
                refreshCombo = true;
            }
            if (refreshCombo) {
                this.combo.removeAll();
                this.combo.setData(COMBODATA_ROOTS, (Object)roots);
                i = 0;
                while (i < roots.length) {
                    File file = roots[i];
                    this.combo.add(file.getPath());
                    ++i;
                }
            }
        }
        this.treeRefresh(roots);
        File dir = this.currentDirectory;
        this.currentDirectory = null;
        this.notifySelectedDirectory(dir);
        Cursor[] cursorArray2 = this.iconCache.stockCursors;
        this.iconCache.getClass();
        this.shell.setCursor(cursorArray2[0]);
    }

    void doDefaultFileAction(File[] files) {
        if (files.length == 0) {
            return;
        }
        File file = files[0];
        if (file.isDirectory()) {
            this.notifySelectedDirectory(file);
        } else {
            String fileName = file.getAbsolutePath();
            if (!Program.launch((String)fileName)) {
                MessageBox dialog = new MessageBox(this.shell, 33);
                dialog.setMessage(FileViewer.getResourceString("error.FailedLaunch.message", new Object[]{fileName}));
                dialog.setText(this.shell.getText());
                dialog.open();
            }
        }
    }

    void doParent() {
        if (this.currentDirectory == null) {
            return;
        }
        File parentDirectory = this.currentDirectory.getParentFile();
        this.notifySelectedDirectory(parentDirectory);
    }

    void doRefresh() {
        this.notifyRefreshFiles(null);
    }

    private boolean dropTargetValidate(DropTargetEvent event, File targetFile) {
        if (targetFile != null && targetFile.isDirectory()) {
            if (event.detail != 1 && event.detail != 2) {
                event.detail = 2;
            }
        } else {
            event.detail = 0;
        }
        return event.detail != 0;
    }

    private void dropTargetHandleDrop(DropTargetEvent event, File targetFile) {
        if (!this.dropTargetValidate(event, targetFile)) {
            return;
        }
        String[] sourceNames = (String[])event.data;
        if (sourceNames == null) {
            event.detail = 0;
        }
        if (event.detail == 0) {
            return;
        }
        this.progressDialog = new ProgressDialog(this.shell, event.detail == 2 ? 2 : 0);
        this.progressDialog.setTotalWorkUnits(sourceNames.length);
        this.progressDialog.open();
        Vector<File> processedFiles = new Vector<File>();
        int i = 0;
        while (i < sourceNames.length && !this.progressDialog.isCancelled()) {
            File source = new File(sourceNames[i]);
            File dest = new File(targetFile, source.getName());
            if (!source.equals(dest)) {
                this.progressDialog.setDetailFile(source, 0);
                while (!this.progressDialog.isCancelled()) {
                    if (this.copyFileStructure(source, dest)) {
                        processedFiles.add(source);
                        break;
                    }
                    if (!this.progressDialog.isCancelled()) {
                        int button;
                        MessageBox box;
                        if (event.detail == 2 && !this.isDragging) {
                            box = new MessageBox(this.shell, 1281);
                            box.setText(FileViewer.getResourceString("dialog.FailedCopy.title"));
                            box.setMessage(FileViewer.getResourceString("dialog.FailedCopy.description", new Object[]{source, dest}));
                            button = box.open();
                            if (button == 256) {
                                i = sourceNames.length;
                                event.detail = 0;
                                break;
                            }
                        } else {
                            box = new MessageBox(this.shell, 3585);
                            box.setText(FileViewer.getResourceString("dialog.FailedCopy.title"));
                            box.setMessage(FileViewer.getResourceString("dialog.FailedCopy.description", new Object[]{source, dest}));
                            button = box.open();
                            if (button == 512) {
                                i = sourceNames.length;
                            }
                            if (button != 1024) break;
                        }
                    }
                    this.progressDialog.addProgress(1);
                }
            }
            ++i;
        }
        if (this.isDragging) {
            this.processedDropFiles = processedFiles.toArray(new File[processedFiles.size()]);
        } else {
            this.progressDialog.close();
            this.progressDialog = null;
        }
        this.notifyRefreshFiles(new File[]{targetFile});
    }

    private void dragSourceHandleDragFinished(DragSourceEvent event, String[] sourceNames) {
        int i;
        File[] sourceFiles;
        if (sourceNames == null) {
            return;
        }
        if (event.detail != 2) {
            return;
        }
        if (this.processedDropFiles != null) {
            sourceFiles = this.processedDropFiles;
        } else {
            sourceFiles = new File[sourceNames.length];
            i = 0;
            while (i < sourceNames.length) {
                sourceFiles[i] = new File(sourceNames[i]);
                ++i;
            }
        }
        if (this.progressDialog == null) {
            this.progressDialog = new ProgressDialog(this.shell, 2);
        }
        this.progressDialog.setTotalWorkUnits(sourceFiles.length);
        this.progressDialog.setProgress(0);
        this.progressDialog.open();
        i = 0;
        while (i < sourceFiles.length && !this.progressDialog.isCancelled()) {
            File source = sourceFiles[i];
            this.progressDialog.setDetailFile(source, 1);
            while (!this.progressDialog.isCancelled()) {
                if (this.deleteFileStructure(source)) break;
                if (this.progressDialog.isCancelled()) continue;
                MessageBox box = new MessageBox(this.shell, 3585);
                box.setText(FileViewer.getResourceString("dialog.FailedDelete.title"));
                box.setMessage(FileViewer.getResourceString("dialog.FailedDelete.description", new Object[]{source}));
                int button = box.open();
                if (button == 512) {
                    i = sourceNames.length;
                }
                if (button == 1024) break;
            }
            this.progressDialog.addProgress(1);
            ++i;
        }
        this.notifyRefreshFiles(sourceFiles);
        this.progressDialog.close();
        this.progressDialog = null;
    }

    File[] getRoots() {
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            Vector<File> list = new Vector<File>();
            list.add(new File(DRIVE_A));
            list.add(new File(DRIVE_B));
            char i = 'c';
            while (i <= 'z') {
                File drive = new File(String.valueOf(i) + ":" + File.separator);
                if (drive.isDirectory() && drive.exists()) {
                    list.add(drive);
                    if (this.initial && i == 'c') {
                        this.currentDirectory = drive;
                        this.initial = false;
                    }
                }
                i = (char)(i + '\u0001');
            }
            File[] roots = list.toArray(new File[list.size()]);
            FileViewer.sortFiles(roots);
            return roots;
        }
        File root = new File(File.separator);
        if (this.initial) {
            this.currentDirectory = root;
        }
        return new File[]{root};
    }

    static File[] getDirectoryList(File file) {
        File[] list = file.listFiles();
        if (list == null) {
            return new File[0];
        }
        FileViewer.sortFiles(list);
        return list;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean copyFileStructure(File oldFile, File newFile) {
        if (oldFile == null) return false;
        if (newFile == null) {
            return false;
        }
        File searchFile = newFile;
        do {
            if (!oldFile.equals(searchFile)) continue;
            return false;
        } while ((searchFile = searchFile.getParentFile()) != null);
        if (oldFile.isDirectory()) {
            if (this.progressDialog != null) {
                this.progressDialog.setDetailFile(oldFile, 0);
            }
            if (!this.simulateOnly && !newFile.mkdirs()) {
                return false;
            }
            File[] subFiles = oldFile.listFiles();
            if (subFiles == null) return true;
            if (this.progressDialog != null) {
                this.progressDialog.addWorkUnits(subFiles.length);
            }
            int i = 0;
            while (true) {
                if (i >= subFiles.length) {
                    return true;
                }
                File oldSubFile = subFiles[i];
                File newSubFile = new File(newFile, oldSubFile.getName());
                if (!this.copyFileStructure(oldSubFile, newSubFile)) {
                    return false;
                }
                if (this.progressDialog != null) {
                    this.progressDialog.addProgress(1);
                    if (this.progressDialog.isCancelled()) {
                        return false;
                    }
                }
                ++i;
            }
        }
        if (this.simulateOnly) return true;
        FileReader in = null;
        FileWriter out = null;
        try {
            try {
                int count;
                in = new FileReader(oldFile);
                out = new FileWriter(newFile);
                while ((count = in.read()) != -1) {
                    out.write(count);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Object var7_11 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out == null) return false;
                    out.close();
                    return false;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            catch (IOException iOException) {
                Object var7_12 = null;
                try {}
                catch (IOException iOException2) {
                    return false;
                }
                if (in != null) {
                    in.close();
                }
                if (out == null) return false;
                out.close();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            try {}
            catch (IOException iOException) {
                return false;
            }
            if (in != null) {
                in.close();
            }
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
        {
            Object var7_14 = null;
        }
        try {}
        catch (IOException iOException) {
            return false;
        }
        if (in != null) {
            in.close();
        }
        if (out == null) return true;
        out.close();
        return true;
    }

    boolean deleteFileStructure(File oldFile) {
        if (oldFile == null) {
            return false;
        }
        if (oldFile.isDirectory()) {
            File[] subFiles;
            if (this.progressDialog != null) {
                this.progressDialog.setDetailFile(oldFile, 1);
            }
            if ((subFiles = oldFile.listFiles()) != null) {
                if (this.progressDialog != null) {
                    this.progressDialog.addWorkUnits(subFiles.length);
                }
                int i = 0;
                while (i < subFiles.length) {
                    File oldSubFile = subFiles[i];
                    if (!this.deleteFileStructure(oldSubFile)) {
                        return false;
                    }
                    if (this.progressDialog != null) {
                        this.progressDialog.addProgress(1);
                        if (this.progressDialog.isCancelled()) {
                            return false;
                        }
                    }
                    ++i;
                }
            }
        }
        if (this.simulateOnly) {
            return true;
        }
        return oldFile.delete();
    }

    static void sortFiles(File[] files) {
        FileViewer.sortBlock(files, 0, files.length - 1, new File[files.length]);
    }

    private static void sortBlock(File[] files, int start, int end, File[] mergeTemp) {
        int length = end - start + 1;
        if (length < 8) {
            int i = end;
            while (i > start) {
                int j = end;
                while (j > start) {
                    if (FileViewer.compareFiles(files[j - 1], files[j]) > 0) {
                        File temp = files[j];
                        files[j] = files[j - 1];
                        files[j - 1] = temp;
                    }
                    --j;
                }
                --i;
            }
            return;
        }
        int mid = (start + end) / 2;
        FileViewer.sortBlock(files, start, mid, mergeTemp);
        FileViewer.sortBlock(files, mid + 1, end, mergeTemp);
        int x = start;
        int y = mid + 1;
        int i = 0;
        while (i < length) {
            mergeTemp[i] = x > mid || y <= end && FileViewer.compareFiles(files[x], files[y]) > 0 ? files[y++] : files[x++];
            ++i;
        }
        i = 0;
        while (i < length) {
            files[i + start] = mergeTemp[i];
            ++i;
        }
    }

    private static int compareFiles(File a, File b) {
        int compare = a.getName().compareToIgnoreCase(b.getName());
        if (compare == 0) {
            compare = a.getName().compareTo(b.getName());
        }
        return compare;
    }

    /*
     * Unable to fully structure code
     */
    void workerStop() {
        if (this.workerThread == null) {
            return;
        }
        var1_1 = this.workerLock;
        synchronized (var1_1) {
            this.workerCancelled = true;
            this.workerStopped = true;
            this.workerLock.notifyAll();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
            if (true) ** GOTO lbl17
        }
        do {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
lbl17:
            // 3 sources

        } while (this.workerThread != null);
    }

    void workerUpdate(File dir, boolean force) {
        if (dir == null) {
            return;
        }
        if (!force && this.workerNextDir != null && this.workerNextDir.equals(dir)) {
            return;
        }
        Object object = this.workerLock;
        synchronized (object) {
            this.workerNextDir = dir;
            this.workerStopped = false;
            this.workerCancelled = true;
            this.workerLock.notifyAll();
        }
        if (this.workerThread == null) {
            this.workerThread = new Thread(this.workerRunnable);
            this.workerThread.start();
        }
    }

    private void workerExecute() {
        this.display.syncExec(new Runnable(){

            public void run() {
                FileViewer.this.tableContentsOfLabel.setText(FileViewer.getResourceString("details.ContentsOf.text", new Object[]{FileViewer.this.workerStateDir.getPath()}));
                FileViewer.this.table.removeAll();
                FileViewer.this.table.setData(FileViewer.TABLEDATA_DIR, (Object)FileViewer.this.workerStateDir);
            }
        });
        File[] dirList = FileViewer.getDirectoryList(this.workerStateDir);
        int i = 0;
        while (!this.workerCancelled && i < dirList.length) {
            this.workerAddFileDetails(dirList[i]);
            ++i;
        }
    }

    private void workerAddFileDetails(final File file) {
        Image iconImage;
        String sizeString;
        String typeString;
        String nameString = file.getName();
        String dateString = dateFormat.format(new Date(file.lastModified()));
        if (file.isDirectory()) {
            typeString = FileViewer.getResourceString("filetype.Folder");
            sizeString = "";
            iconImage = this.iconCache.stockImages[this.iconCache.iconClosedFolder];
        } else {
            sizeString = FileViewer.getResourceString("filesize.KB", new Object[]{new Long((file.length() + 512L) / 1024L)});
            int dot = nameString.lastIndexOf(46);
            if (dot != -1) {
                String extension = nameString.substring(dot);
                Program program = Program.findProgram((String)extension);
                if (program != null) {
                    typeString = program.getName();
                    iconImage = this.iconCache.getIconFromProgram(program);
                } else {
                    typeString = FileViewer.getResourceString("filetype.Unknown", new Object[]{extension.toUpperCase()});
                    iconImage = this.iconCache.stockImages[this.iconCache.iconFile];
                }
            } else {
                typeString = FileViewer.getResourceString("filetype.None");
                iconImage = this.iconCache.stockImages[this.iconCache.iconFile];
            }
        }
        final String[] strings = new String[]{nameString, sizeString, typeString, dateString};
        this.display.syncExec(new Runnable(){

            public void run() {
                if (FileViewer.this.shell.isDisposed()) {
                    return;
                }
                TableItem tableItem = new TableItem(FileViewer.this.table, 0);
                tableItem.setText(strings);
                tableItem.setImage(iconImage);
                tableItem.setData(FileViewer.TABLEITEMDATA_FILE, (Object)file);
            }
        });
    }

    class ProgressDialog {
        public static final int COPY = 0;
        public static final int DELETE = 1;
        public static final int MOVE = 2;
        Shell shell;
        Label messageLabel;
        Label detailLabel;
        ProgressBar progressBar;
        Button cancelButton;
        boolean isCancelled = false;
        final String[] operationKeyName = new String[]{"Copy", "Delete", "Move"};

        public ProgressDialog(Shell parent, int style) {
            this.shell = new Shell(parent, 67616);
            GridLayout gridLayout = new GridLayout();
            this.shell.setLayout((Layout)gridLayout);
            this.shell.setText(FileViewer.getResourceString("progressDialog." + this.operationKeyName[style] + ".title"));
            this.shell.addShellListener((ShellListener)new ShellAdapter(this){
                final /* synthetic */ ProgressDialog this$1;
                {
                    this.this$1 = progressDialog;
                }

                public void shellClosed(ShellEvent e) {
                    this.this$1.isCancelled = true;
                }
            });
            this.messageLabel = new Label((Composite)this.shell, 256);
            this.messageLabel.setLayoutData((Object)new GridData(784));
            this.messageLabel.setText(FileViewer.getResourceString("progressDialog." + this.operationKeyName[style] + ".description"));
            this.progressBar = new ProgressBar((Composite)this.shell, 320);
            this.progressBar.setLayoutData((Object)new GridData(784));
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(0);
            this.detailLabel = new Label((Composite)this.shell, 256);
            GridData gridData = new GridData(770);
            gridData.widthHint = 400;
            this.detailLabel.setLayoutData((Object)gridData);
            this.cancelButton = new Button((Composite)this.shell, 8);
            this.cancelButton.setLayoutData((Object)new GridData(144));
            this.cancelButton.setText(FileViewer.getResourceString("progressDialog.cancelButton.text"));
            this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ProgressDialog this$1;
                {
                    this.this$1 = progressDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.isCancelled = true;
                    this.this$1.cancelButton.setEnabled(false);
                }
            });
        }

        public void setDetailFile(File file, int operation) {
            this.detailLabel.setText(FileViewer.getResourceString("progressDialog." + this.operationKeyName[operation] + ".operation", new Object[]{file}));
        }

        public boolean isCancelled() {
            return this.isCancelled;
        }

        public void setTotalWorkUnits(int work) {
            this.progressBar.setMaximum(work);
        }

        public void addWorkUnits(int work) {
            this.setTotalWorkUnits(this.progressBar.getMaximum() + work);
        }

        public void setProgress(int work) {
            this.progressBar.setSelection(work);
            while (FileViewer.this.display.readAndDispatch()) {
            }
        }

        public void addProgress(int work) {
            this.setProgress(this.progressBar.getSelection() + work);
        }

        public void open() {
            this.shell.pack();
            Shell parentShell = (Shell)this.shell.getParent();
            Rectangle rect = parentShell.getBounds();
            Rectangle bounds = this.shell.getBounds();
            bounds.x = rect.x + (rect.width - bounds.width) / 2;
            bounds.y = rect.y + (rect.height - bounds.height) / 2;
            this.shell.setBounds(bounds);
            this.shell.open();
        }

        public void close() {
            this.shell.close();
            this.shell.dispose();
            this.shell = null;
            this.messageLabel = null;
            this.detailLabel = null;
            this.progressBar = null;
            this.cancelButton = null;
        }
    }
}

