/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.ScrollableTab;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;

class TextTab
extends ScrollableTab {
    Text text;
    Group textGroup;
    Button wrapButton;
    Button readOnlyButton;
    static /* synthetic */ Class class$0;

    TextTab(ControlExample instance) {
        super(instance);
    }

    Image createBitmapImage(Display display, String name) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.examples.controlexample.ControlExample");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ImageData source = new ImageData(clazz.getResourceAsStream(String.valueOf(name) + ".bmp"));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.swt.examples.controlexample.ControlExample");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ImageData mask = new ImageData(clazz2.getResourceAsStream(String.valueOf(name) + "_mask.bmp"));
        return new Image((Device)display, source, mask);
    }

    void createExampleGroup() {
        super.createExampleGroup();
        this.textGroup = new Group((Composite)this.exampleGroup, 0);
        this.textGroup.setLayout((Layout)new GridLayout());
        this.textGroup.setLayoutData((Object)new GridData(784));
        this.textGroup.setText("Text");
    }

    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.singleButton.getSelection()) {
            style |= 4;
        }
        if (this.multiButton.getSelection()) {
            style |= 2;
        }
        if (this.horizontalButton.getSelection()) {
            style |= 0x100;
        }
        if (this.verticalButton.getSelection()) {
            style |= 0x200;
        }
        if (this.wrapButton.getSelection()) {
            style |= 0x40;
        }
        if (this.readOnlyButton.getSelection()) {
            style |= 8;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        this.text = new Text((Composite)this.textGroup, style);
        this.text.setText(String.valueOf(ControlExample.getResourceString("Example_string")) + Text.DELIMITER + ControlExample.getResourceString("One_Two_Three"));
    }

    void createStyleGroup() {
        super.createStyleGroup();
        this.wrapButton = new Button((Composite)this.styleGroup, 32);
        this.wrapButton.setText("SWT.WRAP");
        this.readOnlyButton = new Button((Composite)this.styleGroup, 32);
        this.readOnlyButton.setText("SWT.READ_ONLY");
    }

    Composite createTabFolderPage(TabFolder tabFolder) {
        super.createTabFolderPage(tabFolder);
        this.tabFolderPage.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TextTab.this.setExampleWidgetSize();
            }
        });
        return this.tabFolderPage;
    }

    Control[] getExampleWidgets() {
        return new Control[]{this.text};
    }

    String getTabText() {
        return "Text";
    }

    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.wrapButton.setSelection((this.text.getStyle() & 0x40) != 0);
        this.readOnlyButton.setSelection((this.text.getStyle() & 8) != 0);
        this.horizontalButton.setEnabled((this.text.getStyle() & 2) != 0);
        this.verticalButton.setEnabled((this.text.getStyle() & 2) != 0);
    }
}

