/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

abstract class Tab {
    Button borderButton;
    Button enabledButton;
    Button visibleButton;
    Button preferredButton;
    Button tooSmallButton;
    Button smallButton;
    Button largeButton;
    Button fillButton;
    Composite tabFolderPage;
    Group exampleGroup;
    Group controlGroup;
    Group listenersGroup;
    Group otherGroup;
    Group sizeGroup;
    Group styleGroup;
    Group colorGroup;
    final ControlExample instance;
    static final int TOO_SMALL_SIZE = 10;
    static final int SMALL_SIZE = 50;
    static final int LARGE_SIZE = 100;
    static final boolean RTL_SUPPORT_ENABLE = false;
    Group orientationGroup;
    Button rtlButton;
    Button ltrButton;
    Button defaultOrietationButton;
    Button foregroundButton;
    Button backgroundButton;
    Button fontButton;
    Image foregroundImage;
    Image backgroundImage;
    Color foregroundColor;
    Color backgroundColor;
    Font font;
    Text eventConsole;
    boolean logging = false;
    boolean[] eventsFilter;
    static final String[] EVENT_NAMES = new String[]{"KeyDown", "KeyUp", "MouseDown", "MouseUp", "MouseMove", "MouseEnter", "MouseExit", "MouseDoubleClick", "Paint", "Move", "Resize", "Dispose", "Selection", "DefaultSelection", "FocusIn", "FocusOut", "Expand", "Collapse", "Iconify", "Deiconify", "Close", "Show", "Hide", "Modify", "Verify", "Activate", "Deactivate", "Help", "DragDetect", "Arm", "Traverse", "MouseHover", "HardKeyDown", "HardKeyUp", "MenuDetect"};

    Tab(ControlExample instance) {
        this.instance = instance;
    }

    void createControlGroup() {
        this.controlGroup = new Group(this.tabFolderPage, 0);
        this.controlGroup.setLayout((Layout)new GridLayout(2, true));
        this.controlGroup.setLayoutData((Object)new GridData(272));
        this.controlGroup.setText(ControlExample.getResourceString("Parameters"));
        this.createStyleGroup();
        this.createOtherGroup();
        this.createSizeGroup();
        this.createColorGroup();
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if ((event.widget.getStyle() & 0x10) != 0 && !((Button)event.widget).getSelection()) {
                    return;
                }
                Tab.this.recreateExampleWidgets();
            }
        };
        Control[] children = this.styleGroup.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Button) {
                Button button = (Button)children[i];
                button.addSelectionListener((SelectionListener)selectionListener);
            }
            ++i;
        }
    }

    void createControlWidgets() {
    }

    void createColorGroup() {
        this.colorGroup = new Group((Composite)this.controlGroup, 0);
        this.colorGroup.setLayout((Layout)new GridLayout(2, false));
        this.colorGroup.setLayoutData((Object)new GridData(272));
        this.colorGroup.setText(ControlExample.getResourceString("Colors"));
        new Label((Composite)this.colorGroup, 0).setText(ControlExample.getResourceString("Foreground_Color"));
        this.foregroundButton = new Button((Composite)this.colorGroup, 8);
        new Label((Composite)this.colorGroup, 0).setText(ControlExample.getResourceString("Background_Color"));
        this.backgroundButton = new Button((Composite)this.colorGroup, 8);
        this.fontButton = new Button((Composite)this.colorGroup, 8);
        this.fontButton.setText(ControlExample.getResourceString("Font"));
        this.fontButton.setLayoutData((Object)new GridData(256));
        Button defaultsButton = new Button((Composite)this.colorGroup, 8);
        defaultsButton.setText(ControlExample.getResourceString("Defaults"));
        Shell shell = this.controlGroup.getShell();
        final ColorDialog foregroundDialog = new ColorDialog(shell);
        final ColorDialog backgroundDialog = new ColorDialog(shell);
        final FontDialog fontDialog = new FontDialog(shell);
        int imageSize = 12;
        Display display = shell.getDisplay();
        this.foregroundImage = new Image((Device)display, imageSize, imageSize);
        this.backgroundImage = new Image((Device)display, imageSize, imageSize);
        this.foregroundButton.setImage(this.foregroundImage);
        this.foregroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RGB rgb;
                Control[] controls;
                Color oldColor = Tab.this.foregroundColor;
                if (oldColor == null && (controls = Tab.this.getExampleWidgets()).length > 0) {
                    oldColor = controls[0].getForeground();
                }
                if (oldColor != null) {
                    foregroundDialog.setRGB(oldColor.getRGB());
                }
                if ((rgb = foregroundDialog.open()) == null) {
                    return;
                }
                oldColor = Tab.this.foregroundColor;
                Tab.this.foregroundColor = new Color((Device)event.display, rgb);
                Tab.this.setExampleWidgetForeground();
                if (oldColor != null) {
                    oldColor.dispose();
                }
            }
        });
        this.backgroundButton.setImage(this.backgroundImage);
        this.backgroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RGB rgb;
                Control[] controls;
                Color oldColor = Tab.this.backgroundColor;
                if (oldColor == null && (controls = Tab.this.getExampleWidgets()).length > 0) {
                    oldColor = controls[0].getBackground();
                }
                if (oldColor != null) {
                    backgroundDialog.setRGB(oldColor.getRGB());
                }
                if ((rgb = backgroundDialog.open()) == null) {
                    return;
                }
                oldColor = Tab.this.backgroundColor;
                Tab.this.backgroundColor = new Color((Device)event.display, rgb);
                Tab.this.setExampleWidgetBackground();
                if (oldColor != null) {
                    oldColor.dispose();
                }
            }
        });
        this.fontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FontData fontData;
                Control[] controls;
                Font oldFont = Tab.this.font;
                if (oldFont == null && (controls = Tab.this.getExampleWidgets()).length > 0) {
                    oldFont = controls[0].getFont();
                }
                if (oldFont != null) {
                    fontDialog.setFontList(oldFont.getFontData());
                }
                if ((fontData = fontDialog.open()) == null) {
                    return;
                }
                oldFont = Tab.this.font;
                Tab.this.font = new Font((Device)event.display, fontData);
                Tab.this.setExampleWidgetFont();
                Tab.this.setExampleWidgetSize();
                if (oldFont != null) {
                    oldFont.dispose();
                }
            }
        });
        defaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Tab.this.resetColorsAndFonts();
            }
        });
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (Tab.this.foregroundImage != null) {
                    Tab.this.foregroundImage.dispose();
                }
                if (Tab.this.backgroundImage != null) {
                    Tab.this.backgroundImage.dispose();
                }
                if (Tab.this.foregroundColor != null) {
                    Tab.this.foregroundColor.dispose();
                }
                if (Tab.this.backgroundColor != null) {
                    Tab.this.backgroundColor.dispose();
                }
                if (Tab.this.font != null) {
                    Tab.this.font.dispose();
                }
                Tab.this.foregroundColor = null;
                Tab.this.backgroundColor = null;
                Tab.this.font = null;
            }
        });
    }

    void createOtherGroup() {
        this.otherGroup = new Group((Composite)this.controlGroup, 0);
        this.otherGroup.setLayout((Layout)new GridLayout());
        this.otherGroup.setLayoutData((Object)new GridData(272));
        this.otherGroup.setText(ControlExample.getResourceString("Other"));
        this.enabledButton = new Button((Composite)this.otherGroup, 32);
        this.enabledButton.setText(ControlExample.getResourceString("Enabled"));
        this.visibleButton = new Button((Composite)this.otherGroup, 32);
        this.visibleButton.setText(ControlExample.getResourceString("Visible"));
        this.enabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Tab.this.setExampleWidgetEnabled();
            }
        });
        this.visibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Tab.this.setExampleWidgetVisibility();
            }
        });
        this.enabledButton.setSelection(true);
        this.visibleButton.setSelection(true);
    }

    void createEventConsolePopup() {
        Menu popup = new Menu((Decorations)this.eventConsole.getShell(), 8);
        this.eventConsole.setMenu(popup);
        MenuItem cut = new MenuItem(popup, 8);
        cut.setText(ControlExample.getResourceString("MenuItem_Cut"));
        cut.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Tab.this.eventConsole.cut();
            }
        });
        MenuItem copy = new MenuItem(popup, 8);
        copy.setText(ControlExample.getResourceString("MenuItem_Copy"));
        copy.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Tab.this.eventConsole.copy();
            }
        });
        MenuItem paste = new MenuItem(popup, 8);
        paste.setText(ControlExample.getResourceString("MenuItem_Paste"));
        paste.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Tab.this.eventConsole.paste();
            }
        });
        new MenuItem(popup, 2);
        MenuItem selectAll = new MenuItem(popup, 8);
        selectAll.setText(ControlExample.getResourceString("MenuItem_SelectAll"));
        selectAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Tab.this.eventConsole.selectAll();
            }
        });
    }

    void createExampleGroup() {
        this.exampleGroup = new Group(this.tabFolderPage, 0);
        GridLayout gridLayout = new GridLayout();
        this.exampleGroup.setLayout((Layout)gridLayout);
        this.exampleGroup.setLayoutData((Object)new GridData(1808));
    }

    void createExampleWidgets() {
    }

    void createListenerSelectionDialog() {
        final Shell dialog = new Shell(this.tabFolderPage.getShell(), 67680);
        dialog.setText(ControlExample.getResourceString("Select_Listeners"));
        dialog.setLayout((Layout)new GridLayout(2, false));
        final Table table = new Table((Composite)dialog, 2592);
        GridData data = new GridData(1808);
        data.verticalSpan = 2;
        table.setLayoutData((Object)data);
        int i = 0;
        while (i < EVENT_NAMES.length) {
            TableItem item = new TableItem(table, 0);
            item.setText(EVENT_NAMES[i]);
            item.setChecked(this.eventsFilter[i]);
            ++i;
        }
        final String[] customNames = this.getCustomEventNames();
        int i2 = 0;
        while (i2 < customNames.length) {
            TableItem item = new TableItem(table, 0);
            item.setText(customNames[i2]);
            item.setChecked(this.eventsFilter[EVENT_NAMES.length + i2]);
            ++i2;
        }
        Button selectAll = new Button((Composite)dialog, 8);
        selectAll.setText(ControlExample.getResourceString("Select_All"));
        selectAll.setLayoutData((Object)new GridData(256));
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = table.getItems();
                int i = 0;
                while (i < EVENT_NAMES.length) {
                    items[i].setChecked(true);
                    ++i;
                }
                i = 0;
                while (i < customNames.length) {
                    items[EVENT_NAMES.length + i].setChecked(true);
                    ++i;
                }
            }
        });
        Button deselectAll = new Button((Composite)dialog, 8);
        deselectAll.setText(ControlExample.getResourceString("Deselect_All"));
        deselectAll.setLayoutData((Object)new GridData(258));
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = table.getItems();
                int i = 0;
                while (i < EVENT_NAMES.length) {
                    items[i].setChecked(false);
                    ++i;
                }
                i = 0;
                while (i < customNames.length) {
                    items[EVENT_NAMES.length + i].setChecked(false);
                    ++i;
                }
            }
        });
        new Label((Composite)dialog, 0);
        Button ok = new Button((Composite)dialog, 8);
        ok.setText(ControlExample.getResourceString("OK"));
        dialog.setDefaultButton(ok);
        ok.setLayoutData((Object)new GridData(256));
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = table.getItems();
                int i = 0;
                while (i < EVENT_NAMES.length) {
                    Tab.this.eventsFilter[i] = items[i].getChecked();
                    ++i;
                }
                i = 0;
                while (i < customNames.length) {
                    Tab.this.eventsFilter[Tab.EVENT_NAMES.length + i] = items[EVENT_NAMES.length + i].getChecked();
                    ++i;
                }
                dialog.dispose();
            }
        });
        dialog.pack();
        dialog.open();
        while (!dialog.isDisposed()) {
            if (dialog.getDisplay().readAndDispatch()) continue;
            dialog.getDisplay().sleep();
        }
    }

    void createListenersGroup() {
        this.listenersGroup = new Group(this.tabFolderPage, 0);
        this.listenersGroup.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(1296);
        gridData.horizontalSpan = 2;
        this.listenersGroup.setLayoutData((Object)gridData);
        this.listenersGroup.setText(ControlExample.getResourceString("Listeners"));
        Button listenersButton = new Button((Composite)this.listenersGroup, 8);
        listenersButton.setText(ControlExample.getResourceString("Select_Listeners"));
        listenersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Tab.this.createListenerSelectionDialog();
                Tab.this.recreateExampleWidgets();
            }
        });
        final Button listenCheckbox = new Button((Composite)this.listenersGroup, 32);
        listenCheckbox.setText(ControlExample.getResourceString("Listen"));
        listenCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Tab.this.logging = listenCheckbox.getSelection();
                Tab.this.recreateExampleWidgets();
            }
        });
        Button clearButton = new Button((Composite)this.listenersGroup, 8);
        clearButton.setText(ControlExample.getResourceString("Clear"));
        clearButton.setLayoutData((Object)new GridData(128));
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Tab.this.eventConsole.setText("");
            }
        });
        int customEventCount = this.getCustomEventNames().length;
        this.eventsFilter = new boolean[EVENT_NAMES.length + customEventCount];
        int i = 0;
        while (i < EVENT_NAMES.length + customEventCount) {
            this.eventsFilter[i] = true;
            ++i;
        }
        this.eventConsole = new Text((Composite)this.listenersGroup, 2818);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        data.heightHint = 80;
        this.eventConsole.setLayoutData((Object)data);
        this.createEventConsolePopup();
        this.eventConsole.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.keyCode == 65 || e.keyCode == 97) && (e.stateMask & SWT.MOD1) != 0) {
                    Tab.this.eventConsole.selectAll();
                    e.doit = false;
                }
            }
        });
    }

    void createOrientationGroup() {
        this.orientationGroup = new Group((Composite)this.controlGroup, 0);
        this.orientationGroup.setLayout((Layout)new GridLayout());
        this.orientationGroup.setLayoutData((Object)new GridData(272));
        this.orientationGroup.setText(ControlExample.getResourceString("Orientation"));
        this.defaultOrietationButton = new Button((Composite)this.orientationGroup, 16);
        this.defaultOrietationButton.setText(ControlExample.getResourceString("Default"));
        this.defaultOrietationButton.setSelection(true);
        this.ltrButton = new Button((Composite)this.orientationGroup, 16);
        this.ltrButton.setText("SWT.LEFT_TO_RIGHT");
        this.rtlButton = new Button((Composite)this.orientationGroup, 16);
        this.rtlButton.setText("SWT.RIGHT_TO_LEFT");
    }

    void createSizeGroup() {
        this.sizeGroup = new Group((Composite)this.controlGroup, 0);
        this.sizeGroup.setLayout((Layout)new GridLayout());
        this.sizeGroup.setLayoutData((Object)new GridData(272));
        this.sizeGroup.setText(ControlExample.getResourceString("Size"));
        this.preferredButton = new Button((Composite)this.sizeGroup, 16);
        this.preferredButton.setText(ControlExample.getResourceString("Preferred"));
        this.tooSmallButton = new Button((Composite)this.sizeGroup, 16);
        this.tooSmallButton.setText("10 X 10");
        this.smallButton = new Button((Composite)this.sizeGroup, 16);
        this.smallButton.setText("50 X 50");
        this.largeButton = new Button((Composite)this.sizeGroup, 16);
        this.largeButton.setText("100 X 100");
        this.fillButton = new Button((Composite)this.sizeGroup, 16);
        this.fillButton.setText(ControlExample.getResourceString("Fill"));
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!((Button)event.widget).getSelection()) {
                    return;
                }
                Tab.this.setExampleWidgetSize();
            }
        };
        this.preferredButton.addSelectionListener((SelectionListener)selectionListener);
        this.tooSmallButton.addSelectionListener((SelectionListener)selectionListener);
        this.smallButton.addSelectionListener((SelectionListener)selectionListener);
        this.largeButton.addSelectionListener((SelectionListener)selectionListener);
        this.fillButton.addSelectionListener((SelectionListener)selectionListener);
        this.preferredButton.setSelection(true);
    }

    void createStyleGroup() {
        this.styleGroup = new Group((Composite)this.controlGroup, 0);
        this.styleGroup.setLayout((Layout)new GridLayout());
        this.styleGroup.setLayoutData((Object)new GridData(272));
        this.styleGroup.setText(ControlExample.getResourceString("Styles"));
    }

    Composite createTabFolderPage(TabFolder tabFolder) {
        this.tabFolderPage = new Composite((Composite)tabFolder, 0);
        this.tabFolderPage.setLayout((Layout)new GridLayout(2, false));
        this.createExampleGroup();
        this.createControlGroup();
        this.createListenersGroup();
        this.createExampleWidgets();
        this.hookExampleWidgetListeners();
        this.createControlWidgets();
        this.setExampleWidgetState();
        return this.tabFolderPage;
    }

    void disposeExampleWidgets() {
        Control[] controls = this.getExampleWidgets();
        int i = 0;
        while (i < controls.length) {
            controls[i].dispose();
            ++i;
        }
    }

    void drawImage(Image image, Color color) {
        GC gc = new GC((Drawable)image);
        gc.setBackground(color);
        Rectangle bounds = image.getBounds();
        gc.fillRectangle(0, 0, bounds.width, bounds.height);
        gc.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
        gc.dispose();
    }

    String[] getCustomEventNames() {
        return new String[0];
    }

    int getDefaultStyle() {
        if (this.ltrButton != null && this.ltrButton.getSelection()) {
            return 0x2000000;
        }
        if (this.rtlButton != null && this.rtlButton.getSelection()) {
            return 0x4000000;
        }
        return 0;
    }

    Control[] getExampleWidgets() {
        return new Control[0];
    }

    Item[] getExampleWidgetItems() {
        return new Item[0];
    }

    String getTabText() {
        return "";
    }

    void hookExampleWidgetListeners() {
        if (this.logging) {
            Control[] exampleControls = this.getExampleWidgets();
            int i = 0;
            while (i < exampleControls.length) {
                this.hookListeners((Widget)exampleControls[i]);
                ++i;
            }
            Item[] exampleItems = this.getExampleWidgetItems();
            int i2 = 0;
            while (i2 < exampleItems.length) {
                this.hookListeners((Widget)exampleItems[i2]);
                ++i2;
            }
            String[] customNames = this.getCustomEventNames();
            int i3 = 0;
            while (i3 < customNames.length) {
                if (this.eventsFilter[EVENT_NAMES.length + i3]) {
                    this.hookCustomListener(customNames[i3]);
                }
                ++i3;
            }
        }
    }

    void hookCustomListener(String eventName) {
    }

    void hookListeners(Widget widget) {
        if (this.logging) {
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    Tab.this.log(event);
                }
            };
            int i = 0;
            while (i < EVENT_NAMES.length) {
                if (this.eventsFilter[i]) {
                    widget.addListener(i + 1, listener);
                }
                ++i;
            }
        }
    }

    void log(Event event) {
        String toString = String.valueOf(EVENT_NAMES[event.type - 1]) + ": ";
        switch (event.type) {
            case 1: 
            case 2: {
                toString = String.valueOf(toString) + new KeyEvent(event).toString();
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 32: {
                toString = String.valueOf(toString) + new MouseEvent(event).toString();
                break;
            }
            case 9: {
                toString = String.valueOf(toString) + new PaintEvent(event).toString();
                break;
            }
            case 10: 
            case 11: {
                toString = String.valueOf(toString) + new ControlEvent(event).toString();
                break;
            }
            case 12: {
                toString = String.valueOf(toString) + new DisposeEvent(event).toString();
                break;
            }
            case 13: 
            case 14: {
                toString = String.valueOf(toString) + new SelectionEvent(event).toString();
                break;
            }
            case 15: 
            case 16: {
                toString = String.valueOf(toString) + new FocusEvent(event).toString();
                break;
            }
            case 17: 
            case 18: {
                toString = String.valueOf(toString) + new TreeEvent(event).toString();
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: {
                toString = String.valueOf(toString) + new ShellEvent(event).toString();
                break;
            }
            case 22: 
            case 23: {
                toString = String.valueOf(toString) + (event.widget instanceof Menu ? new MenuEvent(event).toString() : event.toString());
                break;
            }
            case 24: {
                toString = String.valueOf(toString) + new ModifyEvent(event).toString();
                break;
            }
            case 25: {
                toString = String.valueOf(toString) + new VerifyEvent(event).toString();
                break;
            }
            case 28: {
                toString = String.valueOf(toString) + new HelpEvent(event).toString();
                break;
            }
            case 30: {
                toString = String.valueOf(toString) + new ArmEvent(event).toString();
                break;
            }
            case 31: {
                toString = String.valueOf(toString) + new TraverseEvent(event).toString();
                break;
            }
            default: {
                toString = String.valueOf(toString) + event.toString();
            }
        }
        this.eventConsole.append(toString);
        this.eventConsole.append("\n");
    }

    void log(String eventName, TypedEvent event) {
        this.eventConsole.append(String.valueOf(eventName) + ": ");
        this.eventConsole.append(event.toString());
        this.eventConsole.append("\n");
    }

    void recreateExampleWidgets() {
        this.disposeExampleWidgets();
        this.createExampleWidgets();
        this.hookExampleWidgetListeners();
        this.setExampleWidgetState();
    }

    void resetColorsAndFonts() {
        Color oldColor = this.foregroundColor;
        this.foregroundColor = null;
        this.setExampleWidgetForeground();
        if (oldColor != null) {
            oldColor.dispose();
        }
        oldColor = this.backgroundColor;
        this.backgroundColor = null;
        this.setExampleWidgetBackground();
        if (oldColor != null) {
            oldColor.dispose();
        }
        Font oldFont = this.font;
        this.font = null;
        this.setExampleWidgetFont();
        this.setExampleWidgetSize();
        if (oldFont != null) {
            oldFont.dispose();
        }
    }

    void setExampleWidgetBackground() {
        if (this.backgroundButton == null) {
            return;
        }
        Control[] controls = this.getExampleWidgets();
        int i = 0;
        while (i < controls.length) {
            controls[i].setBackground(this.backgroundColor);
            ++i;
        }
        Color color = this.backgroundColor;
        if (controls.length == 0) {
            return;
        }
        if (color == null) {
            color = controls[0].getBackground();
        }
        this.drawImage(this.backgroundImage, color);
        this.backgroundButton.setImage(this.backgroundImage);
    }

    void setExampleWidgetEnabled() {
        Control[] controls = this.getExampleWidgets();
        int i = 0;
        while (i < controls.length) {
            controls[i].setEnabled(this.enabledButton.getSelection());
            ++i;
        }
    }

    void setExampleWidgetFont() {
        if (this.instance.startup) {
            return;
        }
        if (this.fontButton == null) {
            return;
        }
        Control[] controls = this.getExampleWidgets();
        int i = 0;
        while (i < controls.length) {
            Control control = controls[i];
            control.setFont(this.font);
            ++i;
        }
    }

    void setExampleWidgetForeground() {
        if (this.foregroundButton == null) {
            return;
        }
        Control[] controls = this.getExampleWidgets();
        int i = 0;
        while (i < controls.length) {
            controls[i].setForeground(this.foregroundColor);
            ++i;
        }
        Color color = this.foregroundColor;
        if (controls.length == 0) {
            return;
        }
        if (color == null) {
            color = controls[0].getForeground();
        }
        this.drawImage(this.foregroundImage, color);
        this.foregroundButton.setImage(this.foregroundImage);
    }

    void setExampleWidgetSize() {
        int size = -1;
        if (this.preferredButton == null) {
            return;
        }
        if (this.preferredButton.getSelection()) {
            size = -1;
        }
        if (this.tooSmallButton.getSelection()) {
            size = 10;
        }
        if (this.smallButton.getSelection()) {
            size = 50;
        }
        if (this.largeButton.getSelection()) {
            size = 100;
        }
        Control[] controls = this.getExampleWidgets();
        int i = 0;
        while (i < controls.length) {
            GridData gridData;
            if (this.fillButton.getSelection()) {
                gridData = new GridData(1808);
            } else {
                gridData = new GridData();
                gridData.widthHint = size;
                gridData.heightHint = size;
            }
            controls[i].setLayoutData((Object)gridData);
            ++i;
        }
        int seenCount = 0;
        Composite[] seen = new Composite[4];
        int i2 = 0;
        while (i2 < controls.length) {
            Control control = controls[i2];
            while (control != this.exampleGroup) {
                Composite parent = control.getParent();
                int index = 0;
                while (index < seenCount) {
                    if (seen[index] == parent) break;
                    ++index;
                }
                if (index == seenCount) {
                    parent.layout();
                }
                if (seenCount == seen.length) {
                    Composite[] newSeen = new Composite[seen.length + 4];
                    System.arraycopy(seen, 0, newSeen, 0, seen.length);
                    seen = newSeen;
                }
                seen[seenCount++] = parent;
                control = control.getParent();
            }
            ++i2;
        }
    }

    void setExampleWidgetState() {
        this.setExampleWidgetEnabled();
        this.setExampleWidgetVisibility();
        this.setExampleWidgetBackground();
        this.setExampleWidgetForeground();
        this.setExampleWidgetFont();
        this.setExampleWidgetSize();
    }

    void setExampleWidgetVisibility() {
        Control[] controls = this.getExampleWidgets();
        int i = 0;
        while (i < controls.length) {
            controls[i].setVisible(this.visibleButton.getSelection());
            ++i;
        }
    }
}

