/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.readmetool;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.examples.readmetool.AdaptableList;
import org.eclipse.ui.examples.readmetool.DefaultSectionsParser;
import org.eclipse.ui.examples.readmetool.IReadmeFileParser;
import org.eclipse.ui.examples.readmetool.MarkElement;
import org.eclipse.ui.examples.readmetool.MessageUtil;

public class ReadmeModelFactory {
    private static ReadmeModelFactory instance = new ReadmeModelFactory();
    private boolean registryLoaded = false;
    IReadmeFileParser parser = null;

    private ReadmeModelFactory() {
    }

    protected void addSections(AdaptableList list, MarkElement element) {
        list.add(element);
        Object[] children = element.getChildren(element);
        int i = 0;
        while (i < children.length) {
            this.addSections(list, (MarkElement)children[i]);
            ++i;
        }
    }

    public AdaptableList getContentOutline(IAdaptable adaptable) {
        return new AdaptableList(this.getToc((IFile)adaptable));
    }

    public static ReadmeModelFactory getInstance() {
        return instance;
    }

    public AdaptableList getSections(IFile file) {
        MarkElement[] topLevel = this.getToc(file);
        AdaptableList list = new AdaptableList();
        int i = 0;
        while (i < topLevel.length) {
            this.addSections(list, topLevel[i]);
            ++i;
        }
        return list;
    }

    public AdaptableList getSections(ISelection sel) {
        IFile file;
        String extension;
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structured = (IStructuredSelection)sel;
        Object object = structured.getFirstElement();
        if (object instanceof IFile && (extension = (file = (IFile)object).getFileExtension()) != null && extension.equals("readme")) {
            return this.getSections(file);
        }
        return null;
    }

    private MarkElement[] getToc(IFile file) {
        if (!this.registryLoaded) {
            this.loadParser();
        }
        return this.parser.parse(file);
    }

    private void loadParser() {
        IPluginRegistry pluginRegistry = Platform.getPluginRegistry();
        IExtensionPoint point = pluginRegistry.getExtensionPoint("org.eclipse.ui.examples.readmetool", "sectionParser");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension currentExtension = extensions[i];
                if (i == extensions.length - 1) {
                    IConfigurationElement[] configElements = currentExtension.getConfigurationElements();
                    int j = 0;
                    while (j < configElements.length) {
                        IConfigurationElement config = configElements[i];
                        if (config.getName().equals("parser")) {
                            this.processParserElement(config);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (this.parser == null) {
            this.parser = new DefaultSectionsParser();
        }
        this.registryLoaded = true;
    }

    private void processParserElement(IConfigurationElement element) {
        try {
            this.parser = (IReadmeFileParser)element.createExecutableExtension("class");
        }
        catch (CoreException e) {
            System.out.println(String.valueOf(MessageUtil.getString("Unable_to_create_file_parser")) + e.getStatus().getMessage());
            this.parser = null;
        }
    }
}

