/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.readmetool;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.examples.readmetool.AdaptableList;
import org.eclipse.ui.examples.readmetool.MessageUtil;
import org.eclipse.ui.examples.readmetool.ReadmeModelFactory;
import org.eclipse.ui.help.WorkbenchHelp;

public class ReadmeFilePropertyPage
extends PropertyPage {
    protected Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Control createContents(Composite parent) {
        Label l;
        Composite panel;
        block16: {
            IResource resource;
            block15: {
                this.noDefaultAndApplyButton();
                panel = this.createComposite(parent, 2);
                WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.ui.examples.readmetool.property_page_context");
                resource = (IResource)this.getElement();
                IStatus result = null;
                if (resource.getType() != 1) break block16;
                l = this.createLabel(panel, MessageUtil.getString("File_name"));
                l = this.createLabel(panel, resource.getName());
                this.grabExcessSpace((Control)l);
                this.createLabel(panel, MessageUtil.getString("Path"));
                l = this.createLabel(panel, resource.getFullPath().setDevice(null).toString());
                this.grabExcessSpace((Control)l);
                this.createLabel(panel, MessageUtil.getString("Size"));
                InputStream contentStream = null;
                try {
                    block14: {
                        try {
                            IFile file = (IFile)resource;
                            if (!file.isLocal(0)) {
                                l = this.createLabel(panel, MessageUtil.getString("<file_contents_not_local>"));
                                break block14;
                            }
                            contentStream = file.getContents();
                            InputStreamReader in = new InputStreamReader(contentStream);
                            int chunkSize = contentStream.available();
                            StringBuffer buffer = new StringBuffer(chunkSize);
                            char[] readBuffer = new char[chunkSize];
                            int n = in.read(readBuffer);
                            while (true) {
                                if (n <= 0) {
                                    contentStream.close();
                                    l = this.createLabel(panel, Integer.toString(buffer.length()));
                                }
                                buffer.append(readBuffer);
                                n = in.read(readBuffer);
                            }
                        }
                        catch (CoreException e) {
                            result = e.getStatus();
                            String message = result.getMessage();
                            if (message == null) {
                                l = this.createLabel(panel, MessageUtil.getString("<Unknown>"));
                                break block14;
                            }
                            l = this.createLabel(panel, message);
                        }
                        catch (IOException iOException) {
                            l = this.createLabel(panel, MessageUtil.getString("<Unknown>"));
                        }
                    }
                    Object var13_16 = null;
                    if (contentStream == null) break block15;
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    if (contentStream == null) throw throwable;
                    try {
                        contentStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {}
                catch (IOException iOException) {}
                contentStream.close();
            }
            this.grabExcessSpace((Control)l);
            this.createLabel(panel, MessageUtil.getString("Number_of_sections"));
            AdaptableList sections = this.getSections((IAdaptable)resource);
            if (sections instanceof AdaptableList) {
                AdaptableList list = sections;
                l = this.createLabel(panel, String.valueOf(list.size()));
                this.grabExcessSpace((Control)l);
            }
        }
        l = this.createLabel(panel, MessageUtil.getString("Additional_information"));
        this.grabExcessSpace((Control)l);
        GridData gd = (GridData)l.getLayoutData();
        gd.horizontalSpan = 2;
        return new Canvas(panel, 0);
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private AdaptableList getSections(IAdaptable adaptable) {
        if (adaptable instanceof IFile) {
            return ReadmeModelFactory.getInstance().getSections((IFile)adaptable);
        }
        return null;
    }

    private void grabExcessSpace(Control control) {
        GridData gd = (GridData)control.getLayoutData();
        if (gd != null) {
            gd.grabExcessHorizontalSpace = true;
        }
    }

    public boolean performOk() {
        return true;
    }
}

