/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.readmetool;

import org.eclipse.jface.action.ControlContribution;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.examples.readmetool.MessageUtil;

public class DirtyStateContribution
extends ControlContribution
implements IPropertyListener {
    private Composite composite;
    private Label label;
    private IEditorPart activeEditor;

    protected DirtyStateContribution() {
        super("DirtyState");
    }

    protected Control createControl(Composite parent) {
        if (this.composite != null && !this.composite.isDisposed()) {
            return this.composite;
        }
        this.composite = new Composite(parent, 2048);
        this.composite.setData((Object)this);
        this.label = new Label(this.composite, 0);
        this.label.setSize(80, 15);
        this.updateState();
        return this.composite;
    }

    public void editorChanged(IEditorPart part) {
        if (this.activeEditor != null) {
            this.activeEditor.removePropertyListener((IPropertyListener)this);
        }
        this.activeEditor = part;
        if (this.activeEditor != null) {
            this.activeEditor.addPropertyListener((IPropertyListener)this);
        }
        this.updateState();
    }

    public void propertyChanged(Object source, int propID) {
        if (source instanceof IEditorPart) {
            this.updateState();
        }
    }

    private void updateState() {
        if (this.label == null || this.label.isDisposed()) {
            return;
        }
        boolean saveNeeded = false;
        if (this.activeEditor != null) {
            saveNeeded = this.activeEditor.isDirty();
        }
        if (saveNeeded) {
            this.label.setText(MessageUtil.getString("Save_Needed"));
        } else {
            this.label.setText(MessageUtil.getString("Clean"));
        }
    }
}

