/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.readmetool;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.examples.readmetool.IReadmeFileParser;
import org.eclipse.ui.examples.readmetool.MarkElement;

public class DefaultSectionsParser
implements IReadmeFileParser {
    protected IAdaptable getParent(Hashtable toc, String number) {
        int lastDot = number.lastIndexOf(46);
        if (lastDot < 0) {
            return null;
        }
        String parentNumber = number.substring(0, lastDot);
        return (IAdaptable)toc.get(parentNumber);
    }

    protected String getText(IFile file) {
        try {
            InputStream in = file.getContents();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int read = in.read(buf);
            while (read > 0) {
                out.write(buf, 0, read);
                read = in.read(buf);
            }
            return out.toString();
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
        return "";
    }

    public MarkElement[] parse(IFile file) {
        Hashtable<String, MarkElement> markTable = new Hashtable<String, MarkElement>(40);
        Vector<MarkElement> topLevel = new Vector<MarkElement>();
        String s = this.getText(file);
        int start = 0;
        int end = -1;
        int lineno = 0;
        int lastlineno = 0;
        MarkElement lastme = null;
        int ix = s.indexOf(10, start);
        while (ix != -1) {
            MarkElement me;
            start = end + 1;
            end = ix = s.indexOf(10, start);
            ++lineno;
            if (ix == -1) continue;
            while (s.charAt(start) == ' ' || s.charAt(start) == '\t') {
                ++start;
            }
            if (!Character.isDigit(s.charAt(start))) continue;
            if (lastme != null) {
                lastme.setNumberOfLines(lineno - lastlineno - 1);
            }
            lastlineno = lineno;
            String markName = this.parseHeading(s, start, end);
            String markNumber = this.parseNumber(markName);
            IAdaptable parent = this.getParent(markTable, markNumber);
            if (parent == null) {
                parent = file;
            }
            lastme = me = new MarkElement(parent, markName, start, end - start);
            markTable.put(markNumber, me);
            if (parent != file) continue;
            topLevel.add(me);
        }
        if (lastme != null) {
            lastme.setNumberOfLines(lineno - lastlineno - 1);
        }
        Object[] results = new MarkElement[topLevel.size()];
        topLevel.copyInto(results);
        return results;
    }

    private String parseHeading(String buffer, int start, int end) {
        while (Character.isWhitespace(buffer.charAt(end - 1)) && end > start) {
            --end;
        }
        return buffer.substring(start, end);
    }

    protected String parseNumber(String heading) {
        char c;
        int start = 0;
        int end = heading.length();
        while (((c = heading.charAt(start++)) == '.' || Character.isDigit(c)) && start < end) {
        }
        while (heading.charAt(start - 1) == '.' && start > 0) {
            --start;
        }
        return heading.substring(0, start);
    }
}

