/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.pessimistic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ResourceSetContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Map fResourceTree = new HashMap(1);
    private IResource[] fRoots;

    public ResourceSetContentProvider(Set resources) {
        HashSet roots = new HashSet(resources);
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            IContainer parent;
            IResource resource = (IResource)i.next();
            if (resource.getType() == 8 || !roots.contains(parent = resource.getParent())) continue;
            roots.remove(resource);
            HashSet<IResource> set = (HashSet<IResource>)this.fResourceTree.get(parent);
            if (set == null) {
                set = new HashSet<IResource>(1);
                this.fResourceTree.put(parent, set);
            }
            set.add(resource);
        }
        this.fRoots = roots.toArray(new IResource[roots.size()]);
    }

    public Object[] getChildren(Object parentElement) {
        Set set = (Set)this.fResourceTree.get(parentElement);
        if (set != null) {
            return set.toArray();
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.fResourceTree.get(element) != null;
    }

    public Object[] getElements(Object inputElement) {
        return this.fRoots;
    }

    public void dispose() {
        this.fResourceTree = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

