/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.pessimistic;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProviderPlugin;
import org.eclipse.team.examples.pessimistic.PessimisticModificationValidator;

public class PessimisticFilesystemProvider
extends RepositoryProvider {
    private static final String CONTROL_FILE_NAME = ".pessimistic";
    private IFileModificationValidator validator = new PessimisticModificationValidator(this);
    private Map fControlledResources = new HashMap(1);

    public void addToControl(final IResource[] resources, IProgressMonitor monitor) {
        if (PessimisticFilesystemProviderPlugin.getInstance().isDebugging()) {
            System.out.println("Add to control:");
            if (resources != null) {
                int i = 0;
                while (i < resources.length) {
                    System.out.println("\t" + resources[i]);
                    ++i;
                }
            } else {
                System.out.println("null resources");
            }
        }
        if (resources == null || resources.length == 0) {
            return;
        }
        final HashSet toAdd = new HashSet(resources.length);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < resources.length) {
                    IResource resource = resources[i];
                    if (!PessimisticFilesystemProvider.this.isControlled(resource)) {
                        toAdd.add(resource);
                    }
                    ++i;
                }
                Map byParent = PessimisticFilesystemProvider.this.sortByParent(toAdd);
                monitor.beginTask("Adding to control", 1000);
                Iterator i2 = byParent.keySet().iterator();
                while (i2.hasNext()) {
                    IContainer parent = (IContainer)i2.next();
                    HashSet controlledResources = (HashSet)PessimisticFilesystemProvider.this.fControlledResources.get(parent);
                    if (controlledResources == null) {
                        controlledResources = new HashSet(1);
                        PessimisticFilesystemProvider.this.fControlledResources.put(parent, controlledResources);
                    }
                    controlledResources.addAll((Set)byParent.get(parent));
                    PessimisticFilesystemProvider.this.writeControlFile(parent, monitor);
                }
                monitor.done();
            }
        };
        this.run(runnable, monitor);
        this.fireStateChanged(toAdd, false);
    }

    public void removeFromControl(final IResource[] resources, IProgressMonitor monitor) {
        if (PessimisticFilesystemProviderPlugin.getInstance().isDebugging()) {
            System.out.println("Remove from control:");
            if (resources != null) {
                int i = 0;
                while (i < resources.length) {
                    System.out.println("\t" + resources[i]);
                    ++i;
                }
            } else {
                System.out.println("null resources");
            }
        }
        if (resources == null || resources.length == 0) {
            return;
        }
        final HashSet toRemove = new HashSet(resources.length);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < resources.length) {
                    IResource resource = resources[i];
                    if (PessimisticFilesystemProvider.this.isControlled(resource)) {
                        toRemove.add(resource);
                    }
                    ++i;
                }
                Map byParent = PessimisticFilesystemProvider.this.sortByParent(toRemove);
                byParent.keySet();
                monitor.beginTask("Removing from control", 1000);
                Iterator i2 = byParent.keySet().iterator();
                while (i2.hasNext()) {
                    IContainer parent = (IContainer)i2.next();
                    Set controlledResources = (Set)PessimisticFilesystemProvider.this.fControlledResources.get(parent);
                    if (controlledResources == null) {
                        PessimisticFilesystemProvider.this.deleteControlFile(parent, monitor);
                        continue;
                    }
                    Set toRemove2 = (Set)byParent.get(parent);
                    controlledResources.removeAll(toRemove2);
                    if (controlledResources.isEmpty()) {
                        PessimisticFilesystemProvider.this.fControlledResources.remove(parent);
                        PessimisticFilesystemProvider.this.deleteControlFile(parent, monitor);
                    } else {
                        PessimisticFilesystemProvider.this.writeControlFile(parent, monitor);
                    }
                    Iterator j = controlledResources.iterator();
                    while (j.hasNext()) {
                        IResource resource = (IResource)j.next();
                        if (resource.exists()) continue;
                        j.remove();
                    }
                }
                monitor.done();
            }
        };
        this.run(runnable, monitor);
        this.fireStateChanged(toRemove, false);
    }

    private Map sortByParent(Set resources) {
        HashMap<IContainer, HashSet<IResource>> byParent = new HashMap<IContainer, HashSet<IResource>>(1);
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            IResource resource = (IResource)i.next();
            IContainer parent = resource.getParent();
            HashSet<IResource> set = (HashSet<IResource>)byParent.get(parent);
            if (set == null) {
                set = new HashSet<IResource>(1);
                byParent.put(parent, set);
            }
            set.add(resource);
        }
        return byParent;
    }

    private void deleteControlFile(final IContainer container, IProgressMonitor monitor) {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IFile controlFile = PessimisticFilesystemProvider.this.getControlFile(container, monitor);
                monitor.beginTask("Deleting control file " + controlFile, 1);
                if (controlFile.exists()) {
                    controlFile.delete(true, false, monitor);
                }
                monitor.done();
            }
        };
        this.run(runnable, monitor);
    }

    private IFile getControlFile(IContainer container, IProgressMonitor monitor) throws CoreException {
        IResource child = container.findMember(CONTROL_FILE_NAME);
        if (child != null) {
            if (child.getType() == 1) {
                return (IFile)child;
            }
            child.delete(true, monitor);
        }
        IFile controlFile = container.getFile((IPath)new Path(CONTROL_FILE_NAME));
        monitor.beginTask("Creating control file " + controlFile, 2);
        controlFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, monitor);
        controlFile.setDerived(true);
        controlFile.setTeamPrivateMember(true);
        monitor.done();
        return controlFile;
    }

    /*
     * Exception decompiling
     */
    private Set readControlFile(IFile controlFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [5 : 238->241)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeControlFile(IContainer container, IProgressMonitor monitor) throws CoreException {
        IFile controlFile = this.getControlFile(container, monitor);
        Set controlledResources = (Set)this.fControlledResources.get(container);
        InputStream contents = this.generateControlFileContents(controlledResources);
        monitor.beginTask("Writing control file " + controlFile, 1000);
        if (contents == null) {
            controlFile.delete(true, false, monitor);
        } else {
            controlFile.setContents(contents, true, false, monitor);
        }
        monitor.done();
    }

    private InputStream generateControlFileContents(Set controlledResources) {
        if (controlledResources == null || controlledResources.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        try {
            out.writeInt(controlledResources.size());
            Iterator i = controlledResources.iterator();
            while (i.hasNext()) {
                IResource resource = (IResource)i.next();
                out.writeUTF(resource.getProjectRelativePath().toString());
            }
            out.flush();
        }
        catch (IOException e) {
            PessimisticFilesystemProviderPlugin.getInstance().logError(e, "Unexpected problems during content generation");
        }
        return new ByteArrayInputStream(byteOut.toByteArray());
    }

    public void setProject(IProject project) {
        if (PessimisticFilesystemProviderPlugin.getInstance().isDebugging()) {
            System.out.println("Set project to " + project);
        }
        super.setProject(project);
        this.configureProject();
    }

    public String getID() {
        return "org.eclipse.team.examples.pessimistic.pessimisticnature";
    }

    public IFileModificationValidator getFileModificationValidator() {
        return this.validator;
    }

    public void deconfigure() {
        if (PessimisticFilesystemProviderPlugin.getInstance().isDebugging()) {
            System.out.println("Deconfigure " + this.getProject());
        }
        this.fControlledResources.clear();
        this.fireStateChanged(this.getSubtreeMembers((IResource)this.getProject()), true);
    }

    public void configureProject() {
        if (PessimisticFilesystemProviderPlugin.getInstance().isDebugging()) {
            System.out.println("Configure " + this.getProject());
        }
        this.readControlFiles();
        this.fireStateChanged(this.getSubtreeMembers((IResource)this.getProject()), true);
    }

    private void readControlFiles() {
        IProject project = this.getProject();
        HashSet<IProject> set = new HashSet<IProject>(1);
        set.add(project);
        this.fControlledResources.put(project.getParent(), set);
        try {
            this.getProject().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.getType() == 1) {
                        if (PessimisticFilesystemProvider.CONTROL_FILE_NAME.equals(resource.getName())) {
                            Set controlledResources = PessimisticFilesystemProvider.this.readControlFile((IFile)resource);
                            PessimisticFilesystemProvider.this.fControlledResources.put(resource.getParent(), controlledResources);
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            PessimisticFilesystemProviderPlugin.getInstance().logError(e, "Problems traversing resource tree");
        }
    }

    public void checkin(final IResource[] resources, IProgressMonitor monitor) {
        if (PessimisticFilesystemProviderPlugin.getInstance().isDebugging()) {
            System.out.println("Check in:");
            if (resources != null) {
                int i = 0;
                while (i < resources.length) {
                    System.out.println("\t" + resources[i]);
                    ++i;
                }
            } else {
                System.out.println("null resources");
            }
        }
        if (resources == null || resources.length == 0) {
            return;
        }
        final HashSet modified = new HashSet(1);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("Checking in resources", 1000);
                int i = 0;
                while (i < resources.length) {
                    IResource resource = resources[i];
                    if (PessimisticFilesystemProvider.this.isControlled(resource) && resource.exists()) {
                        resource.setReadOnly(true);
                        modified.add(resource);
                    }
                    ++i;
                }
                monitor.done();
            }
        };
        this.run(runnable, monitor);
        this.fireStateChanged(modified, false);
    }

    public void uncheckout(final IResource[] resources, IProgressMonitor monitor) {
        if (PessimisticFilesystemProviderPlugin.getInstance().isDebugging()) {
            System.out.println("Uncheckout:");
            if (resources != null) {
                int i = 0;
                while (i < resources.length) {
                    System.out.println("\t" + resources[i]);
                    ++i;
                }
            } else {
                System.out.println("null resources");
            }
        }
        if (resources == null || resources.length == 0) {
            return;
        }
        final HashSet modified = new HashSet(1);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("Unchecking in resources", 1000);
                int i = 0;
                while (i < resources.length) {
                    IResource resource = resources[i];
                    if (PessimisticFilesystemProvider.this.isControlled(resource) && resource.exists()) {
                        resource.setReadOnly(true);
                        modified.add(resource);
                    }
                    ++i;
                }
                monitor.done();
            }
        };
        this.run(runnable, monitor);
        this.fireStateChanged(modified, false);
    }

    public void checkout(final IResource[] resources, IProgressMonitor monitor) {
        if (PessimisticFilesystemProviderPlugin.getInstance().isDebugging()) {
            System.out.println("Check out:");
            if (resources != null) {
                int i = 0;
                while (i < resources.length) {
                    System.out.println("\t" + resources[i]);
                    ++i;
                }
            } else {
                System.out.println("null resources");
            }
        }
        if (resources == null || resources.length == 0) {
            return;
        }
        final HashSet modified = new HashSet(1);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("Checking out resources", 1000);
                int i = 0;
                while (i < resources.length) {
                    IResource resource = resources[i];
                    if (PessimisticFilesystemProvider.this.isControlled(resource) && resource.exists()) {
                        resource.setReadOnly(false);
                        modified.add(resource);
                    }
                    ++i;
                }
                monitor.done();
            }
        };
        this.run(runnable, monitor);
        this.fireStateChanged(modified, false);
    }

    public boolean isCheckedout(IResource resource) {
        if (PessimisticFilesystemProviderPlugin.getInstance().isDebugging()) {
            System.out.println("Is checked out: " + resource);
        }
        if (resource == null) {
            return false;
        }
        if (!this.isControlled(resource)) {
            return false;
        }
        if (this.isIgnored(resource)) {
            return false;
        }
        return !resource.isReadOnly();
    }

    public boolean isControlled(IResource resource) {
        if (PessimisticFilesystemProviderPlugin.getInstance().isDebugging()) {
            System.out.println("Is controlled: " + resource);
        }
        if (resource == null) {
            return false;
        }
        IProject project = this.getProject();
        if (!project.equals((Object)resource.getProject())) {
            return false;
        }
        Set controlled = (Set)this.fControlledResources.get(resource.getParent());
        if (controlled == null) {
            return false;
        }
        return controlled.contains(resource);
    }

    public boolean isIgnored(IResource resource) {
        if (PessimisticFilesystemProviderPlugin.getInstance().isDebugging()) {
            System.out.println("Is ignored: " + resource);
        }
        if (resource.isDerived()) {
            return !this.isControlled(resource);
        }
        return false;
    }

    public boolean hasContentChanged(IResource resource) {
        IPreferenceStore preferences;
        boolean change;
        if (PessimisticFilesystemProviderPlugin.getInstance().isDebugging()) {
            System.out.println("Has content change: " + resource);
        }
        if (change = (preferences = PessimisticFilesystemProviderPlugin.getInstance().getPreferenceStore()).getBoolean("org.eclipse.team.examples.pessimistic.ChangeFileContents")) {
            try {
                if (resource.getType() == 1) {
                    try {
                        this.appendText((IFile)resource, PessimisticFilesystemProvider.getRandomSnippet(), false);
                    }
                    catch (IOException iOException) {}
                } else {
                    resource.touch(null);
                }
            }
            catch (CoreException e) {
                PessimisticFilesystemProviderPlugin.getInstance().logError(e, "Problems touching resource: " + resource);
            }
        }
        return change;
    }

    public void appendText(IFile file, String text, boolean prepend) throws CoreException, IOException {
        String contents = PessimisticFilesystemProvider.getFileContents(file);
        StringBuffer buffer = new StringBuffer();
        if (prepend) {
            buffer.append(text);
        }
        buffer.append(contents);
        if (!prepend) {
            buffer.append(String.valueOf(System.getProperty("line.separator")) + text);
        }
        file.setContents((InputStream)new ByteArrayInputStream(buffer.toString().getBytes()), false, false, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileContents(IFile file) throws IOException, CoreException {
        StringBuffer buf = new StringBuffer();
        InputStreamReader reader = new InputStreamReader(new BufferedInputStream(file.getContents()));
        try {
            int c;
            while ((c = ((Reader)reader).read()) != -1) {
                buf.append((char)c);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ((Reader)reader).close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        ((Reader)reader).close();
        return buf.toString();
    }

    public static String getRandomSnippet() {
        switch ((int)Math.round(Math.random() * 10.0)) {
            case 0: {
                return "este e' o meu conteudo (portuguese)";
            }
            case 1: {
                return "Dann brauchen wir aber auch einen deutschen Satz!";
            }
            case 2: {
                return "I'll be back";
            }
            case 3: {
                return "don't worry, be happy";
            }
            case 4: {
                return "there is no imagination for more sentences";
            }
            case 5: {
                return "customize yours";
            }
            case 6: {
                return "foo";
            }
            case 7: {
                return "bar";
            }
            case 8: {
                return "foobar";
            }
            case 9: {
                return "case 9";
            }
        }
        return "these are my contents";
    }

    private void fireStateChanged(final Collection resources, boolean queueAfterWorkspaceOperation) {
        if (resources == null || resources.isEmpty()) {
            return;
        }
        if (queueAfterWorkspaceOperation) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(this){
                            final /* synthetic */ 8 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run(IProgressMonitor monitor) throws CoreException {
                            }
                        }, null);
                    }
                    catch (CoreException e) {
                        PessimisticFilesystemProviderPlugin.getInstance().logError(e, "Problem during empty runnable");
                    }
                    PessimisticFilesystemProvider.this.fireStateChanged(resources, false);
                }
            });
            t.start();
        } else {
            PessimisticFilesystemProviderPlugin.getInstance().fireResourcesChanged(resources.toArray(new IResource[resources.size()]));
        }
    }

    private Collection getSubtreeMembers(IResource resource) {
        final HashSet resources = new HashSet(1);
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                switch (resource.getType()) {
                    case 1: 
                    case 2: 
                    case 4: {
                        resources.add(resource);
                        return true;
                    }
                }
                return true;
            }
        };
        try {
            resource.accept(visitor);
        }
        catch (CoreException e) {
            PessimisticFilesystemProviderPlugin.getInstance().logError(e, "Problem during resource visiting");
        }
        return resources;
    }

    private void run(IWorkspaceRunnable runnable, IProgressMonitor monitor) {
        try {
            ResourcesPlugin.getWorkspace().run(runnable, monitor);
        }
        catch (CoreException e) {
            PessimisticFilesystemProviderPlugin.getInstance().logError(e, "Problems during workspace operation.");
        }
    }
}

