/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.examples.filesystem.Policy;

public class StreamUtil {
    protected static final byte[] COPY_BUFFER = new byte[4096];

    public static void pipe(InputStream in, OutputStream out, long sizeEstimate, IProgressMonitor progress, String title) throws IOException {
        Long kilobytesEstimate = new Long(sizeEstimate / 1024L);
        boolean showProgress = progress != null && sizeEstimate > 25000L;
        long bytesCopied = 0L;
        byte[] byArray = COPY_BUFFER;
        synchronized (COPY_BUFFER) {
            int read = in.read(COPY_BUFFER, 0, COPY_BUFFER.length);
            while (read != -1) {
                out.write(COPY_BUFFER, 0, read);
                if (showProgress) {
                    progress.subTask(Policy.bind("filetransfer.monitor", new Object[]{title, new Long((bytesCopied += (long)read) / 1024L), kilobytesEstimate}));
                }
                read = in.read(COPY_BUFFER, 0, COPY_BUFFER.length);
            }
            // ** MonitorExit[var10_8] (shouldn't be in output)
            return;
        }
    }
}

