/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.examples.paint.ContainerFigure;
import org.eclipse.swt.examples.paint.DragPaintSession;
import org.eclipse.swt.examples.paint.EllipseFigure;
import org.eclipse.swt.examples.paint.Figure;
import org.eclipse.swt.examples.paint.PaintPlugin;
import org.eclipse.swt.examples.paint.PaintSurface;
import org.eclipse.swt.examples.paint.PaintTool;
import org.eclipse.swt.examples.paint.SolidEllipseFigure;
import org.eclipse.swt.examples.paint.ToolSettings;
import org.eclipse.swt.graphics.Point;

public class EllipseTool
extends DragPaintSession
implements PaintTool {
    private ToolSettings settings;

    public EllipseTool(ToolSettings toolSettings, PaintSurface paintSurface) {
        super(paintSurface);
        this.set(toolSettings);
    }

    public void set(ToolSettings toolSettings) {
        this.settings = toolSettings;
    }

    public String getDisplayName() {
        return PaintPlugin.getResourceString("tool.Ellipse.label");
    }

    protected Figure createFigure(Point a, Point b) {
        ContainerFigure container = new ContainerFigure();
        if (this.settings.commonFillType != 0) {
            container.add(new SolidEllipseFigure(this.settings.commonBackgroundColor, a.x, a.y, b.x, b.y));
        }
        if (this.settings.commonFillType != 2) {
            container.add(new EllipseFigure(this.settings.commonForegroundColor, this.settings.commonBackgroundColor, this.settings.commonLineStyle, a.x, a.y, b.x, b.y));
        }
        return container;
    }
}

