/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;

public class DriverUtil {
    static /* synthetic */ Class class$0;

    private DriverUtil() {
    }

    public static int countClassesToProcess(File jarFile) throws Exception {
        JarFile jar = new JarFile(jarFile);
        return jar.getManifest().getEntries().size();
    }

    public static String[] getDriverClassesFromJar(File jarFile, IProgressMonitor monitor) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        JarFile jar = null;
        try {
            jar = new JarFile(jarFile);
        }
        catch (ZipException zipException) {
            return new String[0];
        }
        ZipFile zip = new ZipFile(jarFile);
        String taskDescription = ConnectivityPlugin.getDefault().getResourceString("DriverUtil.taskName", new Object[]{jarFile.getName()});
        int max = zip.size();
        monitor.beginTask(taskDescription, max);
        Enumeration<JarEntry> iter = jar.entries();
        while (iter.hasMoreElements()) {
            ZipEntry entry = iter.nextElement();
            monitor.worked(1);
            if (!entry.getName().endsWith(".class")) continue;
            try {
                String name = entry.getName();
                name = name.substring(0, name.length() - 6);
                name = name.replace('/', '.');
                Class testClass = DriverUtil.getDriverClassesFromJar2(jarFile, name);
                if (testClass == null) continue;
                list.add(testClass.getName());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private static Class getDriverClassesFromJar2(File jarFile, String classname) throws Exception {
        Class<?> outclass = null;
        URL[] jdbcClasspathURL = new URL[]{jarFile.toURL()};
        try {
            URLClassLoader classLoader = URLClassLoader.newInstance(jdbcClasspathURL);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.sql.Driver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> driverClass = classLoader.loadClass(clazz.getName());
            try {
                Class<?> testclass = classLoader.loadClass(classname);
                if (driverClass.isAssignableFrom(testclass)) {
                    outclass = testclass;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (UnsupportedClassVersionError err) {
                String reason = err.toString();
                Exception ce = new Exception(reason);
                ce.setStackTrace(err.getStackTrace());
                ConnectivityPlugin.getDefault().log(ce);
            }
        }
        catch (Exception e) {
            String reason = e.toString();
            Exception ce = new Exception(reason);
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
        return outclass;
    }
}

