/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.drivers;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.drivers.DriverMgmtMessages;
import org.eclipse.datatools.connectivity.drivers.DriverMigratorBase;
import org.eclipse.datatools.connectivity.drivers.IDriverMgmtConstants;
import org.eclipse.datatools.connectivity.drivers.IDriverMigrator;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;

public class DriverInstance {
    public static final String ELEM_MIGRATION = "migration";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_DRIVERTEMPLATEID = "newDriverTemplateID";
    private TemplateDescriptor mTemplate;
    private IPropertySet mInstance;
    private Properties mInstanceProps;
    private SoftReference mClassLoader;
    private IDriverMigrator mMigrator;
    private boolean mMigratorLoaded = false;

    public DriverInstance(IPropertySet instance) {
        this.mInstance = instance;
        this.mInstanceProps = this.mInstance.getBaseProperties();
        if (this.mInstanceProps != null) {
            String templateId = this.mInstanceProps.getProperty("org.eclipse.datatools.connectivity.drivers.defnType");
            this.mTemplate = TemplateDescriptor.getDriverTemplateDescriptor(templateId);
        }
    }

    public DriverInstance(TemplateDescriptor template, IPropertySet instance) {
        this.mTemplate = template;
        this.mInstance = instance;
        this.mInstanceProps = this.mInstance.getBaseProperties();
    }

    public String getName() {
        return this.mInstance.getName();
    }

    public String getId() {
        return this.mInstance.getID();
    }

    public String getJarList() {
        if (this.mInstanceProps != null && this.mInstanceProps.getProperty("jarList") != null) {
            String jarlist = this.mInstanceProps.getProperty("jarList");
            return jarlist.trim();
        }
        return null;
    }

    public String[] getJarListAsArray() {
        if (this.mInstanceProps != null && this.getJarList() != null) {
            if (this.getJarList().length() == 0) {
                return new String[0];
            }
            String[] paths = this.parseString(this.getJarList(), IDriverMgmtConstants.PATH_DELIMITER);
            return paths;
        }
        return null;
    }

    public String getNamedProperty(String name) {
        String id;
        String rtnStr = "";
        if (this.getTemplate() == null) {
            this.handleException(null, ConnectivityPlugin.getDefault().getResourceString("drivers.error.finding.property.no.template", new Object[]{name}));
            return rtnStr;
        }
        if (this.mInstanceProps != null && (id = this.getTemplate().getPropertyIDFromName(name)) != null) {
            rtnStr = this.mInstanceProps.getProperty(id);
        }
        if (rtnStr == null) {
            rtnStr = this.getTemplate().getPropertyValue(name);
        }
        return rtnStr;
    }

    public String getNamedPropertyByID(String id) {
        String rtnStr = "";
        if (this.mInstanceProps != null && id != null) {
            rtnStr = this.mInstanceProps.getProperty(id);
        }
        if (rtnStr == null) {
            if (this.getTemplate() == null) {
                this.handleException(null, ConnectivityPlugin.getDefault().getResourceString("drivers.error.finding.property.no.template", new Object[]{id}));
                rtnStr = "";
                return rtnStr;
            }
            rtnStr = this.getTemplate().getPropertyValueFromId(id);
        }
        return rtnStr;
    }

    public String getProperty(String id) {
        String rtnStr = null;
        if (this.mInstanceProps != null) {
            rtnStr = this.mInstanceProps.getProperty(id);
        }
        return rtnStr == null ? new String() : rtnStr;
    }

    public TemplateDescriptor getTemplate() {
        return this.mTemplate;
    }

    private String[] parseString(String str_list, String token) {
        StringTokenizer tk = new StringTokenizer(str_list, token);
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }

    public IPropertySet getPropertySet() {
        return this.mInstance;
    }

    public ClassLoader getClassLoader() throws Exception {
        if (this.mClassLoader == null || this.mClassLoader.get() == null) {
            this.mClassLoader = new SoftReference<ClassLoader>(this.createClassLoader(null));
        }
        return (ClassLoader)this.mClassLoader.get();
    }

    public ClassLoader createClassLoader(ClassLoader parentCL) throws Exception {
        String jarList = this.getJarList();
        if (!(jarList != null && jarList.trim().length() != 0 || this.getTemplate().getEmptyJarListIsOKFlag())) {
            throw new Exception(DriverMgmtMessages.getString("DriverInstance.error.jarListNotDefined"));
        }
        String[] jarStrings = this.getJarListAsArray();
        URL[] jars = new URL[jarStrings.length];
        int index = 0;
        int count = jars.length;
        while (index < count) {
            try {
                jars[index] = new File(jarStrings[index]).toURL();
            }
            catch (MalformedURLException e) {
                throw new Exception(DriverMgmtMessages.getString("DriverInstance.error.invalidClassPath"), e);
            }
            ++index;
        }
        if (parentCL == null) {
            return URLClassLoader.newInstance(jars);
        }
        return URLClassLoader.newInstance(jars, parentCL);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DriverInstance) {
            return obj == this || this.getId().equals(((DriverInstance)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public void handleException(Throwable exception, String message) {
        ConnectivityPlugin.getDefault().log((IStatus)new Status(4, ConnectivityPlugin.getDefault().getBundle().getSymbolicName(), -1, ConnectivityPlugin.getDefault().getResourceString("plugin.internal_error", new Object[]{message}), exception));
    }

    public synchronized boolean migrate() {
        if (this.mTemplate == null || this.mTemplate.getElement() == null) {
            return false;
        }
        IDriverMigrator migrator = this.getMigrator(this.mTemplate.getElement());
        if (migrator == null) {
            return false;
        }
        boolean changed = false;
        String newID = migrator.getNewDriverTemplateID();
        if (newID != null && !newID.equals(this.mTemplate.getId())) {
            Properties baseProps = this.mInstance.getBaseProperties();
            this.mInstance.setBaseProperties(null);
            baseProps.setProperty("org.eclipse.datatools.connectivity.drivers.defnType", newID);
            this.mInstance.setBaseProperties(baseProps);
            changed = true;
        }
        boolean migrated = migrator.performMigration(this);
        return changed || migrated;
    }

    public IDriverMigrator getMigrator(IConfigurationElement element) {
        this.loadMigrator(element);
        return this.mMigrator;
    }

    private void loadMigrator(IConfigurationElement element) {
        block10: {
            if (!this.mMigratorLoaded) {
                this.mMigratorLoaded = true;
                if (element == null) {
                    return;
                }
                IConfigurationElement[] migrationElements = element.getChildren(ELEM_MIGRATION);
                if (migrationElements == null || migrationElements.length == 0) {
                    return;
                }
                String migratorImpl = migrationElements[0].getAttribute(ATTR_CLASS);
                String newID = migrationElements[0].getAttribute(ATTR_DRIVERTEMPLATEID);
                if (migratorImpl != null && migratorImpl.length() > 0) {
                    try {
                        this.mMigrator = (IDriverMigrator)migrationElements[0].createExecutableExtension(ATTR_CLASS);
                    }
                    catch (CoreException e) {
                        String error = ConnectivityPlugin.getDefault().getResourceString("trace.error.migration", new Object[]{this.getId(), migratorImpl});
                        ConnectivityPlugin.getDefault().log(error);
                        if (ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) {
                            System.err.println(error);
                            e.printStackTrace();
                        }
                        break block10;
                    }
                }
                if (newID != null && newID.length() > 0) {
                    try {
                        DriverMigratorBase migrator = new DriverMigratorBase();
                        migrator.setInitializationData(migrationElements[0], null, null);
                        this.mMigrator = migrator;
                    }
                    catch (CoreException e) {
                        String error = ConnectivityPlugin.getDefault().getResourceString("trace.error.migration", new Object[]{this.getId(), migratorImpl});
                        ConnectivityPlugin.getDefault().log(error);
                        if (!ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) break block10;
                        System.err.println(error);
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

