/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.fullselect;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.ValuesRow;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConstants;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.util.LabelValuePair;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.BaseWindow;
import org.eclipse.datatools.sqltools.sqlbuilder.views.EditComboBoxCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.GridContentProvider;
import org.eclipse.datatools.sqltools.sqlbuilder.views.Modifier;
import org.eclipse.datatools.sqltools.sqlbuilder.views.NavigableTableViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.fullselect.RemoveValuesRowAction;
import org.eclipse.datatools.sqltools.sqlbuilder.views.fullselect.ValueTableElement;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ValuesRowViewer
extends BaseWindow {
    protected SQLDomainModel domainModel;
    protected ValuesGridViewer valuesGrid;
    protected ValuesRow valuesRow;
    static /* synthetic */ Class class$0;

    public ValuesRowViewer(SQLDomainModel domainModel) {
        super(domainModel);
        this.domainModel = domainModel;
    }

    public Control createControl(Composite parent) {
        this.client = ViewUtility.createComposite(parent, 1);
        this.valuesGrid = new ValuesGridViewer(this.client);
        return this.client;
    }

    public void setInput(Object element) {
        super.setInput(element);
        this.valuesGrid.setInput(element);
        this.valuesRow = (ValuesRow)element;
    }

    public void handleEvent(Event e) {
    }

    class ValuesComboBoxCellEditor
    extends EditComboBoxCellEditor {
        ValuesGridViewer viewer;

        public ValuesComboBoxCellEditor(Composite parent, LabelValuePair[] items, boolean addItems, ValuesGridViewer viewer) {
            super(parent, items, addItems);
            this.viewer = viewer;
        }

        protected void refreshComboItems() {
            int row = this.viewer.getTable().getSelectionIndex();
            if (row >= 0) {
                this.viewer.refreshCellEditor(row);
            }
        }

        protected LabelValuePair createComboBoxItem(String newValue) {
            if (!(newValue.equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || newValue.equals(SQLBuilderConstants.P_EDIT_EXPRESSION) || newValue.equals(SQLBuilderConstants.P_REPLACE_EXPRESSION))) {
                return new LabelValuePair(newValue, ExpressionHelper.createExpression(newValue));
            }
            return new LabelValuePair(newValue, newValue);
        }

        protected void doSetValue(Object value) {
            super.doSetValue(value);
        }
    }

    public class ValuesGridViewer
    extends NavigableTableViewer
    implements IMenuListener {
        protected Table table;
        protected TableColumn c1;
        protected ValuesComboBoxCellEditor valuesRowCellEditor;
        protected ValuesRowGridLabelProvider valuesRowLabelProvider;

        public ValuesGridViewer(Composite parent) {
            super(new Table(parent, 65538));
            this.table = this.getTable();
            this.table.setLinesVisible(true);
            this.table.setHeaderVisible(true);
            this.table.setLayoutData((Object)ViewUtility.createFill());
            TableLayout layout = new TableLayout();
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
            this.table.setLayout((Layout)layout);
            this.c1 = new TableColumn(this.table, 0);
            this.c1.setText(Messages._UI_COLUMN_VALUES_ROW_ITEM);
            String[] columnProperties = new String[]{(String)SQLBuilderConstants.P_STATEMENT_VALUE};
            this.setColumnProperties(columnProperties);
            LabelValuePair[] valueComboItems = new LabelValuePair[]{new LabelValuePair(SQLBuilderConstants.P_BUILD_EXPRESSION, SQLBuilderConstants.P_BUILD_EXPRESSION)};
            this.valuesRowCellEditor = new ValuesComboBoxCellEditor((Composite)this.table, valueComboItems, false, this);
            CellEditor[] editors = new CellEditor[]{this.valuesRowCellEditor};
            this.setCellEditors(editors);
            this.setCellModifier(new Modifier());
            this.setContentProvider((IContentProvider)new ValuesRowGridContentProvider(ValuesRowViewer.this.domainModel.getAdapterFactory()));
            this.setLabelProvider((IBaseLabelProvider)new ValuesRowGridLabelProvider());
            MenuManager contextMenu = new MenuManager("#PopUp");
            contextMenu.add((IContributionItem)new Separator("additions"));
            contextMenu.setRemoveAllWhenShown(true);
            contextMenu.addMenuListener((IMenuListener)this);
            Menu menu = contextMenu.createContextMenu(this.getControl());
            this.getControl().setMenu(menu);
        }

        public void menuAboutToShow(IMenuManager menu) {
            RemoveValuesRowAction removeValuesRowAction = new RemoveValuesRowAction(this);
            menu.add((IAction)removeValuesRowAction);
        }

        protected void inputChanged(Object newInput, Object oldInput) {
            super.inputChanged(newInput, oldInput);
        }

        public void refresh() {
            if (!this.isCellEditorActive()) {
                super.refresh();
            }
        }

        public void refreshCellEditor(int row) {
            QueryValueExpression expr;
            Object obj = this.getElementAt(row);
            LabelValuePair[] valueComboItems = new LabelValuePair[]{new LabelValuePair(SQLBuilderConstants.P_BUILD_EXPRESSION, SQLBuilderConstants.P_BUILD_EXPRESSION)};
            this.valuesRowCellEditor.createItems(valueComboItems);
            if (obj instanceof ValueTableElement && (expr = ((ValueTableElement)obj).getExpression()) != null) {
                LabelValuePair[] valueComboItems2 = new LabelValuePair[]{new LabelValuePair(SQLBuilderConstants.P_EDIT_EXPRESSION, SQLBuilderConstants.P_EDIT_EXPRESSION), new LabelValuePair(SQLBuilderConstants.P_REPLACE_EXPRESSION, SQLBuilderConstants.P_REPLACE_EXPRESSION)};
                this.valuesRowCellEditor.createItems(valueComboItems2);
            }
            CellEditor[] editors = new CellEditor[]{this.valuesRowCellEditor};
            this.setCellEditors(editors);
        }
    }

    public class ValuesRowGridContentProvider
    extends GridContentProvider {
        public ValuesRowGridContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object property) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.IStructuredItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.adapterFactory.adapt(property, (Object)clazz);
            if (property instanceof ValuesRow) {
                this.tableElements = new Vector();
                ValuesRow valRow = (ValuesRow)property;
                if (valRow != null) {
                    Iterator iterator = valRow.getExprList().iterator();
                    while (iterator.hasNext()) {
                        QueryValueExpression expr = (QueryValueExpression)iterator.next();
                        this.createNewValueElement(valRow, expr);
                    }
                }
                this.createNewValueElement(valRow, null);
            }
            return this.tableElements.toArray();
        }

        private void createNewValueElement(ValuesRow row, QueryValueExpression expr) {
            this.tableElements.add(new ValueTableElement(ValuesRowViewer.this.domainModel, row, expr));
        }
    }

    class ValuesRowGridLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ValuesRowGridLabelProvider() {
        }

        public String getColumnText(Object object, int columnIndex) {
            if (object instanceof ValueTableElement) {
                ValueTableElement element = (ValueTableElement)object;
                return element.getColumnText(columnIndex);
            }
            return "";
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return null;
        }
    }
}

