/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.IContentChangeListener;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.ParseException;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilder;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.SQLBuilderActionBarContributor;
import org.eclipse.datatools.sqltools.sqlbuilder.input.ISQLBuilderEditorInput;
import org.eclipse.datatools.sqltools.sqlbuilder.input.SQLBuilderFileEditorInput;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorResources;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class SQLBuilderEditor
extends EditorPart
implements ISelectionProvider,
IContentChangeListener {
    protected SQLBuilder _sqlBuilder;
    protected boolean _firstFocus = true;
    protected Collection _selectionChangedListeners = new ArrayList();
    protected ISelection _editorSelection;
    protected boolean _resourceRemoved = false;
    static /* synthetic */ Class class$0;

    public SQLBuilderEditor() {
        this._sqlBuilder = new SQLBuilder((IEditorPart)this);
        this._sqlBuilder.addContentChangeListener(this);
    }

    public void dispose() {
        super.dispose();
    }

    public void createPartControl(Composite composite) {
        this._sqlBuilder.createClient(composite);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        block6: {
            ISQLBuilderEditorInput sqlBuilderEditorInput = null;
            if (editorInput instanceof ISQLBuilderEditorInput) {
                sqlBuilderEditorInput = (ISQLBuilderEditorInput)editorInput;
            } else if (editorInput instanceof IFileEditorInput) {
                sqlBuilderEditorInput = new SQLBuilderFileEditorInput(((IFileEditorInput)editorInput).getFile());
            }
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(editorInput);
            this._sqlBuilder.setLoadOnConnection(true);
            try {
                this._sqlBuilder.setInput(sqlBuilderEditorInput);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                String sSQL = sqlBuilderEditorInput.getSQL();
                if (sSQL == null || sSQL.trim().length() <= 0) break block6;
                String sMessage = String.valueOf(e.getLocalizedMessage()) + Messages._QUESTION_MESSAGE_OPEN_INPUT_PARSE_FAILED;
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages._QUESTION_TITLE_OPEN_INPUT_PARSE_FAILED, (String)sMessage);
            }
        }
        site.setSelectionProvider((ISelectionProvider)this);
        this.refreshConnectionStatus();
        String title = editorInput.getName();
        this.setPartName(title);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        this._sqlBuilder.doSave(progressMonitor);
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return this._sqlBuilder.isDirty();
    }

    public void setResourceRemoved(boolean value) {
        this._resourceRemoved = value;
    }

    public void notifyContentChange() {
        this.updateDirtyStatus();
    }

    public void updateDirtyStatus() {
        this.firePropertyChange(257);
    }

    public void setFocus() {
        if (this._firstFocus) {
            this._firstFocus = false;
            this._sqlBuilder.connectIfNeeded((IWorkbenchPart)this);
        }
        this.refreshConnectionStatus();
    }

    public SQLBuilder getSQLBuilder() {
        return this._sqlBuilder;
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz) && this._sqlBuilder != null) {
            return this._sqlBuilder.getContentOutlinePage(null);
        }
        return super.getAdapter(key);
    }

    public SQLBuilderActionBarContributor getActionBarContributor() {
        return this._sqlBuilder.getActionBarContributor();
    }

    public void setActionBarContributor(SQLBuilderActionBarContributor contributor) {
        this._sqlBuilder.setActionBarContributor(contributor);
    }

    public void refreshConnectionStatus() {
        IEditorSite editorSite = this.getEditorSite();
        if (editorSite != null) {
            ISQLEditorConnectionInfo connInfo = this._sqlBuilder.getConnectionInfo();
            IActionBars actionBars = editorSite.getActionBars();
            if (actionBars != null) {
                IStatusLineManager statusLineMgr = actionBars.getStatusLineManager();
                if (connInfo != null) {
                    statusLineMgr.setErrorMessage(null);
                    String connStatus = connInfo.getName();
                    statusLineMgr.setMessage(connStatus);
                } else {
                    String connStatus = SQLEditorResources.SQLEditor_connection_status_noConnection;
                    statusLineMgr.setErrorMessage(connStatus);
                }
                actionBars.updateActionBars();
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this._selectionChangedListeners.add(listener);
    }

    public ISelection getSelection() {
        if (this._editorSelection != null) {
            System.out.println("non null _editorSelection");
        }
        return this._editorSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this._selectionChangedListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this._editorSelection = selection;
        Iterator listeners = this._selectionChangedListeners.iterator();
        while (listeners.hasNext()) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners.next();
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
    }
}

