/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.impl.DataTypes;
import org.eclipse.datatools.enablement.oda.xml.util.RelationInformation;

public class ResultSetMetaData
implements IResultSetMetaData {
    private String[] columnNames;
    private Map nameIndexMap;
    private RelationInformation ri;
    private String tableName;

    public ResultSetMetaData(RelationInformation ri, String tableName) {
        this.ri = ri;
        this.tableName = tableName;
        this.columnNames = ri.getTableColumnNames(tableName);
        this.nameIndexMap = new HashMap();
        int i = 0;
        while (i < this.columnNames.length) {
            this.nameIndexMap.put(this.columnNames[i], new Integer(i + 1));
            ++i;
        }
    }

    public int getColumnCount() throws OdaException {
        return this.columnNames.length;
    }

    public String getColumnName(int index) throws OdaException {
        return this.columnNames[index - 1];
    }

    public String getColumnLabel(int index) throws OdaException {
        return this.columnNames[index - 1];
    }

    public int getColumnType(int index) throws OdaException {
        return DataTypes.getType(this.getColumnTypeName(index));
    }

    public String getColumnTypeName(int index) throws OdaException {
        return this.ri.getTableColumnType(this.tableName, this.getColumnName(index));
    }

    public int getColumnDisplayLength(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public int getPrecision(int index) throws OdaException {
        return -1;
    }

    public int getScale(int index) throws OdaException {
        return -1;
    }

    public int isNullable(int index) throws OdaException {
        return 2;
    }

    int getColumnIndex(String columnName) throws OdaException {
        Object index = this.nameIndexMap.get(columnName);
        if (index == null) {
            throw new OdaException();
        }
        return (Integer)index;
    }
}

