/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.ui.designsession;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.internal.designsession.DataSetDesignSessionBase;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetEditorPage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;

public class DataSetDesignSession
extends DataSetDesignSessionBase {
    public static DataSetDesignSession startNewDesign(String newDataSetName, String odaDataSetId, DataSourceDesign dataSourceDesign) throws OdaException {
        OdaDesignSession odaDesign = DesignSessionUtil.createNewDataSetRequestSession(newDataSetName, odaDataSetId, dataSourceDesign);
        DataSetDesignSession newSession = new DataSetDesignSession(odaDesign);
        newSession.initWizard();
        return newSession;
    }

    public void restartNewDesign(String newDataSetName, String odaDataSetId, DataSourceDesign dataSourceDesign) throws OdaException {
        super.restartNewDesign(newDataSetName, odaDataSetId, dataSourceDesign);
    }

    public static DataSetDesignSession startEditDesign(DesignSessionRequest request) throws OdaException {
        DesignSessionUtil.validateRequestSession(request);
        OdaDesignSession odaDesign = DesignFactory.eINSTANCE.createOdaDesignSession();
        odaDesign.setRequest(request);
        DataSetDesignSession newSession = new DataSetDesignSession(odaDesign);
        newSession.initWizard();
        return newSession;
    }

    public boolean restartEditDesign(DesignSessionRequest newRequest, boolean resetEditorPages) throws OdaException {
        DesignSessionUtil.validateRequestSession(newRequest);
        return super.restartEditDesign(newRequest, resetEditorPages);
    }

    public OdaDesignSession flush() throws OdaException {
        return super.flush();
    }

    private DataSetDesignSession(OdaDesignSession odaDesign) throws OdaException {
        super(odaDesign);
    }

    public DesignSessionRequest getRequest() {
        return super.getRequest();
    }

    public OdaDesignSession finish() throws OdaException {
        return super.finish();
    }

    public OdaDesignSession cancel() {
        return super.cancel();
    }

    public IWizard getNewWizard() throws OdaException {
        return super.getNewWizard();
    }

    public IWizardPage getWizardStartingPage() throws OdaException {
        return super.getWizardStartingPage();
    }

    public DataSetEditorPage[] getEditorPages() throws OdaException {
        return super.getEditorPages();
    }

    public IAdaptable getEditorPageElement() throws OdaException {
        return super.getEditorPageElement();
    }
}

