/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.IPropertySetChangeEvent;
import org.eclipse.datatools.connectivity.IPropertySetListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.Category;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.LocalRepositoryNode;
import org.eclipse.datatools.connectivity.ui.RefreshProfileJob;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.INavigatorContentService;

public class ConnectionProfileContentProvider
implements ICommonContentProvider {
    private boolean mShowCategories = true;
    private Viewer mViewer;
    private Object mInput;
    private IExtensionStateModel mStateModel;
    private LocalRepositoryNode mLocalRepoNode;
    private IProfileListener mProfileListener = new IProfileListener(){

        public void profileAdded(IConnectionProfile profile) {
            profile.addPropertySetListener(ConnectionProfileContentProvider.this.mPropertyListener);
            ConnectionProfileContentProvider.this.refreshViewer(ConnectionProfileContentProvider.this.mShowCategories && !ConnectionProfileContentProvider.this.isRepositoryProfile(profile) ? profile.getCategory() : null, true);
        }

        public void profileDeleted(IConnectionProfile profile) {
            profile.removePropertySetListener(ConnectionProfileContentProvider.this.mPropertyListener);
            ConnectionProfileContentProvider.this.refreshViewer(ConnectionProfileContentProvider.this.mShowCategories && !ConnectionProfileContentProvider.this.isRepositoryProfile(profile) ? profile.getCategory() : null, true);
        }

        public void profileChanged(IConnectionProfile profile) {
            ConnectionProfileContentProvider.this.refreshViewer(profile, false);
        }
    };
    private IPropertySetListener mPropertyListener = new IPropertySetListener(){

        public void propertySetChanged(IPropertySetChangeEvent event) {
            ConnectionProfileContentProvider.this.handleProfilePropertyChanged(event);
        }
    };
    private IPropertyChangeListener mPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("showCategories".equals(event.getProperty())) {
                ConnectionProfileContentProvider.this.setShowCategories((Boolean)event.getNewValue());
            }
        }
    };

    public ConnectionProfileContentProvider() {
        ProfileManager.getInstance().addProfileListener(this.mProfileListener);
    }

    public void setShowCategories(boolean showCategories) {
        if (showCategories != this.mShowCategories) {
            this.mShowCategories = showCategories;
            this.refreshViewer(null, false);
        }
    }

    public boolean isShowCategories() {
        return this.mShowCategories;
    }

    protected void refreshViewer(final Object object, boolean expand) {
        if (this.mViewer instanceof TreeViewer && object instanceof IConnectionProfile) {
            RefreshProfileJob.scheduleRefreshProfileJob((IConnectionProfile)object, (TreeViewer)this.mViewer);
        } else {
            Runnable runner = new Runnable(){

                /*
                 * Unable to fully structure code
                 */
                public void run() {
                    block12: {
                        if (ConnectionProfileContentProvider.access$3(ConnectionProfileContentProvider.this) instanceof CommonViewer) {
                            exception = null;
                            try {
                                ((CommonViewer)ConnectionProfileContentProvider.access$3(ConnectionProfileContentProvider.this)).refresh(object);
                                break block12;
                            }
                            catch (SWTException v0) {
                                return;
                            }
                            catch (RuntimeException re) {
                                exception = re;
                                count = 5;
                                ** while (exception != null && count > 0)
                            }
lbl-1000:
                            // 1 sources

                            {
                                --count;
                                try {
                                    ((CommonViewer)ConnectionProfileContentProvider.access$3(ConnectionProfileContentProvider.this)).refresh(object);
                                }
                                catch (RuntimeException re2) {
                                    exception = re2;
                                }
                                continue;
                            }
lbl19:
                            // 1 sources

                            if (count == 0 && exception != null) {
                                ConnectivityUIPlugin.getDefault().log(exception);
                            }
                        } else if (ConnectionProfileContentProvider.access$3(ConnectionProfileContentProvider.this) instanceof StructuredViewer) {
                            try {
                                ((StructuredViewer)ConnectionProfileContentProvider.access$3(ConnectionProfileContentProvider.this)).refresh(object);
                            }
                            catch (SWTException v1) {
                                return;
                            }
                        }
                    }
                }
            };
            if (this.mViewer != null && !this.mViewer.getControl().isDisposed() && !this.mViewer.getControl().getDisplay().isDisposed()) {
                this.mViewer.getControl().getDisplay().asyncExec(runner);
            }
        }
    }

    protected void handleProfilePropertyChanged(IPropertySetChangeEvent event) {
        if (IConnectionProfile.CONNECTION_PROFILE_PROPERTY_SET.equals(event.getPropertySetType()) && event.getChangedProperty("connectionState") != null) {
            final IPropertySetChangeEvent finalEvent = event;
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (display != null && !display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        IViewPart dse = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.datatools.connectivity.DataSourceExplorerNavigator");
                        if (dse != null) {
                            CommonNavigator navigator = (CommonNavigator)dse;
                            INavigatorContentService contentService = navigator.getNavigatorContentService();
                            String description = contentService.createCommonDescriptionProvider().getDescription((Object)finalEvent.getConnectionProfile());
                            Image image = contentService.createCommonLabelProvider().getImage((Object)finalEvent.getConnectionProfile());
                            navigator.getViewSite().getActionBars().getStatusLineManager().setMessage(image, description);
                        }
                    }
                });
            }
            this.refreshViewer(event.getConnectionProfile(), false);
        }
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = new Object[]{};
        if (parentElement instanceof IWorkspaceRoot) {
            return this.getChildren(ProfileManager.getInstance());
        }
        if (parentElement instanceof ProfileManager) {
            ProfileManager pm = (ProfileManager)parentElement;
            ArrayList<LocalRepositoryNode> kids = new ArrayList<LocalRepositoryNode>();
            if (this.mLocalRepoNode == null) {
                this.mLocalRepoNode = new LocalRepositoryNode();
            }
            kids.add(this.mLocalRepoNode);
            this.recurseSubCategoryProfiles(pm.getCategory("org.eclipse.datatools.connectivity.connectionProfileRepositoryCategory"), kids);
            children = kids.size() == 1 ? this.getChildren(kids.get(0)) : kids.toArray();
        } else if (parentElement instanceof LocalRepositoryNode) {
            ArrayList<Object> kids = new ArrayList<Object>();
            ProfileManager pm = ProfileManager.getInstance();
            if (this.mShowCategories) {
                kids.addAll(Arrays.asList(pm.getRootCategories()));
                kids.remove(pm.getCategory("org.eclipse.datatools.connectivity.connectionProfileRepositoryCategory"));
                children = kids.toArray();
            } else {
                kids.addAll(Arrays.asList(pm.getProfiles(false)));
                this.removeRepositoryProfiles(kids, pm.getCategory("org.eclipse.datatools.connectivity.connectionProfileRepositoryCategory"));
            }
            children = kids.toArray();
        } else if (parentElement instanceof Object[]) {
            children = (Object[])parentElement;
        } else if (parentElement instanceof ICategory) {
            ICategory icat = (ICategory)parentElement;
            ArrayList arry = new ArrayList();
            if (this.mShowCategories) {
                arry.addAll(icat.getChildCategories());
                arry.addAll(icat.getAssociatedProfiles());
            } else {
                arry.addAll(icat.getAssociatedProfiles());
                this.recurseSubCategoryProfiles(icat, arry);
            }
            children = arry.toArray();
        } else if (parentElement instanceof IConnectionProfile) {
            children = new Object[]{};
        }
        if (children != null && children.length > 0) {
            Arrays.sort(children, new Comparator(){

                public int compare(Object e1, Object e2) {
                    if (e1 instanceof LocalRepositoryNode) {
                        return -1;
                    }
                    if (e2 instanceof LocalRepositoryNode) {
                        return 1;
                    }
                    if (e1 instanceof IConnectionProfile && e2 instanceof IConnectionProfile) {
                        IConnectionProfile icp1 = (IConnectionProfile)e1;
                        IConnectionProfile icp2 = (IConnectionProfile)e2;
                        return icp1.getName().compareToIgnoreCase(icp2.getName());
                    }
                    if (e1 instanceof ICategory && e2 instanceof ICategory) {
                        ICategory icat1 = (ICategory)e1;
                        ICategory icat2 = (ICategory)e2;
                        return icat1.getName().compareToIgnoreCase(icat2.getName());
                    }
                    return 0;
                }
            });
        }
        return children;
    }

    private void removeRepositoryProfiles(List kids, ICategory category) {
        kids.removeAll(category.getAssociatedProfiles());
        Iterator it = category.getChildCategories().iterator();
        while (it.hasNext()) {
            this.removeRepositoryProfiles(kids, (ICategory)it.next());
        }
    }

    private void recurseSubCategoryProfiles(ICategory parent, List arry) {
        arry.addAll(parent.getAssociatedProfiles());
        Iterator it = parent.getChildCategories().iterator();
        while (it.hasNext()) {
            ICategory sub = (ICategory)it.next();
            this.recurseSubCategoryProfiles(sub, arry);
        }
    }

    public Object getParent(Object element) {
        Object parent = null;
        if (element instanceof ICategory) {
            parent = ((ICategory)element).getParent();
            if (parent == null) {
                parent = ((Category)element).getRepositoryProfile();
            }
            if (parent == null) {
                parent = this.mInput;
            }
        } else if (element instanceof IConnectionProfile) {
            if (this.mShowCategories) {
                parent = ((IConnectionProfile)element).getCategory();
                if (parent == null || this.isRepositoryProfile((IConnectionProfile)element)) {
                    parent = this.mInput;
                }
            } else {
                parent = ((IConnectionProfile)element).getParentProfile();
                if (parent == null) {
                    parent = this.mInput;
                }
            }
        }
        return parent;
    }

    private boolean isRepositoryProfile(IConnectionProfile profile) {
        ICategory cat = profile.getCategory();
        while (cat != null) {
            if ("org.eclipse.datatools.connectivity.connectionProfileRepositoryCategory".equals(cat.getId())) {
                return true;
            }
            cat = cat.getParent();
        }
        return false;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        ProfileManager.getInstance().removeProfileListener(this.mProfileListener);
        Iterator<IConnectionProfile> it = Arrays.asList(ProfileManager.getInstance().getProfiles()).iterator();
        while (it.hasNext()) {
            it.next().removePropertySetListener(this.mPropertyListener);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.mInput = newInput;
        this.mViewer = viewer;
        if (this.mViewer == null) {
            Iterator<IConnectionProfile> it = Arrays.asList(ProfileManager.getInstance().getProfiles()).iterator();
            while (it.hasNext()) {
                it.next().removePropertySetListener(this.mPropertyListener);
            }
        } else {
            Iterator<IConnectionProfile> it = Arrays.asList(ProfileManager.getInstance().getProfiles()).iterator();
            while (it.hasNext()) {
                it.next().addPropertySetListener(this.mPropertyListener);
            }
            if (this.mViewer instanceof CommonViewer) {
                ((CommonViewer)this.mViewer).getNavigatorContentService().findStateModel("org.eclipse.datatools.connectivity.dsexplorer.content").removePropertyChangeListener(this.mPropertyChangeListener);
                IExtensionStateModel stateModel = ((CommonViewer)this.mViewer).getNavigatorContentService().findStateModel("org.eclipse.datatools.connectivity.dsexplorer.content");
                stateModel.addPropertyChangeListener(this.mPropertyChangeListener);
                boolean testStateCategories = stateModel.getBooleanProperty("showCategories");
                if (this.mShowCategories != testStateCategories) {
                    this.setShowCategories(testStateCategories);
                }
            }
        }
    }

    public void init(ICommonContentExtensionSite aConfig) {
        this.mStateModel = aConfig.getExtensionStateModel();
    }

    public void restoreState(IMemento aMemento) {
        this.mStateModel.setBooleanProperty("showCategories", this.mShowCategories);
    }

    public void saveState(IMemento aMemento) {
        aMemento.putString("showCategories", Boolean.toString(this.isShowCategories()));
    }

    static /* synthetic */ Viewer access$3(ConnectionProfileContentProvider connectionProfileContentProvider) {
        return connectionProfileContentProvider.mViewer;
    }
}

