/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.drivers.DriverMgmtMessages;
import org.eclipse.datatools.connectivity.drivers.DriverValidator;
import org.eclipse.datatools.connectivity.drivers.IDriverMgmtConstants;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.PropertySetImpl;
import org.eclipse.datatools.connectivity.drivers.models.CategoryDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.DriverImages;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.DriverDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DriverListCombo {
    private Composite mPanel;
    private Combo mComboList;
    private Label mLabel;
    private String mLabelText;
    private String mCategoryId;
    private String mErrorMessage;
    private String mInitialDriverName;
    private boolean mNullDriverValid = true;
    private String mFilter = null;
    private boolean isReadOnly = false;
    private boolean mShowLabel = true;
    private ListenerList changeListeners = new ListenerList();
    private Image mDriverImage = null;
    private Image mChangeImage = null;
    private static ImageDescriptor PLUS = null;
    private static ImageDescriptor ARROW = null;
    private static ImageDescriptor CHANGE = null;
    private Image mArrowImage = null;
    private boolean mShowNewDriverButton = true;
    private boolean mShowGenericDriverButton = false;
    private boolean mShowMenu = false;
    private boolean mShowEditButton = true;
    private ToolItem mTBButtonEdit;

    public DriverListCombo() {
        this(false);
    }

    public DriverListCombo(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public void setInitialDriverName(String driverName) {
        this.mInitialDriverName = driverName;
    }

    public String getInitialDriverName() {
        return this.mInitialDriverName;
    }

    public void setCategory(String category) {
        this.mCategoryId = category;
    }

    public String getCategory() {
        return this.mCategoryId;
    }

    public void setFilter(String filter) {
        this.mFilter = filter;
    }

    public String getFilter() {
        return this.mFilter;
    }

    public void setShowLabel(boolean flag) {
        this.mShowLabel = flag;
    }

    public void setShowNewDriverButton(boolean flag) {
        this.mShowNewDriverButton = flag;
    }

    public void setShowGenericDriverButton(boolean flag) {
        this.mShowGenericDriverButton = flag;
    }

    public void setShowMenu(boolean flag) {
        this.mShowMenu = flag;
    }

    public void setShowEditButton(boolean flag) {
        this.mShowEditButton = flag;
    }

    public boolean getShowLabel() {
        return this.mShowLabel;
    }

    public void setLabelText(String label) {
        this.mLabelText = label;
    }

    public String getLabelText() {
        return this.mLabelText;
    }

    public boolean getNullDriverIsValid() {
        return this.mNullDriverValid;
    }

    public void setNullDriverIsValid(boolean flag) {
        this.mNullDriverValid = flag;
    }

    public void createContents(Composite parent) {
        this.makeImages();
        this.mPanel = new Composite(parent, 0);
        GridData vdata = new GridData(784);
        vdata.horizontalSpan = 2;
        this.mPanel.setLayoutData((Object)vdata);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.mPanel.setLayout((Layout)gridLayout);
        if (this.mShowLabel) {
            this.mLabel = new Label(this.mPanel, 0);
            GridData ldata = new GridData(256);
            ldata.horizontalSpan = 2;
            this.mLabel.setLayoutData((Object)ldata);
            this.mLabel.setText(this.mLabelText);
        }
        this.mComboList = new Combo(this.mPanel, 2060);
        this.mComboList.setEnabled(!this.isReadOnly);
        GridData cdata = new GridData(768);
        this.mComboList.setLayoutData((Object)cdata);
        ComboSelectionListener listener = new ComboSelectionListener(this);
        this.mComboList.addModifyListener((ModifyListener)listener);
        this.mComboList.addSelectionListener((SelectionListener)listener);
        final ToolBar toolBar = new ToolBar(this.mPanel, 0x800000);
        if (this.mShowNewDriverButton) {
            ToolItem item1 = new ToolItem(toolBar, 8);
            DecorationOverlayIcon icon = new DecorationOverlayIcon(this.mDriverImage, PLUS, 1);
            item1.setImage(icon.createImage());
            item1.setToolTipText(DriverMgmtMessages.getString((String)"DriverListCombo.button.newdriver"));
            item1.addSelectionListener((SelectionListener)new NewButtonSelectionChangedListener(this));
            item1.setEnabled(!this.isReadOnly);
        }
        if (this.mShowGenericDriverButton) {
            ToolItem item2 = new ToolItem(toolBar, 8);
            item2.setImage(this.mDriverImage);
            item2.setToolTipText(DriverMgmtMessages.getString((String)"DriverListCombo.button.generic"));
            item2.addSelectionListener((SelectionListener)new NewGenericSelectionChangedListener(this));
            item2.setEnabled(!this.isReadOnly);
        }
        if (this.mShowEditButton) {
            this.mTBButtonEdit = new ToolItem(toolBar, 8);
            this.mTBButtonEdit.setImage(this.mChangeImage);
            this.mTBButtonEdit.setToolTipText(DriverMgmtMessages.getString((String)"DriverListCombo.EditDriverButton.tooltip"));
            this.mTBButtonEdit.addSelectionListener((SelectionListener)new EditButtonSelectionChangedListener(this));
        }
        if (this.mShowMenu) {
            final Menu menu = new Menu((Decorations)this.mPanel.getShell(), 8);
            MenuItem mitem1 = new MenuItem(menu, 8);
            mitem1.setText(DriverMgmtMessages.getString((String)"DriverListCombo.button.newdriver"));
            mitem1.addSelectionListener((SelectionListener)new NewButtonSelectionChangedListener(this));
            MenuItem mitem2 = new MenuItem(menu, 8);
            mitem2.setText(DriverMgmtMessages.getString((String)"DriverListCombo.button.generic"));
            mitem2.addSelectionListener((SelectionListener)new NewGenericSelectionChangedListener(this));
            final ToolItem item3 = new ToolItem(toolBar, 8);
            item3.setImage(this.mArrowImage);
            item3.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    Rectangle rect = item3.getBounds();
                    Point pt = new Point(rect.x, rect.y + rect.height);
                    pt = toolBar.toDisplay(pt);
                    menu.setLocation(pt.x, pt.y);
                    menu.setVisible(true);
                }
            });
            item3.setEnabled(!this.isReadOnly);
        }
        this.refreshCombo();
    }

    public Combo getCombo() {
        return this.mComboList;
    }

    private void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this.changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ChangeListener)listeners[i]).stateChanged(e);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove((Object)listener);
    }

    protected String[] parseString(String str_list) {
        return this.parseString(str_list, IDriverMgmtConstants.PATH_DELIMITER);
    }

    protected String[] parseString(String str_list, String token) {
        StringTokenizer tk = new StringTokenizer(str_list, token);
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }

    private IPropertySet getSelectedDriver() {
        String keyString;
        int keyIndex = this.mComboList.getSelectionIndex();
        if (keyIndex > -1 && this.mComboList.getData(keyString = this.mComboList.getItem(keyIndex)) != null) {
            IPropertySet ps = (IPropertySet)this.mComboList.getData(keyString);
            return ps;
        }
        return null;
    }

    public DriverInstance getSelectedDriverInstance() {
        IPropertySet ps = this.getSelectedDriver();
        if (ps != null) {
            return new DriverInstance(ps);
        }
        return null;
    }

    public String getSelectedDriverName() {
        IPropertySet ps = this.getSelectedDriver();
        if (ps != null) {
            return ps.getName();
        }
        return null;
    }

    public String getSelectedDriverID() {
        IPropertySet ps = this.getSelectedDriver();
        if (ps != null) {
            return ps.getID();
        }
        return null;
    }

    public void setSelection(String name) {
        List<String> list = Arrays.asList(this.mComboList.getItems());
        if (list.contains(name)) {
            this.mComboList.select(list.indexOf(name));
            this.mComboList.setText(name);
        }
    }

    public void setSelectionToID(String id) {
        String driverName = null;
        List<String> list = Arrays.asList(this.mComboList.getItems());
        int i = 0;
        while (i < list.size()) {
            IPropertySet ps;
            String keyString = this.mComboList.getItem(i);
            if (this.mComboList.getData(keyString) != null && (ps = (IPropertySet)this.mComboList.getData(keyString)).getID().equals(id)) {
                driverName = keyString;
                break;
            }
            ++i;
        }
        if (driverName != null) {
            this.mComboList.select(list.indexOf(driverName));
            this.mComboList.setText(driverName);
        }
    }

    public void selectFirstItem() {
        if (this.mComboList.getItemCount() > 0) {
            this.mComboList.select(0);
        } else {
            this.mErrorMessage = this.mNullDriverValid ? null : DriverMgmtMessages.getString((String)"DriverValidator.msg.no_driver_selected");
        }
        this.fireChangedEvent(this.mComboList.getParent());
    }

    private boolean passesFilter(TemplateDescriptor template, IPropertySet pset) {
        boolean rtn = true;
        if (this.mFilter != null && template != null && pset != null) {
            String[] filters = this.parseString(this.mFilter, ",");
            int i = 0;
            while (i < filters.length) {
                String filter = filters[i];
                String[] args = this.parseString(filter, "=");
                String arg = args[0].trim();
                String value = args[1].trim();
                if (arg.equals("id")) {
                    if (pset.getID().indexOf(value) == -1) {
                        rtn = false;
                        break;
                    }
                } else if (arg.equals("name")) {
                    if (pset.getName().indexOf(value) == -1) {
                        rtn = false;
                        break;
                    }
                } else if (arg.equals("templateID")) {
                    if (template.getId().indexOf(value) == -1) {
                        rtn = false;
                        break;
                    }
                } else if (arg.equals("templateIDStartsWith")) {
                    if (!template.getId().startsWith(value)) {
                        rtn = false;
                        break;
                    }
                } else if (arg.equals("templateIDEndsWith")) {
                    if (!template.getId().endsWith(value)) {
                        rtn = false;
                        break;
                    }
                } else if (arg.equals("templateIDContains") && template.getId().indexOf(value) == -1) {
                    rtn = false;
                    break;
                }
                ++i;
            }
        }
        return rtn;
    }

    public void refreshCombo() {
        String text;
        this.getCombo().removeAll();
        IPropertySet[] psets = new IPropertySet[]{};
        IPropertySet[] comboPsets = new IPropertySet[]{};
        DriverInstance[] dilist = DriverManager.getInstance().getAllDriverInstances();
        if (dilist != null && dilist.length > 0) {
            psets = new IPropertySet[dilist.length];
            int i = 0;
            while (i < psets.length) {
                psets[i] = dilist[i].getPropertySet();
                ++i;
            }
        }
        if (this.mCategoryId != null) {
            CategoryDescriptor category = CategoryDescriptor.getCategoryDescriptor((String)this.mCategoryId);
            ArrayList templates = new ArrayList();
            if (category == null) {
                CategoryDescriptor[] categories = CategoryDescriptor.getRootCategories();
                int index = 0;
                int count = categories.length;
                while (index < count) {
                    this.populateAssociatedDriverTypes(categories[index], templates);
                    ++index;
                }
            } else {
                this.populateAssociatedDriverTypes(category, templates);
            }
            TemplateDescriptorComparator comparator = new TemplateDescriptorComparator();
            Object[] templatesArray = templates.toArray();
            Arrays.sort(templatesArray, comparator);
            Arrays.sort(psets, new PropertySetComparator());
            ArrayList<IPropertySet> listForCombo = new ArrayList<IPropertySet>();
            int i = 0;
            while (i < templatesArray.length) {
                TemplateDescriptor template = (TemplateDescriptor)templatesArray[i];
                int j = 0;
                while (j < psets.length) {
                    IPropertySet pset = psets[j];
                    String driverType = pset.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType");
                    if (driverType.equals(template.getId()) && this.passesFilter(template, pset)) {
                        listForCombo.add(pset);
                    }
                    ++j;
                }
                ++i;
            }
            comboPsets = listForCombo.toArray(new IPropertySet[listForCombo.size()]);
        } else {
            comboPsets = psets;
        }
        if (comboPsets != null && comboPsets.length > 0) {
            PropertySetComparator comparator = new PropertySetComparator();
            Arrays.sort(comboPsets, comparator);
            int i = 0;
            while (i < comboPsets.length) {
                IPropertySet pset = comboPsets[i];
                this.getCombo().add(pset.getName());
                this.getCombo().setData(pset.getName(), (Object)pset);
                ++i;
            }
        }
        if (this.mTBButtonEdit != null) {
            this.mTBButtonEdit.setEnabled(false);
        }
        if ((text = this.getCombo().getText()) != null && text.trim().length() > 0) {
            int i = 0;
            while (i < this.getCombo().getItemCount()) {
                if (this.getCombo().getItem(i).equals(text)) {
                    this.getCombo().select(i);
                    break;
                }
                ++i;
            }
        } else if (this.getCombo().getItemCount() > 0 && this.mTBButtonEdit != null) {
            this.mTBButtonEdit.setEnabled(true);
        }
    }

    private void populateAssociatedDriverTypes(CategoryDescriptor category, List templates) {
        templates.addAll(category.getAssociatedDriverTypes());
        Iterator it = category.getChildCategories().iterator();
        while (it.hasNext()) {
            this.populateAssociatedDriverTypes((CategoryDescriptor)it.next(), templates);
        }
    }

    protected void finalize() throws Throwable {
        this.mDriverImage.dispose();
        this.mChangeImage.dispose();
        super.finalize();
    }

    private void makeImages() {
        this.mDriverImage = DriverImages.DRIVER.createImage();
        PLUS = AbstractUIPlugin.imageDescriptorFromPlugin((String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName(), (String)"icons/add_obj2.gif");
        PLUS.createImage();
        ARROW = AbstractUIPlugin.imageDescriptorFromPlugin((String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName(), (String)"icons/view_menu.gif");
        this.mArrowImage = ARROW.createImage();
        CHANGE = AbstractUIPlugin.imageDescriptorFromPlugin((String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName(), (String)"icons/change_obj.gif");
        this.mChangeImage = CHANGE.createImage();
        PLUS.createImage();
    }

    private IPropertySet duplicatePropertySet(IPropertySet pset) {
        PropertySetImpl newPset = new PropertySetImpl(pset.getName(), pset.getID());
        if (pset.getBaseProperties().size() > 0) {
            Properties newProps = new Properties();
            newPset.setBaseProperties(newProps);
            newPset.getBaseProperties().putAll((Map<?, ?>)pset.getBaseProperties());
        }
        return newPset;
    }

    private void copyPropertySet(IPropertySet fromPset, IPropertySet topset) {
        topset.setID(fromPset.getID());
        topset.setName(fromPset.getName());
        if (topset.getBaseProperties().size() > 0) {
            topset.getBaseProperties().putAll((Map<?, ?>)fromPset.getBaseProperties());
        }
    }

    private class ComboSelectionListener
    implements SelectionListener,
    ModifyListener {
        private DriverListCombo parent;

        public ComboSelectionListener(DriverListCombo combo) {
            this.parent = combo;
        }

        public void widgetSelected(SelectionEvent e) {
            int keyIndex = DriverListCombo.this.mComboList.getSelectionIndex();
            if (keyIndex == -1 && DriverListCombo.this.mTBButtonEdit != null) {
                DriverListCombo.this.mTBButtonEdit.setEnabled(false);
            } else if (keyIndex > -1 && DriverListCombo.this.mTBButtonEdit != null) {
                DriverListCombo.this.mTBButtonEdit.setEnabled(true);
            }
            if (keyIndex > -1) {
                TemplateDescriptor template;
                String driverType;
                IPropertySet ps;
                String keyString = DriverListCombo.this.mComboList.getItem(keyIndex);
                if (DriverListCombo.this.mComboList.getData(keyString) != null && (ps = (IPropertySet)DriverListCombo.this.mComboList.getData(keyString)) != null && (driverType = ps.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType")) != null && (template = TemplateDescriptor.getDriverTemplateDescriptor((String)driverType)) != null) {
                    DriverValidator validator = new DriverValidator(template, ps);
                    DriverListCombo.this.mErrorMessage = null;
                    if (!validator.isValid()) {
                        DriverListCombo.this.mErrorMessage = validator.getMessage();
                    }
                }
            } else if (DriverListCombo.this.mNullDriverValid) {
                DriverListCombo.this.mErrorMessage = null;
            } else {
                DriverListCombo.this.mErrorMessage = DriverMgmtMessages.getString((String)"DriverValidator.msg.no_driver_selected");
            }
            DriverListCombo.this.fireChangedEvent(this.parent);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void modifyText(ModifyEvent e) {
            String keyString = DriverListCombo.this.mComboList.getText();
            if (keyString.length() > 0) {
                TemplateDescriptor template;
                String driverType;
                IPropertySet ps;
                if (DriverListCombo.this.mComboList.getData(keyString) != null && (ps = (IPropertySet)DriverListCombo.this.mComboList.getData(keyString)) != null && (driverType = ps.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType")) != null && (template = TemplateDescriptor.getDriverTemplateDescriptor((String)driverType)) != null) {
                    DriverValidator validator = new DriverValidator(template, ps);
                    DriverListCombo.this.mErrorMessage = null;
                    if (!validator.isValid()) {
                        DriverListCombo.this.mErrorMessage = validator.getMessage();
                    }
                }
            } else if (DriverListCombo.this.mNullDriverValid) {
                DriverListCombo.this.mErrorMessage = null;
            } else {
                DriverListCombo.this.mErrorMessage = DriverMgmtMessages.getString((String)"DriverValidator.msg.no_driver_selected");
            }
            DriverListCombo.this.fireChangedEvent(this.parent);
        }
    }

    public class EditButtonSelectionChangedListener
    implements SelectionListener {
        private DriverListCombo parent;

        public EditButtonSelectionChangedListener(DriverListCombo combo) {
            this.parent = combo;
        }

        public void widgetSelected(SelectionEvent e) {
            int keyIndex;
            Shell newShell = this.parent.getCombo().getShell();
            DriverDialog dlg = DriverListCombo.this.mCategoryId != null ? new DriverDialog(newShell, DriverListCombo.this.mCategoryId) : new DriverDialog(newShell);
            dlg.setIsEditable(!DriverListCombo.this.isReadOnly);
            if (this.parent.getSelectedDriver() == null) {
                return;
            }
            IPropertySet copy = DriverListCombo.this.duplicatePropertySet(this.parent.getSelectedDriver());
            dlg.setPropertySet(copy);
            dlg.setEditMode(true);
            int rtn = dlg.open();
            if (rtn != 0) {
                return;
            }
            copy = dlg.getPropertySet();
            DriverListCombo.this.copyPropertySet(copy, this.parent.getSelectedDriver());
            DriverManager.getInstance().removeDriverInstance(this.parent.getSelectedDriver().getID());
            System.gc();
            DriverManager.getInstance().addDriverInstance(copy);
            DriverListCombo.this.refreshCombo();
            boolean fireEvent = false;
            if (dlg.getSelectedDefinition() != null) {
                fireEvent = true;
                String driverName = dlg.getSelectedDefinition().getName();
                String[] itemList = DriverListCombo.this.mComboList.getItems();
                if (itemList.length > 0) {
                    int i = 0;
                    while (i < itemList.length) {
                        String item = itemList[i];
                        IPropertySet temp = (IPropertySet)DriverListCombo.this.mComboList.getData(item);
                        if (temp.getID().equals(dlg.getSelectedDefinition().getID())) {
                            TemplateDescriptor template;
                            DriverListCombo.this.mComboList.setText(driverName);
                            DriverListCombo.this.mComboList.select(i);
                            String driverType = temp.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType");
                            if (driverType != null && (template = TemplateDescriptor.getDriverTemplateDescriptor((String)driverType)) != null) {
                                DriverValidator validator = new DriverValidator(template, temp);
                                DriverListCombo.this.mErrorMessage = null;
                                if (!validator.isValid()) {
                                    DriverListCombo.this.mErrorMessage = validator.getMessage();
                                }
                            }
                            break;
                        }
                        ++i;
                    }
                }
            } else {
                DriverListCombo.this.mComboList.setText(copy.getName());
            }
            if ((keyIndex = DriverListCombo.this.mComboList.getSelectionIndex()) == -1 && DriverListCombo.this.mTBButtonEdit != null) {
                DriverListCombo.this.mTBButtonEdit.setEnabled(false);
            } else if (keyIndex > -1 && DriverListCombo.this.mTBButtonEdit != null) {
                DriverListCombo.this.mTBButtonEdit.setEnabled(true);
            }
            if (fireEvent) {
                DriverListCombo.this.fireChangedEvent(this.parent);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    public class NewButtonSelectionChangedListener
    implements SelectionListener {
        private DriverListCombo parent;

        public NewButtonSelectionChangedListener(DriverListCombo combo) {
            this.parent = combo;
        }

        public void widgetSelected(SelectionEvent e) {
            int keyIndex;
            Shell newShell = this.parent.getCombo().getShell();
            DriverDialog dlg = DriverListCombo.this.mCategoryId != null ? new DriverDialog(newShell, DriverListCombo.this.mCategoryId) : new DriverDialog(newShell);
            int rtn = dlg.open();
            if (rtn != 0) {
                return;
            }
            String tempStore = DriverListCombo.this.mComboList.getText();
            if (dlg.getPropertySet() != null) {
                DriverManager.getInstance().addDriverInstance(dlg.getPropertySet());
            }
            DriverListCombo.this.refreshCombo();
            boolean fireEvent = false;
            if (dlg.getSelectedDefinition() != null) {
                fireEvent = true;
                String driverName = dlg.getSelectedDefinition().getName();
                String[] itemList = DriverListCombo.this.mComboList.getItems();
                if (itemList.length > 0) {
                    int i = 0;
                    while (i < itemList.length) {
                        String item = itemList[i];
                        IPropertySet temp = (IPropertySet)DriverListCombo.this.mComboList.getData(item);
                        if (temp.getID().equals(dlg.getSelectedDefinition().getID())) {
                            TemplateDescriptor template;
                            DriverListCombo.this.mComboList.setText(driverName);
                            DriverListCombo.this.mComboList.select(i);
                            String driverType = temp.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType");
                            if (driverType != null && (template = TemplateDescriptor.getDriverTemplateDescriptor((String)driverType)) != null) {
                                DriverValidator validator = new DriverValidator(template, temp);
                                DriverListCombo.this.mErrorMessage = null;
                                if (!validator.isValid()) {
                                    DriverListCombo.this.mErrorMessage = validator.getMessage();
                                }
                            }
                            break;
                        }
                        ++i;
                    }
                }
            } else {
                DriverListCombo.this.mComboList.setText(tempStore);
            }
            if ((keyIndex = DriverListCombo.this.mComboList.getSelectionIndex()) == -1 && DriverListCombo.this.mTBButtonEdit != null) {
                DriverListCombo.this.mTBButtonEdit.setEnabled(false);
            } else if (keyIndex > -1 && DriverListCombo.this.mTBButtonEdit != null) {
                DriverListCombo.this.mTBButtonEdit.setEnabled(true);
            }
            if (fireEvent) {
                DriverListCombo.this.fireChangedEvent(this.parent);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    public class NewGenericSelectionChangedListener
    implements SelectionListener {
        private DriverListCombo parent;

        public NewGenericSelectionChangedListener(DriverListCombo combo) {
            this.parent = combo;
        }

        public void widgetSelected(SelectionEvent e) {
            int keyIndex;
            Shell newShell = this.parent.getCombo().getShell();
            DriverDialog dlg = DriverListCombo.this.mCategoryId != null ? new DriverDialog(newShell, DriverListCombo.this.mCategoryId) : new DriverDialog(newShell);
            dlg.setHideDriverList(true);
            dlg.setInitialTemplate("org.eclipse.datatools.connectivity.db.generic.genericDriverTemplate");
            int rtn = dlg.open();
            if (rtn != 0) {
                return;
            }
            String tempStore = DriverListCombo.this.mComboList.getText();
            if (dlg.getPropertySet() != null) {
                DriverManager.getInstance().addDriverInstance(dlg.getPropertySet());
            }
            DriverListCombo.this.refreshCombo();
            boolean fireEvent = false;
            if (dlg.getSelectedDefinition() != null) {
                fireEvent = true;
                String driverName = dlg.getSelectedDefinition().getName();
                String[] itemList = DriverListCombo.this.mComboList.getItems();
                if (itemList.length > 0) {
                    int i = 0;
                    while (i < itemList.length) {
                        String item = itemList[i];
                        IPropertySet temp = (IPropertySet)DriverListCombo.this.mComboList.getData(item);
                        if (temp.getID().equals(dlg.getSelectedDefinition().getID())) {
                            TemplateDescriptor template;
                            DriverListCombo.this.mComboList.setText(driverName);
                            DriverListCombo.this.mComboList.select(i);
                            String driverType = temp.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType");
                            if (driverType != null && (template = TemplateDescriptor.getDriverTemplateDescriptor((String)driverType)) != null) {
                                DriverValidator validator = new DriverValidator(template, temp);
                                DriverListCombo.this.mErrorMessage = null;
                                if (!validator.isValid()) {
                                    DriverListCombo.this.mErrorMessage = validator.getMessage();
                                }
                            }
                            break;
                        }
                        ++i;
                    }
                }
            } else {
                DriverListCombo.this.mComboList.setText(tempStore);
            }
            if ((keyIndex = DriverListCombo.this.mComboList.getSelectionIndex()) == -1 && DriverListCombo.this.mTBButtonEdit != null) {
                DriverListCombo.this.mTBButtonEdit.setEnabled(false);
            } else if (keyIndex > -1 && DriverListCombo.this.mTBButtonEdit != null) {
                DriverListCombo.this.mTBButtonEdit.setEnabled(true);
            }
            if (fireEvent) {
                DriverListCombo.this.fireChangedEvent(this.parent);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private class PropertySetComparator
    implements Comparator {
        private PropertySetComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            IPropertySet ps1 = (IPropertySet)arg0;
            IPropertySet ps2 = (IPropertySet)arg1;
            return ps1.getName().compareToIgnoreCase(ps2.getName());
        }
    }

    private class TemplateDescriptorComparator
    implements Comparator {
        private TemplateDescriptorComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            TemplateDescriptor td1 = (TemplateDescriptor)arg0;
            TemplateDescriptor td2 = (TemplateDescriptor)arg1;
            return td1.getName().compareToIgnoreCase(td2.getName());
        }
    }
}

