/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.ui.wizards;

import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.TextProcessorWrapper;
import org.eclipse.datatools.enablement.oda.ws.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSUIUtil;
import org.eclipse.datatools.enablement.oda.ws.util.PropertyValueUtil;
import org.eclipse.datatools.enablement.oda.ws.util.WSUtil;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class WebServiceSelectionPageHelper {
    private WizardPage wizardPage;
    private PreferencePage propertyPage;
    private transient Text wsdlURI;
    private transient Text soapEndPoint;
    private transient Text customClass;
    private transient Text driverClassPath;
    static final String DEFAULT_MESSAGE;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.enablement.oda.ws.ui.wizards.WebServiceSelectionPageHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        DEFAULT_MESSAGE = Messages.getString("webServiceSelectionPage.message.default");
    }

    WebServiceSelectionPageHelper(WizardPage page) {
        this.wizardPage = page;
    }

    WebServiceSelectionPageHelper(PreferencePage page) {
        this.propertyPage = page;
    }

    void createCustomControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.setupWSDLGroup(composite);
        this.setupEndPointGroup(composite);
        this.setupCustomClassGroup(composite);
        this.setupClassPathGroup(composite);
        WSUIUtil.setSystemHelp(this.getControl(), "org.eclipse.datatools.oda.cshelp.Wizard_WS_DATASOURCE_ID");
    }

    private void setupWSDLGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setLayout((Layout)new GridLayout(3, false));
        GridData layoutData = new GridData(768);
        group.setLayoutData((Object)layoutData);
        group.setText(Messages.getString("webServiceSelectionPage.group.wsdl"));
        Label label = new Label((Composite)group, 64);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 3;
        label.setLayoutData((Object)layoutData);
        label.setText(Messages.getString("webServiceSelectionPage.label.wsdl"));
        label = new Label((Composite)group, 0);
        layoutData = new GridData();
        label.setLayoutData((Object)layoutData);
        label.setText(Messages.getString("webServiceSelectionPage.label.wsdlURI"));
        this.wsdlURI = new Text((Composite)group, 2048);
        layoutData = new GridData(768);
        this.wsdlURI.setLayoutData((Object)layoutData);
        this.wsdlURI.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebServiceSelectionPageHelper.this.verifyPage();
            }
        });
        Button button = new Button((Composite)group, 0);
        layoutData = new GridData();
        button.setLayoutData((Object)layoutData);
        button.setText(Messages.getString("webServiceSelectionPage.button.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedLocation;
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.wsdl", "*.*"});
                if (WebServiceSelectionPageHelper.this.wsdlURI.getText() != null && WebServiceSelectionPageHelper.this.wsdlURI.getText().trim().length() > 0) {
                    dialog.setFilterPath(WebServiceSelectionPageHelper.this.getWsdlURIString());
                }
                if ((selectedLocation = dialog.open()) != null) {
                    WebServiceSelectionPageHelper.this.setWsdlURIString(selectedLocation);
                }
            }
        });
    }

    private void setupEndPointGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setLayout((Layout)new GridLayout(1, false));
        GridData layoutData = new GridData(768);
        group.setLayoutData((Object)layoutData);
        group.setText(Messages.getString("webServiceSelectionPage.group.endPoint"));
        Label label = new Label((Composite)group, 64);
        layoutData = new GridData(768);
        label.setLayoutData((Object)layoutData);
        label.setText(Messages.getString("webServiceSelectionPage.label.endPoint"));
        this.soapEndPoint = new Text((Composite)group, 2048);
        layoutData = new GridData(768);
        this.soapEndPoint.setLayoutData((Object)layoutData);
        this.soapEndPoint.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebServiceSelectionPageHelper.this.verifyPage();
            }
        });
    }

    private void setupCustomClassGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setLayout((Layout)new GridLayout(1, false));
        GridData layoutData = new GridData(768);
        group.setLayoutData((Object)layoutData);
        group.setText(Messages.getString("webServiceSelectionPage.group.customClass"));
        Label label = new Label((Composite)group, 64);
        layoutData = new GridData(768);
        label.setLayoutData((Object)layoutData);
        label.setText(Messages.getString("webServiceSelectionPage.label.customClass"));
        this.customClass = new Text((Composite)group, 2048);
        layoutData = new GridData(768);
        this.customClass.setLayoutData((Object)layoutData);
    }

    private void setupClassPathGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setLayout((Layout)new GridLayout(1, false));
        GridData layoutData = new GridData(768);
        group.setLayoutData((Object)layoutData);
        group.setText(Messages.getString("webServiceSelectionPage.group.classPath"));
        Label label = new Label((Composite)group, 64);
        layoutData = new GridData(768);
        label.setLayoutData((Object)layoutData);
        label.setText(Messages.getString("webServiceSelectionPage.label.classPath"));
        this.driverClassPath = new Text((Composite)group, 2048);
        layoutData = new GridData(768);
        this.driverClassPath.setLayoutData((Object)layoutData);
    }

    Properties collectCustomProperties(Properties props) {
        String value;
        if (props == null) {
            props = new Properties();
        }
        if ((value = this.getSoapEndPointString()) != null) {
            props.setProperty("soapEndPoint", value);
        } else {
            props.remove("soapEndPoint");
        }
        value = this.getCustomClassString();
        if (value != null) {
            props.setProperty("connectionClass", value);
        } else {
            props.remove("connectionClass");
        }
        value = this.getWsdlURIString();
        if (value != null) {
            props.setProperty("wsdlURI", value);
        } else {
            props.remove("wsdlURI");
        }
        value = this.getDriverClassPathString();
        if (value != null) {
            props.setProperty("driverClassPath", value);
        } else {
            props.remove("driverClassPath");
        }
        return props;
    }

    void initCustomControl(Properties profileProps) {
        if (profileProps == null || profileProps.isEmpty()) {
            this.setPageComplete(false);
            this.setMessage(DEFAULT_MESSAGE, 0);
            return;
        }
        this.setWsdlURIString(profileProps.getProperty("wsdlURI"));
        this.setSoapEndPointString(profileProps.getProperty("soapEndPoint"));
        this.setCustomClassString(profileProps.getProperty("connectionClass"));
        this.setDriverClassPathString(profileProps.getProperty("driverClassPath"));
    }

    private void verifyPage() {
        if (WSUtil.isNull((Object)this.soapEndPoint.getText()) && WSUtil.isNull((Object)this.wsdlURI.getText())) {
            this.setPageComplete(false);
            this.setMessage(Messages.getString("webServiceSelectionPage.message.error"), 3);
        } else {
            this.setPageComplete(true);
            this.setMessage(DEFAULT_MESSAGE, 0);
        }
    }

    private void setPageComplete(boolean complete) {
        if (this.wizardPage != null) {
            this.wizardPage.setPageComplete(complete);
        } else if (this.propertyPage != null) {
            this.propertyPage.setValid(complete);
        }
    }

    private void setMessage(String newMessage, int newType) {
        if (this.wizardPage != null) {
            this.wizardPage.setMessage(newMessage, newType);
        } else if (this.propertyPage != null) {
            this.propertyPage.setMessage(newMessage, newType);
        }
    }

    void setWsdlURIString(String text) {
        if (text != null) {
            this.wsdlURI.setText(TextProcessorWrapper.process((String)text));
        }
    }

    private String getDriverClassPathString() {
        return TextProcessorWrapper.deprocess((String)PropertyValueUtil.getQualifiedValueForDataSource((String)this.driverClassPath.getText(), (String)"driverClassPath"));
    }

    private void setDriverClassPathString(String text) {
        if (text != null) {
            this.driverClassPath.setText(TextProcessorWrapper.process((String)text));
        }
    }

    private String getSoapEndPointString() {
        return TextProcessorWrapper.deprocess((String)PropertyValueUtil.getQualifiedValueForDataSource((String)this.soapEndPoint.getText(), (String)"soapEndPoint"));
    }

    private String getCustomClassString() {
        return TextProcessorWrapper.deprocess((String)PropertyValueUtil.getQualifiedValueForDataSource((String)this.customClass.getText(), (String)"connectionClass"));
    }

    private void setSoapEndPointString(String text) {
        if (text != null) {
            this.soapEndPoint.setText(TextProcessorWrapper.process((String)text));
        }
    }

    private String getWsdlURIString() {
        return TextProcessorWrapper.deprocess((String)PropertyValueUtil.getQualifiedValueForDataSource((String)this.wsdlURI.getText(), (String)"wsdlURI"));
    }

    private void setCustomClassString(String text) {
        if (text != null) {
            this.customClass.setText(TextProcessorWrapper.process((String)text));
        }
    }

    private Control getControl() {
        if (this.wizardPage != null) {
            return this.wizardPage.getControl();
        }
        if (!$assertionsDisabled && this.propertyPage == null) {
            throw new AssertionError();
        }
        return this.propertyPage.getControl();
    }
}

