/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.parsers.sql.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lpg.lpgjavaruntime.IToken;
import lpg.lpgjavaruntime.LexStream;
import lpg.lpgjavaruntime.ParseTable;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.util.SQLComment;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceFormat;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceInfo;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParser;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserInternalException;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserLogger;

public abstract class AbstractSQLQueryParser
extends SQLParser {
    private boolean debug;

    public AbstractSQLQueryParser(LexStream lexStream, ParseTable prs, int EOFTsymbol, boolean checkStmtOnly) throws SQLParserInternalException {
        super(lexStream, prs, EOFTsymbol, checkStmtOnly);
    }

    public AbstractSQLQueryParser(LexStream lexStream, ParseTable prs, int EOFTsymbol, SQLQuerySourceFormat sourceFormat) throws SQLParserInternalException {
        super(lexStream, prs, EOFTsymbol, sourceFormat);
    }

    public AbstractSQLQueryParser(LexStream lexStream, ParseTable prs, int EOFTsymbol, SQLQuerySourceFormat p_sourceFormat, boolean checkStmtOnly) throws SQLParserInternalException {
        super(lexStream, prs, EOFTsymbol, p_sourceFormat, checkStmtOnly);
    }

    protected void addCommentsToAST(List commentTokens) {
        Map stmtToSortedASTNodesMap = this.getSortedASTNodesForStmtMap();
        List comments = this.createCommentObjectsSorted(commentTokens);
        List stmts = this.getStmtsInASTOrdered();
        Iterator stmtIt = stmts.iterator();
        while (stmtIt.hasNext()) {
            QueryStatement stmt = (QueryStatement)stmtIt.next();
            SortedSet astNodes = (SortedSet)stmtToSortedASTNodesMap.get(stmt);
            this.addCommentsToStatement(stmt, astNodes, comments);
            if (stmtIt.hasNext()) continue;
            Iterator commentIt = comments.iterator();
            while (commentIt.hasNext()) {
                SQLComment comment = (SQLComment)commentIt.next();
                comment.setRelativePosition(2);
            }
            if (stmt.getSourceInfo().getComments() == null) {
                stmt.getSourceInfo().setComments(new ArrayList());
            }
            stmt.getSourceInfo().getComments().addAll(comments);
            comments.clear();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void addCommentsToStatement(QueryStatement stmt, SortedSet astNodes, List allStmtsComments) {
        astArray = astNodes.toArray();
        this.logASTNodes(astArray);
        lastAST = null;
        currentStmtStart = stmt.getSourceInfo().getSpanStartOffset();
        currentStmtEnd = stmt.getSourceInfo().getSpanEndOffset();
        currentStmtLastLine = stmt.getSourceInfo().getLineNumberEnd();
        astIndex = 0;
        lastLineEndCommentIndent = 0;
        commentIt = allStmtsComments.iterator();
        while (commentIt.hasNext()) {
            comment = (SQLComment)commentIt.next();
            commentStartIndex = comment.getSourceInfo().getSpanStartOffset();
            commentStartLine = comment.getSourceInfo().getLineNumberStart();
            if (commentStartLine <= currentStmtLastLine) ** GOTO lbl57
            break;
lbl-1000:
            // 1 sources

            {
                astNode = (SQLObject)astArray[astIndex];
                if (astNode instanceof SQLQueryObject) {
                    sqo = (SQLQueryObject)astNode;
                    si = sqo.getSourceInfo();
                    astEnd = si.getSpanEndOffset();
                    astStart = si.getSpanStartOffset();
                    if (astEnd > commentStartIndex || astIndex == astArray.length - 1) {
                        sqoToAppendComment /* !! */  = null;
                        if (astStart < commentStartIndex && (lastAST != null && astStart > lastAST.getSourceInfo().getSpanEndOffset() || lastAST == null)) {
                            sqoToAppendComment /* !! */  = sqo;
                        } else if (lastAST != null && commentStartIndex < currentStmtEnd) {
                            sqoToAppendComment /* !! */  = lastAST;
                        } else if (astStart < commentStartIndex) {
                            sqoToAppendComment /* !! */  = sqo;
                        } else if (lastAST == null && commentStartIndex < currentStmtEnd) {
                            sqoToAppendComment /* !! */  = commentStartIndex > currentStmtStart ? sqo : stmt;
                        } else if (astIndex == astArray.length - 1) {
                            sqoToAppendComment /* !! */  = sqo;
                        }
                        if (sqoToAppendComment /* !! */  != null) {
                            if (sqoToAppendComment /* !! */ .getSourceInfo().getComments() == null) {
                                sqoToAppendComment /* !! */ .getSourceInfo().setComments(new ArrayList<E>());
                            }
                            sqoToAppendComment /* !! */ .getSourceInfo().getComments().add(comment);
                            if (sqoToAppendComment /* !! */ .getSourceInfo().getLineNumberEnd() < comment.getSourceInfo().getLineNumberStart()) {
                                if (lastLineEndCommentIndent <= 0 || comment.getSourceInfo().getColumnNumberStart() != lastLineEndCommentIndent) {
                                    comment.setRelativePosition(2);
                                }
                            } else if (sqoToAppendComment /* !! */ .getSourceInfo().getLineNumberStart() > comment.getSourceInfo().getLineNumberEnd()) {
                                comment.setRelativePosition(1);
                            }
                            commentIt.remove();
                            if (astIndex <= 0) break;
                            --astIndex;
                            break;
                        }
                        lastAST = sqo;
                        break;
                    }
                    lastAST = sqo;
                }
                ++astIndex;
lbl57:
                // 2 sources

                ** while (astIndex < astArray.length)
            }
lbl58:
            // 4 sources

            lastLineEndCommentIndent = 0;
            if (comment.getRelativePosition() != 0) continue;
            lastLineEndCommentIndent = comment.getSourceInfo().getColumnNumberStart();
        }
        if (stmt.getSourceInfo().getComments() != null && !stmt.getSourceInfo().getComments().isEmpty() && (firstComment = (SQLComment)stmt.getSourceInfo().getComments().get(0)).getSourceInfo().getSpanStartOffset() < stmt.getSourceInfo().getSpanStartOffset()) {
            stmtSI = stmt.getSourceInfo();
            cmntSI = firstComment.getSourceInfo();
            beg = cmntSI.getSpanStartOffset();
            end = stmtSI.getSpanEndOffset();
            source = this.getSpan(beg, end);
            lineBeg = cmntSI.getLineNumberStart();
            colBeg = cmntSI.getColumnNumberStart();
            stmtSI.setSpanStartOffset(beg);
            stmtSI.setColumnNumberStart(colBeg);
            stmtSI.setLineNumberStart(lineBeg);
            stmtSI.setSourceSnippet(source);
        }
    }

    private void logASTNodes(Object[] astArray) {
        int astIndex = 0;
        while (astIndex < astArray.length) {
            SQLObject astNode = (SQLObject)astArray[astIndex];
            if (astNode instanceof SQLQueryObject) {
                SQLQueryObject sqo = (SQLQueryObject)astNode;
                this.logASTNode(astIndex, sqo);
            }
            ++astIndex;
        }
    }

    public abstract void ruleAction(int var1);

    private void logASTNode(int astIndex, SQLQueryObject sqo) {
        if (this.debug) {
            SQLQuerySourceInfo si = sqo.getSourceInfo();
            int astEnd = si.getSpanEndOffset();
            int astLine = si.getLineNumberStart();
            int astStart = si.getSpanStartOffset();
            SQLParserLogger.getLogger().writeInfo(String.valueOf(astIndex) + " " + "end: " + astEnd + "\t" + "line: " + astLine + "\t" + "start: " + astStart + "\t" + si.getSourceSnippet().replace('\n', '/'));
        }
    }

    private List getStmtsInASTOrdered() {
        ArrayList<SQLObject> stmtList = new ArrayList<SQLObject>();
        Iterator astIt = this.getASTElementList().iterator();
        while (astIt.hasNext()) {
            SQLObject astNode = (SQLObject)astIt.next();
            if (!(astNode instanceof QueryStatement)) continue;
            stmtList.add(astNode);
        }
        return stmtList;
    }

    private Map getSortedASTNodesForStmtMap() {
        HashMap stmtToASTNodesMap = new HashMap();
        Comparator astSpanComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                int compare = 0;
                if (o1 instanceof SQLQueryObject && o2 instanceof SQLQueryObject) {
                    int lineO2;
                    int lineO1;
                    int endO2;
                    SQLQueryObject sqo1 = (SQLQueryObject)o1;
                    SQLQueryObject sqo2 = (SQLQueryObject)o2;
                    int endO1 = sqo1.getSourceInfo().getSpanEndOffset();
                    compare = endO1 - (endO2 = sqo2.getSourceInfo().getSpanEndOffset());
                    if (compare == 0 && (compare = (lineO1 = sqo1.getSourceInfo().getLineNumberStart()) - (lineO2 = sqo2.getSourceInfo().getLineNumberStart())) == 0) {
                        int startO1 = sqo1.getSourceInfo().getSpanStartOffset();
                        int startO2 = sqo2.getSourceInfo().getSpanStartOffset();
                        compare = startO2 - startO1;
                    }
                }
                return compare;
            }
        };
        TreeSet<SQLObject> astSpanSet = new TreeSet<SQLObject>(astSpanComparator);
        Iterator astIt = this.getASTElementList().iterator();
        while (astIt.hasNext()) {
            SQLObject astNode = (SQLObject)astIt.next();
            if (astNode instanceof QueryStatement) {
                stmtToASTNodesMap.put(astNode, astSpanSet);
                astSpanSet = new TreeSet(astSpanComparator);
                continue;
            }
            astSpanSet.add(astNode);
        }
        return stmtToASTNodesMap;
    }

    List createCommentObjectsSorted(List commentTokens) {
        ArrayList<SQLComment> resultCommentList = new ArrayList<SQLComment>();
        boolean toBeSorted = false;
        int lastCommentStartIndex = 0;
        if (commentTokens != null) {
            Iterator iter = commentTokens.iterator();
            while (iter.hasNext()) {
                IToken cmntTok = (IToken)iter.next();
                cmntTok.getKind();
                SQLComment commentObj = this.createCommentObject(cmntTok);
                resultCommentList.add(commentObj);
                toBeSorted |= cmntTok.getStartOffset() < lastCommentStartIndex;
                lastCommentStartIndex = cmntTok.getStartOffset();
            }
        }
        if (toBeSorted) {
            Comparator commentComparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    SQLComment c1 = (SQLComment)o1;
                    SQLComment c2 = (SQLComment)o2;
                    int c1start = c1.getSourceInfo().getSpanStartOffset();
                    int c2start = c2.getSourceInfo().getSpanStartOffset();
                    return c1start - c2start;
                }
            };
            Collections.sort(resultCommentList, commentComparator);
        }
        return resultCommentList;
    }

    private SQLComment createCommentObject(IToken cmntTok) {
        SQLComment comment = new SQLComment();
        SQLQuerySourceInfo sourceInfo = new SQLQuerySourceInfo();
        int startOffset = cmntTok.getStartOffset();
        int endOffset = cmntTok.getEndOffset();
        int startColumn = this.getLexStream().getColumnOfCharAt(startOffset);
        int endColumn = this.getLexStream().getColumnOfCharAt(endOffset);
        int startLine = this.getLexStream().getLineNumberOfCharAt(startOffset);
        int endLine = this.getLexStream().getLineNumberOfCharAt(endOffset);
        sourceInfo.setSpanStartOffset(startOffset);
        sourceInfo.setSpanEndOffset(endOffset);
        sourceInfo.setColumnNumberStart(startColumn);
        sourceInfo.setColumnNumberEnd(endColumn);
        sourceInfo.setLineNumberStart(startLine);
        sourceInfo.setLineNumberEnd(endLine);
        sourceInfo.setSourceSnippet(cmntTok.getValue(this.getInputChars()));
        comment.setSourceInfo(sourceInfo);
        comment.setText(sourceInfo.getSourceSnippet());
        int tokenKind = cmntTok.getKind();
        if (tokenKind == 783) {
            comment.setMultiLineComment(true);
        }
        return comment;
    }

    protected void setSym1(Object p_obj) {
        this.btParser.setSym1(p_obj);
        if (p_obj != null) {
            if (this.lastASTElement != p_obj && p_obj instanceof SQLObject) {
                this.astElementList.add(p_obj);
                this.lastASTElement = p_obj;
            }
            if (p_obj instanceof SQLQueryObject) {
                SQLQueryObject sqo = (SQLQueryObject)p_obj;
                sqo.setSourceInfo(new SQLQuerySourceInfo(sqo));
                this.setSpan(sqo);
                if (this.sourceFormat != null) {
                    sqo.getSourceInfo().setSqlFormat(this.sourceFormat);
                }
            }
        }
    }

    protected void setSym1_keepSpan(Object p_obj) {
        this.btParser.setSym1(p_obj);
        if (p_obj != null && this.lastASTElement != p_obj && p_obj instanceof SQLObject) {
            this.astElementList.add(p_obj);
            this.lastASTElement = p_obj;
        }
    }

    protected void extendSpan(SQLQueryObject sqo, int toSym) {
        int tokenIndex = this.btParser.getLastToken(toSym);
        int startOffset = sqo.getSourceInfo().getSpanStartOffset();
        int endOffset = this.getSpanEndOffset(toSym);
        String extendedSpan = this.getSpan(startOffset, endOffset);
        sqo.getSourceInfo().setSourceSnippet(extendedSpan);
        sqo.getSourceInfo().setSpanEndOffset(endOffset);
        sqo.getSourceInfo().setColumnNumberEnd(this.getEndColumn(tokenIndex));
        sqo.getSourceInfo().setLineNumberEnd(this.getEndLine(tokenIndex));
    }

    protected void extendSpanToFollowingToken(SQLQueryObject sqo, int tokenKind) {
        IToken followingToken = this.getFollowingToken();
        if (followingToken.getKind() == tokenKind) {
            int tokenIndex = this.btParser.getLastToken() + 1;
            int startOffset = sqo.getSourceInfo().getSpanStartOffset();
            int endOffset = followingToken.getStartOffset() - 1;
            String extendedSpan = this.getSpan(startOffset, endOffset);
            sqo.getSourceInfo().setSourceSnippet(extendedSpan);
            sqo.getSourceInfo().setSpanEndOffset(endOffset);
            sqo.getSourceInfo().setColumnNumberEnd(this.getEndColumn(tokenIndex));
            sqo.getSourceInfo().setLineNumberEnd(this.getEndLine(tokenIndex));
        }
    }
}

