/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.launching;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.core.ConnectionException;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.core.services.SQLEditorService;
import org.eclipse.datatools.sqltools.debugger.core.AutoAttachUtil;
import org.eclipse.datatools.sqltools.debugger.core.IDebugHandler;
import org.eclipse.datatools.sqltools.debugger.core.SQLDebuggerConfiguration;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerCorePlugin;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerMessages;
import org.eclipse.datatools.sqltools.debugger.debug.ISourceLocatorProvider;
import org.eclipse.datatools.sqltools.debugger.model.SPDebugTarget;
import org.eclipse.datatools.sqltools.debugger.model.SPThread;
import org.eclipse.datatools.sqltools.debugger.sourcelookup.SPSourceLocator;
import org.eclipse.datatools.sqltools.editor.core.connection.IConnectionTracker;
import org.eclipse.datatools.sqltools.launching.IExtendedLaunchSupport;
import org.eclipse.datatools.sqltools.routineeditor.launching.LaunchHelper;
import org.eclipse.datatools.sqltools.routineeditor.result.CallableSQLResultRunnable;
import org.eclipse.datatools.sqltools.sqleditor.result.SimpleSQLResultRunnable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.osgi.util.NLS;

public class SPDebuggerLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    private HashMap fSourceLocators;

    private SPThread createThread(DatabaseIdentifier databaseIdentifier, SPDebugTarget target, String id, Connection debuggeeCon) throws CoreException, DebugException, SQLException, NoSuchProfileException, ConnectionException {
        DatabaseVendorDefinitionId vendorId = ProfileUtil.getDatabaseVendorDefinitionId((String)databaseIdentifier.getProfileName());
        SQLDevToolsConfiguration factory = SQLToolsFacade.getConfigurationByProfileName((String)databaseIdentifier.getProfileName());
        if (factory == null || !(factory instanceof SQLDebuggerConfiguration)) {
            throw new CoreException((IStatus)new Status(4, DebuggerCorePlugin.PLUGIN_ID, 0, String.valueOf(DebuggerMessages.SPLaunchConfigurationDelegate_UnsupportedServerType) + vendorId, null));
        }
        String errorMessage = String.valueOf(DebuggerMessages.SPLaunchConfigurationDelegate_UnsupportedServerType) + vendorId;
        SPThread th = null;
        try {
            th = ((SQLDebuggerConfiguration)factory).getSPThread(target, databaseIdentifier, id, debuggeeCon);
        }
        catch (Exception e) {
            th = null;
            String string = errorMessage = e.getMessage() == null || e.getMessage().length() < 1 ? errorMessage : e.getMessage();
        }
        if (th == null) {
            throw new CoreException((IStatus)new Status(4, DebuggerCorePlugin.PLUGIN_ID, 0, errorMessage, null));
        }
        return th;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch_debug(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask(DebuggerMessages.SPLaunchConfigurationDelegate_Launching, 3);
        }
        try {
            ProcIdentifier proc;
            SPThread thread;
            String[] id = new String[1];
            DatabaseIdentifier databaseIdentifier = LaunchHelper.readDatabaseIdentifier((ILaunchConfiguration)configuration);
            IControlConnection controlCon = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(databaseIdentifier);
            IDebugHandler debugHandler = DebuggerCorePlugin.getDefault().getDebugHandlerManager().getOrCreateDebugHandler(databaseIdentifier.getProfileName());
            String readyToDebug = debugHandler.readyToDebug();
            if (readyToDebug != null) {
                throw new CoreException((IStatus)new Status(1, DebuggerCorePlugin.PLUGIN_ID, 0, readyToDebug, null));
            }
            SPDebugTarget target = new SPDebugTarget(launch, null, databaseIdentifier.toString());
            Object postrun = null;
            String externalId = LaunchHelper.readExternalClientId((ILaunchConfiguration)configuration);
            if (externalId != null && !externalId.equals("")) {
                if (monitor != null) {
                    monitor.subTask(DebuggerMessages.SPLaunchConfigurationDelegate_CreatingDebugger);
                }
                IDebugHandler iDebugHandler = debugHandler;
                synchronized (iDebugHandler) {
                    if (debugHandler.getNumOfDebugProcess() == 3) {
                        throw new CoreException((IStatus)new Status(1, DebuggerCorePlugin.PLUGIN_ID, 0, DebuggerMessages.SPDebuggerLaunchConfigurationDelegate_debug_process_number_limitation, null));
                    }
                    thread = this.createThread(databaseIdentifier, target, externalId, null);
                }
            }
            if (monitor != null) {
                monitor.subTask(DebuggerMessages.SPLaunchConfigurationDelegate_CreatingClientConn);
            }
            Connection debuggeeCon = AutoAttachUtil.createConnection(controlCon, false, id);
            IExtendedLaunchSupport extendedLaunchSupport = null;
            SQLDevToolsConfiguration config = SQLToolsFacade.getConfiguration(null, (DatabaseIdentifier)databaseIdentifier);
            SQLEditorService s = config.getSQLEditorService();
            if (s != null) {
                extendedLaunchSupport = s.getExtendedLaunchSupport();
            }
            if (extendedLaunchSupport != null) {
                extendedLaunchSupport.preLaunch(configuration, debuggeeCon, mode);
            }
            monitor.worked(1);
            if (monitor != null) {
                monitor.subTask(DebuggerMessages.SPLaunchConfigurationDelegate_AttachingConn);
            }
            IDebugHandler iDebugHandler = debugHandler;
            synchronized (iDebugHandler) {
                if (debugHandler.getNumOfDebugProcess() == 3) {
                    throw new CoreException((IStatus)new Status(1, DebuggerCorePlugin.PLUGIN_ID, 0, DebuggerMessages.SPDebuggerLaunchConfigurationDelegate_debug_process_number_limitation, null));
                }
                thread = this.createThread(databaseIdentifier, target, id[0], debuggeeCon);
            }
            if (!LaunchHelper.isAdHocSQL((ILaunchConfiguration)configuration) && (proc = LaunchHelper.readProcIdentifier((ILaunchConfiguration)configuration)) != null && proc.getType() == 2) {
                AutoAttachUtil.enableAutoAttach(controlCon);
            }
            if ((proc = LaunchHelper.readProcIdentifier((ILaunchConfiguration)configuration)) == null) {
                postrun = new SimpleSQLResultRunnable(debuggeeCon, LaunchHelper.constructDirectInvocationSQLString((ILaunchConfiguration)configuration), true, (IConnectionTracker)thread, null, databaseIdentifier, configuration);
            } else {
                switch (proc.getType()) {
                    case 0: {
                        postrun = config.getExecutionService().createCallableSQLResultRunnable(debuggeeCon, configuration, true, (IConnectionTracker)thread, databaseIdentifier);
                        if (postrun != null) break;
                        postrun = new CallableSQLResultRunnable(debuggeeCon, configuration, true, (IConnectionTracker)thread, databaseIdentifier);
                        break;
                    }
                    case 2: {
                        postrun = new SimpleSQLResultRunnable(debuggeeCon, LaunchHelper.constructDirectInvocationSQLString((ILaunchConfiguration)configuration), true, (IConnectionTracker)thread, null, databaseIdentifier, configuration);
                        break;
                    }
                    default: {
                        postrun = config.getExecutionService().createSimpleSQLResultRunnable(debuggeeCon, LaunchHelper.constructDirectInvocationSQLString((ILaunchConfiguration)configuration), true, (IConnectionTracker)thread, null, databaseIdentifier, configuration, null);
                        if (postrun != null) break;
                        postrun = new SimpleSQLResultRunnable(debuggeeCon, LaunchHelper.constructDirectInvocationSQLString((ILaunchConfiguration)configuration), true, (IConnectionTracker)thread, null, databaseIdentifier, configuration);
                    }
                }
            }
            launch.setSourceLocator((ISourceLocator)this.getSourceLocator(configuration));
            target.setSPThread(thread);
            monitor.worked(1);
            launch.addDebugTarget((IDebugTarget)target);
            if (postrun != null) {
                new Thread((Runnable)postrun).start();
            }
            IDebugHandler handler = DebuggerCorePlugin.getDefault().getDebugHandlerManager().getOrCreateDebugHandler(controlCon.getDatabaseIdentifier().getProfileName());
            handler.refreshExternalClients();
            if (monitor != null) {
                monitor.done();
            }
        }
        catch (CoreException ex) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            if (ex.getStatus().getSeverity() == 1) {
                throw new CoreException((IStatus)new Status(4, DebuggerCorePlugin.PLUGIN_ID, 0, ex.getLocalizedMessage(), null));
            }
            DebuggerCorePlugin.getDefault().log(DebuggerMessages.SPLaunchConfigurationDelegate_Launching, ex);
            throw new CoreException((IStatus)new Status(4, DebuggerCorePlugin.PLUGIN_ID, 0, ex.getLocalizedMessage(), (Throwable)ex));
        }
        catch (Exception ex) {
            DebuggerCorePlugin.getDefault().log(DebuggerMessages.SPLaunchConfigurationDelegate_Launching, ex);
            throw new CoreException((IStatus)new Status(4, DebuggerCorePlugin.PLUGIN_ID, 0, ex.getLocalizedMessage(), (Throwable)ex));
        }
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if ("debug".equals(mode)) {
            this.launch_debug(configuration, mode, launch, monitor);
        }
    }

    public IPersistableSourceLocator getSourceLocator(ILaunchConfiguration configuration) throws CoreException {
        this.initializeSourceLocators();
        SPSourceLocator sourceLocator = null;
        Iterator it = this.fSourceLocators.values().iterator();
        while (it.hasNext()) {
            ISourceLocatorProvider provider = (ISourceLocatorProvider)it.next();
            sourceLocator = provider.getSourceLocator(configuration);
            if (sourceLocator == null) continue;
            return sourceLocator;
        }
        if (sourceLocator == null) {
            sourceLocator = new SPSourceLocator();
        }
        return sourceLocator;
    }

    private synchronized void initializeSourceLocators() {
        if (this.fSourceLocators == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebuggerCorePlugin.PLUGIN_ID, "sourceLocatorProvider");
            IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
            this.fSourceLocators = new HashMap(infos.length);
            IConfigurationElement configurationElement = null;
            String id = null;
            int i = 0;
            while (i < infos.length) {
                configurationElement = infos[i];
                id = configurationElement.getAttribute("id");
                if (id != null) {
                    try {
                        ISourceLocatorProvider provider = (ISourceLocatorProvider)configurationElement.createExecutableExtension("class");
                        this.fSourceLocators.put(id, provider);
                    }
                    catch (CoreException e) {
                        DebuggerCorePlugin.getDefault().log(e);
                    }
                } else {
                    Status s = new Status(4, DebugPlugin.getUniqueIdentifier(), 5013, NLS.bind((String)DebuggerMessages.SPLaunchConfigurationDelegate_Invalid_locator, (Object[])new String[]{configurationElement.getContributor().getName()}), null);
                    DebuggerCorePlugin.getDefault().log((IStatus)s);
                }
                ++i;
            }
        }
    }
}

