/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.insert;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot;
import org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement;
import org.eclipse.datatools.modelbase.sql.query.TableInDatabase;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.helper.TableHelper;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.sqltools.sqlbuilder.model.InsertHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConstants;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.GridContentProvider;
import org.eclipse.datatools.sqltools.sqlbuilder.views.GridViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.ObjectListHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.help.WorkbenchHelp;

public class InsertSelectViewer
extends ContentViewer {
    QueryInsertStatement insert;
    SQLDomainModel domainModel;
    Composite canvas;
    List columnList;
    ObjectListHelper columnListHelper;
    int selectionNumber = 0;
    String[] listSelections;
    Button addButton;
    Button addAllButton;
    Button removeButton;
    Button removeAllButton;
    ColumnListGridViewer columnGrid;

    public InsertSelectViewer(SQLDomainModel domain) {
        this.domainModel = domain;
        this.insert = null;
        this.setContentProvider((IContentProvider)this.domainModel.createContentProvider());
    }

    public Control createControl(Composite parent) {
        SashForm sashForm = new SashForm(parent, 256);
        this.canvas = sashForm;
        Composite listPanel = ViewUtility.createComposite(this.canvas, 2, true);
        listPanel.setData("layout ratio", (Object)new Long(29492L));
        this.columnList = new List(listPanel, 2818);
        WorkbenchHelp.setHelp((Control)this.columnList, (String)"org.eclipse.datatools.sqltools.sqlbuilder.sqlb0010");
        GridData gridData = ViewUtility.createFill();
        gridData.horizontalSpan = 2;
        gridData.widthHint = 10;
        this.columnList.setLayoutData((Object)gridData);
        this.columnListHelper = new ObjectListHelper(this.columnList);
        ColumnListListener columnListListener = new ColumnListListener();
        this.columnList.addListener(13, (Listener)columnListListener);
        Composite buttonPanel = ViewUtility.createComposite(this.canvas, 1, true);
        buttonPanel.setData("layout ratio", (Object)new Long(6554L));
        this.addButton = ViewUtility.createPushButton(buttonPanel, ">");
        SelectListener addButtonListener = new SelectListener();
        this.addButton.addSelectionListener((SelectionListener)addButtonListener);
        WorkbenchHelp.setHelp((Control)this.addButton, (String)"org.eclipse.datatools.sqltools.sqlbuilder.sqlb0010");
        this.removeButton = ViewUtility.createPushButton(buttonPanel, "<");
        SelectListener removeButtonListener = new SelectListener();
        this.removeButton.addSelectionListener((SelectionListener)removeButtonListener);
        WorkbenchHelp.setHelp((Control)this.removeButton, (String)"org.eclipse.datatools.sqltools.sqlbuilder.sqlb0010");
        this.addAllButton = ViewUtility.createPushButton(buttonPanel, ">>");
        SelectListener addAllButtonListener = new SelectListener();
        this.addAllButton.addSelectionListener((SelectionListener)addAllButtonListener);
        WorkbenchHelp.setHelp((Control)this.addAllButton, (String)"org.eclipse.datatools.sqltools.sqlbuilder.sqlb0010");
        this.removeAllButton = ViewUtility.createPushButton(buttonPanel, "<<");
        SelectListener removeAllButtonListener = new SelectListener();
        this.removeAllButton.addSelectionListener((SelectionListener)removeAllButtonListener);
        WorkbenchHelp.setHelp((Control)this.removeAllButton, (String)"org.eclipse.datatools.sqltools.sqlbuilder.sqlb0010");
        Composite colGroup = ViewUtility.createComposite(this.canvas, 2, true);
        colGroup.setData("layout ratio", (Object)new Long(29492L));
        WorkbenchHelp.setHelp((Control)colGroup, (String)"org.eclipse.datatools.sqltools.sqlbuilder.sqlb0010");
        this.columnGrid = new ColumnListGridViewer(this.domainModel, colGroup);
        gridData = ViewUtility.createFill();
        gridData.horizontalSpan = 2;
        this.columnGrid.getTable().setLayoutData((Object)gridData);
        SelectionChangedListener gridListener = new SelectionChangedListener();
        this.columnGrid.addSelectionChangedListener(gridListener);
        int[] weigths = new int[]{45, 10, 45};
        sashForm.setWeights(weigths);
        this.hookControl((Control)this.canvas);
        return this.getControl();
    }

    public Control getControl() {
        return this.canvas;
    }

    public void setInput(Object input) {
        this.insert = (QueryInsertStatement)input;
        this.populateColumnList();
        this.columnGrid.setInput(input);
        super.setInput(input);
    }

    public Object getInput() {
        return this.insert;
    }

    public void refresh() {
        this.populateColumnList();
    }

    public void inputChanged(Object element, Object oldElement) {
        super.inputChanged(element, oldElement);
    }

    protected void populateColumnList() {
        TableInDatabase tableExpr = this.insert.getTargetTable();
        if (tableExpr != null) {
            Vector<String> availCol = new Vector<String>();
            for (ValueExpressionColumn colExpr : tableExpr.getColumnList()) {
                String name = colExpr.getName();
                ValueExpressionColumn tempCol = InsertHelper.getColumnExpressionForName(this.insert, name);
                if (tempCol != null) continue;
                availCol.add(colExpr.getName());
            }
            String[] listColumns = new String[availCol.size()];
            Iterator addColumns = availCol.iterator();
            int count = 0;
            while (addColumns.hasNext()) {
                String nextCol;
                listColumns[count] = nextCol = (String)addColumns.next();
                ++count;
            }
            this.columnListHelper.removeAll();
            this.columnList.setItems(listColumns);
        } else {
            this.columnListHelper.removeAll();
        }
        this.columnListHelper.deselectAll();
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        if (this.columnList.getItemCount() == 0) {
            this.addAllButton.setEnabled(false);
        } else {
            this.addAllButton.setEnabled(true);
        }
        this.removeAllButton.setEnabled(false);
        QueryExpressionRoot expr = this.insert.getSourceQuery();
        if (expr != null) {
            this.removeAllButton.setEnabled(true);
        }
    }

    public ISelection getSelection() {
        return null;
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public void setEnabled(boolean enable) {
        this.columnGrid.setEnabled(enable);
    }

    public class ColumnContentProvider
    extends GridContentProvider {
        public ColumnContentProvider(SQLDomainModel domainModel) {
            super(domainModel.getAdapterFactory());
        }

        public Object[] getElements(Object object) {
            this.adapterFactory.adapt(object, IStructuredItemContentProvider.class);
            this.tableElements = new Vector();
            if (object instanceof QueryInsertStatement) {
                QueryInsertStatement insertStmt = (QueryInsertStatement)object;
                EList colList = insertStmt.getTargetColumnList();
                this.tableElements.addAll(colList);
                if (this.tableElements.size() > 0) {
                    InsertSelectViewer.this.removeAllButton.setEnabled(true);
                }
            }
            return this.tableElements.toArray();
        }
    }

    class ColumnLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ColumnLabelProvider() {
        }

        public String getColumnText(Object object, int columnIndex) {
            if (columnIndex == 0) {
                return ((ValueExpressionColumn)object).getName();
            }
            return "";
        }

        public Image getColumnImage(Object object, int column) {
            return null;
        }
    }

    public class ColumnListGridViewer
    extends GridViewer
    implements IMenuListener {
        public ColumnListGridViewer(SQLDomainModel domainModel, Composite parent) {
            super(domainModel, parent);
            TableLayout layout = new TableLayout();
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
            this.table.setLayout((Layout)layout);
            String[] columnProperties = new String[]{(String)SQLBuilderConstants.P_STATEMENT_COLUMN};
            this.setColumnProperties(columnProperties);
            this.setContentProvider((IContentProvider)new ColumnContentProvider(domainModel));
            this.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider());
        }

        public void menuAboutToShow(IMenuManager menu) {
        }

        public void setEnabled(boolean enable) {
            this.table.setEnabled(enable);
        }
    }

    class ColumnListListener
    implements Listener {
        ColumnListListener() {
        }

        public void handleEvent(Event e) {
            InsertSelectViewer.this.selectionNumber = InsertSelectViewer.this.columnListHelper.getSelectionCount();
            InsertSelectViewer.this.listSelections = InsertSelectViewer.this.columnListHelper.getSelection();
            if (InsertSelectViewer.this.selectionNumber > 0) {
                InsertSelectViewer.this.addButton.setEnabled(true);
            } else if (InsertSelectViewer.this.selectionNumber <= 0) {
                InsertSelectViewer.this.addButton.setEnabled(false);
            }
        }
    }

    class SelectListener
    implements SelectionListener {
        SelectListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            TableInDatabase tableExpr = InsertSelectViewer.this.insert.getTargetTable();
            Column selectedColumn = null;
            if (e.widget == InsertSelectViewer.this.addButton) {
                if (tableExpr instanceof TableInDatabase) {
                    TableInDatabase tableInDB = tableExpr;
                    int i = 0;
                    while (i < InsertSelectViewer.this.listSelections.length) {
                        selectedColumn = TableHelper.getColumnForName((TableInDatabase)tableInDB, (String)InsertSelectViewer.this.listSelections[i]);
                        AdapterFactoryEditingDomain editDomain = InsertSelectViewer.this.domainModel.getEditingDomain();
                        InsertHelper.addDefaultInsertValue((EditingDomain)editDomain, InsertSelectViewer.this.insert, selectedColumn);
                        ++i;
                    }
                }
            } else if (e.widget == InsertSelectViewer.this.addAllButton) {
                String[] columnListNames = InsertSelectViewer.this.columnList.getItems();
                int itemCount = columnListNames.length;
                int i = 0;
                while (i < itemCount) {
                    if (tableExpr instanceof TableInDatabase) {
                        TableInDatabase tableInDB = tableExpr;
                        selectedColumn = TableHelper.getColumnForName((TableInDatabase)tableInDB, (String)columnListNames[i]);
                    }
                    if (selectedColumn != null) {
                        AdapterFactoryEditingDomain editDomain = InsertSelectViewer.this.domainModel.getEditingDomain();
                        InsertHelper.addDefaultInsertValue((EditingDomain)editDomain, InsertSelectViewer.this.insert, selectedColumn);
                    }
                    ++i;
                }
            } else if (e.widget == InsertSelectViewer.this.removeButton) {
                Object gridSelection = ((StructuredSelection)InsertSelectViewer.this.columnGrid.getSelection()).getFirstElement();
                if (gridSelection instanceof ValueExpressionColumn) {
                    ValueExpressionColumn column = (ValueExpressionColumn)gridSelection;
                    String columnName = column.getName();
                    for (ValueExpressionColumn valueExprCol : InsertSelectViewer.this.insert.getTargetColumnList()) {
                        if (valueExprCol.getName() != columnName) continue;
                        InsertHelper.removeColumn(InsertSelectViewer.this.insert, valueExprCol);
                        break;
                    }
                }
                InsertHelper.refresh(InsertSelectViewer.this.insert);
            } else if (e.widget == InsertSelectViewer.this.removeAllButton) {
                InsertSelectViewer.this.insert.getTargetColumnList().clear();
                InsertHelper.refresh(InsertSelectViewer.this.insert);
            }
        }
    }

    class SelectionChangedListener
    implements ISelectionChangedListener {
        SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = InsertSelectViewer.this.columnGrid.getSelection();
            boolean cfr_ignored_0 = selection instanceof Column;
            InsertSelectViewer.this.removeButton.setEnabled(true);
        }
    }
}

