/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.pages.storage;

import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasasqlmodel.SybaseASATable;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.LabelFormEntry;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.ASATableSchemaEditorPage;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.pages.storage.Messages;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorInput;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorPage;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.common.CollapseableSection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ASAStorageEditorPage
extends ASATableSchemaEditorPage
implements ISchemaObjectEditorPage {
    Button _defaultButton;
    Button _userDefinedButton;
    Spinner _percentageSpinner;
    Label _tipLabel;
    private SelectionListener _defaultpctSelectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (ASAStorageEditorPage.this._defaultButton.getSelection()) {
                ASAStorageEditorPage.this._percentageSpinner.setEnabled(false);
                ((SybaseASATable)ASAStorageEditorPage.this._table).setPctfree(-1);
                ASAStorageEditorPage.this.markDirty();
            } else {
                ASAStorageEditorPage.this._percentageSpinner.setEnabled(true);
            }
        }
    };
    private SelectionListener _udpctfreeSelectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (ASAStorageEditorPage.this._userDefinedButton.getSelection()) {
                ASAStorageEditorPage.this._percentageSpinner.setEnabled(true);
                ((SybaseASATable)ASAStorageEditorPage.this._table).setPctfree(ASAStorageEditorPage.this._percentageSpinner.getSelection());
                ASAStorageEditorPage.this.markDirty();
            } else {
                ASAStorageEditorPage.this._percentageSpinner.setEnabled(false);
            }
        }
    };
    private SelectionListener _percentageSpinnerListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            int percentage = ASAStorageEditorPage.this._percentageSpinner.getSelection();
            String info = "%  (";
            int reservedBytes = percentage * 2048 / 100;
            info = String.valueOf(info) + reservedBytes + Messages.ASAStorageEditorPage_reserved_bytes;
            ASAStorageEditorPage.this._tipLabel.setText(info);
            ((SybaseASATable)ASAStorageEditorPage.this._table).setPctfree(ASAStorageEditorPage.this._percentageSpinner.getSelection());
            ASAStorageEditorPage.this.markDirty();
        }
    };

    public ASAStorageEditorPage() {
    }

    public ASAStorageEditorPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public ASAStorageEditorPage(String id, String title) {
        super(id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ISchemaObjectEditorInput input = (ISchemaObjectEditorInput)this.getEditor().getEditorInput();
        this._table = (SybaseASATable)input.getEditModelObject().getMainSQLObject();
        managedForm.getForm().setText(Messages.ASAStorageEditorPage_storage);
        Composite parent = managedForm.getForm().getBody();
        parent.setLayout((Layout)new GridLayout());
        FormToolkit toolKit = managedForm.getToolkit();
        PhysicalStorageSection pSection = new PhysicalStorageSection(toolKit, Messages.ASAStorageEditorPage_physical_storage, parent.getDisplay(), false, false, 0);
        pSection.createControl(parent, 1, null);
        managedForm.getForm().reflow(true);
    }

    public void modelRegenerated() {
        super.modelRegenerated();
    }

    public void refresh() {
        if (!this.isPageOpened()) {
            return;
        }
        super.refresh();
        this._defaultButton.removeSelectionListener(this._defaultpctSelectionListener);
        this._userDefinedButton.removeSelectionListener(this._udpctfreeSelectionListener);
        this._percentageSpinner.removeSelectionListener(this._percentageSpinnerListener);
        if (((SybaseASATable)this._table).getPctfree() == -1) {
            this._defaultButton.setSelection(true);
            this._userDefinedButton.setSelection(false);
            this._percentageSpinner.setEnabled(false);
            this._defaultButton.notifyListeners(13, new Event());
        } else {
            this._userDefinedButton.setSelection(true);
            this._defaultButton.setSelection(false);
            this._percentageSpinner.setEnabled(true);
            int percentage = this._percentageSpinner.getSelection();
            String info = "%  (";
            int reservedBytes = percentage * 2048 / 100;
            info = String.valueOf(info) + reservedBytes + Messages.ASAStorageEditorPage_bytes_reserved;
            this._tipLabel.setText(info);
            ((SybaseASATable)this._table).setPctfree(this._percentageSpinner.getSelection());
        }
        this._defaultButton.addSelectionListener(this._defaultpctSelectionListener);
        this._userDefinedButton.addSelectionListener(this._udpctfreeSelectionListener);
        this._percentageSpinner.addSelectionListener(this._percentageSpinnerListener);
    }

    class PhysicalStorageSection
    extends CollapseableSection {
        public PhysicalStorageSection(FormToolkit toolkit, String title, Display display, boolean isCollapseable, boolean isCollapsed, int estyle) {
            super(toolkit, title, display, isCollapseable, isCollapsed, estyle);
        }

        public void createSectionContent(Composite parent) {
            if (!(ASAStorageEditorPage.this._table instanceof SybaseASATable)) {
                return;
            }
            this.getSection().setLayoutData((Object)new GridData(1808));
            this.getSection().setLayout((Layout)new GridLayout());
            GridLayout layout = new GridLayout();
            parent.setLayout((Layout)layout);
            parent.setLayoutData((Object)new GridData(1808));
            Composite dbSpaceComp = this._toolkit.createComposite(parent);
            layout = new GridLayout();
            layout.numColumns = 2;
            dbSpaceComp.setLayout((Layout)layout);
            LabelFormEntry spaceName = new LabelFormEntry(dbSpaceComp, this._toolkit, 0, Messages.ASAStorageEditorPage_dbspace_name, 2);
            spaceName.getValueLabel().setText(((SybaseASATable)ASAStorageEditorPage.this._table).getDbSpace() == null ? "" : ((SybaseASATable)ASAStorageEditorPage.this._table).getDbSpace().getName());
            LabelFormEntry spaceFile = new LabelFormEntry(dbSpaceComp, this._toolkit, 0, Messages.ASAStorageEditorPage_file, 2);
            spaceFile.getValueLabel().setText(((SybaseASATable)ASAStorageEditorPage.this._table).getDbSpace() == null ? "" : ((SybaseASATable)ASAStorageEditorPage.this._table).getDbSpace().getFileName());
            Composite pctFreeComp = this._toolkit.createComposite(parent);
            layout = new GridLayout();
            layout.numColumns = 2;
            pctFreeComp.setLayout((Layout)layout);
            LabelFormEntry pctFreeLabel = new LabelFormEntry(pctFreeComp, this._toolkit, 0, Messages.ASAStorageEditorPage_bytes_reserved_label, 2);
            pctFreeLabel.getValueLabel().setText(" ");
            Composite pctFreeValueComp = this._toolkit.createComposite(parent);
            layout = new GridLayout();
            layout.numColumns = 4;
            pctFreeValueComp.setLayout((Layout)layout);
            ASAStorageEditorPage.this._defaultButton = this._toolkit.createButton(pctFreeValueComp, Messages.ASAStorageEditorPage_default, 16);
            ASAStorageEditorPage.this._defaultButton.setToolTipText(Messages.ASAStorageEditorPage_default_tip);
            ASAStorageEditorPage.this._defaultButton.addSelectionListener(ASAStorageEditorPage.this._defaultpctSelectionListener);
            ASAStorageEditorPage.this._userDefinedButton = this._toolkit.createButton(pctFreeValueComp, Messages.ASAStorageEditorPage_percentage, 16);
            ASAStorageEditorPage.this._userDefinedButton.setToolTipText(Messages.ASAStorageEditorPage_percentage_tip);
            ASAStorageEditorPage.this._percentageSpinner = new Spinner(pctFreeValueComp, 2048);
            ASAStorageEditorPage.this._percentageSpinner.setToolTipText(Messages.ASAStorageEditorPage_percentage_tip);
            ASAStorageEditorPage.this._percentageSpinner.setSelection(10);
            ASAStorageEditorPage.this._tipLabel = this._toolkit.createLabel(pctFreeValueComp, Messages.ASAStorageEditorPage_204_default);
            GridData gd = new GridData(768);
            ASAStorageEditorPage.this._tipLabel.setLayoutData((Object)gd);
            if (((SybaseASATable)ASAStorageEditorPage.this._table).getPctfree() == -1) {
                ASAStorageEditorPage.this._defaultButton.setSelection(true);
                ASAStorageEditorPage.this._percentageSpinner.setEnabled(false);
            } else {
                ASAStorageEditorPage.this._userDefinedButton.setSelection(true);
                ASAStorageEditorPage.this._percentageSpinner.setSelection(((SybaseASATable)ASAStorageEditorPage.this._table).getPctfree());
                int percentage = ASAStorageEditorPage.this._percentageSpinner.getSelection();
                String info = "%  (";
                int reservedBytes = percentage * 2048 / 100;
                info = String.valueOf(info) + reservedBytes + Messages.ASAStorageEditorPage_byte_reserved_for_table;
                ASAStorageEditorPage.this._tipLabel.setText(info);
                ((SybaseASATable)ASAStorageEditorPage.this._table).setPctfree(ASAStorageEditorPage.this._percentageSpinner.getSelection());
            }
            ASAStorageEditorPage.this._userDefinedButton.addSelectionListener(ASAStorageEditorPage.this._udpctfreeSelectionListener);
            ASAStorageEditorPage.this._percentageSpinner.addSelectionListener(ASAStorageEditorPage.this._percentageSpinnerListener);
        }
    }
}

