/* Generated By:JJTree&JavaCC: Do not edit this line. GenericSQLParser.java */
package org.eclipse.datatools.sqltools.db.generic.parser;

import java.util.ArrayList;
import java.io.StringReader;

import org.eclipse.datatools.sqltools.db.generic.internal.GenericPlugin;
import org.eclipse.datatools.sqltools.sql.parser.SQLParser;
import org.eclipse.datatools.sqltools.sql.parser.ast.Node;
import org.eclipse.datatools.sqltools.sql.parser.ast.SimpleNode;
import org.eclipse.datatools.sqltools.sql.parser.ParseException;
import org.eclipse.datatools.sqltools.sql.parser.SQLParserConstants;
import org.eclipse.datatools.sqltools.sql.parser.JavaCharStream;
import org.eclipse.datatools.sqltools.sql.parser.Token;
import org.eclipse.datatools.sqltools.sql.parser.TokenMgrError;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.datatools.sqltools.sql.parser.util.ParserUtil;
import org.eclipse.datatools.sqltools.db.generic.internal.Messages;
import org.eclipse.datatools.sqltools.sql.parser.ParserParameters;


/**
 * Generic SQL parser. 
 * @author Hui Cao
 * 
 */
public class GenericSQLParser extends SQLParser implements/*@bgen(jjtree)*/ GenericSQLParserTreeConstants,SQLParserConstants, GenericSQLParserConstants {/*@bgen(jjtree)*/
  protected JJTGenericSQLParserState jjtree = new JJTGenericSQLParserState();private static GenericSQLParser _instance = new GenericSQLParser(new StringReader(""));
    private boolean _debug = false;

    private ParsingResult result = null;
    private ArrayList exceptions = new ArrayList();
        private static final int[] STMT_START = new int[]{ALTER, BEGIN, BREAK, CHECKPOINT, CLOSE, COMMIT, CONNECT,
                CONTINUE, CREATE, DEALLOCATE, DECLARE, DELETE, DISK, DROP, DUMP, EXECUTE, EXEC,
                FETCH, GOTO, GRANT, IF, INSERT, KILL, LOAD, LOCK, ONLINE, OPEN, PREPARE, //MOUNT,
                PRINT, QUIESCE, RAISERROR, READTEXT, RECONFIGURE, REMOVE, REORG, RETURN, REVOKE,
                ROLLBACK, SAVE, SELECT, SET, SETUSER, SHUTDOWN, TRUNCATE, UPDATE, USE,//UNMOUNT, 
                WAITFOR, WHILE, WRITETEXT
                                 };

        public static final String[] STMT_START_STRING = new String[]{"ALTER","BEGIN","BREAK","CHECKPOINT","CLOSE","COMMIT","CONNECT",
        "CONTINUE","CREATE","DEALLOCATE","DECLARE","DELETE","DISK","DROP","DUMP","EXECUTE","EXEC",
        "FETCH","GOTO","GRANT","IF","INSERT","KILL","LOAD","LOCK","ONLINE","OPEN","PREPARE",
        "PRINT","QUIESCE","RAISERROR","READTEXT","RECONFIGURE","REMOVE","REORG","RETURN","REVOKE",
        "ROLLBACK","SAVE","SELECT","SET","SETUSER","SHUTDOWN","TRUNCATE","UPDATE","USE",
        "WAITFOR","WHILE","WRITETEXT"
                                 };

        private static final int[] DEFINED_STMT_START = new int[]{ALTER, BEGIN, CREATE, DECLARE, DELETE, EXECUTE, EXEC, FETCH, IF, INSERT, PRINT, RETURN, SELECT, UPDATE, USE    };

        private static final int[] TERMINATORS = new int[]{GO, SEMICOLON};
        private static final String[] TERMINATORS_STRING = new String[]{"GO", ";"};

        private static int[] STMT_START_TERMINATORS = new int[STMT_START.length + TERMINATORS.length];
        static {
                System.arraycopy(STMT_START, 0, STMT_START_TERMINATORS, 0, STMT_START.length);
                System.arraycopy(TERMINATORS, 0, STMT_START_TERMINATORS, STMT_START.length, TERMINATORS.length);
        }

    /*
    * Singleton
    */
    public static GenericSQLParser getInstance(){
        return _instance;
    }

    public GenericSQLParser()
    {
    }

    public boolean isComplete()
    {
        return false;
    }

        //Implements JavaCC methods
    void jjtreeOpenNodeScope(Node n)
    {
      ((SimpleNode)n).setFirstToken ( getToken(1));
    }

    void jjtreeCloseNodeScope(Node n)
    {
      ((SimpleNode)n).setLastToken( getToken(0));
    }

    //Implements SQLParser abstract methods
    /**
	 * Returns the statement terminator array. Different vendors will have their
	 * own terminators defined, so we just leave this method as abstract here.
	 * 
	 * @return statement terminator array
	 */
    public String[] getStatementTerminators()
    {
        return TERMINATORS_STRING;
    }

    /**
     * Returns the token strings that can be used to begin a SQL statement. 
     * 
     * @return statement start token array
     */
    public String[] getStatementStartTokens()
    {
        return STMT_START_STRING;
    }

    /**
     * Concrete parsers must imlement this method to do the real parsing.
     * @param text sql text to be parsed.
     * @return <code>ParsingResult</code> containing root AST node and <code>ParseException</code>s.
     */
    protected synchronized ParsingResult doParse(String text)
    {
        java.io.StringReader sr = new java.io.StringReader( text );
                java.io.Reader r = new java.io.BufferedReader( sr );
                //ReInit will be generated by JavaCC
                ReInit(r);
        initParsing();
        return startIgnoreException();
    }


    //Other methods
    private ParsingResult startIgnoreException()
    {

        Node node = new ASTStart(JJTSTART);
        try
        {
                        node = startRootIgnoreException();
        }catch (ParseException e) {
            exceptions.add(e);
                }
                catch (TokenMgrError t)
                {
                    ParseException e = new ParseException(t.getMessage());
                    if (token == null){
                        //when the error token occurs at the beginning
                        e.currentToken = new Token();
                    }else{
                            e.currentToken = token;
                    }
                    if (t.getToken() != null){
                        e.currentToken.next = t.getToken();
                    }else{
                        Token errtoken = new Token();
                        errtoken.beginLine = token.endLine;
                        errtoken.beginColumn = token.endColumn + 1;
                        errtoken.endLine = token.endLine;
                        errtoken.endColumn = token.endColumn + 1;
                        e.currentToken.next = errtoken;
                    }
                    exceptions.add(e);
                }
                catch (Throwable t)
                {
                        GenericPlugin.getDefault().log(t);
                }
        //Since this grammar is not accurate, do not show parse exceptions by default
        Boolean consumeException = (Boolean)getParameters().getProperty(ParserParameters.PARAM_CONSUME_EXCEPTION);
        result.setRootNode(node);
        if ( consumeException == null || consumeException.booleanValue())
        {
                result.setExceptions(new ArrayList());
        }
        else
        {
                result.setExceptions(exceptions);
        }

        return result;
    }

        private void initParsing(){
                result = new GenericParsingResult();
                exceptions = new ArrayList();
        }

        private boolean isSupportedStatementStartToken(int kind)
        {
                for (int i=0; i<DEFINED_STMT_START.length; i++)
                {
                        if (kind == DEFINED_STMT_START[i])
                        {
                                return true;
                        }
                }
                return false;
        }

        private boolean isStatementStartToken(int kind)
        {
                for (int i=0; i<STMT_START.length; i++)
                {
                        if (kind == STMT_START[i])
                        {
                                return true;
                        }
                }
                return false;
        }

        private boolean isStatementToken(int kind)
        {
                if (kind == 0 || isStatementStartToken(kind))
                {
                        return false;
                }

                for (int i=0; i<TERMINATORS.length; i++)
                {
                        if (kind == TERMINATORS[i])
                        {
                                return false;
                        }
                }
                return true;
        }

        private boolean check(String unReservedKeyword)
        {
    Token currentToken = getToken(1);
    int currentTokenKind = currentToken.kind;
    String currentTokenImage = currentToken.image;
    if (currentTokenKind == ID && currentTokenImage.equalsIgnoreCase(unReservedKeyword))
    {
        return true;
    }
        if (currentTokenKind == INVALID_TOKEN)
        {
                  result.addExpectedUnreservedKeywords(unReservedKeyword);
        }
    return false;
    }

          private boolean check(int type, String multiKeyword)
  {
        return check(type, new String[]{multiKeyword});
  }

  /**
  *multiKeywords will show as content assist proposal
  */
  private boolean check(int type, String[] multiKeywords)
  {
    Token currentToken = getToken(1);
    int currentTokenKind = currentToken.kind;
    String currentTokenImage = currentToken.image;
    if (currentTokenKind == type)
    {
        return true;
    }
        if (currentTokenKind == INVALID_TOKEN)
        {
                for (int i=0; i< multiKeywords.length; i++)
                {
                result.addExpectedUnreservedKeywords(multiKeywords[i]);
        }
        }
    return false;
  }

    final private void logDebug(String message)
    {
            if (_debug)
                {
                        GenericPlugin.getDefault().log(message);
                }
    }

  final public Token string_literal() throws ParseException {
                                  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SINGLE_STRING_LITERAL:
      t = jj_consume_token(SINGLE_STRING_LITERAL);
      break;
    case DOUBLE_STRING_LITERAL:
      t = jj_consume_token(DOUBLE_STRING_LITERAL);
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                 {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

    /*******************************************************************
     * Unreserved Keywords
     *******************************************************************/
  final public Token UK_ABSOLUTE() throws ParseException {
                       Token t;
    if (check("absolute")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_ALL() throws ParseException {
                  Token t;
    if (check("all")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_BINARY() throws ParseException {
                     Token t;
    if (check("binary")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_BIT() throws ParseException {
                  Token t;
    if (check("bit")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_BOOLEAN() throws ParseException {
                      Token t;
    if (check("boolean")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_CHAR() throws ParseException {
                   Token t;
    if (check("char")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_CHAR_S() throws ParseException {
                     Token t;
    if (check("character")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_DATE() throws ParseException {
                   Token t;
    if (check("date")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_DATETIME() throws ParseException {
                       Token t;
    if (check("datetime")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_DECIMAL() throws ParseException {
                      Token t;
    if (check("decimal")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_DECIMAL_S() throws ParseException {
                        Token t;
    if (check("dec")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_DOUBLE_PRECISION() throws ParseException {
                               Token t;
    if (check( UK_DOUBLE_PRECISION, "double precision")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(UK_DOUBLE_PRECISION);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_FALSE() throws ParseException {
                    Token t;
    if (check("false")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_FIRST() throws ParseException {
                    Token t;
    if (check("first")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_FLOAT() throws ParseException {
                    Token t;
    if (check("float")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_FULL() throws ParseException {
                   Token t;
    if (check("full")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_IMAGE() throws ParseException {
                    Token t;
    if (check("image")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_INNER() throws ParseException {
                    Token t;
    if (check( "inner")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_INSENSITIVE() throws ParseException {
                          Token t;
    if (check("insensitive")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_INT() throws ParseException {
                  Token t;
    if (check("int")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_INT_S() throws ParseException {
                    Token t;
    if (check("integer")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_LAST() throws ParseException {
                   Token t;
    if (check("last")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_LEFT() throws ParseException {
                   Token t;
    if (check("left")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_MONEY() throws ParseException {
                    Token t;
    if (check("money")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_NAME() throws ParseException {
                   Token t;
    if (check("name")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_NCHAR() throws ParseException {
                    Token t;
    if (check("nchar")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_NCHAR_S() throws ParseException {
                      Token t;
    if (check( UK_NCHAR_S, "national char")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(UK_NCHAR_S);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_NCHAR_S1() throws ParseException {
                       Token t;
    if (check( UK_NCHAR_S1, "national character")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(UK_NCHAR_S1);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_NEXT() throws ParseException {
                   Token t;
    if (check("next")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_NEW() throws ParseException {
                  Token t;
    if (check("new")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_NONE() throws ParseException {
                   Token t;
    if (check("none")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_NO_SCROLL() throws ParseException {
                        Token t;
    if (check( UK_NO_SCROLL, "no scroll")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(UK_NO_SCROLL);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_NUMERIC() throws ParseException {
                      Token t;
    if (check("numeric")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_NVARCHAR() throws ParseException {
                       Token t;
    if (check("nvarchar")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_NVARCHAR_S() throws ParseException {
                         Token t;
    if (check( UK_NVARCHAR_S, "national char varying")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(UK_NVARCHAR_S);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_NVARCHAR_S1() throws ParseException {
                          Token t;
    if (check( UK_NVARCHAR_S1, "national character varying")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(UK_NVARCHAR_S1);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_NVARCHAR_S2() throws ParseException {
                          Token t;
    if (check( UK_NVARCHAR_S2, "nchar varying")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(UK_NVARCHAR_S2);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_OUTER() throws ParseException {
                    Token t;
    if (check("outer")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_PRIOR() throws ParseException {
                    Token t;
    if (check("prior")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_REAL() throws ParseException {
                   Token t;
    if (check("real")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_RELATIVE() throws ParseException {
                       Token t;
    if (check("relative")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_RIGHT() throws ParseException {
                    Token t;
    if (check("right")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_SCROLL() throws ParseException {
                     Token t;
    if (check("scroll")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_SEMI_SENSITIVE() throws ParseException {
                             Token t;
    if (check( UK_SEMI_SENSITIVE, "semi sensitive")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(UK_SEMI_SENSITIVE);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_SMALLDATETIME() throws ParseException {
                            Token t;
    if (check("smalldatetime")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_SMALLINT() throws ParseException {
                       Token t;
    if (check("smallint")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_SMALLMONEY() throws ParseException {
                         Token t;
    if (check("smallmoney")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_TEXT() throws ParseException {
                   Token t;
    if (check("text")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_THEN() throws ParseException {
                   Token t;
    if (check("then")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_TIME() throws ParseException {
                   Token t;
    if (check("time")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_TIMESTAMP() throws ParseException {
                        Token t;
    if (check("timestamp")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_TINYINT() throws ParseException {
                      Token t;
    if (check("tinyint")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_TRUE() throws ParseException {
                   Token t;
    if (check("true")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_UNICHAR() throws ParseException {
                      Token t;
    if (check("unichar")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_UNIVARCHAR() throws ParseException {
                         Token t;
    if (check("univarchar")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_VARBINARY() throws ParseException {
                        Token t;
    if (check("varbinary")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_VARCHAR() throws ParseException {
                      Token t;
    if (check("varchar")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(ID);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_VARCHAR_S() throws ParseException {
                        Token t;
    if (check( UK_VARCHAR_S, "char varying")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(UK_VARCHAR_S);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token UK_VARCHAR_S1() throws ParseException {
                         Token t;
    if (check( UK_VARCHAR_S1, "character varying")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(UK_VARCHAR_S1);
         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

        /**
	 * Ignore exception during parsing so that the rest part can be parsed
	 */
  final public Node startRootIgnoreException() throws ParseException {
                                                   /*@bgen(jjtree) Start */
  ASTStart jjtn000 = new ASTStart(JJTSTART);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GO:
      case SEMICOLON:
        delimiter();
        break;
      default:
        jj_la1[1] = jj_gen;
        ;
      }
      label_1:
      while (true) {
        if (jj_2_1(1)) {
          ;
        } else {
          break label_1;
        }
        try {
          statement();
        } catch (ParseException e) {
                        //TODO can we create an UnknownStatement?
                    exceptions.add(e);
                    error_skiptobefore(new int[]{END}, STMT_START_TERMINATORS);
        } catch (Throwable t) {
                //TODO: handle this throwable separately in SQLEditor:setOutlineContent.
                        ParseException e = new ParseException(ParserUtil.getErrorMessage(getToken(0)));
                        e.currentToken = getToken(0);
                        exceptions.add(e);
                    error_skiptobefore(new int[]{END}, STMT_START_TERMINATORS);
        }
      }
      jj_consume_token(0);
           jjtree.closeNodeScope(jjtn000, true);
           jjtc000 = false;
           jjtreeCloseNodeScope(jjtn000);
           {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
            jjtreeCloseNodeScope(jjtn000);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public ASTSQLDelimiter delimiter() throws ParseException {
                                           /*@bgen(jjtree) SQLDelimiter */
  ASTSQLDelimiter jjtn000 = new ASTSQLDelimiter(JJTSQLDELIMITER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case GO:
          jj_consume_token(GO);
          break;
        case SEMICOLON:
          jj_consume_token(SEMICOLON);
          break;
        default:
          jj_la1[2] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        if (jj_2_2(2)) {
          ;
        } else {
          break label_2;
        }
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          jjtreeCloseNodeScope(jjtn000);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
            jjtreeCloseNodeScope(jjtn000);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public void statement() throws ParseException {
                    setScope("SQL Statement", SCOPE_DEFAULT);
    try {
      if (jj_2_13(1)) {
                    ASTSQLStatement jjtn001 = new ASTSQLStatement(JJTSQLSTATEMENT);
                    boolean jjtc001 = true;
                    jjtree.openNodeScope(jjtn001);
                    jjtreeOpenNodeScope(jjtn001);
        try {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case USE:
            use();
            break;
          default:
            jj_la1[3] = jj_gen;
            if (jj_2_3(2147483647)) {
              create_stmts();
            } else if (jj_2_4(2147483647)) {
              alter_stmts();
            } else if (jj_2_5(2147483647)) {
              drop_stmts();
            } else if (jj_2_6(2147483647)) {
              insert_stmts();
            } else if (jj_2_7(2147483647)) {
              update_stmts();
            } else if (jj_2_8(2147483647)) {
              select();
            } else if (jj_2_9(2147483647)) {
              delete_stmts();
            } else if (jj_2_10(2147483647)) {
              fetch();
            } else if (jj_2_11(2147483647)) {
              begin_stmts();
            } else {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case RETURN:
                return_stmt();
                break;
              case IF:
                if_stmt();
                break;
              case PRINT:
                print();
                break;
              default:
                jj_la1[4] = jj_gen;
                if (jj_2_12(1)) {
                  unknown_sql_stmt();
                } else {
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
            }
          }
        } catch (Throwable jjte001) {
                    if (jjtc001) {
                      jjtree.clearNodeScope(jjtn001);
                      jjtc001 = false;
                    } else {
                      jjtree.popNode();
                    }
                    if (jjte001 instanceof RuntimeException) {
                      {if (true) throw (RuntimeException)jjte001;}
                    }
                    if (jjte001 instanceof ParseException) {
                      {if (true) throw (ParseException)jjte001;}
                    }
                    {if (true) throw (Error)jjte001;}
        } finally {
                    if (jjtc001) {
                      jjtree.closeNodeScope(jjtn001, true);
                      jjtreeCloseNodeScope(jjtn001);
                    }
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DECLARE:
          declare();
          break;
        default:
          jj_la1[5] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      if (jj_2_14(2147483647)) {
        delimiter();
      } else {
        ;
      }
    } catch (ParseException e) {
          exceptions.add(e);
          error_skiptobefore(new int[]{END}, STMT_START_TERMINATORS);
          //to generate an ASTSQLDelimiter node so that the statement can be separated
          if (getToken(1).kind == GO || getToken(1).kind == SEMICOLON )
          {
             delimiter();
          }
    } catch (Throwable t) {
        //TODO: handle this throwable separately in SQLEditor:setOutlineContent.
                ParseException e = new ParseException(ParserUtil.getErrorMessage(getToken(0)));
                e.currentToken = getToken(0);
                exceptions.add(e);
            error_skiptobefore(new int[]{END}, STMT_START_TERMINATORS);
            if (getToken(1).kind == GO || getToken(1).kind == SEMICOLON )
            {
                delimiter();
            }
    }

  }

  final public void unknown_sql_stmt() throws ParseException {
    if (!isSupportedStatementStartToken(getToken(1).kind)) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BREAK:
      jj_consume_token(BREAK);
      break;
    case CHECKPOINT:
      jj_consume_token(CHECKPOINT);
      break;
    case CLOSE:
      jj_consume_token(CLOSE);
      break;
    case COMMIT:
      jj_consume_token(COMMIT);
      break;
    case CONNECT:
      jj_consume_token(CONNECT);
      break;
    case CONTINUE:
      jj_consume_token(CONTINUE);
      break;
    case DEALLOCATE:
      jj_consume_token(DEALLOCATE);
      break;
    case DECLARE:
      jj_consume_token(DECLARE);
      break;
    case DISK:
      jj_consume_token(DISK);
      break;
    case DUMP:
      jj_consume_token(DUMP);
      break;
    case EXECUTE:
      jj_consume_token(EXECUTE);
      break;
    case EXEC:
      jj_consume_token(EXEC);
      break;
    case GOTO:
      jj_consume_token(GOTO);
      break;
    case GRANT:
      jj_consume_token(GRANT);
      break;
    case KILL:
      jj_consume_token(KILL);
      break;
    case LOAD:
      jj_consume_token(LOAD);
      break;
    case LOCK:
      jj_consume_token(LOCK);
      break;
    case ONLINE:
      jj_consume_token(ONLINE);
      break;
    case OPEN:
      jj_consume_token(OPEN);
      break;
    case PREPARE:
      jj_consume_token(PREPARE);
      break;
    case QUIESCE:
      jj_consume_token(QUIESCE);
      break;
    case RAISERROR:
      jj_consume_token(RAISERROR);
      break;
    case READTEXT:
      jj_consume_token(READTEXT);
      break;
    case RECONFIGURE:
      jj_consume_token(RECONFIGURE);
      break;
    case REMOVE:
      jj_consume_token(REMOVE);
      break;
    case REORG:
      jj_consume_token(REORG);
      break;
    case RETURN:
      jj_consume_token(RETURN);
      break;
    case REVOKE:
      jj_consume_token(REVOKE);
      break;
    case ROLLBACK:
      jj_consume_token(ROLLBACK);
      break;
    case SAVE:
      jj_consume_token(SAVE);
      break;
    case SET:
      jj_consume_token(SET);
      break;
    case SETUSER:
      jj_consume_token(SETUSER);
      break;
    case SHUTDOWN:
      jj_consume_token(SHUTDOWN);
      break;
    case TRUNCATE:
      jj_consume_token(TRUNCATE);
      break;
    case WAITFOR:
      jj_consume_token(WAITFOR);
      break;
    case WHILE:
      jj_consume_token(WHILE);
      break;
    case WRITETEXT:
      jj_consume_token(WRITETEXT);
      break;
    case ID:
      jj_consume_token(ID);
      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                error_skiptobefore(new int[]{END}, STMT_START_TERMINATORS);
  }

  final public void any_stmt_token() throws ParseException {
                error_skiptobefore(new int[]{END}, STMT_START_TERMINATORS);
  }

  final public void use() throws ParseException {
              setScope("SQL Statement", SCOPE_CATALOGS);
    jj_consume_token(USE);
    id();
  }

  final public void create_stmts() throws ParseException {
    jj_consume_token(CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATABASE:
      jj_consume_token(DATABASE);
      break;
    case TABLE:
      jj_consume_token(TABLE);
      break;
    case PROCEDURE:
      jj_consume_token(PROCEDURE);
      break;
    case PROC:
      jj_consume_token(PROC);
      break;
    case TRIGGER:
      jj_consume_token(TRIGGER);
      break;
    case FUNCTION:
      jj_consume_token(FUNCTION);
      break;
    case EVENT:
      jj_consume_token(EVENT);
      break;
    case SCHEMA:
      jj_consume_token(SCHEMA);
      break;
    case CLUSTERED:
    case DUMMY:
    case INDEX:
    case NONCLUSTERED:
    case UNIQUE:
      unique();
      dummy();
      clustered();
      jj_consume_token(INDEX);
      break;
    case VIEW:
      jj_consume_token(VIEW);
      break;
    case DEFAULT_VAL:
      jj_consume_token(DEFAULT_VAL);
      break;
    case ROLE:
      jj_consume_token(ROLE);
      break;
    case ID:
      jj_consume_token(ID);
      break;
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    any_stmt_token();
  }

  final public void unique() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNIQUE:
      jj_consume_token(UNIQUE);
      break;
    default:
      jj_la1[8] = jj_gen;
      ;
    }
  }

  final public void dummy() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DUMMY:
      jj_consume_token(DUMMY);
      break;
    default:
      jj_la1[9] = jj_gen;
      ;
    }
  }

  final public void clustered() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CLUSTERED:
    case NONCLUSTERED:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NONCLUSTERED:
        jj_consume_token(NONCLUSTERED);
        break;
      case CLUSTERED:
        jj_consume_token(CLUSTERED);
        break;
      default:
        jj_la1[10] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[11] = jj_gen;
      ;
    }
  }

  final public void alter_stmts() throws ParseException {
    jj_consume_token(ALTER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATABASE:
      jj_consume_token(DATABASE);
      break;
    case TABLE:
      jj_consume_token(TABLE);
      break;
    case PROCEDURE:
      jj_consume_token(PROCEDURE);
      break;
    case PROC:
      jj_consume_token(PROC);
      break;
    case TRIGGER:
      jj_consume_token(TRIGGER);
      break;
    case FUNCTION:
      jj_consume_token(FUNCTION);
      break;
    case EVENT:
      jj_consume_token(EVENT);
      break;
    case ROLE:
      jj_consume_token(ROLE);
      break;
    case ID:
      jj_consume_token(ID);
      break;
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    any_stmt_token();
  }

  final public void drop_stmts() throws ParseException {
    jj_consume_token(DROP);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATABASE:
      jj_consume_token(DATABASE);
      break;
    case TABLE:
      jj_consume_token(TABLE);
      break;
    case PROCEDURE:
      jj_consume_token(PROCEDURE);
      break;
    case PROC:
      jj_consume_token(PROC);
      break;
    case TRIGGER:
      jj_consume_token(TRIGGER);
      break;
    case FUNCTION:
      jj_consume_token(FUNCTION);
      break;
    case EVENT:
      jj_consume_token(EVENT);
      break;
    case SCHEMA:
      jj_consume_token(SCHEMA);
      break;
    case INDEX:
      jj_consume_token(INDEX);
      break;
    case VIEW:
      jj_consume_token(VIEW);
      break;
    case DEFAULT_VAL:
      jj_consume_token(DEFAULT_VAL);
      break;
    case ROLE:
      jj_consume_token(ROLE);
      break;
    case ID:
      jj_consume_token(ID);
      break;
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    any_stmt_token();
  }

  final public void begin_stmts() throws ParseException {
    if (jj_2_15(2147483647)) {
      begin_tran();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BEGIN:
        compound_statement();
        break;
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void delete_stmts() throws ParseException {
    delete();
  }

  final public void insert_stmts() throws ParseException {
    insert();
  }

  final public void update_stmts() throws ParseException {
    update();
  }

  final public ASTSQLDataType datatype() throws ParseException {
                                           /*@bgen(jjtree) SQLDataType */
  ASTSQLDataType jjtn000 = new ASTSQLDataType(JJTSQLDATATYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      base_datatype();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          jjtreeCloseNodeScope(jjtn000);
         {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
            jjtreeCloseNodeScope(jjtn000);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public ASTSQLDataType base_datatype() throws ParseException {
                                                /*@bgen(jjtree) SQLDataType */
                                                ASTSQLDataType jjtn000 = new ASTSQLDataType(JJTSQLDATATYPE);
                                                boolean jjtc000 = true;
                                                jjtree.openNodeScope(jjtn000);
                                                jjtreeOpenNodeScope(jjtn000);Token t= null; int length=0, scale=-1; String name=null;
    try {
      try {
        if (jj_2_41(1)) {
          t = UK_DOUBLE_PRECISION();
        } else if (jj_2_42(1)) {
          t = UK_BINARY();
          if (jj_2_16(2)) {
            jj_consume_token(OPENPAREN);
            length = number();
            jj_consume_token(CLOSEPAREN);
          } else {
            ;
          }
        } else if (jj_2_43(1)) {
          t = UK_BIT();
        } else if (jj_2_44(1)) {
          if (jj_2_17(1)) {
            t = UK_CHAR();
          } else if (jj_2_18(1)) {
            t = UK_CHAR_S();
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
          if (jj_2_19(2)) {
            jj_consume_token(OPENPAREN);
            length = number();
            jj_consume_token(CLOSEPAREN);
          } else {
            ;
          }
        } else if (jj_2_45(1)) {
          t = UK_DATETIME();
        } else if (jj_2_46(1)) {
          t = UK_DATE();
        } else if (jj_2_47(1)) {
          if (jj_2_20(1)) {
            t = UK_DECIMAL();
          } else if (jj_2_21(1)) {
            t = UK_DECIMAL_S();
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
          if (jj_2_22(2)) {
            jj_consume_token(OPENPAREN);
            length = number();
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case COMMA:
              jj_consume_token(COMMA);
              scale = number();
              break;
            default:
              jj_la1[15] = jj_gen;
              ;
            }
            jj_consume_token(CLOSEPAREN);
          } else {
            ;
          }
        } else if (jj_2_48(1)) {
          t = UK_FLOAT();
          if (jj_2_23(2)) {
            jj_consume_token(OPENPAREN);
            length = number();
            jj_consume_token(CLOSEPAREN);
          } else {
            ;
          }
        } else if (jj_2_49(1)) {
          if (jj_2_24(1)) {
            t = UK_INT();
          } else if (jj_2_25(1)) {
            t = UK_INT_S();
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        } else if (jj_2_50(1)) {
          t = UK_MONEY();
        } else if (jj_2_51(1)) {
          if (jj_2_26(1)) {
            t = UK_NCHAR();
          } else if (jj_2_27(1)) {
            t = UK_NCHAR_S();
          } else if (jj_2_28(1)) {
            t = UK_NCHAR_S1();
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
          if (jj_2_29(2)) {
            jj_consume_token(OPENPAREN);
            length = number();
            jj_consume_token(CLOSEPAREN);
          } else {
            ;
          }
        } else if (jj_2_52(1)) {
          t = UK_NUMERIC();
          if (jj_2_30(2)) {
            jj_consume_token(OPENPAREN);
            length = number();
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case COMMA:
              jj_consume_token(COMMA);
              scale = number();
              break;
            default:
              jj_la1[16] = jj_gen;
              ;
            }
            jj_consume_token(CLOSEPAREN);
                                                    if ((length < scale))
                                                    {
                                                            ParseException e = new ParseException(Messages.SQLParser_datatype_judgeLengthAndScale);
                                                            e.currentToken = t.next;
                                                            exceptions.add(e);
                                                    }
          } else {
            ;
          }
        } else if (jj_2_53(1)) {
          if (jj_2_31(1)) {
            t = UK_NVARCHAR();
          } else if (jj_2_32(1)) {
            t = UK_NVARCHAR_S();
          } else if (jj_2_33(1)) {
            t = UK_NVARCHAR_S1();
          } else if (jj_2_34(1)) {
            t = UK_NVARCHAR_S2();
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
          if (jj_2_35(2)) {
            jj_consume_token(OPENPAREN);
            length = number();
            jj_consume_token(CLOSEPAREN);
          } else {
            ;
          }
        } else if (jj_2_54(1)) {
          t = UK_REAL();
        } else if (jj_2_55(1)) {
          t = UK_SMALLDATETIME();
        } else if (jj_2_56(1)) {
          t = UK_SMALLINT();
        } else if (jj_2_57(1)) {
          t = UK_SMALLMONEY();
        } else if (jj_2_58(1)) {
          t = UK_TIMESTAMP();
        } else if (jj_2_59(1)) {
          t = UK_TIME();
        } else if (jj_2_60(1)) {
          t = UK_TINYINT();
        } else if (jj_2_61(1)) {
          t = UK_UNICHAR();
          if (jj_2_36(2)) {
            jj_consume_token(OPENPAREN);
            length = number();
            jj_consume_token(CLOSEPAREN);
          } else {
            ;
          }
        } else if (jj_2_62(1)) {
          t = UK_UNIVARCHAR();
          if (jj_2_37(2)) {
            jj_consume_token(OPENPAREN);
            length = number();
            jj_consume_token(CLOSEPAREN);
          } else {
            ;
          }
        } else if (jj_2_63(1)) {
          t = UK_VARBINARY();
          if (jj_2_38(2)) {
            jj_consume_token(OPENPAREN);
            length = number();
            jj_consume_token(CLOSEPAREN);
          } else {
            ;
          }
        } else if (jj_2_64(1)) {
          t = UK_VARCHAR();
          if (jj_2_39(2)) {
            jj_consume_token(OPENPAREN);
            length = number();
            jj_consume_token(CLOSEPAREN);
          } else {
            ;
          }
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SINGLE_STRING_LITERAL:
          case DOUBLE_STRING_LITERAL:
          case ID:
          case SQUARE_BRACKET_ID:
          case TEMP_TABLE_NAME:
            name = java_name();
            if (jj_2_40(2)) {
              jj_consume_token(OPENPAREN);
              length = number();
              jj_consume_token(CLOSEPAREN);
            } else {
              ;
            }
            break;
          default:
            jj_la1[17] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        if (t != null )
        {
                ((ASTSQLDataType)jjtn000).setName(t.image);
        }else{
                ((ASTSQLDataType)jjtn000).setName(name);
        }
      ((ASTSQLDataType)jjtn000).setLength(length);
      ((ASTSQLDataType)jjtn000).setScale(scale);
      {if (true) return jjtn000;}
      } catch (ParseException e) {
                exceptions.add(e);
                {if (true) return jjtn000;}
      }
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
            jjtreeCloseNodeScope(jjtn000);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public String java_name() throws ParseException {
                      Token t = null; String wholename = null; String part = null;
    t = id_or_string();
                                             wholename = t.image;
    if (jj_2_65(2)) {
      jj_consume_token(DOT);
      part = java_name();
                                                                                                         wholename += "." + part;
    } else {
      ;
    }
         {if (true) return wholename;}
    throw new Error("Missing return statement in function");
  }

  final public void length_spec() throws ParseException {
    if (jj_2_66(2)) {
      jj_consume_token(OPENPAREN);
      number();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        number();
        break;
      default:
        jj_la1[18] = jj_gen;
        ;
      }
      jj_consume_token(CLOSEPAREN);
    } else {
      ;
    }
  }

  final public void insert() throws ParseException {
                 setScope("insert", SCOPE_TABLES);
    jj_consume_token(INSERT);
    into_over();
    table_object();
                                                               setScope("insert", SCOPE_COLUMNS);
    optional_insert_col_list();
    insert_source();
  }

  final public void into_over() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTO:
    case OVER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTO:
        jj_consume_token(INTO);
        break;
      case OVER:
        jj_consume_token(OVER);
        break;
      default:
        jj_la1[19] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[20] = jj_gen;
      ;
    }
  }

  final public void optional_insert_col_list() throws ParseException {
    if (jj_2_67(2)) {
      jj_consume_token(OPENPAREN);
      insert_column_list();
      jj_consume_token(CLOSEPAREN);
    } else {
      ;
    }
  }

  final public void insert_column_list() throws ParseException {
    insert_column();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[21] = jj_gen;
        break label_3;
      }
      jj_consume_token(COMMA);
      insert_column();
    }
  }

  final public void insert_column() throws ParseException {
    if (jj_2_68(2147483647)) {
      prefix_list();
      id_or_string();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SINGLE_STRING_LITERAL:
      case DOUBLE_STRING_LITERAL:
      case ID:
      case SQUARE_BRACKET_ID:
      case TEMP_TABLE_NAME:
        id_or_string();
        break;
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void insert_source() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VALUES:
      jj_consume_token(VALUES);
      jj_consume_token(OPENPAREN);
      insert_values();
      jj_consume_token(CLOSEPAREN);
      break;
    case SELECT:
    case OPENPAREN:
      select();
      break;
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void insert_values() throws ParseException {
    if (jj_2_69(1)) {
      insert_value_list();
    } else {
      ;
    }
  }

  final public void insert_value_list() throws ParseException {
    insert_value();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[24] = jj_gen;
        break label_4;
      }
      jj_consume_token(COMMA);
      insert_value();
    }
  }

  final public void insert_value() throws ParseException {
    if (jj_2_70(1)) {
      expression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DEFAULT_VAL:
        jj_consume_token(DEFAULT_VAL);
        break;
      default:
        jj_la1[25] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void update() throws ParseException {
    jj_consume_token(UPDATE);
                          setScope("update", SCOPE_TABLES);
    table_object();

    jj_consume_token(SET);
                          setScope("update", SCOPE_COLUMNS);
    set_clause_list();
                          setScope("update", SCOPE_TABLES);
    from_where_clause();

  }

  final public void set_clause_list() throws ParseException {
    set_clause();
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[26] = jj_gen;
        break label_5;
      }
      jj_consume_token(COMMA);
      set_clause();
    }
  }

  final public void set_clause() throws ParseException {
    if (jj_2_71(3)) {
      primary();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VAR_NAME:
        variable_assignment();
        break;
      default:
        jj_la1[27] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(EQUAL);
    expression();
  }

  final public void select() throws ParseException {
    query_expression();
    order_by_clause();
    compute_clause();
    isolation_clause();
  }

  final public void query_expression() throws ParseException {
    query_term();
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNION:
        ;
        break;
      default:
        jj_la1[28] = jj_gen;
        break label_6;
      }
      jj_consume_token(UNION);
      all_option();
      query_term();
    }
  }

  final public void query_term() throws ParseException {
    query_primary();
  }

  final public void all_option() throws ParseException {
    if (jj_2_72(1)) {
      UK_ALL();
    } else {
      ;
    }
  }

  final public void query_primary() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
      simple_table();
      break;
    case OPENPAREN:
      jj_consume_token(OPENPAREN);
      query_expression();
      jj_consume_token(CLOSEPAREN);
      break;
    default:
      jj_la1[29] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void simple_table() throws ParseException {
    query_specification();
  }

  final public void query_specification() throws ParseException {
    jj_consume_token(SELECT);
    all_distinct();
                          setScope("query_specification", SCOPE_COLUMNS);
    select_list();
                          setScope("query_specification", SCOPE_TABLES);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTO:
      into();
      break;
    default:
      jj_la1[30] = jj_gen;
      ;
    }
    optional_from_clause();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      where_clause();
      break;
    default:
      jj_la1[31] = jj_gen;
      ;
    }
    group_by_clause();
    having_clause();
  }

  final public void into() throws ParseException {
    jj_consume_token(INTO);
    into_object();
  }

  final public void into_object() throws ParseException {
    table_object();
  }

  final public void cursor_update_list() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OF:
      jj_consume_token(OF);
      cursor_column_list();
      break;
    default:
      jj_la1[32] = jj_gen;
      ;
    }
  }

  final public void cursor_column_list() throws ParseException {
    curs_upd_column();
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[33] = jj_gen;
        break label_7;
      }
      jj_consume_token(COMMA);
      curs_upd_column();
    }
  }

  final public void curs_upd_column() throws ParseException {
    if (jj_2_73(2147483647)) {
      prefix_list();
    } else {
      ;
    }
    idplus();
  }

  final public void isolation_clause() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AT:
      jj_consume_token(AT);
      jj_consume_token(ISOLATION);
      isolation_lvl();
      break;
    default:
      jj_la1[34] = jj_gen;
      ;
    }
  }

  final public void isolation_lvl() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
      break;
    case READ:
      jj_consume_token(READ);
      jj_consume_token(ID);
      break;
    case ID:
      jj_consume_token(ID);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case READ:
        jj_consume_token(READ);
        break;
      default:
        jj_la1[35] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[36] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void all_distinct() throws ParseException {
    if (jj_2_75(1)) {
      if (jj_2_74(1)) {
        UK_ALL();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DISTINCT:
          jj_consume_token(DISTINCT);
          break;
        default:
          jj_la1[37] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } else {
      ;
    }
  }

  final public void delete() throws ParseException {
                 setScope("delete", SCOPE_TABLES);
    jj_consume_token(DELETE);
    result_table();
    from_where_clause();
  }

  final public void result_table() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FROM:
      jj_consume_token(FROM);
      break;
    default:
      jj_la1[38] = jj_gen;
      ;
    }
    table_object();

  }

  final public void subquery() throws ParseException {
    jj_consume_token(OPENPAREN);
    subquery_content();
    jj_consume_token(CLOSEPAREN);
  }

  final public void subquery_content() throws ParseException {
                                        /*@bgen(jjtree) SQLStatement */
  ASTSQLStatement jjtn000 = new ASTSQLStatement(JJTSQLSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(SELECT);
      subq_select();
                           jjtree.closeNodeScope(jjtn000, true);
                           jjtc000 = false;
                           jjtreeCloseNodeScope(jjtn000);

    } catch (Throwable jjte000) {
                           if (jjtc000) {
                             jjtree.clearNodeScope(jjtn000);
                             jjtc000 = false;
                           } else {
                             jjtree.popNode();
                           }
                           if (jjte000 instanceof RuntimeException) {
                             {if (true) throw (RuntimeException)jjte000;}
                           }
                           if (jjte000 instanceof ParseException) {
                             {if (true) throw (ParseException)jjte000;}
                           }
                           {if (true) throw (Error)jjte000;}
    } finally {
                           if (jjtc000) {
                             jjtree.closeNodeScope(jjtn000, true);
                             jjtreeCloseNodeScope(jjtn000);
                           }
    }
  }

  final public void subq_select() throws ParseException {
    if (jj_2_76(1)) {
      subq_all_distinct();
      subquery_select_expression();
      optional_from_clause();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHERE:
        where_clause();
        break;
      default:
        jj_la1[39] = jj_gen;
        ;
      }
      group_by_clause();
      having_clause();
      subq_fake_union();
      subq_fake_order_by_clause();
      subq_fake_compute_clause();
      subq_fake_isolation_clause();
    } else {
      ;
    }
  }

  final public void subq_all_distinct() throws ParseException {
    if (jj_2_78(1)) {
      if (jj_2_77(1)) {
        UK_ALL();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DISTINCT:
          jj_consume_token(DISTINCT);
          break;
        default:
          jj_la1[40] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } else {
      ;
    }
  }

  final public void subq_fake_union() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNION:
      jj_consume_token(UNION);
      subq_fake_select();
      break;
    default:
      jj_la1[41] = jj_gen;
      ;
    }
  }

  final public void subq_fake_select() throws ParseException {
    if (jj_2_79(2)) {
      subq_fake_primary();
      jj_consume_token(UNION);
    } else {
      ;
    }
    subq_fake_primary();
  }

  final public void subq_fake_primary() throws ParseException {
    jj_consume_token(SELECT);
    subq_fake_all_distinct();
    subq_fake_select_expression();
    optional_from_clause();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      where_clause();
      break;
    default:
      jj_la1[42] = jj_gen;
      ;
    }
    group_by_clause();
    having_clause();
  }

  final public void subq_fake_all_distinct() throws ParseException {
    if (jj_2_81(1)) {
      if (jj_2_80(1)) {
        UK_ALL();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DISTINCT:
          jj_consume_token(DISTINCT);
          break;
        default:
          jj_la1[43] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } else {
      ;
    }
  }

  final public void subq_fake_select_expression() throws ParseException {
    if (jj_2_82(2)) {
      subq_expression_list();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SINGLE_STRING_LITERAL:
      case DOUBLE_STRING_LITERAL:
      case ID:
      case SQUARE_BRACKET_ID:
      case TEMP_TABLE_NAME:
      case DOT:
      case ASTERISK:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SINGLE_STRING_LITERAL:
        case DOUBLE_STRING_LITERAL:
        case ID:
        case SQUARE_BRACKET_ID:
        case TEMP_TABLE_NAME:
        case DOT:
          prefix_list();
          break;
        default:
          jj_la1[44] = jj_gen;
          ;
        }
        jj_consume_token(ASTERISK);
        break;
      default:
        jj_la1[45] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void subq_fake_order_by_clause() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      jj_consume_token(ORDER);
      jj_consume_token(BY);
      subq_fake_order_by_list();
      break;
    default:
      jj_la1[46] = jj_gen;
      ;
    }
  }

  final public void subq_fake_order_by_list() throws ParseException {
    subq_fake_order_by_item();
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[47] = jj_gen;
        break label_8;
      }
      jj_consume_token(COMMA);
      subq_fake_order_by_item();
    }
  }

  final public void subq_fake_order_by_item() throws ParseException {
    expression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASC:
    case DESC:
      order_by_option();
      break;
    default:
      jj_la1[48] = jj_gen;
      ;
    }
  }

  final public void subq_fake_compute_clause() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMPUTE:
      subq_fake_compute_statement_list();
      break;
    default:
      jj_la1[49] = jj_gen;
      ;
    }
  }

  final public void subq_fake_compute_statement_list() throws ParseException {
    subq_fake_compute_statement();
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMPUTE:
        ;
        break;
      default:
        jj_la1[50] = jj_gen;
        break label_9;
      }
      subq_fake_compute_statement();
    }
  }

  final public void subq_fake_compute_statement() throws ParseException {
    jj_consume_token(COMPUTE);
    subq_fake_optional_compute_by_list();
    subq_fake_compute_list();
    subq_fake_optional_compute_by_list();
  }

  final public void subq_fake_compute_list() throws ParseException {
    subq_fake_compute_function();
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[51] = jj_gen;
        break label_10;
      }
      jj_consume_token(COMMA);
      subq_fake_compute_function();
    }
  }

  final public void subq_fake_compute_function() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COUNT:
      jj_consume_token(COUNT);
      jj_consume_token(OPENPAREN);
      expression();
      jj_consume_token(CLOSEPAREN);
      break;
    case AVG:
      jj_consume_token(AVG);
      jj_consume_token(OPENPAREN);
      expression();
      jj_consume_token(CLOSEPAREN);
      break;
    case MAX:
      jj_consume_token(MAX);
      jj_consume_token(OPENPAREN);
      expression();
      jj_consume_token(CLOSEPAREN);
      break;
    case MIN:
      jj_consume_token(MIN);
      jj_consume_token(OPENPAREN);
      expression();
      jj_consume_token(CLOSEPAREN);
      break;
    case SUM:
      jj_consume_token(SUM);
      jj_consume_token(OPENPAREN);
      expression();
      jj_consume_token(CLOSEPAREN);
      break;
    default:
      jj_la1[52] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void subq_fake_optional_compute_by_list() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BY:
      jj_consume_token(BY);
      subq_fake_compute_by_list();
      break;
    default:
      jj_la1[53] = jj_gen;
      ;
    }
  }

  final public void subq_fake_compute_by_list() throws ParseException {
    subq_fake_compute_by_item();
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[54] = jj_gen;
        break label_11;
      }
      jj_consume_token(COMMA);
      subq_fake_compute_by_item();
    }
  }

  final public void subq_fake_compute_by_item() throws ParseException {
    expression();
  }

  final public void subq_fake_cursor_update_list() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OF:
      jj_consume_token(OF);
      subq_fake_cursor_column_list();
      break;
    default:
      jj_la1[55] = jj_gen;
      ;
    }
  }

  final public void subq_fake_cursor_column_list() throws ParseException {
    subq_fake_curs_upd_column();
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[56] = jj_gen;
        break label_12;
      }
      jj_consume_token(COMMA);
      subq_fake_curs_upd_column();
    }
  }

  final public void subq_fake_curs_upd_column() throws ParseException {
    if (jj_2_83(2147483647)) {
      prefix_list();
    } else {
      ;
    }
    idplus();
  }

  final public void subq_fake_isolation_clause() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AT:
      jj_consume_token(AT);
      jj_consume_token(ISOLATION);
      isolation_lvl();
      break;
    default:
      jj_la1[57] = jj_gen;
      ;
    }
  }

  final public void compound_statement() throws ParseException {
    jj_consume_token(BEGIN);
    nullprogram();
    jj_consume_token(END);
  }

  final public void nullprogram() throws ParseException {
    if (jj_2_84(1)) {
      program();
    } else {
      ;
    }
  }

  final public void program() throws ParseException {
    label_13:
    while (true) {
      statement();
      if (jj_2_85(1)) {
        ;
      } else {
        break label_13;
      }
    }
  }

  final public void declare() throws ParseException {
         int oldScope = setScope(SCOPE_DEFINE_VARIABLES);
    if (jj_2_86(2)) {
      declare_prefix();
      declaration_list();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DECLARE:
                    ASTSQLStatement jjtn001 = new ASTSQLStatement(JJTSQLSTATEMENT);
                    boolean jjtc001 = true;
                    jjtree.openNodeScope(jjtn001);
                    jjtreeOpenNodeScope(jjtn001);
        try {
          declare_prefix();
          declare_cursor();
        } catch (Throwable jjte001) {
                    if (jjtc001) {
                      jjtree.clearNodeScope(jjtn001);
                      jjtc001 = false;
                    } else {
                      jjtree.popNode();
                    }
                    if (jjte001 instanceof RuntimeException) {
                      {if (true) throw (RuntimeException)jjte001;}
                    }
                    if (jjte001 instanceof ParseException) {
                      {if (true) throw (ParseException)jjte001;}
                    }
                    {if (true) throw (Error)jjte001;}
        } finally {
                    if (jjtc001) {
                      jjtree.closeNodeScope(jjtn001, true);
                      jjtreeCloseNodeScope(jjtn001);
                    }
        }
        break;
      default:
        jj_la1[58] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
     setScope(oldScope);
  }

  final public void declare_cursor() throws ParseException {
                         Token t = null;
    t = idplus();

    cur_sensitivity();
    cur_scrollability();
    jj_consume_token(CURSOR);
    jj_consume_token(FOR);
    select();
  }

  final public void cur_sensitivity() throws ParseException {
    if (jj_2_89(1)) {
      if (jj_2_87(1)) {
        UK_INSENSITIVE();
      } else if (jj_2_88(1)) {
        UK_SEMI_SENSITIVE();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
  }

  final public void cur_scrollability() throws ParseException {
    if (jj_2_92(1)) {
      if (jj_2_90(1)) {
        UK_NO_SCROLL();
      } else if (jj_2_91(1)) {
        UK_SCROLL();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
  }

  final public void declare_prefix() throws ParseException {
                                         /*@bgen(jjtree) DeclareKeyword */
  ASTDeclareKeyword jjtn000 = new ASTDeclareKeyword(JJTDECLAREKEYWORD);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(DECLARE);
    } finally {
                           if (jjtc000) {
                             jjtree.closeNodeScope(jjtn000, true);
                             jjtreeCloseNodeScope(jjtn000);
                           }
    }
  }

  final public void fetch() throws ParseException {
    fetch_orientation();
    fetch_val_spec();
    fetch_from_spec();
    object();
    fetch_into_clause();
  }

  final public void fetch_orientation() throws ParseException {
    jj_consume_token(FETCH);
    if (jj_2_99(2147483647) && (getToken(2).kind != INTO && getToken(2).kind != FROM)) {
      if (jj_2_93(1)) {
        UK_NEXT();
      } else if (jj_2_94(1)) {
        UK_PRIOR();
      } else if (jj_2_95(1)) {
        UK_FIRST();
      } else if (jj_2_96(1)) {
        UK_LAST();
      } else if (jj_2_97(1)) {
        UK_ABSOLUTE();
      } else if (jj_2_98(1)) {
        UK_RELATIVE();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
  }

  final public void fetch_val_spec() throws ParseException {
                         Token t=null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
    case VAR_NAME:
    case PLUS:
    case MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VAR_NAME:
        t = jj_consume_token(VAR_NAME);
        break;
      case INTEGER_LITERAL:
      case PLUS:
      case MINUS:
        number();
        break;
      default:
        jj_la1[59] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[60] = jj_gen;
      ;
    }
  }

  final public void fetch_into_clause() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTO:
      jj_consume_token(INTO);
      fetch_into_list();
      break;
    default:
      jj_la1[61] = jj_gen;
      ;
    }
  }

  final public void fetch_into_list() throws ParseException {
    variable_assignment();
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[62] = jj_gen;
        break label_14;
      }
      jj_consume_token(COMMA);
      variable_assignment();
    }
  }

  final public void fetch_from_spec() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FROM:
      jj_consume_token(FROM);
      break;
    default:
      jj_la1[63] = jj_gen;
      ;
    }
  }

  final public void return_stmt() throws ParseException {
    jj_consume_token(RETURN);
    optional_expression();
  }

  final public void optional_expression() throws ParseException {
    if (jj_2_100(2)) {
      expression();
    } else {
      ;
    }
  }

  final public void if_stmt() throws ParseException {
    if_prefix();
    statement();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELSE:
      jj_consume_token(ELSE);
      statement();
      break;
    default:
      jj_la1[64] = jj_gen;
      ;
    }
  }

  final public void if_prefix() throws ParseException {
    jj_consume_token(IF);
    boolean_expression();
  }

  final public void begin_tran() throws ParseException {
    jj_consume_token(BEGIN);
    tran();
    optional_xact_name();
  }

  final public void commit_tran() throws ParseException {
    jj_consume_token(COMMIT);
    tran_or_work();
    optional_xact_name();
  }

  final public void tran_or_work() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRAN:
    case TRANSACTION:
    case WORK:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRANSACTION:
        jj_consume_token(TRANSACTION);
        break;
      case TRAN:
        jj_consume_token(TRAN);
        break;
      case WORK:
        jj_consume_token(WORK);
        break;
      default:
        jj_la1[65] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[66] = jj_gen;
      ;
    }
  }

  final public void tran() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRANSACTION:
      jj_consume_token(TRANSACTION);
      break;
    case TRAN:
      jj_consume_token(TRAN);
      break;
    default:
      jj_la1[67] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void rollback_tran() throws ParseException {
    jj_consume_token(ROLLBACK);
    tran_or_work();
    optional_xact_name();
  }

  final public void optional_xact_name() throws ParseException {
    if (jj_2_101(2)) {
      xact_name();
    } else {
      ;
    }
  }

  final public void xact_name() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
      jj_consume_token(253);
      jj_consume_token(ID);
      jj_consume_token(DOT);
      jj_consume_token(ID);
      break;
    case ID:
    case SQUARE_BRACKET_ID:
    case VAR_NAME:
    case GLOBAL_VAR_NAME:
    case TEMP_TABLE_NAME:
    case QUESTIONMARK:
      id();
      break;
    default:
      jj_la1[68] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void checkpoint() throws ParseException {
    jj_consume_token(CHECKPOINT);
    optional_name_list_or_all();
  }

  final public void optional_name_list_or_all() throws ParseException {
    if (jj_2_102(1)) {
      UK_ALL();
    } else {
      optional_name_list();
    }
  }

  final public void optional_name_list() throws ParseException {
    if (jj_2_103(2)) {
      name_list();
    } else {
      ;
    }
  }

  final public void name_list() throws ParseException {
    name_item();
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[69] = jj_gen;
        break label_15;
      }
      jj_consume_token(COMMA);
      name_item();
    }
  }

  final public void name_item() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
    case SQUARE_BRACKET_ID:
    case TEMP_TABLE_NAME:
      idplus();
      break;
    case VAR_NAME:
    case GLOBAL_VAR_NAME:
    case QUESTIONMARK:
      variable();
      break;
    default:
      jj_la1[70] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void print() throws ParseException {
    jj_consume_token(PRINT);
    pr_arglist();
  }

  final public void pr_arglist() throws ParseException {
    printstring();
    arglist();
  }

  final public void arglist() throws ParseException {
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[71] = jj_gen;
        break label_16;
      }
      jj_consume_token(COMMA);
      literal();
    }
  }

  final public void printstring() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SINGLE_STRING_LITERAL:
    case DOUBLE_STRING_LITERAL:
      string_literal();
      break;
    case VAR_NAME:
    case GLOBAL_VAR_NAME:
    case QUESTIONMARK:
      variable();
      break;
    case NULL:
      null_stmt();
      break;
    default:
      jj_la1[72] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public Token id_or_string() throws ParseException {
                        Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
    case SQUARE_BRACKET_ID:
    case TEMP_TABLE_NAME:
      t = idplus();
      break;
    case SINGLE_STRING_LITERAL:
    case DOUBLE_STRING_LITERAL:
      t = string_literal();
      break;
    default:
      jj_la1[73] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
              {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

//Special case: "NEW" can be used as id
  final public Token idplus() throws ParseException {
                  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      t = jj_consume_token(ID);
      break;
    case TEMP_TABLE_NAME:
      t = jj_consume_token(TEMP_TABLE_NAME);
      break;
    case SQUARE_BRACKET_ID:
      t = jj_consume_token(SQUARE_BRACKET_ID);
      break;
    default:
      jj_la1[74] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public void select_list() throws ParseException {
    select_expression();
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[75] = jj_gen;
        break label_17;
      }
      jj_consume_token(COMMA);
      select_expression();
    }
  }

  final public void select_expression() throws ParseException {
    if (jj_2_107(2147483647)) {
      select_or_set_variable_assignment();
    } else if (jj_2_108(2147483647)) {
      idplus();
      jj_consume_token(EQUAL);
      if (jj_2_104(1)) {
        expression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENTITY:
          jj_consume_token(IDENTITY);
          jj_consume_token(OPENPAREN);
          jj_consume_token(INTEGER_LITERAL);
          jj_consume_token(CLOSEPAREN);
          break;
        default:
          jj_la1[76] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } else if (jj_2_109(2147483647)) {
      string_literal();
      jj_consume_token(EQUAL);
      expression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASTERISK:
        jj_consume_token(ASTERISK);
        break;
      default:
        jj_la1[79] = jj_gen;
        if (jj_2_110(2147483647)) {
          prefix_list();
          jj_consume_token(ASTERISK);
        } else if (jj_2_111(2147483647)) {
          expression();
          if (jj_2_106(2)) {
            if (jj_2_105(2)) {
              optional_as();
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case ID:
              case SQUARE_BRACKET_ID:
              case TEMP_TABLE_NAME:
                idplus();
                break;
              case SINGLE_STRING_LITERAL:
              case DOUBLE_STRING_LITERAL:
                string_literal();
                break;
              default:
                jj_la1[77] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            } else {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case EQUAL:
                jj_consume_token(EQUAL);
                expression();
                break;
              default:
                jj_la1[78] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          } else {
            ;
          }
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

  final public void select_or_set_variable_assignment() throws ParseException {
    variable_assignment();
    jj_consume_token(EQUAL);
    expression();
  }

  final public void optional_as() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
      break;
    default:
      jj_la1[80] = jj_gen;
      ;
    }
  }

  final public void subquery_select_expression() throws ParseException {
    if (jj_2_112(3)) {
      subq_expression_list();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SINGLE_STRING_LITERAL:
      case DOUBLE_STRING_LITERAL:
      case ID:
      case SQUARE_BRACKET_ID:
      case TEMP_TABLE_NAME:
      case DOT:
      case ASTERISK:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SINGLE_STRING_LITERAL:
        case DOUBLE_STRING_LITERAL:
        case ID:
        case SQUARE_BRACKET_ID:
        case TEMP_TABLE_NAME:
        case DOT:
          prefix_list();
          break;
        default:
          jj_la1[81] = jj_gen;
          ;
        }
        jj_consume_token(ASTERISK);
        break;
      default:
        jj_la1[82] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void declaration_list() throws ParseException {
    declaration();
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[83] = jj_gen;
        break label_18;
      }
      comma();
      declaration();
    }
  }

  final public void comma() throws ParseException {
                              /*@bgen(jjtree) DeclareComma */
  ASTDeclareComma jjtn000 = new ASTDeclareComma(JJTDECLARECOMMA);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(COMMA);
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
            jjtreeCloseNodeScope(jjtn000);
          }
    }
  }

  final public void declaration() throws ParseException {
                               /*@bgen(jjtree) SQLParam */
                               ASTSQLParam jjtn000 = new ASTSQLParam(JJTSQLPARAM);
                               boolean jjtc000 = true;
                               jjtree.openNodeScope(jjtn000);
                               jjtreeOpenNodeScope(jjtn000);Token name=null; String defaultValue=null; Node type=null; int direction = 0;
    try {
      try {
        name = jj_consume_token(VAR_NAME);
        type = base_datatype();
        defaultValue = optional_param_default();
        direction = param_options();
      } catch (ParseException e) {
            exceptions.add(e);
            error_skiptobefore(new int[]{}, new int[]{COMMA, CLOSEPAREN, WITH, AS});
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          jjtreeCloseNodeScope(jjtn000);
        ((ASTSQLParam)jjtn000).setName(name.image);
        ((ASTSQLParam)jjtn000).setType(type.toString());
        ((ASTSQLParam)jjtn000).setTypeObject((ASTSQLDataType)type);
        if (defaultValue != null){
            ((ASTSQLParam)jjtn000).setDefaultValue(defaultValue);
        }
        ((ASTSQLParam)jjtn000).setDirection(direction);
    } catch (Throwable jjte000) {
                  if (jjtc000) {
                    jjtree.clearNodeScope(jjtn000);
                    jjtc000 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte000 instanceof RuntimeException) {
                    {if (true) throw (RuntimeException)jjte000;}
                  }
                  if (jjte000 instanceof ParseException) {
                    {if (true) throw (ParseException)jjte000;}
                  }
                  {if (true) throw (Error)jjte000;}
    } finally {
                  if (jjtc000) {
                    jjtree.closeNodeScope(jjtn000, true);
                    jjtreeCloseNodeScope(jjtn000);
                  }
    }
  }

  final public String optional_param_default() throws ParseException {
                                   String t = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQUAL:
      jj_consume_token(EQUAL);
      t = literal();
      break;
    default:
      jj_la1[84] = jj_gen;
      ;
    }
                         {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public int param_options() throws ParseException {
                       int direction = 0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IN:
    case OUT:
    case OUTPUT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IN:
        jj_consume_token(IN);
        break;
      case OUT:
      case OUTPUT:
        out_option();
                              direction = 1;
        break;
      default:
        jj_la1[85] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[86] = jj_gen;
      ;
    }
             {if (true) return direction;}
    throw new Error("Missing return statement in function");
  }

  final public void out_option() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OUT:
      jj_consume_token(OUT);
      break;
    case OUTPUT:
      jj_consume_token(OUTPUT);
      break;
    default:
      jj_la1[87] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void holdlock() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HOLDLOCK:
    case NOHOLDLOCK:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HOLDLOCK:
        jj_consume_token(HOLDLOCK);
        break;
      case NOHOLDLOCK:
        jj_consume_token(NOHOLDLOCK);
        break;
      default:
        jj_la1[88] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[89] = jj_gen;
      ;
    }
  }

  final public void shared() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SHARED:
      jj_consume_token(SHARED);
      break;
    default:
      jj_la1[90] = jj_gen;
      ;
    }
  }

  final public void readpast() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case READPAST:
      jj_consume_token(READPAST);
      break;
    default:
      jj_la1[91] = jj_gen;
      ;
    }
  }

  final public void forceoptions() throws ParseException {
    if (jj_2_115(2)) {
      jj_consume_token(OPENPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INDEX:
      case PARTITION:
      case INTEGER_LITERAL:
      case ID:
      case OPENPAREN:
        if (jj_2_114(2)) {
          jj_consume_token(INTEGER_LITERAL);
          if (jj_2_113(2)) {
            forceoption_terms();
          } else {
            ;
          }
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case PARTITION:
            jj_consume_token(PARTITION);
            jj_consume_token(ID);
            break;
          case INDEX:
          case ID:
          case OPENPAREN:
            forceoption_terms();
            break;
          default:
            jj_la1[92] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
      default:
        jj_la1[93] = jj_gen;
        ;
      }
      jj_consume_token(CLOSEPAREN);
    } else {
      ;
    }
  }

  final public void forceoption_terms() throws ParseException {
    label_19:
    while (true) {
      forceoption_term();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INDEX:
      case ID:
      case OPENPAREN:
        ;
        break;
      default:
        jj_la1[94] = jj_gen;
        break label_19;
      }
    }
  }

  final public void forceoption_term() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INDEX:
      forceindex();
      break;
    case ID:
    case OPENPAREN:
      forcestrategy();
      break;
    default:
      jj_la1[95] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void forceindex() throws ParseException {
    jj_consume_token(INDEX);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
      break;
    case ID:
    case SQUARE_BRACKET_ID:
    case TEMP_TABLE_NAME:
      idplus();
      break;
    default:
      jj_la1[96] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void forcestrategy() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      jj_consume_token(ID);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case PLUS:
      case MINUS:
        number();
        break;
      default:
        jj_la1[97] = jj_gen;
        ;
      }
      break;
    case OPENPAREN:
      jj_consume_token(OPENPAREN);
      jj_consume_token(ID);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
        jj_consume_token(ID);
        jj_consume_token(CLOSEPAREN);
        break;
      case INTEGER_LITERAL:
      case PLUS:
      case MINUS:
        number();
        number();
        jj_consume_token(CLOSEPAREN);
        break;
      default:
        jj_la1[98] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[99] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void inner_join() throws ParseException {
    if (jj_2_116(1)) {
      UK_INNER();
    } else {
      ;
    }
    jj_consume_token(JOIN);
  }

  final public void oj_operator() throws ParseException {
    if (jj_2_119(1)) {
      UK_LEFT();
      if (jj_2_117(1)) {
        UK_OUTER();
      } else {
        ;
      }
      jj_consume_token(JOIN);
    } else if (jj_2_120(1)) {
      UK_RIGHT();
      if (jj_2_118(1)) {
        UK_OUTER();
      } else {
        ;
      }
      jj_consume_token(JOIN);
    } else if (jj_2_121(1)) {
      inner_join();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void oj_expr() throws ParseException {
    jj_consume_token(OPENPAREN);
    oj_clause();
    jj_consume_token(CLOSEPAREN);
  }

  final public void oj_clause() throws ParseException {
    from_item();
    oj_operator();
    from_item();
    jj_consume_token(ON);
    boolean_expression();
  }

  final public void from_where_clause() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FROM:
    case WHERE:
      if (jj_2_122(2)) {
        jj_consume_token(WHERE);
        jj_consume_token(CURRENT);
        jj_consume_token(OF);
        object();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FROM:
          from_clause();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case WHERE:
            where_clause();
            break;
          default:
            jj_la1[100] = jj_gen;
            ;
          }
          break;
        case WHERE:
          where_clause();
          break;
        default:
          jj_la1[101] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    default:
      jj_la1[102] = jj_gen;
      ;
    }
  }

  final public void where_current_clause() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      if (jj_2_123(2)) {
        jj_consume_token(WHERE);
        jj_consume_token(CURRENT);
        jj_consume_token(OF);
        object();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHERE:
          where_clause();
          break;
        default:
          jj_la1[103] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    default:
      jj_la1[104] = jj_gen;
      ;
    }
  }

  final public void from_clause() throws ParseException {
    jj_consume_token(FROM);
    from_list();
  }

  final public void optional_from_clause() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FROM:
      from_clause();
      break;
    default:
      jj_la1[105] = jj_gen;
      ;
    }
  }

  final public void from_list() throws ParseException {
    from_table();
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[106] = jj_gen;
        break label_20;
      }
      jj_consume_token(COMMA);
      from_table();

    }
  }

  final public void from_table() throws ParseException {
     setScope("from_clause", SCOPE_TABLES);
    from_item();
         setScope("from_clause", SCOPE_DEFAULT);
  }

  final public void from_item() throws ParseException {
                    String retval = null;
    if (jj_2_126(2147483647)) {
      retval = from_unit();
      label_21:
      while (true) {
        if (jj_2_124(2)) {
          ;
        } else {
          break label_21;
        }
        oj_operator();
        retval = from_unit();
        jj_consume_token(ON);
                                         setScope("from_item", SCOPE_COLUMNS);
        boolean_expression();
      }
    } else if (jj_2_127(3)) {
      jj_consume_token(OPENPAREN);
      retval = from_unit();
      label_22:
      while (true) {
        oj_operator();
        retval = from_unit();
        jj_consume_token(ON);
        boolean_expression();
        if (jj_2_125(2)) {
          ;
        } else {
          break label_22;
        }
      }
      jj_consume_token(CLOSEPAREN);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public String from_unit() throws ParseException {
                      String retval = null; Token aliasNameToken = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SINGLE_STRING_LITERAL:
    case DOUBLE_STRING_LITERAL:
    case ID:
    case SQUARE_BRACKET_ID:
    case TEMP_TABLE_NAME:
    case DOT:
      retval = table_object();
      if ((getToken(1).kind == AS || getToken(1).kind == ID) && !(getToken(1).image.equalsIgnoreCase("inner") || getToken(1).image.equalsIgnoreCase("left") || getToken(1).image.equalsIgnoreCase("right"))) {
        optional_as();
        aliasNameToken = idplus();
      } else {
        ;
      }
      forceoptions();
      holdlock();
      readpast();
      shared();
      break;
    case OPENPAREN:
      jj_consume_token(OPENPAREN);
      select();
      jj_consume_token(CLOSEPAREN);
      optional_as();
      derived_table_name();
      optional_derived_col_name_list();
      holdlock();
      readpast();
      shared();
      break;
    default:
      jj_la1[107] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     {if (true) return retval;}
    throw new Error("Missing return statement in function");
  }

  final public void derived_table_name() throws ParseException {
    if (!(getToken(1).image.equalsIgnoreCase("inner") || getToken(1).image.equalsIgnoreCase("left") || getToken(1).image.equalsIgnoreCase("right"))) {
      idplus();
    } else {
      ;
    }
  }

  final public void optional_derived_col_name_list() throws ParseException {
    if (jj_2_128(2)) {
      jj_consume_token(OPENPAREN);
      derived_column_list();
      jj_consume_token(CLOSEPAREN);
    } else {
      ;
    }
  }

  final public void derived_column_list() throws ParseException {
    derived_col_name();
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[108] = jj_gen;
        break label_23;
      }
      jj_consume_token(COMMA);
      derived_col_name();
    }
  }

  final public void derived_col_name() throws ParseException {
    idplus();
  }

  final public void where_clause() throws ParseException {
                       setScope("from_clause", SCOPE_COLUMNS);
    jj_consume_token(WHERE);
    boolean_expression();
                          setScope("where_clause", SCOPE_DEFAULT);
  }

  final public void boolean_expression() throws ParseException {
    boolean_term();
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
        ;
        break;
      default:
        jj_la1[109] = jj_gen;
        break label_24;
      }
      jj_consume_token(OR);
      boolean_term();
    }
  }

  final public void boolean_term() throws ParseException {
    boolean_factor();
    label_25:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        ;
        break;
      default:
        jj_la1[110] = jj_gen;
        break label_25;
      }
      jj_consume_token(AND);
      boolean_factor();
    }
  }

  final public void boolean_factor() throws ParseException {
    if (jj_2_129(1)) {
      boolean_primary();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
        boolean_primary();
        break;
      default:
        jj_la1[111] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void boolean_primary() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UPDATE:
      boolean_function();
      break;
    default:
      jj_la1[112] = jj_gen;
      if (jj_2_130(2147483647)) {
        jj_consume_token(OPENPAREN);
        boolean_expression();
        jj_consume_token(CLOSEPAREN);
      } else if (jj_2_131(1)) {
        predicate();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void group_by_clause() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GROUP:
      jj_consume_token(GROUP);
      jj_consume_token(BY);
      by_all();
      group_by_list();
      break;
    default:
      jj_la1[113] = jj_gen;
      ;
    }
  }

  final public void by_all() throws ParseException {
    if (jj_2_132(1)) {
      UK_ALL();
    } else {
      ;
    }
  }

  final public void group_by_list() throws ParseException {
    group_by_item();
    label_26:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[114] = jj_gen;
        break label_26;
      }
      jj_consume_token(COMMA);
      group_by_item();
    }
  }

  final public void group_by_item() throws ParseException {
                          setScope("group_clause", SCOPE_COLUMNS);
    expression();
                          setScope("group_clause", SCOPE_DEFAULT);
  }

  final public void having_clause() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HAVING:
      jj_consume_token(HAVING);
                                    setScope("having_clause", SCOPE_COLUMNS);
      boolean_expression();
                                                                                                     setScope("having_clause", SCOPE_DEFAULT);
      break;
    default:
      jj_la1[115] = jj_gen;
      ;
    }
  }

  final public void order_by_clause() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      jj_consume_token(ORDER);
      jj_consume_token(BY);
      order_by_list();
      break;
    default:
      jj_la1[116] = jj_gen;
      ;
    }
  }

  final public void order_by_list() throws ParseException {
    order_by_item();
    label_27:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[117] = jj_gen;
        break label_27;
      }
      jj_consume_token(COMMA);
      order_by_item();
    }
  }

  final public void order_by_item() throws ParseException {
                        setScope("order_by_clause", SCOPE_COLUMNS);
    expression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASC:
    case DESC:
      order_by_option();
      break;
    default:
      jj_la1[118] = jj_gen;
      ;
    }
                                                    setScope("order_by_clause", SCOPE_DEFAULT);
  }

  final public void order_by_option() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASC:
      jj_consume_token(ASC);
      break;
    case DESC:
      jj_consume_token(DESC);
      break;
    default:
      jj_la1[119] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void compute_clause() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMPUTE:
      compute_statement_list();
      break;
    default:
      jj_la1[120] = jj_gen;
      ;
    }
  }

  final public void compute_statement_list() throws ParseException {
    compute_statement();
    label_28:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMPUTE:
        ;
        break;
      default:
        jj_la1[121] = jj_gen;
        break label_28;
      }
      compute_statement();
    }
  }

  final public void compute_statement() throws ParseException {
    jj_consume_token(COMPUTE);
    compute_list();
                                                 setScope("compute_statement", SCOPE_DEFAULT);
    optional_compute_by_list();
  }

  final public void compute_list() throws ParseException {
    compute_function();
    label_29:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[122] = jj_gen;
        break label_29;
      }
      jj_consume_token(COMMA);
      compute_function();
    }
  }

  final public void compute_function() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COUNT:
      jj_consume_token(COUNT);
      jj_consume_token(OPENPAREN);
                                                 setScope("compute_function", SCOPE_COLUMNS);
      expression();
      jj_consume_token(CLOSEPAREN);
      break;
    case AVG:
      jj_consume_token(AVG);
      jj_consume_token(OPENPAREN);
                                     setScope("compute_function", SCOPE_COLUMNS);
      expression();
      jj_consume_token(CLOSEPAREN);
      break;
    case MAX:
      jj_consume_token(MAX);
      jj_consume_token(OPENPAREN);
                                     setScope("compute_function", SCOPE_COLUMNS);
      expression();
      jj_consume_token(CLOSEPAREN);
      break;
    case MIN:
      jj_consume_token(MIN);
      jj_consume_token(OPENPAREN);
                                     setScope("compute_function", SCOPE_COLUMNS);
      expression();
      jj_consume_token(CLOSEPAREN);
      break;
    case SUM:
      jj_consume_token(SUM);
      jj_consume_token(OPENPAREN);
                                     setScope("compute_function", SCOPE_COLUMNS);
      expression();
      jj_consume_token(CLOSEPAREN);
      break;
    default:
      jj_la1[123] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void optional_compute_by_list() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BY:
      jj_consume_token(BY);
      compute_by_list();
      break;
    default:
      jj_la1[124] = jj_gen;
      ;
    }
  }

  final public void compute_by_list() throws ParseException {
    compute_by_item();
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[125] = jj_gen;
        break label_30;
      }
      jj_consume_token(COMMA);
      compute_by_item();
    }
  }

  final public void compute_by_item() throws ParseException {
                         setScope("compute_by_item", SCOPE_COLUMNS);
    expression();
  }

  final public void predicate() throws ParseException {
    if (jj_2_140(2147483647)) {
      exists_predicate();
    } else if (jj_2_141(2147483647)) {
      expression();
      if (jj_2_133(2147483647)) {
        any_predicate();
      } else if (jj_2_134(2147483647)) {
        all_predicate();
      } else if (jj_2_135(2147483647)) {
        comparison_predicate();
      } else if (jj_2_136(2147483647)) {
        between_predicate();
      } else if (jj_2_137(2147483647)) {
        null_predicate();
      } else if (jj_2_138(2147483647)) {
        in_predicate();
      } else if (jj_2_139(2147483647)) {
        like_predicate();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else if (jj_2_142(2147483647)) {
      row_constructor();
      row_comparison_predicate();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void predicate_op() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXISTS:
      jj_consume_token(EXISTS);
      break;
    default:
      jj_la1[130] = jj_gen;
      if (jj_2_143(2147483647)) {
        expression();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LESS:
        case LESSEQUAL:
        case GREATER:
        case GREATEREQUAL:
        case EQUAL:
        case NOTEQUAL:
        case 254:
        case 255:
        case 256:
        case 257:
          comp_op();
          break;
        case LEQJOIN:
        case REQJOIN:
          join_op();
          break;
        case BETWEEN:
        case IN:
        case LIKE:
        case NOT:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NOT:
            jj_consume_token(NOT);
            break;
          default:
            jj_la1[126] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case BETWEEN:
            jj_consume_token(BETWEEN);
            break;
          case IN:
            jj_consume_token(IN);
            break;
          case LIKE:
            jj_consume_token(LIKE);
            break;
          default:
            jj_la1[127] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        case IS:
          jj_consume_token(IS);
          break;
        default:
          jj_la1[128] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OPENPAREN:
          row_constructor();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LESS:
          case LESSEQUAL:
          case GREATER:
          case GREATEREQUAL:
          case EQUAL:
          case NOTEQUAL:
          case 254:
          case 255:
          case 256:
          case 257:
            comp_op();
            break;
          case LEQJOIN:
          case REQJOIN:
            join_op();
            break;
          default:
            jj_la1[129] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[131] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

  final public void comparison_predicate() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LESS:
    case LESSEQUAL:
    case GREATER:
    case GREATEREQUAL:
    case EQUAL:
    case NOTEQUAL:
    case 254:
    case 255:
    case 256:
    case 257:
      comp_op();
      break;
    case LEQJOIN:
    case REQJOIN:
      join_op();
      break;
    default:
      jj_la1[132] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    expression();
  }

  final public void row_comparison_predicate() throws ParseException {
    comp_op();
    row_constructor();
  }

  final public void comp_op() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQUAL:
      jj_consume_token(EQUAL);
      break;
    case 254:
      jj_consume_token(254);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LESS:
      case GREATER:
      case EQUAL:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case GREATER:
          jj_consume_token(GREATER);
          break;
        case EQUAL:
          jj_consume_token(EQUAL);
          break;
        case LESS:
          jj_consume_token(LESS);
          break;
        default:
          jj_la1[133] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[134] = jj_gen;
        ;
      }
      break;
    case 255:
      jj_consume_token(255);
      break;
    case NOTEQUAL:
      jj_consume_token(NOTEQUAL);
      break;
    case 256:
      jj_consume_token(256);
      break;
    case GREATER:
      jj_consume_token(GREATER);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQUAL:
        jj_consume_token(EQUAL);
        break;
      default:
        jj_la1[135] = jj_gen;
        ;
      }
      break;
    case GREATEREQUAL:
      jj_consume_token(GREATEREQUAL);
      break;
    case LESS:
      jj_consume_token(LESS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GREATER:
      case EQUAL:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case GREATER:
          jj_consume_token(GREATER);
          break;
        case EQUAL:
          jj_consume_token(EQUAL);
          break;
        default:
          jj_la1[136] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[137] = jj_gen;
        ;
      }
      break;
    case 257:
      jj_consume_token(257);
      break;
    case LESSEQUAL:
      jj_consume_token(LESSEQUAL);
      break;
    default:
      jj_la1[138] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void join_op() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LEQJOIN:
      jj_consume_token(LEQJOIN);
      break;
    case REQJOIN:
      jj_consume_token(REQJOIN);
      break;
    default:
      jj_la1[139] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void between_predicate() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
      break;
    default:
      jj_la1[140] = jj_gen;
      ;
    }
    jj_consume_token(BETWEEN);
    expression();
    jj_consume_token(AND);
    expression();
  }

  final public void null_predicate() throws ParseException {
    jj_consume_token(IS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
      break;
    default:
      jj_la1[141] = jj_gen;
      ;
    }
    null_stmt();
  }

  final public void in_predicate() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
      break;
    default:
      jj_la1[142] = jj_gen;
      ;
    }
    jj_consume_token(IN);
    jj_consume_token(OPENPAREN);
    if (jj_2_144(1)) {
      in_value_list();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SELECT:
        jj_consume_token(SELECT);
        subq_select();
        break;
      default:
        jj_la1[143] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(CLOSEPAREN);
  }

  final public void in_value_list() throws ParseException {
    expression();
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[144] = jj_gen;
        break label_31;
      }
      jj_consume_token(COMMA);
      expression();
    }
  }

  final public void any_predicate() throws ParseException {
    comp_op();
    jj_consume_token(ANY);
    subquery();
  }

  final public void all_predicate() throws ParseException {
    comp_op();
    UK_ALL();
    subquery();
  }

  final public void exists_predicate() throws ParseException {
    jj_consume_token(EXISTS);
    subquery();
  }

  final public void like_predicate() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
      break;
    default:
      jj_la1[145] = jj_gen;
      ;
    }
    jj_consume_token(LIKE);
    pattern_clause();
  }

  final public void pattern_clause() throws ParseException {
    expression();
    escape_clause();
  }

  final public void escape_clause() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ESCAPE:
      jj_consume_token(ESCAPE);
      expression();
      break;
    default:
      jj_la1[146] = jj_gen;
      ;
    }
  }

  final public void row_constructor() throws ParseException {
    jj_consume_token(OPENPAREN);
    row_constructor_list();
    jj_consume_token(CLOSEPAREN);
  }

  final public void row_constructor_list() throws ParseException {
    row_constructor_elem();
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[147] = jj_gen;
        break label_32;
      }
      jj_consume_token(COMMA);
      row_constructor_elem();
    }
  }

  final public void row_constructor_elem() throws ParseException {
    expression();
  }

  final public ASTExpression expression() throws ParseException {
                                         /*@bgen(jjtree) Expression */
  ASTExpression jjtn000 = new ASTExpression(JJTEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      term();
      label_33:
      while (true) {
        if (jj_2_145(3)) {
          ;
        } else {
          break label_33;
        }
        if (jj_2_146(3)) {
          jj_consume_token(258);
          jj_consume_token(258);
        } else if (jj_2_147(2)) {
          jj_consume_token(PLUS);
        } else if (jj_2_148(2)) {
          jj_consume_token(MINUS);
        } else if (jj_2_149(2)) {
          jj_consume_token(259);
        } else if (jj_2_150(2)) {
          jj_consume_token(258);
        } else if (jj_2_151(2)) {
          jj_consume_token(260);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        term();
      }
             jjtree.closeNodeScope(jjtn000, true);
             jjtc000 = false;
             jjtreeCloseNodeScope(jjtn000);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
                           if (jjtc000) {
                             jjtree.clearNodeScope(jjtn000);
                             jjtc000 = false;
                           } else {
                             jjtree.popNode();
                           }
                           if (jjte000 instanceof RuntimeException) {
                             {if (true) throw (RuntimeException)jjte000;}
                           }
                           if (jjte000 instanceof ParseException) {
                             {if (true) throw (ParseException)jjte000;}
                           }
                           {if (true) throw (Error)jjte000;}
    } finally {
                           if (jjtc000) {
                             jjtree.closeNodeScope(jjtn000, true);
                             jjtreeCloseNodeScope(jjtn000);
                           }
    }
    throw new Error("Missing return statement in function");
  }

  final public void term() throws ParseException {
    factor();
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASTERISK:
      case SLASH:
      case 261:
        ;
        break;
      default:
        jj_la1[148] = jj_gen;
        break label_34;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASTERISK:
        jj_consume_token(ASTERISK);
        factor();
        break;
      case SLASH:
        jj_consume_token(SLASH);
        factor();
        break;
      case 261:
        jj_consume_token(261);
        factor();
        break;
      default:
        jj_la1[149] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void factor() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TILDE:
      jj_consume_token(TILDE);
      break;
    default:
      jj_la1[150] = jj_gen;
      ;
    }
    subfactor();
  }

  final public void subfactor() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
        break;
      case MINUS:
        jj_consume_token(MINUS);
        break;
      default:
        jj_la1[151] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[152] = jj_gen;
      ;
    }
    primary();
  }

  final public void primary_1() throws ParseException {
    if (jj_2_152(2147483647)) {
      constant();
    } else if (jj_2_153(2147483647)) {
      subquery();
    } else if (jj_2_154(2147483647)) {
      function();
    } else if (jj_2_155(2147483647)) {
      column();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CASE:
      case COALESCE:
      case NULLIF:
        case_expression();
        break;
      case OPENPAREN:
        jj_consume_token(OPENPAREN);
        expression();
        jj_consume_token(CLOSEPAREN);
        break;
      default:
        jj_la1[153] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

//supports javaname>>javaref
  final public void primary() throws ParseException {
    primary_1();
    label_35:
    while (true) {
      if (jj_2_156(2)) {
        ;
      } else {
        break label_35;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        jj_consume_token(DOT);
        break;
      case JAVA_REF:
        jj_consume_token(JAVA_REF);
        break;
      default:
        jj_la1[154] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      id_or_string();
      if (jj_2_157(2)) {
        jj_consume_token(OPENPAREN);
        expression_list();
        jj_consume_token(CLOSEPAREN);
      } else {
        ;
      }
    }
  }

  final public void case_expression() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COALESCE:
    case NULLIF:
      case_abbreviation();
      break;
    case CASE:
      case_specification();
      break;
    default:
      jj_la1[155] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void case_abbreviation() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULLIF:
      nullif_format();
      break;
    case COALESCE:
      coalesce_format();
      break;
    default:
      jj_la1[156] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void case_specification() throws ParseException {
    jj_consume_token(CASE);
    simple_or_searched_case();
  }

  final public void simple_or_searched_case() throws ParseException {
    if (jj_2_158(1)) {
      simple_case();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHEN:
        searched_case();
        break;
      default:
        jj_la1[157] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void simple_case() throws ParseException {
    expression();
    simple_when_clause_list();
    optional_else_clause();
    jj_consume_token(END);
  }

  final public void searched_case() throws ParseException {
    searched_when_clause_list();
    optional_else_clause();
    jj_consume_token(END);
  }

  final public void simple_when_clause_list() throws ParseException {
    simple_when_clause();
    label_36:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHEN:
        ;
        break;
      default:
        jj_la1[158] = jj_gen;
        break label_36;
      }
      simple_when_clause();
    }
  }

  final public void simple_when_clause() throws ParseException {
    jj_consume_token(WHEN);
    expression();
    UK_THEN();
    result();
  }

  final public void searched_when_clause_list() throws ParseException {
    searched_when_clause();
    label_37:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHEN:
        ;
        break;
      default:
        jj_la1[159] = jj_gen;
        break label_37;
      }
      searched_when_clause();
    }
  }

  final public void searched_when_clause() throws ParseException {
    jj_consume_token(WHEN);
    boolean_expression();
    UK_THEN();
    result();
  }

  final public void optional_else_clause() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELSE:
      jj_consume_token(ELSE);
      result();
      break;
    default:
      jj_la1[160] = jj_gen;
      ;
    }
  }

  final public void result() throws ParseException {
    expression();
  }

  final public void coalesce_format() throws ParseException {
    jj_consume_token(COALESCE);
    jj_consume_token(OPENPAREN);
    coalesce_list();
    jj_consume_token(CLOSEPAREN);
  }

  final public void coalesce_list() throws ParseException {
    coalesce_element();
    label_38:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[161] = jj_gen;
        break label_38;
      }
      jj_consume_token(COMMA);
      coalesce_element();
    }
  }

  final public void coalesce_element() throws ParseException {
    expression();
  }

  final public void nullif_format() throws ParseException {
    jj_consume_token(NULLIF);
    jj_consume_token(OPENPAREN);
    expression();
    jj_consume_token(COMMA);
    expression();
    jj_consume_token(CLOSEPAREN);
  }

//database object such as: table, procedure, view, cursor...
  final public String object() throws ParseException {
                   String retval = ""; Token t;
    if (jj_2_159(2147483647)) {
      retval = prefix_list();
    } else {
      ;
    }
    t = id_or_string();
        {if (true) return retval + t.image;}
    throw new Error("Missing return statement in function");
  }

  final public String table_object() throws ParseException {
                         String retval = ""; Token t=null;
    if (jj_2_160(2147483647)) {
      retval = prefix_list();
    } else {
      ;
    }
    t = id_or_string();
        {if (true) return retval + t.image;}
    throw new Error("Missing return statement in function");
  }

  final public void procedure() throws ParseException {
    proc_name();
  }

  final public String proc_name() throws ParseException {
                      String s = null; Token t = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SINGLE_STRING_LITERAL:
    case DOUBLE_STRING_LITERAL:
    case ID:
    case SQUARE_BRACKET_ID:
    case TEMP_TABLE_NAME:
    case DOT:
      s = object();
      break;
    case VAR_NAME:
    case GLOBAL_VAR_NAME:
    case QUESTIONMARK:
      t = variable();
      break;
    default:
      jj_la1[162] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                if ( t != null )
                {
                        s = t.image;
                }
                {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public void column() throws ParseException {
    if (jj_2_161(2147483647)) {
      prefix_list();
      id_or_string();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
      case SQUARE_BRACKET_ID:
      case TEMP_TABLE_NAME:
        idplus();
        break;
      default:
        jj_la1[163] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public String prefix_list() throws ParseException {
                        String retval = "", pre = "";
    label_39:
    while (true) {
      pre = prefix();
                                                               retval += pre;
      if (jj_2_162(2147483647)) {
        ;
      } else {
        break label_39;
      }
    }
             {if (true) return retval;}
    throw new Error("Missing return statement in function");
  }

  final public String prefix() throws ParseException {
                   Token t = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOT:
      jj_consume_token(DOT);
      break;
    case SINGLE_STRING_LITERAL:
    case DOUBLE_STRING_LITERAL:
    case ID:
    case SQUARE_BRACKET_ID:
    case TEMP_TABLE_NAME:
      t = id_or_string();
      jj_consume_token(DOT);
      break;
    default:
      jj_la1[164] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                         {if (true) return t == null?".":t.image + ".";}
    throw new Error("Missing return statement in function");
  }

  final public Token id() throws ParseException {
              Token t = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
    case SQUARE_BRACKET_ID:
    case TEMP_TABLE_NAME:
      t = idplus();
      break;
    case VAR_NAME:
    case GLOBAL_VAR_NAME:
    case QUESTIONMARK:
      t = variable();
      break;
    default:
      jj_la1[165] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public void string() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SINGLE_STRING_LITERAL:
    case DOUBLE_STRING_LITERAL:
      string_literal();
      break;
    case VAR_NAME:
    case GLOBAL_VAR_NAME:
    case QUESTIONMARK:
      variable();
      break;
    default:
      jj_la1[166] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void id_string() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
    case SQUARE_BRACKET_ID:
    case TEMP_TABLE_NAME:
      idplus();
      break;
    case DOUBLE_STRING_LITERAL:
      jj_consume_token(DOUBLE_STRING_LITERAL);
      break;
    case VAR_NAME:
    case GLOBAL_VAR_NAME:
    case QUESTIONMARK:
      variable();
      break;
    default:
      jj_la1[167] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void integer() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
      break;
    case VAR_NAME:
    case GLOBAL_VAR_NAME:
    case QUESTIONMARK:
      variable();
      break;
    default:
      jj_la1[168] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public int number() throws ParseException {
                int retval = 0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
      jj_consume_token(MINUS);
      jj_consume_token(INTEGER_LITERAL);
                                try {retval = Integer.parseInt("-" + getToken(0).image);}catch(Exception e){}
      break;
    case INTEGER_LITERAL:
    case PLUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
        break;
      default:
        jj_la1[169] = jj_gen;
        ;
      }
      jj_consume_token(INTEGER_LITERAL);
                                    try {retval = Integer.parseInt(getToken(0).image);}catch(Exception e){}
      break;
    default:
      jj_la1[170] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return retval;}
    throw new Error("Missing return statement in function");
  }

  final public void constant() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case MONEY_LITERAL:
      signed_const();
      break;
    case NULL:
    case SINGLE_STRING_LITERAL:
    case DOUBLE_STRING_LITERAL:
    case BINARY_LITERAL:
    case VAR_NAME:
    case GLOBAL_VAR_NAME:
    case QUESTIONMARK:
      unsigned_const();
      break;
    default:
      jj_la1[171] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public Token signed_const() throws ParseException {
                        Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      t = jj_consume_token(INTEGER_LITERAL);
      break;
    case FLOATING_POINT_LITERAL:
      t = jj_consume_token(FLOATING_POINT_LITERAL);
      break;
    case MONEY_LITERAL:
      t = jj_consume_token(MONEY_LITERAL);
      break;
    default:
      jj_la1[172] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
              {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token unsigned_const() throws ParseException {
                          Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BINARY_LITERAL:
      t = jj_consume_token(BINARY_LITERAL);
      break;
    case SINGLE_STRING_LITERAL:
    case DOUBLE_STRING_LITERAL:
      t = string_literal();
      break;
    case NULL:
      t = null_stmt();
      break;
    case VAR_NAME:
    case GLOBAL_VAR_NAME:
    case QUESTIONMARK:
      t = variable();
      break;
    default:
      jj_la1[173] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public String literal() throws ParseException {
                    Token t; boolean negative = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case MONEY_LITERAL:
    case PLUS:
    case MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
          jj_consume_token(PLUS);
          break;
        case MINUS:
          jj_consume_token(MINUS);
                        negative = true;
          break;
        default:
          jj_la1[174] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[175] = jj_gen;
        ;
      }
      t = signed_const();
      break;
    case NULL:
    case SINGLE_STRING_LITERAL:
    case DOUBLE_STRING_LITERAL:
    case BINARY_LITERAL:
    case VAR_NAME:
    case GLOBAL_VAR_NAME:
    case QUESTIONMARK:
      t = unsigned_const();
      break;
    case ID:
    case SQUARE_BRACKET_ID:
    case TEMP_TABLE_NAME:
      t = idplus();
      break;
    case PRIMARY:
      t = jj_consume_token(PRIMARY);
      break;
    case FOREIGN:
      t = jj_consume_token(FOREIGN);
      break;
    default:
      jj_la1[176] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          {if (true) return negative?"-"+t.image:t.image;}
    throw new Error("Missing return statement in function");
  }

  final public void binary() throws ParseException {
    if (jj_2_163(1)) {
      UK_BINARY();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VAR_NAME:
      case GLOBAL_VAR_NAME:
      case QUESTIONMARK:
        variable();
        break;
      default:
        jj_la1[177] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public Token null_stmt() throws ParseException {
                     Token t;
    t = jj_consume_token(NULL);
                          {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

//variable reference
  final public Token variable() throws ParseException {
                    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VAR_NAME:
      t = jj_consume_token(VAR_NAME);
      break;
    case QUESTIONMARK:
      t = dyn_question_mark();
      break;
    case GLOBAL_VAR_NAME:
      t = jj_consume_token(GLOBAL_VAR_NAME);
      break;
    default:
      jj_la1[178] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token variable_assignment() throws ParseException {
                               Token t;
    t = jj_consume_token(VAR_NAME);
          {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token dyn_question_mark() throws ParseException {
                             Token t;
    t = jj_consume_token(QUESTIONMARK);
                          {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

//include field reference and method reference
  final public void java_memberref() throws ParseException {
    primary_1();
    label_40:
    while (true) {
      if (jj_2_164(3)) {
        ;
      } else {
        break label_40;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        jj_consume_token(DOT);
        break;
      case JAVA_REF:
        jj_consume_token(JAVA_REF);
        break;
      default:
        jj_la1[179] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      id_or_string();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OPENPAREN:
        jj_consume_token(OPENPAREN);
        expression_list();
        jj_consume_token(CLOSEPAREN);
        break;
      default:
        jj_la1[180] = jj_gen;
        ;
      }
    }
  }

  final public void function() throws ParseException {
    if (jj_2_165(1)) {
      java_constructor();
    } else if (jj_2_166(2)) {
      builtin_function();
    } else if (jj_2_167(2)) {
      agg_function();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void builtin_function() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONVERT:
      jj_consume_token(CONVERT);
      jj_consume_token(OPENPAREN);
      datatype();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NULL:
        jj_consume_token(NULL);
        break;
      default:
        jj_la1[181] = jj_gen;
        ;
      }
      jj_consume_token(COMMA);
      expression();
      optional_comma_argument();
      jj_consume_token(CLOSEPAREN);
      break;
    case USER:
      jj_consume_token(USER);
      break;
    case SINGLE_STRING_LITERAL:
    case DOUBLE_STRING_LITERAL:
    case ID:
    case SQUARE_BRACKET_ID:
    case TEMP_TABLE_NAME:
    case DOT:
      if (jj_2_168(2)) {
        prefix_list();
      } else {
        ;
      }
      id_or_string();
      jj_consume_token(OPENPAREN);
      expression_list();
      optional_using_clause();
      jj_consume_token(CLOSEPAREN);
      break;
    default:
      jj_la1[182] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void java_constructor() throws ParseException {
    UK_NEW();
    java_name();
    jj_consume_token(OPENPAREN);
    expression_list();
    jj_consume_token(CLOSEPAREN);
  }

  final public void subq_expression_list() throws ParseException {
    subq_expression();
    label_41:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[183] = jj_gen;
        break label_41;
      }
      jj_consume_token(COMMA);
      subq_expression();
    }
  }

  final public void subq_expression() throws ParseException {
    if (jj_2_171(2)) {
      idplus();
      jj_consume_token(EQUAL);
      if (jj_2_170(1)) {
        if (jj_2_169(1)) {
          expression();
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case IDENTITY:
            jj_consume_token(IDENTITY);
            jj_consume_token(OPENPAREN);
            jj_consume_token(INTEGER_LITERAL);
            jj_consume_token(CLOSEPAREN);
            break;
          default:
            jj_la1[184] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      } else {
        ;
      }
    } else if (jj_2_172(2)) {
      expression();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
      case SINGLE_STRING_LITERAL:
      case DOUBLE_STRING_LITERAL:
      case ID:
      case SQUARE_BRACKET_ID:
      case TEMP_TABLE_NAME:
        optional_as();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ID:
        case SQUARE_BRACKET_ID:
        case TEMP_TABLE_NAME:
          idplus();
          break;
        case SINGLE_STRING_LITERAL:
        case DOUBLE_STRING_LITERAL:
          string_literal();
          break;
        default:
          jj_la1[185] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[186] = jj_gen;
        ;
      }
    } else if (jj_2_173(2)) {
      string_literal();
      jj_consume_token(EQUAL);
      expression();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void expression_list() throws ParseException {
    if (jj_2_175(2)) {
      expression();
      label_42:
      while (true) {
        if (jj_2_174(2)) {
          ;
        } else {
          break label_42;
        }
        jj_consume_token(COMMA);
        expression();
      }
    } else {
      ;
    }
  }

  final public void optional_using_clause() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
    case COMMA:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case USING:
          jj_consume_token(USING);
          jj_consume_token(ID);
          break;
        default:
          jj_la1[187] = jj_gen;
          ;
        }
        break;
      case AS:
        jj_consume_token(AS);
        datatype();
        break;
      default:
        jj_la1[188] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[189] = jj_gen;
      ;
    }
  }

  final public void optional_comma_argument() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      expression();
      break;
    default:
      jj_la1[190] = jj_gen;
      ;
    }
  }

  final public void agg_function() throws ParseException {
    agg_function_specification();
  }

  final public void agg_function_specification() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COUNT:
      jj_consume_token(COUNT);
      jj_consume_token(OPENPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASTERISK:
        jj_consume_token(ASTERISK);
        break;
      default:
        jj_la1[192] = jj_gen;
        if (jj_2_176(1)) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case DISTINCT:
            jj_consume_token(DISTINCT);
            break;
          default:
            jj_la1[191] = jj_gen;
            all();
          }
          expression();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(CLOSEPAREN);
      break;
    case AVG:
      jj_consume_token(AVG);
      jj_consume_token(OPENPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DISTINCT:
        jj_consume_token(DISTINCT);
        break;
      default:
        jj_la1[193] = jj_gen;
        all();
      }
      expression();
      jj_consume_token(CLOSEPAREN);
      break;
    case MAX:
      jj_consume_token(MAX);
      jj_consume_token(OPENPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DISTINCT:
        jj_consume_token(DISTINCT);
        break;
      default:
        jj_la1[194] = jj_gen;
        all();
      }
      expression();
      jj_consume_token(CLOSEPAREN);
      break;
    case MIN:
      jj_consume_token(MIN);
      jj_consume_token(OPENPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DISTINCT:
        jj_consume_token(DISTINCT);
        break;
      default:
        jj_la1[195] = jj_gen;
        all();
      }
      expression();
      jj_consume_token(CLOSEPAREN);
      break;
    case SUM:
      jj_consume_token(SUM);
      jj_consume_token(OPENPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DISTINCT:
        jj_consume_token(DISTINCT);
        break;
      default:
        jj_la1[196] = jj_gen;
        all();
      }
      expression();
      jj_consume_token(CLOSEPAREN);
      break;
    default:
      jj_la1[197] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void all() throws ParseException {
    if (jj_2_177(1)) {
      UK_ALL();
    } else {
      ;
    }
  }

  final public void boolean_function() throws ParseException {
    jj_consume_token(UPDATE);
    jj_consume_token(OPENPAREN);
    idplus();
    jj_consume_token(CLOSEPAREN);
  }

/**
 * Skips the subsequent tokens when parsing error occurrs. 
 * The process will continue until the current consumed token matches <code>tokinds</code> 
 * or the next token to be consumed matches <code>beforekinds</code>.
 */
  void error_skiptobefore(int[] tokinds, int[] beforekinds) throws ParseException {
  boolean match = false;
  Token t1 = getToken(0);
    // The following loop consumes tokens all the way up to a token of
    // "kind".  We use a do-while loop rather than a while because the
    // current token is the one immediately before the erroneous token
    // (in our case the token immediately before what should have been
    // "if"/"while".
  do {
    match = token.kind == 0 || getToken(1).kind == 0 ; // 0 means the <EOF>
    if (match) {break;}
    for (int i=0; i< tokinds.length; i++){
        match = match || token.kind == tokinds[i];
        if (match) {break;}
    }
    if (match) {break;}
    for (int i=0; i< beforekinds.length; i++){
        match = match || getToken(1).kind == beforekinds[i];
        if (match) {break;}
    }
    if (!match){
        logDebug("current token:" + token.image);
        getNextToken();
    }

  } while (!match);

  Token t2 = getToken(0);
  if (t1 == t2 ){
        //force get next token
        logDebug("current token:" + token.image);
    getNextToken();
  }
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  final private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  final private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  final private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  final private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  final private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  final private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  final private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  final private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  final private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  final private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  final private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  final private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  final private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  final private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  final private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  final private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  final private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  final private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  final private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  final private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  final private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  final private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  final private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  final private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  final private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  final private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  final private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  final private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  final private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  final private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  final private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  final private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  final private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  final private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_51(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  final private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_52(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  final private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_53(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  final private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_54(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  final private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_55(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  final private boolean jj_2_56(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_56(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  final private boolean jj_2_57(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_57(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  final private boolean jj_2_58(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_58(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  final private boolean jj_2_59(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_59(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  final private boolean jj_2_60(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_60(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  final private boolean jj_2_61(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_61(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  final private boolean jj_2_62(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_62(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  final private boolean jj_2_63(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_63(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  final private boolean jj_2_64(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_64(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  final private boolean jj_2_65(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_65(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  final private boolean jj_2_66(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_66(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  final private boolean jj_2_67(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_67(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  final private boolean jj_2_68(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_68(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  final private boolean jj_2_69(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_69(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  final private boolean jj_2_70(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_70(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  final private boolean jj_2_71(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_71(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  final private boolean jj_2_72(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_72(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  final private boolean jj_2_73(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_73(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  final private boolean jj_2_74(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_74(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  final private boolean jj_2_75(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_75(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  final private boolean jj_2_76(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_76(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  final private boolean jj_2_77(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_77(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  final private boolean jj_2_78(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_78(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  final private boolean jj_2_79(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_79(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  final private boolean jj_2_80(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_80(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  final private boolean jj_2_81(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_81(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  final private boolean jj_2_82(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_82(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  final private boolean jj_2_83(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_83(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(82, xla); }
  }

  final private boolean jj_2_84(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_84(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(83, xla); }
  }

  final private boolean jj_2_85(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_85(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(84, xla); }
  }

  final private boolean jj_2_86(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_86(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(85, xla); }
  }

  final private boolean jj_2_87(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_87(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(86, xla); }
  }

  final private boolean jj_2_88(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_88(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(87, xla); }
  }

  final private boolean jj_2_89(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_89(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(88, xla); }
  }

  final private boolean jj_2_90(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_90(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(89, xla); }
  }

  final private boolean jj_2_91(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_91(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(90, xla); }
  }

  final private boolean jj_2_92(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_92(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(91, xla); }
  }

  final private boolean jj_2_93(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_93(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(92, xla); }
  }

  final private boolean jj_2_94(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_94(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(93, xla); }
  }

  final private boolean jj_2_95(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_95(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(94, xla); }
  }

  final private boolean jj_2_96(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_96(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(95, xla); }
  }

  final private boolean jj_2_97(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_97(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(96, xla); }
  }

  final private boolean jj_2_98(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_98(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(97, xla); }
  }

  final private boolean jj_2_99(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_99(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(98, xla); }
  }

  final private boolean jj_2_100(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_100(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(99, xla); }
  }

  final private boolean jj_2_101(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_101(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(100, xla); }
  }

  final private boolean jj_2_102(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_102(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(101, xla); }
  }

  final private boolean jj_2_103(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_103(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(102, xla); }
  }

  final private boolean jj_2_104(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_104(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(103, xla); }
  }

  final private boolean jj_2_105(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_105(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(104, xla); }
  }

  final private boolean jj_2_106(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_106(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(105, xla); }
  }

  final private boolean jj_2_107(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_107(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(106, xla); }
  }

  final private boolean jj_2_108(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_108(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(107, xla); }
  }

  final private boolean jj_2_109(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_109(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(108, xla); }
  }

  final private boolean jj_2_110(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_110(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(109, xla); }
  }

  final private boolean jj_2_111(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_111(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(110, xla); }
  }

  final private boolean jj_2_112(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_112(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(111, xla); }
  }

  final private boolean jj_2_113(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_113(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(112, xla); }
  }

  final private boolean jj_2_114(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_114(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(113, xla); }
  }

  final private boolean jj_2_115(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_115(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(114, xla); }
  }

  final private boolean jj_2_116(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_116(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(115, xla); }
  }

  final private boolean jj_2_117(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_117(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(116, xla); }
  }

  final private boolean jj_2_118(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_118(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(117, xla); }
  }

  final private boolean jj_2_119(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_119(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(118, xla); }
  }

  final private boolean jj_2_120(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_120(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(119, xla); }
  }

  final private boolean jj_2_121(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_121(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(120, xla); }
  }

  final private boolean jj_2_122(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_122(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(121, xla); }
  }

  final private boolean jj_2_123(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_123(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(122, xla); }
  }

  final private boolean jj_2_124(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_124(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(123, xla); }
  }

  final private boolean jj_2_125(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_125(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(124, xla); }
  }

  final private boolean jj_2_126(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_126(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(125, xla); }
  }

  final private boolean jj_2_127(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_127(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(126, xla); }
  }

  final private boolean jj_2_128(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_128(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(127, xla); }
  }

  final private boolean jj_2_129(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_129(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(128, xla); }
  }

  final private boolean jj_2_130(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_130(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(129, xla); }
  }

  final private boolean jj_2_131(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_131(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(130, xla); }
  }

  final private boolean jj_2_132(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_132(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(131, xla); }
  }

  final private boolean jj_2_133(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_133(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(132, xla); }
  }

  final private boolean jj_2_134(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_134(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(133, xla); }
  }

  final private boolean jj_2_135(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_135(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(134, xla); }
  }

  final private boolean jj_2_136(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_136(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(135, xla); }
  }

  final private boolean jj_2_137(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_137(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(136, xla); }
  }

  final private boolean jj_2_138(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_138(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(137, xla); }
  }

  final private boolean jj_2_139(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_139(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(138, xla); }
  }

  final private boolean jj_2_140(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_140(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(139, xla); }
  }

  final private boolean jj_2_141(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_141(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(140, xla); }
  }

  final private boolean jj_2_142(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_142(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(141, xla); }
  }

  final private boolean jj_2_143(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_143(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(142, xla); }
  }

  final private boolean jj_2_144(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_144(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(143, xla); }
  }

  final private boolean jj_2_145(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_145(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(144, xla); }
  }

  final private boolean jj_2_146(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_146(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(145, xla); }
  }

  final private boolean jj_2_147(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_147(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(146, xla); }
  }

  final private boolean jj_2_148(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_148(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(147, xla); }
  }

  final private boolean jj_2_149(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_149(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(148, xla); }
  }

  final private boolean jj_2_150(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_150(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(149, xla); }
  }

  final private boolean jj_2_151(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_151(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(150, xla); }
  }

  final private boolean jj_2_152(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_152(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(151, xla); }
  }

  final private boolean jj_2_153(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_153(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(152, xla); }
  }

  final private boolean jj_2_154(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_154(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(153, xla); }
  }

  final private boolean jj_2_155(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_155(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(154, xla); }
  }

  final private boolean jj_2_156(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_156(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(155, xla); }
  }

  final private boolean jj_2_157(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_157(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(156, xla); }
  }

  final private boolean jj_2_158(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_158(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(157, xla); }
  }

  final private boolean jj_2_159(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_159(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(158, xla); }
  }

  final private boolean jj_2_160(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_160(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(159, xla); }
  }

  final private boolean jj_2_161(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_161(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(160, xla); }
  }

  final private boolean jj_2_162(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_162(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(161, xla); }
  }

  final private boolean jj_2_163(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_163(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(162, xla); }
  }

  final private boolean jj_2_164(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_164(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(163, xla); }
  }

  final private boolean jj_2_165(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_165(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(164, xla); }
  }

  final private boolean jj_2_166(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_166(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(165, xla); }
  }

  final private boolean jj_2_167(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_167(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(166, xla); }
  }

  final private boolean jj_2_168(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_168(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(167, xla); }
  }

  final private boolean jj_2_169(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_169(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(168, xla); }
  }

  final private boolean jj_2_170(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_170(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(169, xla); }
  }

  final private boolean jj_2_171(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_171(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(170, xla); }
  }

  final private boolean jj_2_172(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_172(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(171, xla); }
  }

  final private boolean jj_2_173(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_173(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(172, xla); }
  }

  final private boolean jj_2_174(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_174(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(173, xla); }
  }

  final private boolean jj_2_175(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_175(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(174, xla); }
  }

  final private boolean jj_2_176(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_176(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(175, xla); }
  }

  final private boolean jj_2_177(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_177(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(176, xla); }
  }

  final private boolean jj_3R_509() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_508()) return true;
    return false;
  }

  final private boolean jj_3R_501() {
    if (jj_3R_508()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_509()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_488() {
    if (jj_scan_token(ORDER)) return true;
    if (jj_scan_token(BY)) return true;
    if (jj_3R_501()) return true;
    return false;
  }

  final private boolean jj_3R_342() {
    if (jj_3R_132()) return true;
    return false;
  }

  final private boolean jj_3R_474() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_488()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_302() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_342()) jj_scanpos = xsp;
    if (jj_scan_token(ASTERISK)) return true;
    return false;
  }

  final private boolean jj_3_82() {
    if (jj_3R_103()) return true;
    return false;
  }

  final private boolean jj_3R_228() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_82()) {
    jj_scanpos = xsp;
    if (jj_3R_302()) return true;
    }
    return false;
  }

  final private boolean jj_3_80() {
    if (jj_3R_98()) return true;
    return false;
  }

  final private boolean jj_3_81() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_80()) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) return true;
    }
    return false;
  }

  final private boolean jj_3R_227() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_81()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_516() {
    if (jj_3R_463()) return true;
    return false;
  }

  final private boolean jj_3R_102() {
    if (jj_scan_token(SELECT)) return true;
    if (jj_3R_227()) return true;
    if (jj_3R_228()) return true;
    if (jj_3R_440()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_516()) jj_scanpos = xsp;
    if (jj_3R_442()) return true;
    if (jj_3R_443()) return true;
    return false;
  }

  final private boolean jj_3R_487() {
    if (jj_scan_token(UNION)) return true;
    if (jj_3R_500()) return true;
    return false;
  }

  final private boolean jj_3R_473() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_487()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_79() {
    if (jj_3R_102()) return true;
    if (jj_scan_token(UNION)) return true;
    return false;
  }

  final private boolean jj_3R_500() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_79()) jj_scanpos = xsp;
    if (jj_3R_102()) return true;
    return false;
  }

  final private boolean jj_3_77() {
    if (jj_3R_98()) return true;
    return false;
  }

  final private boolean jj_3_78() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_77()) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) return true;
    }
    return false;
  }

  final private boolean jj_3R_100() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_78()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_472() {
    if (jj_3R_463()) return true;
    return false;
  }

  final private boolean jj_3_76() {
    if (jj_3R_100()) return true;
    if (jj_3R_101()) return true;
    if (jj_3R_440()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_472()) jj_scanpos = xsp;
    if (jj_3R_442()) return true;
    if (jj_3R_443()) return true;
    if (jj_3R_473()) return true;
    if (jj_3R_474()) return true;
    if (jj_3R_475()) return true;
    if (jj_3R_476()) return true;
    return false;
  }

  final private boolean jj_3R_377() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_76()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_361() {
    if (jj_scan_token(SELECT)) return true;
    if (jj_3R_377()) return true;
    return false;
  }

  final private boolean jj_3R_340() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_361()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_288() {
    if (jj_scan_token(DELETE)) return true;
    return false;
  }

  final private boolean jj_3R_439() {
    if (jj_3R_461()) return true;
    return false;
  }

  final private boolean jj_3R_387() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(202)) {
    jj_scanpos = xsp;
    if (jj_3R_405()) {
    jj_scanpos = xsp;
    if (jj_3R_406()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_74() {
    if (jj_3R_98()) return true;
    return false;
  }

  final private boolean jj_3_75() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_74()) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) return true;
    }
    return false;
  }

  final private boolean jj_3R_370() {
    if (jj_scan_token(AT)) return true;
    if (jj_scan_token(ISOLATION)) return true;
    if (jj_3R_387()) return true;
    return false;
  }

  final private boolean jj_3R_437() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_75()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_99() {
    if (jj_3R_160()) return true;
    return false;
  }

  final private boolean jj_3R_353() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_370()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_73() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_99()) jj_scanpos = xsp;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  final private boolean jj_3R_406() {
    if (jj_scan_token(ID)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(144)) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_405() {
    if (jj_scan_token(READ)) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_482() {
    if (jj_3R_308()) return true;
    return false;
  }

  final private boolean jj_3R_461() {
    if (jj_scan_token(INTO)) return true;
    if (jj_3R_482()) return true;
    return false;
  }

  final private boolean jj_3R_441() {
    if (jj_3R_463()) return true;
    return false;
  }

  final private boolean jj_3R_410() {
    if (jj_scan_token(SELECT)) return true;
    if (jj_3R_437()) return true;
    if (jj_3R_438()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_439()) jj_scanpos = xsp;
    if (jj_3R_440()) return true;
    xsp = jj_scanpos;
    if (jj_3R_441()) jj_scanpos = xsp;
    if (jj_3R_442()) return true;
    if (jj_3R_443()) return true;
    return false;
  }

  final private boolean jj_3R_396() {
    if (jj_3R_410()) return true;
    return false;
  }

  final private boolean jj_3R_360() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_375()) {
    jj_scanpos = xsp;
    if (jj_3R_376()) return true;
    }
    return false;
  }

  final private boolean jj_3R_367() {
    if (jj_scan_token(UNION)) return true;
    if (jj_3R_384()) return true;
    if (jj_3R_337()) return true;
    return false;
  }

  final private boolean jj_3R_375() {
    if (jj_3R_396()) return true;
    return false;
  }

  final private boolean jj_3_72() {
    if (jj_3R_98()) return true;
    return false;
  }

  final private boolean jj_3R_384() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_72()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_376() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_287()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_337() {
    if (jj_3R_360()) return true;
    return false;
  }

  final private boolean jj_3R_287() {
    if (jj_3R_337()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_367()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_181() {
    if (jj_3R_287()) return true;
    if (jj_3R_351()) return true;
    if (jj_3R_352()) return true;
    if (jj_3R_353()) return true;
    return false;
  }

  final private boolean jj_3_71() {
    if (jj_3R_97()) return true;
    return false;
  }

  final private boolean jj_3R_286() {
    if (jj_scan_token(UPDATE)) return true;
    return false;
  }

  final private boolean jj_3_70() {
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_223() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_70()) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) return true;
    }
    return false;
  }

  final private boolean jj_3R_95() {
    if (jj_3R_223()) return true;
    return false;
  }

  final private boolean jj_3_35() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_59()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3_69() {
    if (jj_3R_95()) return true;
    return false;
  }

  final private boolean jj_3_65() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_92()) return true;
    return false;
  }

  final private boolean jj_3R_94() {
    if (jj_3R_160()) return true;
    return false;
  }

  final private boolean jj_3_68() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_94()) jj_scanpos = xsp;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  final private boolean jj_3R_93() {
    if (jj_3R_222()) return true;
    return false;
  }

  final private boolean jj_3R_294() {
    if (jj_3R_160()) return true;
    return false;
  }

  final private boolean jj_3_67() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_93()) return true;
    return false;
  }

  final private boolean jj_3R_222() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_293()) {
    jj_scanpos = xsp;
    if (jj_3R_294()) return true;
    }
    return false;
  }

  final private boolean jj_3R_293() {
    if (jj_3R_132()) return true;
    return false;
  }

  final private boolean jj_3_34() {
    if (jj_3R_72()) return true;
    return false;
  }

  final private boolean jj_3R_432() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_59()) return true;
    return false;
  }

  final private boolean jj_3R_285() {
    if (jj_scan_token(INSERT)) return true;
    return false;
  }

  final private boolean jj_3_66() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_59()) return true;
    return false;
  }

  final private boolean jj_3_29() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_59()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_433() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_59()) return true;
    return false;
  }

  final private boolean jj_3_33() {
    if (jj_3R_71()) return true;
    return false;
  }

  final private boolean jj_3R_92() {
    if (jj_3R_160()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_65()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_40() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_59()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3_38() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_59()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3_39() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_59()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3_37() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_59()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3_22() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_59()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_432()) jj_scanpos = xsp;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3_36() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_59()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3_28() {
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3_32() {
    if (jj_3R_70()) return true;
    return false;
  }

  final private boolean jj_3_19() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_59()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_407() {
    if (jj_3R_92()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_40()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_64() {
    if (jj_3R_91()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_39()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_63() {
    if (jj_3R_90()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_38()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_62() {
    if (jj_3R_89()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_37()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_61() {
    if (jj_3R_88()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_36()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_60() {
    if (jj_3R_87()) return true;
    return false;
  }

  final private boolean jj_3_30() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_59()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_433()) jj_scanpos = xsp;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3_59() {
    if (jj_3R_86()) return true;
    return false;
  }

  final private boolean jj_3_27() {
    if (jj_3R_67()) return true;
    return false;
  }

  final private boolean jj_3_58() {
    if (jj_3R_85()) return true;
    return false;
  }

  final private boolean jj_3_57() {
    if (jj_3R_84()) return true;
    return false;
  }

  final private boolean jj_3_21() {
    if (jj_3R_63()) return true;
    return false;
  }

  final private boolean jj_3_56() {
    if (jj_3R_83()) return true;
    return false;
  }

  final private boolean jj_3_55() {
    if (jj_3R_82()) return true;
    return false;
  }

  final private boolean jj_3_25() {
    if (jj_3R_65()) return true;
    return false;
  }

  final private boolean jj_3_31() {
    if (jj_3R_69()) return true;
    return false;
  }

  final private boolean jj_3_54() {
    if (jj_3R_81()) return true;
    return false;
  }

  final private boolean jj_3_23() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_59()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3_53() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_31()) {
    jj_scanpos = xsp;
    if (jj_3_32()) {
    jj_scanpos = xsp;
    if (jj_3_33()) {
    jj_scanpos = xsp;
    if (jj_3_34()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_35()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_18() {
    if (jj_3R_61()) return true;
    return false;
  }

  final private boolean jj_3_16() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_59()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3_26() {
    if (jj_3R_66()) return true;
    return false;
  }

  final private boolean jj_3_52() {
    if (jj_3R_80()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_30()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_51() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_26()) {
    jj_scanpos = xsp;
    if (jj_3_27()) {
    jj_scanpos = xsp;
    if (jj_3_28()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3_29()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_24() {
    if (jj_3R_64()) return true;
    return false;
  }

  final private boolean jj_3_50() {
    if (jj_3R_79()) return true;
    return false;
  }

  final private boolean jj_3_49() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_24()) {
    jj_scanpos = xsp;
    if (jj_3_25()) return true;
    }
    return false;
  }

  final private boolean jj_3_20() {
    if (jj_3R_62()) return true;
    return false;
  }

  final private boolean jj_3_48() {
    if (jj_3R_78()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_23()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_47() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_20()) {
    jj_scanpos = xsp;
    if (jj_3_21()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_22()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_46() {
    if (jj_3R_77()) return true;
    return false;
  }

  final private boolean jj_3_17() {
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3_45() {
    if (jj_3R_76()) return true;
    return false;
  }

  final private boolean jj_3_44() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_17()) {
    jj_scanpos = xsp;
    if (jj_3_18()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_19()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_41() {
    if (jj_3R_73()) return true;
    return false;
  }

  final private boolean jj_3_43() {
    if (jj_3R_75()) return true;
    return false;
  }

  final private boolean jj_3_42() {
    if (jj_3R_74()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_16()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_389() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_41()) {
    jj_scanpos = xsp;
    if (jj_3_42()) {
    jj_scanpos = xsp;
    if (jj_3_43()) {
    jj_scanpos = xsp;
    if (jj_3_44()) {
    jj_scanpos = xsp;
    if (jj_3_45()) {
    jj_scanpos = xsp;
    if (jj_3_46()) {
    jj_scanpos = xsp;
    if (jj_3_47()) {
    jj_scanpos = xsp;
    if (jj_3_48()) {
    jj_scanpos = xsp;
    if (jj_3_49()) {
    jj_scanpos = xsp;
    if (jj_3_50()) {
    jj_scanpos = xsp;
    if (jj_3_51()) {
    jj_scanpos = xsp;
    if (jj_3_52()) {
    jj_scanpos = xsp;
    if (jj_3_53()) {
    jj_scanpos = xsp;
    if (jj_3_54()) {
    jj_scanpos = xsp;
    if (jj_3_55()) {
    jj_scanpos = xsp;
    if (jj_3_56()) {
    jj_scanpos = xsp;
    if (jj_3_57()) {
    jj_scanpos = xsp;
    if (jj_3_58()) {
    jj_scanpos = xsp;
    if (jj_3_59()) {
    jj_scanpos = xsp;
    if (jj_3_60()) {
    jj_scanpos = xsp;
    if (jj_3_61()) {
    jj_scanpos = xsp;
    if (jj_3_62()) {
    jj_scanpos = xsp;
    if (jj_3_63()) {
    jj_scanpos = xsp;
    if (jj_3_64()) {
    jj_scanpos = xsp;
    if (jj_3R_407()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_372() {
    if (jj_3R_389()) return true;
    return false;
  }

  final private boolean jj_3R_180() {
    if (jj_3R_286()) return true;
    return false;
  }

  final private boolean jj_3R_172() {
    if (jj_3R_283()) return true;
    return false;
  }

  final private boolean jj_3_15() {
    if (jj_scan_token(BEGIN)) return true;
    if (jj_3R_58()) return true;
    return false;
  }

  final private boolean jj_3R_179() {
    if (jj_3R_285()) return true;
    return false;
  }

  final private boolean jj_3R_395() {
    if (jj_3R_283()) return true;
    return false;
  }

  final private boolean jj_3R_394() {
    if (jj_3R_283()) return true;
    return false;
  }

  final private boolean jj_3R_393() {
    if (jj_3R_283()) return true;
    return false;
  }

  final private boolean jj_3R_392() {
    if (jj_3R_283()) return true;
    return false;
  }

  final private boolean jj_3R_182() {
    if (jj_3R_288()) return true;
    return false;
  }

  final private boolean jj_3R_291() {
    if (jj_3R_339()) return true;
    return false;
  }

  final private boolean jj_3R_184() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_290()) {
    jj_scanpos = xsp;
    if (jj_3R_291()) return true;
    }
    return false;
  }

  final private boolean jj_3R_290() {
    if (jj_3R_338()) return true;
    return false;
  }

  final private boolean jj_3_176() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_3R_172()) return true;
    }
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_282() {
    if (jj_3R_131()) return true;
    return false;
  }

  final private boolean jj_3R_316() {
    if (jj_scan_token(UPDATE)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_130()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3_177() {
    if (jj_3R_98()) return true;
    return false;
  }

  final private boolean jj_3R_281() {
    if (jj_3R_130()) return true;
    return false;
  }

  final private boolean jj_3R_283() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_177()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_335() {
    if (jj_scan_token(SUM)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_3R_395()) return true;
    }
    if (jj_3R_96()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_334() {
    if (jj_scan_token(MIN)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_3R_394()) return true;
    }
    if (jj_3R_96()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_333() {
    if (jj_scan_token(MAX)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_3R_393()) return true;
    }
    if (jj_3R_96()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_166() {
    if (jj_scan_token(OPENPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_332() {
    if (jj_scan_token(AVG)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_3R_392()) return true;
    }
    if (jj_3R_96()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_170() {
    if (jj_scan_token(IDENTITY)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_178() {
    if (jj_scan_token(DROP)) return true;
    return false;
  }

  final private boolean jj_3R_280() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_331()) {
    jj_scanpos = xsp;
    if (jj_3R_332()) {
    jj_scanpos = xsp;
    if (jj_3R_333()) {
    jj_scanpos = xsp;
    if (jj_3R_334()) {
    jj_scanpos = xsp;
    if (jj_3R_335()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_331() {
    if (jj_scan_token(COUNT)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(235)) {
    jj_scanpos = xsp;
    if (jj_3_176()) return true;
    }
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_169() {
    if (jj_3R_280()) return true;
    return false;
  }

  final private boolean jj_3R_171() {
    if (jj_3R_126()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_281()) {
    jj_scanpos = xsp;
    if (jj_3R_282()) return true;
    }
    return false;
  }

  final private boolean jj_3R_390() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_417() {
    if (jj_scan_token(USING)) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3_170() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_169()) {
    jj_scanpos = xsp;
    if (jj_3R_170()) return true;
    }
    return false;
  }

  final private boolean jj_3_169() {
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_373() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_390()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_177() {
    if (jj_scan_token(ALTER)) return true;
    return false;
  }

  final private boolean jj_3R_391() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_408()) {
    jj_scanpos = xsp;
    if (jj_3R_409()) return true;
    }
    return false;
  }

  final private boolean jj_3R_408() {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_417()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_409() {
    if (jj_scan_token(AS)) return true;
    if (jj_3R_372()) return true;
    return false;
  }

  final private boolean jj_3R_374() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_391()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_175() {
    if (jj_3R_96()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_174()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_161() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_175()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_174() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3_173() {
    if (jj_3R_131()) return true;
    if (jj_scan_token(EQUAL)) return true;
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_175() {
    if (jj_scan_token(USE)) return true;
    return false;
  }

  final private boolean jj_3R_103() {
    if (jj_3R_229()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_230()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_172() {
    if (jj_3R_96()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_171()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_230() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_229()) return true;
    return false;
  }

  final private boolean jj_3_171() {
    if (jj_3R_130()) return true;
    if (jj_scan_token(EQUAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_170()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_229() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_171()) {
    jj_scanpos = xsp;
    if (jj_3_172()) {
    jj_scanpos = xsp;
    if (jj_3_173()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_167() {
    if (jj_3R_277()) return true;
    if (jj_3R_92()) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_161()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3_168() {
    if (jj_3R_132()) return true;
    return false;
  }

  final private boolean jj_3R_279() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_168()) jj_scanpos = xsp;
    if (jj_3R_160()) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_161()) return true;
    if (jj_3R_374()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_176() {
    if (jj_scan_token(CREATE)) return true;
    return false;
  }

  final private boolean jj_3_164() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(223)) {
    jj_scanpos = xsp;
    if (jj_scan_token(242)) return true;
    }
    if (jj_3R_160()) return true;
    xsp = jj_scanpos;
    if (jj_3R_166()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_168() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_278()) {
    jj_scanpos = xsp;
    if (jj_scan_token(187)) {
    jj_scanpos = xsp;
    if (jj_3R_279()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_278() {
    if (jj_scan_token(CONVERT)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_372()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(113)) jj_scanpos = xsp;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_96()) return true;
    if (jj_3R_373()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3_166() {
    if (jj_3R_168()) return true;
    return false;
  }

  final private boolean jj_3R_174() {
    return false;
  }

  final private boolean jj_3_167() {
    if (jj_3R_169()) return true;
    return false;
  }

  final private boolean jj_3R_380() {
    if (jj_scan_token(QUESTIONMARK)) return true;
    return false;
  }

  final private boolean jj_3_165() {
    if (jj_3R_167()) return true;
    return false;
  }

  final private boolean jj_3R_158() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_165()) {
    jj_scanpos = xsp;
    if (jj_3_166()) {
    jj_scanpos = xsp;
    if (jj_3_167()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_44() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = !isSupportedStatementStartToken(getToken(1).kind);
    lookingAhead = false;
    if (!jj_semLA || jj_3R_174()) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(56)) {
    jj_scanpos = xsp;
    if (jj_scan_token(61)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_scan_token(101)) {
    jj_scanpos = xsp;
    if (jj_scan_token(104)) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) {
    jj_scanpos = xsp;
    if (jj_scan_token(120)) {
    jj_scanpos = xsp;
    if (jj_scan_token(122)) {
    jj_scanpos = xsp;
    if (jj_scan_token(133)) {
    jj_scanpos = xsp;
    if (jj_scan_token(142)) {
    jj_scanpos = xsp;
    if (jj_scan_token(143)) {
    jj_scanpos = xsp;
    if (jj_scan_token(146)) {
    jj_scanpos = xsp;
    if (jj_scan_token(147)) {
    jj_scanpos = xsp;
    if (jj_scan_token(149)) {
    jj_scanpos = xsp;
    if (jj_scan_token(150)) {
    jj_scanpos = xsp;
    if (jj_scan_token(153)) {
    jj_scanpos = xsp;
    if (jj_scan_token(155)) {
    jj_scanpos = xsp;
    if (jj_scan_token(157)) {
    jj_scanpos = xsp;
    if (jj_scan_token(161)) {
    jj_scanpos = xsp;
    if (jj_scan_token(164)) {
    jj_scanpos = xsp;
    if (jj_scan_token(165)) {
    jj_scanpos = xsp;
    if (jj_scan_token(167)) {
    jj_scanpos = xsp;
    if (jj_scan_token(181)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) {
    jj_scanpos = xsp;
    if (jj_scan_token(195)) {
    jj_scanpos = xsp;
    if (jj_scan_token(198)) {
    jj_scanpos = xsp;
    if (jj_scan_token(210)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_505() {
    if (jj_scan_token(VAR_NAME)) return true;
    return false;
  }

  final private boolean jj_3R_371() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  final private boolean jj_3_14() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(81)) {
    jj_scanpos = xsp;
    if (jj_scan_token(222)) return true;
    }
    return false;
  }

  final private boolean jj_3R_345() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(213)) {
    jj_scanpos = xsp;
    if (jj_3R_364()) {
    jj_scanpos = xsp;
    if (jj_scan_token(215)) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_173() {
    if (jj_3R_284()) return true;
    return false;
  }

  final private boolean jj_3_11() {
    if (jj_scan_token(BEGIN)) return true;
    return false;
  }

  final private boolean jj_3_163() {
    if (jj_3R_74()) return true;
    return false;
  }

  final private boolean jj_3R_364() {
    if (jj_3R_380()) return true;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_scan_token(FETCH)) return true;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_scan_token(DELETE)) return true;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_scan_token(SELECT)) return true;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_scan_token(UPDATE)) return true;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_scan_token(INSERT)) return true;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_scan_token(DROP)) return true;
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_3R_175()) return true;
    return false;
  }

  final private boolean jj_3_12() {
    if (jj_3R_44()) return true;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_scan_token(ALTER)) return true;
    return false;
  }

  final private boolean jj_3R_57() {
    if (jj_3R_187()) return true;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_scan_token(CREATE)) return true;
    return false;
  }

  final private boolean jj_3R_56() {
    if (jj_3R_186()) return true;
    return false;
  }

  final private boolean jj_3R_55() {
    if (jj_3R_185()) return true;
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_3R_184()) return true;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_3R_183()) return true;
    return false;
  }

  final private boolean jj_3R_52() {
    if (jj_3R_182()) return true;
    return false;
  }

  final private boolean jj_3R_51() {
    if (jj_3R_181()) return true;
    return false;
  }

  final private boolean jj_3_13() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) {
    jj_scanpos = xsp;
    if (jj_3R_52()) {
    jj_scanpos = xsp;
    if (jj_3R_53()) {
    jj_scanpos = xsp;
    if (jj_3R_54()) {
    jj_scanpos = xsp;
    if (jj_3R_55()) {
    jj_scanpos = xsp;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3_12()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_50() {
    if (jj_3R_180()) return true;
    return false;
  }

  final private boolean jj_3R_49() {
    if (jj_3R_179()) return true;
    return false;
  }

  final private boolean jj_3R_48() {
    if (jj_3R_178()) return true;
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_3R_177()) return true;
    return false;
  }

  final private boolean jj_3R_43() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3R_173()) return true;
    }
    return false;
  }

  final private boolean jj_3R_46() {
    if (jj_3R_176()) return true;
    return false;
  }

  final private boolean jj_3R_329() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(207)) {
    jj_scanpos = xsp;
    if (jj_3R_357()) {
    jj_scanpos = xsp;
    if (jj_3R_358()) {
    jj_scanpos = xsp;
    if (jj_3R_359()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_359() {
    if (jj_3R_345()) return true;
    return false;
  }

  final private boolean jj_3R_358() {
    if (jj_3R_371()) return true;
    return false;
  }

  final private boolean jj_3R_357() {
    if (jj_3R_131()) return true;
    return false;
  }

  final private boolean jj_3R_328() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(202)) {
    jj_scanpos = xsp;
    if (jj_scan_token(203)) {
    jj_scanpos = xsp;
    if (jj_scan_token(209)) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_2() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(81)) {
    jj_scanpos = xsp;
    if (jj_scan_token(222)) return true;
    }
    return false;
  }

  final private boolean jj_3R_157() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_271()) {
    jj_scanpos = xsp;
    if (jj_3R_272()) return true;
    }
    return false;
  }

  final private boolean jj_3R_271() {
    if (jj_3R_328()) return true;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_43()) return true;
    return false;
  }

  final private boolean jj_3R_272() {
    if (jj_3R_329()) return true;
    return false;
  }

  final private boolean jj_3R_189() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(237)) jj_scanpos = xsp;
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_188() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_59() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_188()) {
    jj_scanpos = xsp;
    if (jj_3R_189()) return true;
    }
    return false;
  }

  final private boolean jj_3R_221() {
    return false;
  }

  final private boolean jj_3R_220() {
    return false;
  }

  final private boolean jj_3R_346() {
    if (jj_3R_160()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  final private boolean jj_3R_306() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(223)) {
    jj_scanpos = xsp;
    if (jj_3R_346()) return true;
    }
    return false;
  }

  final private boolean jj_3R_91() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("varchar");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_221()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_219() {
    return false;
  }

  final private boolean jj_3R_165() {
    if (jj_3R_160()) return true;
    return false;
  }

  final private boolean jj_3_162() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_165()) jj_scanpos = xsp;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  final private boolean jj_3R_343() {
    if (jj_3R_130()) return true;
    return false;
  }

  final private boolean jj_3R_90() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("varbinary");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_220()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_303() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_343()) {
    jj_scanpos = xsp;
    if (jj_3R_344()) return true;
    }
    return false;
  }

  final private boolean jj_3R_218() {
    return false;
  }

  final private boolean jj_3R_344() {
    if (jj_3R_345()) return true;
    return false;
  }

  final private boolean jj_3R_89() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("univarchar");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_219()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_246() {
    if (jj_3R_306()) return true;
    return false;
  }

  final private boolean jj_3R_132() {
    Token xsp;
    if (jj_3R_246()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_246()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_161() {
    if (jj_3R_132()) return true;
    return false;
  }

  final private boolean jj_3R_88() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("unichar");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_218()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_217() {
    return false;
  }

  final private boolean jj_3R_215() {
    return false;
  }

  final private boolean jj_3R_274() {
    if (jj_3R_130()) return true;
    return false;
  }

  final private boolean jj_3R_159() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_273()) {
    jj_scanpos = xsp;
    if (jj_3R_274()) return true;
    }
    return false;
  }

  final private boolean jj_3R_273() {
    if (jj_3R_132()) return true;
    if (jj_3R_160()) return true;
    return false;
  }

  final private boolean jj_3R_87() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("tinyint");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_217()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_216() {
    return false;
  }

  final private boolean jj_3R_85() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("timestamp");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_215()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_526() {
    return false;
  }

  final private boolean jj_3R_164() {
    if (jj_3R_160()) return true;
    return false;
  }

  final private boolean jj_3_160() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_164()) jj_scanpos = xsp;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  final private boolean jj_3R_86() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("time");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_216()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_163() {
    if (jj_3R_160()) return true;
    return false;
  }

  final private boolean jj_3_159() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_163()) jj_scanpos = xsp;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  final private boolean jj_3R_411() {
    if (jj_scan_token(NULLIF)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_96()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_96()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_520() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("then");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_526()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_214() {
    return false;
  }

  final private boolean jj_3R_349() {
    if (jj_3R_132()) return true;
    return false;
  }

  final private boolean jj_3R_434() {
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_308() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_349()) jj_scanpos = xsp;
    if (jj_3R_160()) return true;
    return false;
  }

  final private boolean jj_3R_213() {
    return false;
  }

  final private boolean jj_3R_418() {
    if (jj_3R_434()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_503()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_157() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_161()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_84() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("smallmoney");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_214()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_212() {
    return false;
  }

  final private boolean jj_3R_412() {
    if (jj_scan_token(COALESCE)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_418()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_503() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_434()) return true;
    return false;
  }

  final private boolean jj_3R_83() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("smallint");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_213()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_521() {
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_233() {
    return false;
  }

  final private boolean jj_3R_513() {
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_521()) return true;
    return false;
  }

  final private boolean jj_3R_82() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("smalldatetime");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_212()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_504() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_513()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_235() {
    return false;
  }

  final private boolean jj_3R_458() {
    if (jj_scan_token(WHEN)) return true;
    if (jj_3R_144()) return true;
    if (jj_3R_520()) return true;
    if (jj_3R_521()) return true;
    return false;
  }

  final private boolean jj_3R_514() {
    if (jj_3R_458()) return true;
    return false;
  }

  final private boolean jj_3R_109() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check( UK_SEMI_SENSITIVE, "semi sensitive");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_233()) return true;
    if (jj_scan_token(UK_SEMI_SENSITIVE)) return true;
    return false;
  }

  final private boolean jj_3R_253() {
    return false;
  }

  final private boolean jj_3R_436() {
    if (jj_3R_458()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_514()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_111() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("scroll");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_235()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_241() {
    return false;
  }

  final private boolean jj_3R_457() {
    if (jj_scan_token(WHEN)) return true;
    if (jj_3R_96()) return true;
    if (jj_3R_520()) return true;
    if (jj_3R_521()) return true;
    return false;
  }

  final private boolean jj_3R_512() {
    if (jj_3R_457()) return true;
    return false;
  }

  final private boolean jj_3R_138() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("right");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_253()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_211() {
    return false;
  }

  final private boolean jj_3R_435() {
    if (jj_3R_457()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_512()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_117() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("relative");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_241()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_237() {
    return false;
  }

  final private boolean jj_3R_419() {
    if (jj_3R_436()) return true;
    if (jj_3R_504()) return true;
    if (jj_scan_token(END)) return true;
    return false;
  }

  final private boolean jj_3R_81() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("real");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_211()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_251() {
    return false;
  }

  final private boolean jj_3R_162() {
    if (jj_3R_96()) return true;
    if (jj_3R_435()) return true;
    if (jj_3R_504()) return true;
    if (jj_scan_token(END)) return true;
    return false;
  }

  final private boolean jj_3R_413() {
    if (jj_3R_419()) return true;
    return false;
  }

  final private boolean jj_3R_113() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("prior");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_237()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_202() {
    return false;
  }

  final private boolean jj_3_158() {
    if (jj_3R_162()) return true;
    return false;
  }

  final private boolean jj_3R_399() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_158()) {
    jj_scanpos = xsp;
    if (jj_3R_413()) return true;
    }
    return false;
  }

  final private boolean jj_3_156() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(223)) {
    jj_scanpos = xsp;
    if (jj_scan_token(242)) return true;
    }
    if (jj_3R_160()) return true;
    xsp = jj_scanpos;
    if (jj_3_157()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_136() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("outer");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_251()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_379() {
    if (jj_scan_token(CASE)) return true;
    if (jj_3R_399()) return true;
    return false;
  }

  final private boolean jj_3R_201() {
    return false;
  }

  final private boolean jj_3R_72() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check( UK_NVARCHAR_S2, "nchar varying");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_202()) return true;
    if (jj_scan_token(UK_NVARCHAR_S2)) return true;
    return false;
  }

  final private boolean jj_3R_378() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_397()) {
    jj_scanpos = xsp;
    if (jj_3R_398()) return true;
    }
    return false;
  }

  final private boolean jj_3R_397() {
    if (jj_3R_411()) return true;
    return false;
  }

  final private boolean jj_3R_200() {
    return false;
  }

  final private boolean jj_3R_97() {
    if (jj_3R_224()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_156()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_398() {
    if (jj_3R_412()) return true;
    return false;
  }

  final private boolean jj_3R_341() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_362()) {
    jj_scanpos = xsp;
    if (jj_3R_363()) return true;
    }
    return false;
  }

  final private boolean jj_3R_362() {
    if (jj_3R_378()) return true;
    return false;
  }

  final private boolean jj_3R_71() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check( UK_NVARCHAR_S1, "national character varying");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_201()) return true;
    if (jj_scan_token(UK_NVARCHAR_S1)) return true;
    return false;
  }

  final private boolean jj_3R_199() {
    return false;
  }

  final private boolean jj_3R_363() {
    if (jj_3R_379()) return true;
    return false;
  }

  final private boolean jj_3R_70() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check( UK_NVARCHAR_S, "national char varying");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_200()) return true;
    if (jj_scan_token(UK_NVARCHAR_S)) return true;
    return false;
  }

  final private boolean jj_3R_210() {
    return false;
  }

  final private boolean jj_3_152() {
    if (jj_3R_157()) return true;
    return false;
  }

  final private boolean jj_3R_69() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("nvarchar");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_199()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_234() {
    return false;
  }

  final private boolean jj_3_155() {
    if (jj_3R_159()) return true;
    return false;
  }

  final private boolean jj_3_154() {
    if (jj_3R_158()) return true;
    return false;
  }

  final private boolean jj_3_153() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_scan_token(SELECT)) return true;
    return false;
  }

  final private boolean jj_3R_80() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("numeric");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_210()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_270() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_325()) {
    jj_scanpos = xsp;
    if (jj_3R_326()) {
    jj_scanpos = xsp;
    if (jj_3R_327()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_325() {
    if (jj_scan_token(ASTERISK)) return true;
    if (jj_3R_269()) return true;
    return false;
  }

  final private boolean jj_3_146() {
    if (jj_scan_token(258)) return true;
    if (jj_scan_token(258)) return true;
    return false;
  }

  final private boolean jj_3R_224() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_295()) {
    jj_scanpos = xsp;
    if (jj_3R_296()) {
    jj_scanpos = xsp;
    if (jj_3R_297()) {
    jj_scanpos = xsp;
    if (jj_3R_298()) {
    jj_scanpos = xsp;
    if (jj_3R_299()) {
    jj_scanpos = xsp;
    if (jj_3R_300()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_295() {
    if (jj_3R_157()) return true;
    return false;
  }

  final private boolean jj_3R_269() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(225)) jj_scanpos = xsp;
    if (jj_3R_324()) return true;
    return false;
  }

  final private boolean jj_3R_300() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_96()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_110() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check( UK_NO_SCROLL, "no scroll");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_234()) return true;
    if (jj_scan_token(UK_NO_SCROLL)) return true;
    return false;
  }

  final private boolean jj_3R_299() {
    if (jj_3R_341()) return true;
    return false;
  }

  final private boolean jj_3R_356() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(237)) {
    jj_scanpos = xsp;
    if (jj_scan_token(238)) return true;
    }
    return false;
  }

  final private boolean jj_3R_298() {
    if (jj_3R_159()) return true;
    return false;
  }

  final private boolean jj_3R_330() {
    return false;
  }

  final private boolean jj_3R_297() {
    if (jj_3R_158()) return true;
    return false;
  }

  final private boolean jj_3R_324() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_356()) jj_scanpos = xsp;
    if (jj_3R_97()) return true;
    return false;
  }

  final private boolean jj_3_151() {
    if (jj_scan_token(260)) return true;
    return false;
  }

  final private boolean jj_3R_296() {
    if (jj_3R_340()) return true;
    return false;
  }

  final private boolean jj_3_150() {
    if (jj_scan_token(258)) return true;
    return false;
  }

  final private boolean jj_3_149() {
    if (jj_scan_token(259)) return true;
    return false;
  }

  final private boolean jj_3_148() {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  final private boolean jj_3_147() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  final private boolean jj_3R_156() {
    if (jj_3R_269()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_270()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_236() {
    return false;
  }

  final private boolean jj_3_145() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_146()) {
    jj_scanpos = xsp;
    if (jj_3_147()) {
    jj_scanpos = xsp;
    if (jj_3_148()) {
    jj_scanpos = xsp;
    if (jj_3_149()) {
    jj_scanpos = xsp;
    if (jj_3_150()) {
    jj_scanpos = xsp;
    if (jj_3_151()) return true;
    }
    }
    }
    }
    }
    if (jj_3R_156()) return true;
    return false;
  }

  final private boolean jj_3R_277() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("new");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_330()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_198() {
    return false;
  }

  final private boolean jj_3R_112() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("next");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_236()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_96() {
    if (jj_3R_156()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_145()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_197() {
    return false;
  }

  final private boolean jj_3R_327() {
    if (jj_scan_token(261)) return true;
    if (jj_3R_269()) return true;
    return false;
  }

  final private boolean jj_3R_326() {
    if (jj_scan_token(SLASH)) return true;
    if (jj_3R_269()) return true;
    return false;
  }

  final private boolean jj_3R_68() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check( UK_NCHAR_S1, "national character");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_198()) return true;
    if (jj_scan_token(UK_NCHAR_S1)) return true;
    return false;
  }

  final private boolean jj_3R_322() {
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_196() {
    return false;
  }

  final private boolean jj_3R_67() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check( UK_NCHAR_S, "national char");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_197()) return true;
    if (jj_scan_token(UK_NCHAR_S)) return true;
    return false;
  }

  final private boolean jj_3R_268() {
    if (jj_3R_322()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_323()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_323() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_322()) return true;
    return false;
  }

  final private boolean jj_3R_151() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_268()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_470() {
    if (jj_scan_token(SELECT)) return true;
    if (jj_3R_377()) return true;
    return false;
  }

  final private boolean jj_3R_66() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("nchar");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_196()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_209() {
    return false;
  }

  final private boolean jj_3R_499() {
    if (jj_scan_token(ESCAPE)) return true;
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_486() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_499()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_252() {
    return false;
  }

  final private boolean jj_3R_471() {
    if (jj_3R_96()) return true;
    if (jj_3R_486()) return true;
    return false;
  }

  final private boolean jj_3R_79() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("money");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_209()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_456() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(112)) jj_scanpos = xsp;
    if (jj_scan_token(LIKE)) return true;
    if (jj_3R_471()) return true;
    return false;
  }

  final private boolean jj_3R_239() {
    return false;
  }

  final private boolean jj_3R_137() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("left");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_252()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3_144() {
    if (jj_3R_155()) return true;
    return false;
  }

  final private boolean jj_3R_319() {
    if (jj_scan_token(EXISTS)) return true;
    if (jj_3R_340()) return true;
    return false;
  }

  final private boolean jj_3R_195() {
    return false;
  }

  final private boolean jj_3R_451() {
    if (jj_3R_146()) return true;
    if (jj_3R_98()) return true;
    if (jj_3R_340()) return true;
    return false;
  }

  final private boolean jj_3R_115() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("last");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_239()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_194() {
    return false;
  }

  final private boolean jj_3R_450() {
    if (jj_3R_146()) return true;
    if (jj_scan_token(ANY)) return true;
    if (jj_3R_340()) return true;
    return false;
  }

  final private boolean jj_3R_65() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("integer");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_195()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_232() {
    return false;
  }

  final private boolean jj_3R_155() {
    if (jj_3R_96()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_498()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_64() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("int");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_194()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_250() {
    return false;
  }

  final private boolean jj_3R_455() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(112)) jj_scanpos = xsp;
    if (jj_scan_token(IN)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3_144()) {
    jj_scanpos = xsp;
    if (jj_3R_470()) return true;
    }
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_498() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_108() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("insensitive");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_232()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_135() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check( "inner");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_250()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_148() {
    if (jj_3R_267()) return true;
    return false;
  }

  final private boolean jj_3R_154() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(112)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) {
    jj_scanpos = xsp;
    if (jj_scan_token(103)) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_453() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(112)) jj_scanpos = xsp;
    if (jj_scan_token(BETWEEN)) return true;
    if (jj_3R_96()) return true;
    if (jj_scan_token(AND)) return true;
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_208() {
    return false;
  }

  final private boolean jj_3_139() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(112)) jj_scanpos = xsp;
    if (jj_scan_token(LIKE)) return true;
    return false;
  }

  final private boolean jj_3_137() {
    if (jj_scan_token(IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(112)) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_138() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(112)) jj_scanpos = xsp;
    if (jj_scan_token(IN)) return true;
    return false;
  }

  final private boolean jj_3R_267() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(240)) {
    jj_scanpos = xsp;
    if (jj_scan_token(241)) return true;
    }
    return false;
  }

  final private boolean jj_3_136() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(112)) jj_scanpos = xsp;
    if (jj_scan_token(BETWEEN)) return true;
    return false;
  }

  final private boolean jj_3R_147() {
    if (jj_3R_146()) return true;
    return false;
  }

  final private boolean jj_3_135() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_147()) {
    jj_scanpos = xsp;
    if (jj_3R_148()) return true;
    }
    return false;
  }

  final private boolean jj_3R_238() {
    return false;
  }

  final private boolean jj_3_134() {
    if (jj_3R_146()) return true;
    if (jj_3R_98()) return true;
    return false;
  }

  final private boolean jj_3_133() {
    if (jj_3R_146()) return true;
    if (jj_scan_token(ANY)) return true;
    return false;
  }

  final private boolean jj_3R_153() {
    if (jj_3R_267()) return true;
    return false;
  }

  final private boolean jj_3R_454() {
    if (jj_scan_token(IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(112)) jj_scanpos = xsp;
    if (jj_3R_371()) return true;
    return false;
  }

  final private boolean jj_3R_78() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("float");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_208()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_430() {
    if (jj_3R_456()) return true;
    return false;
  }

  final private boolean jj_3R_429() {
    if (jj_3R_455()) return true;
    return false;
  }

  final private boolean jj_3R_428() {
    if (jj_3R_454()) return true;
    return false;
  }

  final private boolean jj_3R_427() {
    if (jj_3R_453()) return true;
    return false;
  }

  final private boolean jj_3R_426() {
    if (jj_3R_452()) return true;
    return false;
  }

  final private boolean jj_3R_114() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("first");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_238()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_425() {
    if (jj_3R_451()) return true;
    return false;
  }

  final private boolean jj_3R_203() {
    return false;
  }

  final private boolean jj_3R_321() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(228)) {
    jj_scanpos = xsp;
    if (jj_scan_token(230)) return true;
    }
    return false;
  }

  final private boolean jj_3R_424() {
    if (jj_3R_450()) return true;
    return false;
  }

  final private boolean jj_3R_469() {
    if (jj_3R_267()) return true;
    return false;
  }

  final private boolean jj_3R_152() {
    if (jj_3R_146()) return true;
    return false;
  }

  final private boolean jj_3R_320() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(228)) {
    jj_scanpos = xsp;
    if (jj_scan_token(230)) {
    jj_scanpos = xsp;
    if (jj_scan_token(226)) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_266() {
    if (jj_scan_token(LESS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_321()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_193() {
    return false;
  }

  final private boolean jj_3R_146() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(230)) {
    jj_scanpos = xsp;
    if (jj_3R_264()) {
    jj_scanpos = xsp;
    if (jj_scan_token(255)) {
    jj_scanpos = xsp;
    if (jj_scan_token(231)) {
    jj_scanpos = xsp;
    if (jj_scan_token(256)) {
    jj_scanpos = xsp;
    if (jj_3R_265()) {
    jj_scanpos = xsp;
    if (jj_scan_token(229)) {
    jj_scanpos = xsp;
    if (jj_3R_266()) {
    jj_scanpos = xsp;
    if (jj_scan_token(257)) {
    jj_scanpos = xsp;
    if (jj_scan_token(227)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_265() {
    if (jj_scan_token(GREATER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(230)) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_431() {
    if (jj_3R_146()) return true;
    if (jj_3R_151()) return true;
    return false;
  }

  final private boolean jj_3R_264() {
    if (jj_scan_token(254)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_320()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_73() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check( UK_DOUBLE_PRECISION, "double precision");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_203()) return true;
    if (jj_scan_token(UK_DOUBLE_PRECISION)) return true;
    return false;
  }

  final private boolean jj_3R_468() {
    if (jj_3R_146()) return true;
    return false;
  }

  final private boolean jj_3R_192() {
    return false;
  }

  final private boolean jj_3R_150() {
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_452() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_468()) {
    jj_scanpos = xsp;
    if (jj_3R_469()) return true;
    }
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3_143() {
    if (jj_3R_96()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_152()) {
    jj_scanpos = xsp;
    if (jj_3R_153()) {
    jj_scanpos = xsp;
    if (jj_3R_154()) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_63() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("dec");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_193()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_206() {
    return false;
  }

  final private boolean jj_3_142() {
    if (jj_3R_151()) return true;
    return false;
  }

  final private boolean jj_3R_62() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("decimal");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_192()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_207() {
    return false;
  }

  final private boolean jj_3R_76() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("datetime");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_206()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_191() {
    return false;
  }

  final private boolean jj_3R_149() {
    Token xsp;
    if (jj_scan_token(233)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(233)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(SELECT)) return true;
    return false;
  }

  final private boolean jj_3_141() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_149()) {
    jj_scanpos = xsp;
    if (jj_3R_150()) return true;
    }
    return false;
  }

  final private boolean jj_3R_263() {
    if (jj_3R_151()) return true;
    if (jj_3R_431()) return true;
    return false;
  }

  final private boolean jj_3_140() {
    if (jj_scan_token(EXISTS)) return true;
    return false;
  }

  final private boolean jj_3R_77() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("date");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_207()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_466() {
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_190() {
    return false;
  }

  final private boolean jj_3R_449() {
    if (jj_3R_466()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_467()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_61() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("character");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_191()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_262() {
    if (jj_3R_96()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_424()) {
    jj_scanpos = xsp;
    if (jj_3R_425()) {
    jj_scanpos = xsp;
    if (jj_3R_426()) {
    jj_scanpos = xsp;
    if (jj_3R_427()) {
    jj_scanpos = xsp;
    if (jj_3R_428()) {
    jj_scanpos = xsp;
    if (jj_3R_429()) {
    jj_scanpos = xsp;
    if (jj_3R_430()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_145() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_261()) {
    jj_scanpos = xsp;
    if (jj_3R_262()) {
    jj_scanpos = xsp;
    if (jj_3R_263()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_261() {
    if (jj_3R_319()) return true;
    return false;
  }

  final private boolean jj_3R_423() {
    if (jj_scan_token(BY)) return true;
    if (jj_3R_449()) return true;
    return false;
  }

  final private boolean jj_3R_467() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_466()) return true;
    return false;
  }

  final private boolean jj_3R_60() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("char");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_190()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_416() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_423()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_205() {
    return false;
  }

  final private boolean jj_3R_204() {
    return false;
  }

  final private boolean jj_3R_75() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("bit");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_205()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_448() {
    if (jj_scan_token(SUM)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_96()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_225() {
    return false;
  }

  final private boolean jj_3R_447() {
    if (jj_scan_token(MIN)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_96()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_74() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("binary");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_204()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_444() {
    if (jj_scan_token(COUNT)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_96()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_240() {
    return false;
  }

  final private boolean jj_3R_421() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_444()) {
    jj_scanpos = xsp;
    if (jj_3R_445()) {
    jj_scanpos = xsp;
    if (jj_3R_446()) {
    jj_scanpos = xsp;
    if (jj_3R_447()) {
    jj_scanpos = xsp;
    if (jj_3R_448()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_446() {
    if (jj_scan_token(MAX)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_96()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_98() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("all");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_225()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_445() {
    if (jj_scan_token(AVG)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_96()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_415() {
    if (jj_3R_421()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_422()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_116() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = check("absolute");
    lookingAhead = false;
    if (!jj_semLA || jj_3R_240()) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_403() {
    if (jj_scan_token(COMPUTE)) return true;
    if (jj_3R_415()) return true;
    if (jj_3R_416()) return true;
    return false;
  }

  final private boolean jj_3R_422() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_421()) return true;
    return false;
  }

  final private boolean jj_3R_404() {
    if (jj_3R_403()) return true;
    return false;
  }

  final private boolean jj_3R_386() {
    if (jj_3R_403()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_404()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_369() {
    if (jj_3R_386()) return true;
    return false;
  }

  final private boolean jj_3R_352() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_369()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_414() {
    if (jj_3R_420()) return true;
    return false;
  }

  final private boolean jj_3R_420() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) return true;
    }
    return false;
  }

  final private boolean jj_3R_385() {
    if (jj_3R_401()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_402()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_401() {
    if (jj_3R_96()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_414()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_368() {
    if (jj_scan_token(ORDER)) return true;
    if (jj_scan_token(BY)) return true;
    if (jj_3R_385()) return true;
    return false;
  }

  final private boolean jj_3R_351() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_368()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_402() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_401()) return true;
    return false;
  }

  final private boolean jj_3R_465() {
    if (jj_scan_token(HAVING)) return true;
    if (jj_3R_144()) return true;
    return false;
  }

  final private boolean jj_3R_443() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_465()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_131() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(205)) {
    jj_scanpos = xsp;
    if (jj_scan_token(206)) return true;
    }
    return false;
  }

  final private boolean jj_3R_496() {
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_485() {
    if (jj_3R_496()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_497()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_132() {
    if (jj_3R_98()) return true;
    return false;
  }

  final private boolean jj_3R_484() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_132()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_497() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_496()) return true;
    return false;
  }

  final private boolean jj_3R_464() {
    if (jj_scan_token(GROUP)) return true;
    if (jj_scan_token(BY)) return true;
    if (jj_3R_484()) return true;
    if (jj_3R_485()) return true;
    return false;
  }

  final private boolean jj_3R_143() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_257()) {
    jj_scanpos = xsp;
    if (jj_3R_258()) {
    jj_scanpos = xsp;
    if (jj_3_131()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_257() {
    if (jj_3R_316()) return true;
    return false;
  }

  final private boolean jj_3R_318() {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_317()) return true;
    return false;
  }

  final private boolean jj_3R_442() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_464()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_130() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_144()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_260() {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_259()) return true;
    return false;
  }

  final private boolean jj_3_131() {
    if (jj_3R_145()) return true;
    return false;
  }

  final private boolean jj_3_129() {
    if (jj_3R_143()) return true;
    return false;
  }

  final private boolean jj_3R_258() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_144()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_317() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_129()) {
    jj_scanpos = xsp;
    if (jj_3R_355()) return true;
    }
    return false;
  }

  final private boolean jj_3R_259() {
    if (jj_3R_317()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_318()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_355() {
    if (jj_scan_token(NOT)) return true;
    if (jj_3R_143()) return true;
    return false;
  }

  final private boolean jj_3R_144() {
    if (jj_3R_259()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_260()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_463() {
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_144()) return true;
    return false;
  }

  final private boolean jj_3_125() {
    if (jj_3R_140()) return true;
    if (jj_3R_141()) return true;
    if (jj_scan_token(ON)) return true;
    if (jj_3R_144()) return true;
    return false;
  }

  final private boolean jj_3R_256() {
    if (jj_3R_130()) return true;
    return false;
  }

  final private boolean jj_3R_142() {
    if (jj_3R_256()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_388()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_388() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_256()) return true;
    return false;
  }

  final private boolean jj_3_128() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_142()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_315() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_128()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_249() {
    if (jj_3R_133()) return true;
    return false;
  }

  final private boolean jj_3R_354() {
    if (jj_3R_130()) return true;
    return false;
  }

  final private boolean jj_3R_314() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_354()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_124() {
    if (jj_3R_140()) return true;
    if (jj_3R_141()) return true;
    if (jj_scan_token(ON)) return true;
    if (jj_3R_144()) return true;
    return false;
  }

  final private boolean jj_3R_309() {
    if (jj_3R_126()) return true;
    if (jj_3R_130()) return true;
    return false;
  }

  final private boolean jj_3R_255() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_181()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    if (jj_3R_126()) return true;
    if (jj_3R_314()) return true;
    if (jj_3R_315()) return true;
    if (jj_3R_311()) return true;
    if (jj_3R_312()) return true;
    if (jj_3R_313()) return true;
    return false;
  }

  final private boolean jj_3R_248() {
    if (jj_scan_token(PARTITION)) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3_126() {
    if (jj_3R_141()) return true;
    return false;
  }

  final private boolean jj_3_127() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_141()) return true;
    Token xsp;
    if (jj_3_125()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_125()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_254() {
    if (jj_3R_308()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_309()) jj_scanpos = xsp;
    if (jj_3R_310()) return true;
    if (jj_3R_311()) return true;
    if (jj_3R_312()) return true;
    if (jj_3R_313()) return true;
    return false;
  }

  final private boolean jj_3R_141() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_254()) {
    jj_scanpos = xsp;
    if (jj_3R_255()) return true;
    }
    return false;
  }

  final private boolean jj_3R_522() {
    if (jj_3R_141()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_124()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_495() {
    if (jj_3R_506()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_507()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_462() {
    if (jj_3R_483()) return true;
    return false;
  }

  final private boolean jj_3R_515() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_522()) {
    jj_scanpos = xsp;
    if (jj_3_127()) return true;
    }
    return false;
  }

  final private boolean jj_3R_440() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_462()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_507() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_506()) return true;
    return false;
  }

  final private boolean jj_3R_483() {
    if (jj_scan_token(FROM)) return true;
    if (jj_3R_495()) return true;
    return false;
  }

  final private boolean jj_3R_506() {
    if (jj_3R_515()) return true;
    return false;
  }

  final private boolean jj_3_123() {
    if (jj_scan_token(WHERE)) return true;
    if (jj_scan_token(CURRENT)) return true;
    return false;
  }

  final private boolean jj_3_113() {
    if (jj_3R_133()) return true;
    return false;
  }

  final private boolean jj_3_122() {
    if (jj_scan_token(WHERE)) return true;
    if (jj_scan_token(CURRENT)) return true;
    return false;
  }

  final private boolean jj_3_117() {
    if (jj_3R_136()) return true;
    return false;
  }

  final private boolean jj_3R_129() {
    if (jj_scan_token(EQUAL)) return true;
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_492() {
    if (jj_3R_59()) return true;
    if (jj_3R_59()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3_118() {
    if (jj_3R_136()) return true;
    return false;
  }

  final private boolean jj_3R_140() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_119()) {
    jj_scanpos = xsp;
    if (jj_3_120()) {
    jj_scanpos = xsp;
    if (jj_3_121()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_119() {
    if (jj_3R_137()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_117()) jj_scanpos = xsp;
    if (jj_scan_token(JOIN)) return true;
    return false;
  }

  final private boolean jj_3R_400() {
    if (jj_3R_59()) return true;
    return false;
  }

  final private boolean jj_3_116() {
    if (jj_3R_135()) return true;
    return false;
  }

  final private boolean jj_3R_139() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_116()) jj_scanpos = xsp;
    if (jj_scan_token(JOIN)) return true;
    return false;
  }

  final private boolean jj_3R_381() {
    if (jj_3R_130()) return true;
    return false;
  }

  final private boolean jj_3R_491() {
    if (jj_scan_token(ID)) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3_121() {
    if (jj_3R_139()) return true;
    return false;
  }

  final private boolean jj_3_120() {
    if (jj_3R_138()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_118()) jj_scanpos = xsp;
    if (jj_scan_token(JOIN)) return true;
    return false;
  }

  final private boolean jj_3R_366() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_382()) {
    jj_scanpos = xsp;
    if (jj_3R_383()) return true;
    }
    return false;
  }

  final private boolean jj_3R_382() {
    if (jj_scan_token(ID)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_400()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_134() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_114()) {
    jj_scanpos = xsp;
    if (jj_3R_248()) {
    jj_scanpos = xsp;
    if (jj_3R_249()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_114() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_113()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_128() {
    if (jj_3R_131()) return true;
    return false;
  }

  final private boolean jj_3R_365() {
    if (jj_scan_token(INDEX)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(202)) {
    jj_scanpos = xsp;
    if (jj_3R_381()) return true;
    }
    return false;
  }

  final private boolean jj_3R_383() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_scan_token(ID)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_491()) {
    jj_scanpos = xsp;
    if (jj_3R_492()) return true;
    }
    return false;
  }

  final private boolean jj_3R_307() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_347()) {
    jj_scanpos = xsp;
    if (jj_3R_348()) return true;
    }
    return false;
  }

  final private boolean jj_3R_347() {
    if (jj_3R_365()) return true;
    return false;
  }

  final private boolean jj_3R_247() {
    if (jj_3R_307()) return true;
    return false;
  }

  final private boolean jj_3R_133() {
    Token xsp;
    if (jj_3R_247()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_247()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_127() {
    if (jj_3R_130()) return true;
    return false;
  }

  final private boolean jj_3R_348() {
    if (jj_3R_366()) return true;
    return false;
  }

  final private boolean jj_3_115() {
    if (jj_scan_token(OPENPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_134()) jj_scanpos = xsp;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_310() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_115()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_312() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(145)) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_313() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(166)) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_350() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(110)) return true;
    }
    return false;
  }

  final private boolean jj_3R_311() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_350()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_105() {
    if (jj_3R_126()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_127()) {
    jj_scanpos = xsp;
    if (jj_3R_128()) return true;
    }
    return false;
  }

  final private boolean jj_3_106() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_105()) {
    jj_scanpos = xsp;
    if (jj_3R_129()) return true;
    }
    return false;
  }

  final private boolean jj_3R_494() {
    if (jj_scan_token(IDENTITY)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3_98() {
    if (jj_3R_117()) return true;
    return false;
  }

  final private boolean jj_3_104() {
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3_97() {
    if (jj_3R_116()) return true;
    return false;
  }

  final private boolean jj_3R_231() {
    if (jj_scan_token(VAR_NAME)) return true;
    return false;
  }

  final private boolean jj_3R_107() {
    if (jj_3R_231()) return true;
    return false;
  }

  final private boolean jj_3_111() {
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_301() {
    if (jj_3R_132()) return true;
    return false;
  }

  final private boolean jj_3R_226() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_301()) jj_scanpos = xsp;
    if (jj_scan_token(ASTERISK)) return true;
    return false;
  }

  final private boolean jj_3R_101() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_112()) {
    jj_scanpos = xsp;
    if (jj_3R_226()) return true;
    }
    return false;
  }

  final private boolean jj_3_112() {
    if (jj_3R_103()) return true;
    return false;
  }

  final private boolean jj_3_96() {
    if (jj_3R_115()) return true;
    return false;
  }

  final private boolean jj_3R_481() {
    if (jj_3R_96()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_106()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_126() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(18)) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_493() {
    if (jj_3R_505()) return true;
    if (jj_scan_token(EQUAL)) return true;
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3_110() {
    if (jj_3R_132()) return true;
    if (jj_scan_token(ASTERISK)) return true;
    return false;
  }

  final private boolean jj_3_95() {
    if (jj_3R_114()) return true;
    return false;
  }

  final private boolean jj_3_109() {
    if (jj_3R_131()) return true;
    if (jj_scan_token(EQUAL)) return true;
    return false;
  }

  final private boolean jj_3_108() {
    if (jj_3R_130()) return true;
    if (jj_scan_token(EQUAL)) return true;
    return false;
  }

  final private boolean jj_3_107() {
    if (jj_scan_token(VAR_NAME)) return true;
    if (jj_scan_token(EQUAL)) return true;
    return false;
  }

  final private boolean jj_3R_480() {
    if (jj_3R_132()) return true;
    if (jj_scan_token(ASTERISK)) return true;
    return false;
  }

  final private boolean jj_3R_479() {
    if (jj_3R_131()) return true;
    if (jj_scan_token(EQUAL)) return true;
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_478() {
    if (jj_3R_130()) return true;
    if (jj_scan_token(EQUAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_104()) {
    jj_scanpos = xsp;
    if (jj_3R_494()) return true;
    }
    return false;
  }

  final private boolean jj_3R_477() {
    if (jj_3R_493()) return true;
    return false;
  }

  final private boolean jj_3R_459() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_477()) {
    jj_scanpos = xsp;
    if (jj_3R_478()) {
    jj_scanpos = xsp;
    if (jj_3R_479()) {
    jj_scanpos = xsp;
    if (jj_scan_token(235)) {
    jj_scanpos = xsp;
    if (jj_3R_480()) {
    jj_scanpos = xsp;
    if (jj_3R_481()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_94() {
    if (jj_3R_113()) return true;
    return false;
  }

  final private boolean jj_3R_438() {
    if (jj_3R_459()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_460()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_460() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_459()) return true;
    return false;
  }

  final private boolean jj_3_93() {
    if (jj_3R_112()) return true;
    return false;
  }

  final private boolean jj_3R_275() {
    if (jj_3R_130()) return true;
    return false;
  }

  final private boolean jj_3R_160() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_275()) {
    jj_scanpos = xsp;
    if (jj_3R_276()) return true;
    }
    return false;
  }

  final private boolean jj_3R_130() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(210)) {
    jj_scanpos = xsp;
    if (jj_scan_token(216)) {
    jj_scanpos = xsp;
    if (jj_scan_token(211)) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_276() {
    if (jj_3R_131()) return true;
    return false;
  }

  final private boolean jj_3R_187() {
    if (jj_scan_token(PRINT)) return true;
    return false;
  }

  final private boolean jj_3R_244() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_304()) {
    jj_scanpos = xsp;
    if (jj_3R_305()) return true;
    }
    return false;
  }

  final private boolean jj_3R_304() {
    if (jj_3R_130()) return true;
    return false;
  }

  final private boolean jj_3R_125() {
    if (jj_3R_244()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_245()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_103() {
    if (jj_3R_125()) return true;
    return false;
  }

  final private boolean jj_3R_305() {
    if (jj_3R_345()) return true;
    return false;
  }

  final private boolean jj_3_102() {
    if (jj_3R_98()) return true;
    return false;
  }

  final private boolean jj_3R_245() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  final private boolean jj_3R_124() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_242()) {
    jj_scanpos = xsp;
    if (jj_3R_243()) return true;
    }
    return false;
  }

  final private boolean jj_3R_242() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    if (jj_scan_token(253)) return true;
    return false;
  }

  final private boolean jj_3_101() {
    if (jj_3R_124()) return true;
    return false;
  }

  final private boolean jj_3R_123() {
    if (jj_3R_117()) return true;
    return false;
  }

  final private boolean jj_3R_243() {
    if (jj_3R_303()) return true;
    return false;
  }

  final private boolean jj_3R_58() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(178)) return true;
    }
    return false;
  }

  final private boolean jj_3R_122() {
    if (jj_3R_116()) return true;
    return false;
  }

  final private boolean jj_3R_338() {
    if (jj_scan_token(BEGIN)) return true;
    return false;
  }

  final private boolean jj_3R_121() {
    if (jj_3R_115()) return true;
    return false;
  }

  final private boolean jj_3R_292() {
    if (jj_scan_token(IF)) return true;
    return false;
  }

  final private boolean jj_3R_120() {
    if (jj_3R_114()) return true;
    return false;
  }

  final private boolean jj_3_100() {
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_186() {
    if (jj_3R_292()) return true;
    return false;
  }

  final private boolean jj_3R_185() {
    if (jj_scan_token(RETURN)) return true;
    return false;
  }

  final private boolean jj_3R_119() {
    if (jj_3R_113()) return true;
    return false;
  }

  final private boolean jj_3R_118() {
    if (jj_3R_112()) return true;
    return false;
  }

  final private boolean jj_3_99() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_118()) {
    jj_scanpos = xsp;
    if (jj_3R_119()) {
    jj_scanpos = xsp;
    if (jj_3R_120()) {
    jj_scanpos = xsp;
    if (jj_3R_121()) {
    jj_scanpos = xsp;
    if (jj_3R_122()) {
    jj_scanpos = xsp;
    if (jj_3R_123()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_183() {
    if (jj_3R_289()) return true;
    return false;
  }

  final private boolean jj_3R_289() {
    if (jj_scan_token(FETCH)) return true;
    return false;
  }

  final private boolean jj_3R_106() {
    if (jj_scan_token(DECLARE)) return true;
    return false;
  }

  final private boolean jj_3_90() {
    if (jj_3R_110()) return true;
    return false;
  }

  final private boolean jj_3_92() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_90()) {
    jj_scanpos = xsp;
    if (jj_3_91()) return true;
    }
    return false;
  }

  final private boolean jj_3_91() {
    if (jj_3R_111()) return true;
    return false;
  }

  final private boolean jj_3_87() {
    if (jj_3R_108()) return true;
    return false;
  }

  final private boolean jj_3_89() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_87()) {
    jj_scanpos = xsp;
    if (jj_3_88()) return true;
    }
    return false;
  }

  final private boolean jj_3_88() {
    if (jj_3R_109()) return true;
    return false;
  }

  final private boolean jj_3_86() {
    if (jj_3R_106()) return true;
    if (jj_3R_107()) return true;
    return false;
  }

  final private boolean jj_3_85() {
    if (jj_3R_43()) return true;
    return false;
  }

  final private boolean jj_3R_336() {
    if (jj_3R_106()) return true;
    return false;
  }

  final private boolean jj_3R_105() {
    Token xsp;
    if (jj_3_85()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_85()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_84() {
    if (jj_3R_105()) return true;
    return false;
  }

  final private boolean jj_3R_339() {
    if (jj_scan_token(BEGIN)) return true;
    return false;
  }

  final private boolean jj_3R_284() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_86()) {
    jj_scanpos = xsp;
    if (jj_3R_336()) return true;
    }
    return false;
  }

  final private boolean jj_3R_490() {
    if (jj_scan_token(AT)) return true;
    if (jj_scan_token(ISOLATION)) return true;
    if (jj_3R_387()) return true;
    return false;
  }

  final private boolean jj_3R_476() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_490()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_104() {
    if (jj_3R_160()) return true;
    return false;
  }

  final private boolean jj_3_83() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_104()) jj_scanpos = xsp;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  final private boolean jj_3R_533() {
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_534() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_533()) return true;
    return false;
  }

  final private boolean jj_3R_527() {
    if (jj_3R_533()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_534()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_523() {
    if (jj_scan_token(BY)) return true;
    if (jj_3R_527()) return true;
    return false;
  }

  final private boolean jj_3R_532() {
    if (jj_scan_token(SUM)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_96()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_518() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_523()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_531() {
    if (jj_scan_token(MIN)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_96()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_530() {
    if (jj_scan_token(MAX)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_96()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_529() {
    if (jj_scan_token(AVG)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_96()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_528() {
    if (jj_scan_token(COUNT)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_96()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_524() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_528()) {
    jj_scanpos = xsp;
    if (jj_3R_529()) {
    jj_scanpos = xsp;
    if (jj_3R_530()) {
    jj_scanpos = xsp;
    if (jj_3R_531()) {
    jj_scanpos = xsp;
    if (jj_3R_532()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_525() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_524()) return true;
    return false;
  }

  final private boolean jj_3R_511() {
    if (jj_3R_510()) return true;
    return false;
  }

  final private boolean jj_3R_519() {
    if (jj_3R_524()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_525()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_510() {
    if (jj_scan_token(COMPUTE)) return true;
    if (jj_3R_518()) return true;
    if (jj_3R_519()) return true;
    if (jj_3R_518()) return true;
    return false;
  }

  final private boolean jj_3R_517() {
    if (jj_3R_420()) return true;
    return false;
  }

  final private boolean jj_3R_502() {
    if (jj_3R_510()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_511()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_489() {
    if (jj_3R_502()) return true;
    return false;
  }

  final private boolean jj_3R_475() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_489()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_508() {
    if (jj_3R_96()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_517()) jj_scanpos = xsp;
    return false;
  }

  public GenericSQLParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[198];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static private int[] jj_la1_7;
  static private int[] jj_la1_8;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
      jj_la1_3();
      jj_la1_4();
      jj_la1_5();
      jj_la1_6();
      jj_la1_7();
      jj_la1_8();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x400000,0x10000000,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x80000,0x0,0x0,0x0,0x400000,0x10000000,0x0,0x0,0x1000000,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x40000,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x80000,0x210c0293,0x10110004,0x0,0x10000000,0x4,0x4,0x10000,0x110000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x2000000,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x400000,0x20,0x20,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x400000,0x20,0x20,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x8,0x8,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x2000000,0x2000000,0x2000000,0x2000000,0x1000,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0x0,0x20000,0x20000,0x0,0x1000000,0x0,0xc0030,0x4010200,0x0,0x0,0x0,0x0,0x10200,0x4010200,0x0,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x400000,0x400000,0x0,0x0,0x4000000,0x4000000,0x4000000,0x4000000,0x0,0x0,0x0,0x0,0x0,0x4000,0x4000,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x5000320,0x8000,0x0,0x0,0x8000,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0xc00,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0xc0000000,0xc0000000,0x4000,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x10000,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0xc00,0x0,0x0,0x10000,0x80,0x10081,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x10000,0x10000,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x40000,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x20000,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc00,};
   }
   private static void jj_la1_4() {
      jj_la1_4 = new int[] {0x0,0x0,0x0,0x0,0x2000080,0x0,0x2a6cc020,0x10000600,0x0,0x0,0x0,0x0,0x10000600,0x10000600,0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x2,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_5() {
      jj_la1_5 = new int[] {0x0,0x0,0x0,0x4000000,0x0,0x0,0x2000b2,0x80902004,0x800000,0x0,0x0,0x0,0x102000,0x80102004,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000008,0x0,0x0,0x0,0x0,0x400000,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000,0xc0000,0xc0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,};
   }
   private static void jj_la1_6() {
      jj_la1_6 = new int[] {0x6000,0x40000000,0x40000000,0x0,0x0,0x0,0x40049,0x40000,0x0,0x0,0x0,0x0,0x40000,0x40000,0x0,0x20000000,0x20000000,0x10c6000,0x20000000,0x0,0x0,0x20000000,0x10c6000,0x0,0x20000000,0x0,0x20000000,0x200000,0x0,0x0,0x0,0x4,0x0,0x20000000,0x0,0x0,0x40400,0x0,0x0,0x4,0x0,0x0,0x4,0x0,0x810c6000,0x810c6000,0x0,0x20000000,0x0,0x0,0x0,0x20000000,0x0,0x0,0x20000000,0x0,0x20000000,0x0,0x0,0x200400,0x200400,0x0,0x20000000,0x0,0x0,0x20,0x20,0x0,0x1ac0400,0x20000000,0x1ac0000,0x20000000,0xa06000,0x10c6000,0x10c0000,0x20000000,0x0,0x10c6000,0x0,0x0,0x0,0x810c6000,0x810c6000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x40400,0x40000,0x40000,0x10c0400,0x400,0x40400,0x40000,0x4,0x4,0x4,0x4,0x4,0x0,0x20000000,0x810c6000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x2,0x2,0x2,0x0,0x20000000,0x81ac6000,0x10c0000,0x810c6000,0x1ac0000,0xa06000,0x1ac4000,0xa00400,0x0,0x400,0xa2ec00,0x20c00,0xa0e000,0x0,0x0,0x1aeec00,0xa00000,0xa00000,0x80000000,0x0,0x0,0x810c6000,0x20000000,0x0,0x10c6000,0x10c6000,0x0,0x20000000,0x20000000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_7() {
      jj_la1_7 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6000,0x6000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x8000,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x40,0x800,0x0,0x0,0x800,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x200,0x200,0x200,0x0,0x6000,0x6000,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc00300fc,0xc00300fc,0x0,0x200,0xc00300fc,0x54,0x54,0x40,0x50,0x50,0xc00000fc,0x30000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1800,0x1800,0x2,0x6000,0x6000,0x200,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x0,0x8000,0x8000,0x8000,0x8000,0x2000,0x6000,0x8000,0x0,0x8000,0x6000,0x6000,0xe000,0x8000,0x8000,0x40000,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_8() {
      jj_la1_8 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x3,0x0,0x0,0x3,0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[177];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public GenericSQLParser(java.io.InputStream stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new GenericSQLParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 198; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 198; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public GenericSQLParser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new GenericSQLParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 198; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 198; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public GenericSQLParser(GenericSQLParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 198; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(GenericSQLParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 198; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[262];
    for (int i = 0; i < 262; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 198; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
          if ((jj_la1_6[i] & (1<<j)) != 0) {
            la1tokens[192+j] = true;
          }
          if ((jj_la1_7[i] & (1<<j)) != 0) {
            la1tokens[224+j] = true;
          }
          if ((jj_la1_8[i] & (1<<j)) != 0) {
            la1tokens[256+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 262; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 177; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
            case 54: jj_3_55(); break;
            case 55: jj_3_56(); break;
            case 56: jj_3_57(); break;
            case 57: jj_3_58(); break;
            case 58: jj_3_59(); break;
            case 59: jj_3_60(); break;
            case 60: jj_3_61(); break;
            case 61: jj_3_62(); break;
            case 62: jj_3_63(); break;
            case 63: jj_3_64(); break;
            case 64: jj_3_65(); break;
            case 65: jj_3_66(); break;
            case 66: jj_3_67(); break;
            case 67: jj_3_68(); break;
            case 68: jj_3_69(); break;
            case 69: jj_3_70(); break;
            case 70: jj_3_71(); break;
            case 71: jj_3_72(); break;
            case 72: jj_3_73(); break;
            case 73: jj_3_74(); break;
            case 74: jj_3_75(); break;
            case 75: jj_3_76(); break;
            case 76: jj_3_77(); break;
            case 77: jj_3_78(); break;
            case 78: jj_3_79(); break;
            case 79: jj_3_80(); break;
            case 80: jj_3_81(); break;
            case 81: jj_3_82(); break;
            case 82: jj_3_83(); break;
            case 83: jj_3_84(); break;
            case 84: jj_3_85(); break;
            case 85: jj_3_86(); break;
            case 86: jj_3_87(); break;
            case 87: jj_3_88(); break;
            case 88: jj_3_89(); break;
            case 89: jj_3_90(); break;
            case 90: jj_3_91(); break;
            case 91: jj_3_92(); break;
            case 92: jj_3_93(); break;
            case 93: jj_3_94(); break;
            case 94: jj_3_95(); break;
            case 95: jj_3_96(); break;
            case 96: jj_3_97(); break;
            case 97: jj_3_98(); break;
            case 98: jj_3_99(); break;
            case 99: jj_3_100(); break;
            case 100: jj_3_101(); break;
            case 101: jj_3_102(); break;
            case 102: jj_3_103(); break;
            case 103: jj_3_104(); break;
            case 104: jj_3_105(); break;
            case 105: jj_3_106(); break;
            case 106: jj_3_107(); break;
            case 107: jj_3_108(); break;
            case 108: jj_3_109(); break;
            case 109: jj_3_110(); break;
            case 110: jj_3_111(); break;
            case 111: jj_3_112(); break;
            case 112: jj_3_113(); break;
            case 113: jj_3_114(); break;
            case 114: jj_3_115(); break;
            case 115: jj_3_116(); break;
            case 116: jj_3_117(); break;
            case 117: jj_3_118(); break;
            case 118: jj_3_119(); break;
            case 119: jj_3_120(); break;
            case 120: jj_3_121(); break;
            case 121: jj_3_122(); break;
            case 122: jj_3_123(); break;
            case 123: jj_3_124(); break;
            case 124: jj_3_125(); break;
            case 125: jj_3_126(); break;
            case 126: jj_3_127(); break;
            case 127: jj_3_128(); break;
            case 128: jj_3_129(); break;
            case 129: jj_3_130(); break;
            case 130: jj_3_131(); break;
            case 131: jj_3_132(); break;
            case 132: jj_3_133(); break;
            case 133: jj_3_134(); break;
            case 134: jj_3_135(); break;
            case 135: jj_3_136(); break;
            case 136: jj_3_137(); break;
            case 137: jj_3_138(); break;
            case 138: jj_3_139(); break;
            case 139: jj_3_140(); break;
            case 140: jj_3_141(); break;
            case 141: jj_3_142(); break;
            case 142: jj_3_143(); break;
            case 143: jj_3_144(); break;
            case 144: jj_3_145(); break;
            case 145: jj_3_146(); break;
            case 146: jj_3_147(); break;
            case 147: jj_3_148(); break;
            case 148: jj_3_149(); break;
            case 149: jj_3_150(); break;
            case 150: jj_3_151(); break;
            case 151: jj_3_152(); break;
            case 152: jj_3_153(); break;
            case 153: jj_3_154(); break;
            case 154: jj_3_155(); break;
            case 155: jj_3_156(); break;
            case 156: jj_3_157(); break;
            case 157: jj_3_158(); break;
            case 158: jj_3_159(); break;
            case 159: jj_3_160(); break;
            case 160: jj_3_161(); break;
            case 161: jj_3_162(); break;
            case 162: jj_3_163(); break;
            case 163: jj_3_164(); break;
            case 164: jj_3_165(); break;
            case 165: jj_3_166(); break;
            case 166: jj_3_167(); break;
            case 167: jj_3_168(); break;
            case 168: jj_3_169(); break;
            case 169: jj_3_170(); break;
            case 170: jj_3_171(); break;
            case 171: jj_3_172(); break;
            case 172: jj_3_173(); break;
            case 173: jj_3_174(); break;
            case 174: jj_3_175(); break;
            case 175: jj_3_176(); break;
            case 176: jj_3_177(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
