/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.pages.general;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.DataTypeProviderExt;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.RoutineSourceUpdater;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.commonui.FullNameCompositeProvider;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.commonui.INameCompositeProvider;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.commonui.ParametersData;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.commonui.ParametersRowData;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.commonui.ParametersTableProvider;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.pages.general.Messages;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.pages.general.ProceduralObjectGeneralPage;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.SQLUtil;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlBuilderWrapper;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseParameter;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseRoutine;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybasesqlmodelFactory;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DateDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.TimeDataType;
import org.eclipse.datatools.modelbase.sql.routines.Parameter;
import org.eclipse.datatools.modelbase.sql.routines.ParameterMode;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.sqltools.common.core.tableviewer.IRowData;
import org.eclipse.datatools.sqltools.common.core.tableviewer.ITableData;
import org.eclipse.datatools.sqltools.common.core.tableviewer.ITableDataChangeListener;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.AccessibleTableViewer;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.RemoveAllRowAction;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.RemoveRowAction;
import org.eclipse.datatools.sqltools.core.DataTypeProvider;
import org.eclipse.datatools.sqltools.core.DataTypeValidator;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.modelvalidity.ContainmentFeatureValidationItem;
import org.eclipse.datatools.sqltools.core.modelvalidity.DiagnosticUtil;
import org.eclipse.datatools.sqltools.core.modelvalidity.SQLModelValidationDelegate;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.IErrorItem;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorPage;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.common.CompositeEditSection;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.ErrorItem;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.SchemaObjectEditorInput;
import org.eclipse.datatools.sqltools.sql.updater.ProceduralObjectSourceUpdater;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class RoutineGeneralPage
extends ProceduralObjectGeneralPage
implements ISchemaObjectEditorPage,
ITableDataChangeListener {
    protected CompositeEditSection _paraSection;
    protected ParametersTableProvider _paraProvider;
    protected ParametersData _paramData = new ParametersData();
    protected Schema _schema;
    protected Routine _oldRoutine;
    protected List _schemas = new ArrayList();
    protected Diagnostic _uiDiagnostic;
    public static final int PARAMETER_FOCUS = 0;
    protected List _cachedParamRow = new ArrayList();
    protected List _validParamRow = new ArrayList();

    protected void composeSections(FormToolkit toolkit, Composite container) {
        this.createTitleSection(toolkit, container);
        this.createParameterSection(toolkit, container);
    }

    protected void createParameterSection(FormToolkit toolkit, Composite container) {
        String[] buttonText = new String[]{Messages.RoutineGeneralPage_add, Messages.RoutineGeneralPage_delete, Messages.RoutineGeneralPage_delete_all, Messages.RoutineGeneralPage_up, Messages.RoutineGeneralPage_down};
        this._paraSection = new CompositeEditSection(toolkit, Messages.RoutineGeneralPage_parameters, container.getDisplay(), true, false, 0, buttonText, 80){

            protected void buttonSelected(SelectionEvent e, int buttonIndex) {
                AccessibleTableViewer viewer = RoutineGeneralPage.this._paraProvider.getViewer();
                Object action = null;
                switch (buttonIndex) {
                    case 0: {
                        action = new AddRowAction(viewer);
                        action.run();
                        RoutineGeneralPage.this.updateButtons();
                        break;
                    }
                    case 1: {
                        action = new RemoveRowAction(viewer);
                        action.run();
                        RoutineGeneralPage.this.updateButtons();
                        break;
                    }
                    case 2: {
                        action = new RemoveAllRowAction(viewer);
                        action.run();
                        RoutineGeneralPage.this.updateButtons();
                        break;
                    }
                    case 3: {
                        viewer.moveupRow();
                        RoutineGeneralPage.this.rowMoved(viewer.getCursor().getTableRow());
                        break;
                    }
                    case 4: {
                        viewer.movedownRow();
                        RoutineGeneralPage.this.rowMoved(viewer.getCursor().getTableRow() - 1);
                    }
                }
            }
        };
        this._paraSection.createControl(container, 1, null);
        TableWrapData td2 = new TableWrapData(256, 256);
        this._paraSection.getSection().setLayoutData((Object)td2);
        Composite tableComp = this._paraSection.getLeftComposite();
        this._paraProvider = this.createParametersTableProvider();
        this._paraProvider.getComposite(tableComp, toolkit, 0);
        this._paraProvider.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RoutineGeneralPage.this.updateButtons();
            }
        });
        this._paraProvider.getViewer().getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RoutineGeneralPage.this.updateButtons();
            }
        });
        this._paramData.addTableDataChangeListener(this);
        this.configureParametersTableProvider();
    }

    protected void configureParametersTableProvider() {
        String[] inOuts = new String[]{"", ParameterMode.IN_LITERAL.getLiteral(), "OUT"};
        this._paraProvider.setInOutItems(inOuts);
        this._paraProvider.setDataTypes(this.getDataTypes());
    }

    protected String[] getDataTypes() {
        DataTypeProvider provider = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)new DatabaseVendorDefinitionId(this._databaseDefinition.getProduct(), this._databaseDefinition.getVersion())).getSQLDataService().getDataTypeProvider();
        String[] types = provider.getAvailableDataTypesDisplayString(4, this._schema, this._databaseIdentifier);
        return types;
    }

    protected ParametersTableProvider createParametersTableProvider() {
        return new ParametersTableProvider(false, true);
    }

    protected void setPageInput(IEditorInput input) {
        super.setPageInput(input);
        if (input instanceof SchemaObjectEditorInput) {
            this._oldRoutine = (Routine)this._editModelObject.getSchemaObjectImmutableModel().getMainSQLObject();
            this._schema = this._oldRoutine.getSchema();
            Catalog catalog = ModelUtil.getCatalog((EObject)this._schema);
            this._schemas = ModelUtil.getSchemas((Database)ModelUtil.getDatabase((Schema)this._schema), (String)(catalog == null ? null : catalog.getName()));
        }
    }

    protected ProceduralObjectSourceUpdater createSourceUpdater() {
        return new RoutineSourceUpdater((SybaseRoutine)this._mainObject, this._databaseDefinition);
    }

    protected void initControls() {
        super.initControls();
        if (this._mainObject instanceof Routine) {
            Routine routine = (Routine)this._mainObject;
            String dbName = ModelUtil.getDatabaseName((EObject)this._schema);
            this._nameProvider.setValues(dbName, this._schema.getName(), this._mainObject.getName(), null, null);
            this._nameChanged = Boolean.FALSE;
            EList params = routine.getParameters();
            this.initParameters(params);
            this._paraProvider.setData(this._paramData);
            this._validParamRow.clear();
            Vector rows = this._paramData.getRows();
            if (rows != null && rows.size() > 0) {
                int i = 0;
                while (i < rows.size()) {
                    this._validParamRow.add(rows.get(i));
                    ++i;
                }
            }
            this.synchronizeCachedParamRow();
        }
        this.updateButtons();
    }

    protected void initParameters(EList params) {
        this._paramData.init(params, this._databaseDefinition);
    }

    public void rowAdded(IRowData row) {
        this.synchronizeCachedParamRow();
        this.updateRow(row);
    }

    protected SybaseParameter getParameter(IRowData row) {
        this._uiDiagnostic = null;
        ParametersRowData pRow = (ParametersRowData)row;
        SybaseParameter param = pRow.getParameter();
        int index = this._paramData.getRows().indexOf(row);
        EList parameters = ((Routine)this._mainObject).getParameters();
        if (param == null || !parameters.contains((Object)param)) {
            param = this.createParameter();
            pRow.setParameter(param);
            parameters.add(index, (Object)param);
        }
        param.setName((String)row.getValue(1));
        String typeName = (String)row.getValue(2);
        DataTypeValidator v = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)ModelUtil.getDatabaseVendorDefinitionId((SQLObject)this._schema)).getSQLDataService().getDataTypeValidator();
        String msg = v.isValidDataTypeString(typeName, this._schema, 4, this._databaseIdentifier);
        if (msg != null) {
            this._uiDiagnostic = new BasicDiagnostic(4, Integer.toString(7), 9999, msg, new Object[]{param});
        }
        DataType type = null;
        if (typeName != null && !typeName.equals("")) {
            DataTypeProvider provider = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)ModelUtil.getDatabaseVendorDefinitionId((SQLObject)this._schema)).getSQLDataService().getDataTypeProvider();
            type = provider.getDataType(typeName, this._schema, this._databaseIdentifier);
            param.setDataType(type);
            if (type != null) {
                param.setDescription(null);
            } else {
                param.setDescription(typeName);
            }
        } else {
            param.setDataType(null);
            param.setDescription(null);
        }
        String modeValue = (String)row.getValue(3);
        if (modeValue == null) {
            modeValue = "";
        }
        param.setMode(this._paramData.getParameterMode(modeValue));
        String defValue = (String)row.getValue(4);
        if (defValue != null && defValue.length() > 0) {
            String unquote = SQLUtil.unquote(defValue);
            if (this.isStringDataType(type)) {
                defValue = SQLUtil.quote(unquote, "'");
            }
            param.setDefaultValue(defValue);
        } else {
            param.setDefaultValue(null);
        }
        return param;
    }

    private boolean isStringDataType(DataType type) {
        if (type instanceof PredefinedDataType) {
            return type instanceof CharacterStringDataType || type instanceof DateDataType || type instanceof TimeDataType;
        }
        if (type instanceof DistinctUserDefinedType) {
            return this.isStringDataType((DataType)((DistinctUserDefinedType)type).getPredefinedRepresentation());
        }
        return false;
    }

    protected SybaseParameter createParameter() {
        return SybasesqlmodelFactory.eINSTANCE.createSybaseParameter();
    }

    public void rowDataUpdated(IRowData row, int col, Object oldVal, Object newVal) {
        if (!newVal.equals(oldVal)) {
            this.updateRow(row);
        }
    }

    protected DiagnosticChain getDiagnosticChain(TypedEvent event) {
        DiagnosticChain chain = super.getDiagnosticChain(event);
        if (this._uiDiagnostic != null) {
            chain.add(this._uiDiagnostic);
        }
        return chain;
    }

    private void updateRow(IRowData row) {
        boolean warning;
        if (!this._inInit.booleanValue()) {
            this.markDirty();
            row.updateValue(0, (Object)"*");
        }
        SybaseParameter param = this.getParameter(row);
        Event e = new Event();
        e.data = row;
        e.widget = this._paraProvider.getTable();
        this.validateAndShowErrors((TypedEvent)new ModifyEvent(e));
        Diagnostic d = DiagnosticUtil.getDiagnostic((BasicDiagnostic)((BasicDiagnostic)this._diagnostics), (Object)param);
        boolean bl = warning = d != null && d.getSeverity() == 2;
        if (d == null || warning) {
            if (warning) {
                this._updater.setTestMode(true);
            }
            boolean success = true;
            int i = this.getUpdatedParamIndex(row);
            if (this._validParamRow.contains(row)) {
                success = ((RoutineSourceUpdater)this._updater).updateParameterModified(param, this.getParameterDef(param), i);
            } else {
                success = ((RoutineSourceUpdater)this._updater).updateParameterAdded(param, this.getParameterDef(param), i);
                if (success) {
                    this._validParamRow.add(row);
                }
            }
            ((ParametersRowData)row).setValid(success);
            this._updater.setTestMode(false);
            if (!success && d != null) {
                BasicDiagnostic error = new BasicDiagnostic(4, d.getSource(), d.getCode(), NLS.bind((String)Messages.RoutineGeneralPage_parameter_update_error, (Object)param.getName()), new Object[]{param});
                this._diagnostics.add((Diagnostic)error);
                Iterator iter = ((Diagnostic)this._diagnostics).getChildren().iterator();
                ArrayList<ErrorItem> errors = new ArrayList<ErrorItem>();
                while (iter.hasNext()) {
                    Diagnostic diag = (Diagnostic)iter.next();
                    errors.add(new ErrorItem(null, diag.getMessage(), diag.getSeverity()));
                }
                IErrorItem[] items = errors.toArray(new IErrorItem[errors.size()]);
                this.showErrorItems(items);
            }
        } else {
            ((ParametersRowData)row).setValid(false);
        }
    }

    public void rowDeleted(IRowData row) {
        if (!this._inInit.booleanValue()) {
            this.markDirty();
        }
        SybaseParameter param = ((ParametersRowData)row).getParameter();
        if (this._uiDiagnostic != null && this._uiDiagnostic.getData() != null && this._uiDiagnostic.getData().contains(param)) {
            this._uiDiagnostic = null;
        }
        if (param != null) {
            EList params = ((Routine)this._mainObject).getParameters();
            params.remove((Object)param);
            if (this._validParamRow.contains(row)) {
                int i = this.getUpdatedParamIndex(row);
                ((RoutineSourceUpdater)this._updater).updateParameterDeleted(i);
                this._validParamRow.remove(row);
            }
            this.synchronizeCachedParamRow();
            Event e = new Event();
            e.data = param;
            e.widget = this._paraProvider.getTable();
            this.validateAndShowErrors((TypedEvent)new ModifyEvent(e));
        }
    }

    protected void rowMoved(int index) {
        Vector rows = this._paramData.getRows();
        ParametersRowData row1 = null;
        ParametersRowData row2 = null;
        if (rows != null && index < rows.size()) {
            row1 = (ParametersRowData)((Object)rows.get(index));
            row2 = (ParametersRowData)((Object)rows.get(index + 1));
        }
        if (row1 == null || row2 == null) {
            return;
        }
        SybaseParameter param1 = row1.getParameter();
        SybaseParameter param2 = row2.getParameter();
        if (param1 == null || param2 == null) {
            return;
        }
        EList params = ((Routine)this._mainObject).getParameters();
        int ind1 = params.indexOf((Object)param1);
        int ind2 = params.indexOf((Object)param2);
        if (ind1 >= 0 && ind2 >= 0) {
            params.remove((Object)param1);
            params.remove((Object)param2);
            params.add(ind2, (Object)param1);
            params.add(ind1, (Object)param2);
            if (this._validParamRow.contains((Object)row1) && this._validParamRow.contains((Object)row2)) {
                ((RoutineSourceUpdater)this._updater).updateParameterRearranged(index);
            }
        }
        this.synchronizeCachedParamRow();
        this.updateButtons();
        this.markDirty();
    }

    protected String getParameterDef(SybaseParameter p) {
        return this.getTSQLParameterDef(p);
    }

    protected String getTSQLParameterDef(SybaseParameter p) {
        String name = p.getName();
        DataTypeProvider provider = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)ModelUtil.getDatabaseVendorDefinitionId((SQLObject)this._schema)).getSQLDataService().getDataTypeProvider();
        DataTypeProviderExt providerExt = (DataTypeProviderExt)provider;
        String type = providerExt.getDataTypeString(p.getDataType(), this._databaseIdentifier);
        String dft = p.getDefaultValue();
        ParameterMode mode = p.getMode();
        String modeLiteral = mode.getLiteral();
        if (mode.getValue() == 2) {
            modeLiteral = ParameterMode.OUT_LITERAL.getLiteral();
        }
        return SybaseDdlBuilderWrapper.getInstance().getTSQLParameter(name, type, dft, modeLiteral);
    }

    protected int getUpdatedParamIndex(IRowData row) {
        int index = this._cachedParamRow.indexOf(row);
        if (index > 0) {
            int validIndex = index;
            int i = 0;
            while (i < index) {
                if (!this._validParamRow.contains(this._cachedParamRow.get(i))) {
                    --validIndex;
                }
                ++i;
            }
            index = validIndex;
        }
        return index;
    }

    protected Map buildValidationContext(TypedEvent e) {
        Map context = super.buildValidationContext(e);
        List items = (List)context.get("vitems");
        if (e == null || e.widget == this._paraProvider.getTable()) {
            ContainmentFeatureValidationItem item = new ContainmentFeatureValidationItem(17);
            Map paramsContext = SQLModelValidationDelegate.getCompleteValidationContext((int)2);
            item.setContext(paramsContext);
            items.add(item);
        }
        return context;
    }

    protected Collection getFilteredDiagnostics(BasicDiagnostic diagnostics, TypedEvent event) {
        Collection filtered = super.getFilteredDiagnostics(diagnostics, event);
        if (event.widget == this._paraProvider.getTable()) {
            block0: for (Diagnostic d : ((Diagnostic)this._diagnostics).getChildren()) {
                if (Integer.toString(17).equals(d.getSource())) {
                    filtered.add(d);
                    continue;
                }
                for (Object element : d.getData()) {
                    if (!(element instanceof SybaseParameter)) continue;
                    filtered.add(d);
                    continue block0;
                }
            }
        }
        return filtered;
    }

    protected void updateButtons() {
    }

    protected INameCompositeProvider createNameComposite() {
        return new FullNameCompositeProvider();
    }

    private void synchronizeCachedParamRow() {
        this._cachedParamRow.clear();
        Vector rows = this._paramData.getRows();
        if (rows != null && rows.size() > 0) {
            int i = 0;
            while (i < rows.size()) {
                this._cachedParamRow.add(rows.get(i));
                ++i;
            }
        }
    }

    public void revert() {
        this._uiDiagnostic = null;
        this._paraProvider.getViewer().refresh();
        super.revert();
    }

    public void setFocus(int itemType, Object item) {
        super.setFocus(itemType, item);
        if (itemType == 0) {
            AccessibleTableViewer viewer = this._paraProvider.getViewer();
            if (item == null) {
                int rowNum = this._paraProvider.geData().getRows().size();
                viewer.getCursor().setSelection(rowNum, 2);
                viewer.getCursor().edit();
                return;
            }
            if (item instanceof Parameter) {
                String paraName = ((Parameter)item).getName();
                Iterator iter = this._paraProvider.geData().getRows().iterator();
                int i = 0;
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof ParametersRowData)) continue;
                    ParametersRowData row = (ParametersRowData)((Object)obj);
                    if (row.getValue(1).equals(paraName)) {
                        viewer.getCursor().setSelection(i, 2);
                        viewer.getCursor().edit();
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    protected class AddRowAction
    extends Action {
        private AccessibleTableViewer _tableViewer;

        public AddRowAction(AccessibleTableViewer viewer) {
            this.setText(Messages.RoutineGeneralPage_add);
            this._tableViewer = viewer;
        }

        public void run() {
            ITableData tableData = (ITableData)this._tableViewer.getInput();
            tableData.insertRow();
            this._tableViewer.refresh();
            int selection = this._tableViewer.getTable().getItemCount() - 2;
            this._tableViewer.getCursor().setSelection(selection, 2);
            this._tableViewer.getCursor().edit();
        }
    }
}

