/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ase.JDBCASEPlugin;
import org.eclipse.datatools.enablement.ase.catalog.ASEUtil;
import org.eclipse.datatools.enablement.ase.catalog.ICatalogTable;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalog;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogSchema;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogUtils;
import org.eclipse.datatools.enablement.ase.ddl.SybaseASEDdlParser;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEColumnCheckConstraint;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEDatabase;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEDefault;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEEncryptionKey;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASERule;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASESchema;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseasesqlmodelPackage;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.impl.SybaseASEColumnImpl;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.impl.SybaseasesqlmodelFactoryImpl;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseAuthorizedObject;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybasePrivilege;
import org.eclipse.datatools.enablement.sybase.util.SQLUtil;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.expressions.SQLExpressionsPackage;
import org.eclipse.datatools.modelbase.sql.expressions.SearchCondition;
import org.eclipse.datatools.modelbase.sql.expressions.SearchConditionDefault;
import org.eclipse.datatools.modelbase.sql.expressions.ValueExpression;
import org.eclipse.datatools.modelbase.sql.expressions.ValueExpressionDefault;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.IdentitySpecifier;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.impl.SQLSchemaFactoryImpl;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASECatalogColumn
extends SybaseASEColumnImpl
implements ICatalogObject,
IAdaptable {
    private static final long serialVersionUID = 3257570602843189304L;
    private static final int COL_STATUS2_COMPUTED_COL = 16;
    private static final int COL_STATUS2_COMPUTED_MATERIALIZED_COL = 32;
    private static final int COL_STATUS2_COMPUTED_VIEW_COL = 48;
    private static final int COL_STATUS3_HIDDEN_COMPUTED_COL = 1;
    private static final String ATTR_COL_TYPE = "type";
    private static final String ATTR_COL_SCALE = "scale";
    private static final String ATTR_COL_LENGTH = "col_length";
    private static final String ATTR_COL_STATUS = "status";
    private static final String ATTR_CHAR_LENGTH = "char_length";
    private static final String ATTR_COL_PRECISION = "prec";
    private static final String ATTR_COL_USERTYPE_ID = "type_id";
    private static final String ATTR_COL_OFFLINE_RULE = "offline_rule";
    private static final String ATTR_COL_OBJECT_STORAGE = "object_storage";
    private static final String ATTR_COL_OFFLINE_DEFAULT = "offline_default";
    private static final String ATTR_COL_INLINE_DEFAULT_ID = "inline_default";
    private static final String ATTR_COL_INLINE_RULE_ID = "inline_rule";
    private static final String ATTR_COL_STATUS2 = "status2";
    private static final String ATTR_COL_ENCRYPT_KEY = "encrkey_id";
    private static final String ATTR_COL_ENCRYPT_KEY_DB = "encrdb";
    private Boolean inlineDefaultLoaded = Boolean.FALSE;
    private Boolean boundDefaultLoaded = Boolean.FALSE;
    private Boolean valueExpressionLoaded = Boolean.FALSE;
    private Boolean columnCheckLoaded = Boolean.FALSE;
    private Boolean bindedRuleLoaded = Boolean.FALSE;
    private Boolean columnTypeLoaded = Boolean.FALSE;
    private Boolean columnInfoLoaded = Boolean.FALSE;
    private Boolean encryptionKeyLoaded = Boolean.FALSE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.inlineDefaultLoaded;
        synchronized (bl) {
            if (this.inlineDefaultLoaded.booleanValue()) {
                this.inlineDefaultLoaded = Boolean.FALSE;
            }
        }
        bl = this.boundDefaultLoaded;
        synchronized (bl) {
            if (this.boundDefaultLoaded.booleanValue()) {
                this.boundDefaultLoaded = Boolean.FALSE;
            }
        }
        bl = this.valueExpressionLoaded;
        synchronized (bl) {
            if (this.valueExpressionLoaded.booleanValue()) {
                this.valueExpressionLoaded = Boolean.FALSE;
            }
        }
        bl = this.columnCheckLoaded;
        synchronized (bl) {
            if (this.columnCheckLoaded.booleanValue()) {
                this.columnCheckLoaded = Boolean.FALSE;
            }
        }
        bl = this.bindedRuleLoaded;
        synchronized (bl) {
            if (this.bindedRuleLoaded.booleanValue()) {
                this.bindedRuleLoaded = Boolean.FALSE;
            }
        }
        bl = this.columnTypeLoaded;
        synchronized (bl) {
            if (this.columnTypeLoaded.booleanValue()) {
                this.columnTypeLoaded = Boolean.FALSE;
            }
        }
        bl = this.columnInfoLoaded;
        synchronized (bl) {
            if (this.columnInfoLoaded.booleanValue()) {
                this.columnInfoLoaded = Boolean.FALSE;
            }
        }
        bl = this.encryptionKeyLoaded;
        synchronized (bl) {
            if (this.encryptionKeyLoaded.booleanValue()) {
                this.encryptionKeyLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public Connection getConnection() {
        SybaseASECatalogSchema schema = (SybaseASECatalogSchema)this.getTable().getSchema();
        return schema.getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getTable().getSchema().getCatalog().getDatabase();
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 10: {
                this.getIdentitySpecifier();
                break;
            }
            case 14: {
                this.getDefaultValue();
                break;
            }
            case 18: {
                this.getBoundDefault();
                break;
            }
            case 19: {
                this.getBoundRule();
                break;
            }
            case 11: {
                this.getGenerateExpression();
                break;
            }
            case 17: {
                this.getColumnCheck();
                break;
            }
            case 13: {
                this.isNullable();
                break;
            }
            case 21: {
                this.getEncryptionKey();
                break;
            }
            case 20: {
                this.isMaterialized();
                break;
            }
            case 7: {
                this.getContainedType();
                break;
            }
            case 8: {
                this.getReferencedType();
                break;
            }
            case 6: {
                this.getPrivileges();
            }
        }
        return super.eIsSet(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLDataType getContainedType() {
        Boolean bl = this.columnTypeLoaded;
        synchronized (bl) {
            if (!this.columnTypeLoaded.booleanValue()) {
                this.loadColumnType();
            }
        }
        return super.getContainedType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserDefinedType getReferencedType() {
        Boolean bl = this.columnTypeLoaded;
        synchronized (bl) {
            if (!this.columnTypeLoaded.booleanValue()) {
                this.loadColumnType();
            }
        }
        return super.getReferencedType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataType getDataType() {
        Boolean bl = this.columnTypeLoaded;
        synchronized (bl) {
            if (!this.columnTypeLoaded.booleanValue()) {
                this.loadColumnType();
            }
        }
        return super.getDataType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHidden() {
        Boolean bl = this.columnInfoLoaded;
        synchronized (bl) {
            if (!this.columnInfoLoaded.booleanValue()) {
                this.loadColumnInfo();
            }
        }
        return super.isHidden();
    }

    private void loadColumnType() {
        boolean deliver;
        block11: {
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                conn = this.getConnection();
                Table table = this.getTable();
                Schema schema = table.getSchema();
                oldCatalog = conn.getCatalog();
                conn.setCatalog(this.getTable().getSchema().getCatalog().getName());
                stmt = conn.prepareStatement("SELECT type = isnull(X.xtname, isnull(get_xtypename(C.xtype,C.xdbid), T.name)),col_length = C.length, prec = C.prec, scale = C.scale, type_id = T.usertype,char_length = isnull(@@ncharsize,1) FROM syscolumns C, systypes T, sysxtypes X, sysobjects O, sysusers U WHERE U.name = ? AND U.uid = O.uid AND O.name = ? AND C.id = O.id AND C.name like ? AND C.usertype *= T.usertype AND C.xtype *= X.xtid ORDER BY colid");
                stmt.setString(1, schema.getName());
                stmt.setString(2, table.getName());
                stmt.setString(3, this.getName());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    boolean isUDT;
                    String typeName = rs.getString(ATTR_COL_TYPE);
                    int typeID = rs.getInt(ATTR_COL_USERTYPE_ID);
                    boolean bl = isUDT = typeID > 100;
                    if (!isUDT) {
                        int iCharSize = rs.getInt(ATTR_CHAR_LENGTH);
                        int length = rs.getInt(ATTR_COL_LENGTH);
                        int precision = rs.getInt(ATTR_COL_PRECISION);
                        int scale = rs.getInt(ATTR_COL_SCALE);
                        DatabaseDefinition dbDef = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
                        PredefinedDataType type = SybaseASECatalogUtils.getASEPredefinedType(length, precision, scale, iCharSize, typeName, dbDef);
                        super.setDataType((DataType)type);
                        continue;
                    }
                    try {
                        DistinctUserDefinedType udt = null;
                        String ownerName = SybaseASECatalogUtils.getUDTOwner(typeName, this.getTable().getSchema().getCatalog().getName(), conn);
                        Schema udtSchema = (Schema)ASEUtil.getSQLObject((Collection)this.getTable().getSchema().getCatalog().getSchemas(), ownerName);
                        udt = (DistinctUserDefinedType)ASEUtil.getSQLObject((Collection)udtSchema.getUserDefinedTypes(), typeName);
                        super.setDataType((DataType)udt);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                break block11;
            }
            catch (Exception exception) {
                try {
                    break block11;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                }
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        this.eSetDeliver(deliver);
        this.columnTypeLoaded = Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultValue() {
        Boolean bl = this.inlineDefaultLoaded;
        synchronized (bl) {
            if (!this.inlineDefaultLoaded.booleanValue()) {
                this.loadInlineDefault();
                this.loadBoundDefault();
            }
        }
        return super.getDefaultValue();
    }

    private void loadInlineDefault() {
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        super.setDefaultValue(null);
        String inlineDefaultString = this.getInlineDefault(this.getConnection());
        if (inlineDefaultString != null) {
            super.setDefaultValue(new SybaseASEDdlParser().parseInlineDefault(inlineDefaultString));
        }
        this.eSetDeliver(deliver);
        this.inlineDefaultLoaded = Boolean.TRUE;
    }

    private String getInlineDefault(Connection conn) {
        String inlineDefault;
        block6: {
            inlineDefault = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this.getTable().getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("SELECT text FROM syscomments D, sysprocedures P, syscolumns C WHERE C.id =? and C.name = ? and D.id = C.cdefault AND P.id = D.id AND P.sequence = 0 AND P.status & 4096 = 4096");
                    stmt.setInt(1, ((ICatalogTable)this.getTable()).getTableId());
                    stmt.setString(2, this.getName());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        inlineDefault = rs.getString(1).trim();
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        return inlineDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SybaseASEDefault getBoundDefault() {
        Boolean bl = this.boundDefaultLoaded;
        synchronized (bl) {
            if (!this.boundDefaultLoaded.booleanValue()) {
                this.loadBoundDefault();
            }
        }
        return super.getBoundDefault();
    }

    private void loadBoundDefault() {
        boolean deliver;
        block7: {
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            Connection conn = this.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this.getTable().getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("SELECT U.name, O.name FROM sysusers U, sysobjects O, sysprocedures P, syscolumns C WHERE C.cdefault<>0 AND U.uid=O.uid AND O.id=C.cdefault AND P.sequence = 0 AND P.status & 4096 != 4096 AND P.id = O.id AND C.id = ? and C.name = ?");
                    stmt.setInt(1, ((ICatalogTable)this.getTable()).getTableId());
                    stmt.setString(2, this.getName());
                    rs = stmt.executeQuery();
                    SybaseASEDefault offlineDefault = null;
                    while (rs.next()) {
                        String ownerName = rs.getString(1);
                        String defaultName = rs.getString(2);
                        SybaseASESchema schema = (SybaseASESchema)ASEUtil.getSQLObject((Collection)this.getTable().getSchema().getCatalog().getSchemas(), ownerName);
                        offlineDefault = (SybaseASEDefault)ASEUtil.getSQLObject((Collection)schema.getDefaults(), defaultName);
                    }
                    super.setBoundDefault(offlineDefault);
                    if (offlineDefault != null) {
                        String statement = offlineDefault.getStatement();
                        super.setDefaultValue(new SybaseASEDdlParser().parseDefaultRuleStatement(statement));
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        this.eSetDeliver(deliver);
        this.boundDefaultLoaded = Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueExpression getGenerateExpression() {
        Boolean bl = this.valueExpressionLoaded;
        synchronized (bl) {
            if (!this.valueExpressionLoaded.booleanValue()) {
                try {
                    this.loadValueExpression();
                }
                catch (Exception exception) {}
            }
        }
        return super.getGenerateExpression();
    }

    private void loadValueExpression() {
        String computedColExpr;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        SybaseASEDatabase database = (SybaseASEDatabase)this.getCatalogDatabase();
        ValueExpressionDefault expression = null;
        if (database.isComputedColApplicable() && (computedColExpr = this.getComputedColExpression(this.getName(), this.getConnection())) != null && !computedColExpr.equals("")) {
            DatabaseDefinition dbDef = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
            DataModelElementFactory factory = dbDef.getDataModelElementFactory();
            expression = (ValueExpressionDefault)factory.create(SQLExpressionsPackage.eINSTANCE.getValueExpressionDefault());
            expression.setSQL(computedColExpr);
        }
        super.setGenerateExpression(expression);
        this.eSetDeliver(deliver);
        this.valueExpressionLoaded = Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SybaseASEColumnCheckConstraint getColumnCheck() {
        Boolean bl = this.columnCheckLoaded;
        synchronized (bl) {
            if (!this.columnCheckLoaded.booleanValue()) {
                this.loadColumncheckConstraint();
            }
        }
        return super.getColumnCheck();
    }

    private void loadColumncheckConstraint() {
        SybaseASEColumnCheckConstraint inlineRule;
        boolean deliver;
        block7: {
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            inlineRule = null;
            Connection conn = this.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this.getTable().getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("SELECT O.name, text FROM syscomments R, sysprocedures P, syscolumns C, sysobjects O WHERE R.id = C.domain AND P.id = R.id AND P.id = O.id AND P.sequence = 0 AND P.status & 4096 = 4096 AND C.id = ? AND C.name = ?");
                    stmt.setInt(1, ((ICatalogTable)this.getTable()).getTableId());
                    stmt.setString(2, this.getName());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String checkName = rs.getString(1);
                        String inlineRuleExpr = rs.getString(2);
                        DatabaseDefinition dbDef = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
                        DataModelElementFactory factory = dbDef.getDataModelElementFactory();
                        SearchConditionDefault sc = (SearchConditionDefault)factory.create(SQLExpressionsPackage.eINSTANCE.getSearchConditionDefault());
                        sc.setSQL(SQLUtil.parseSearchStatement((String)inlineRuleExpr));
                        inlineRule = (SybaseASEColumnCheckConstraint)factory.create(SybaseasesqlmodelPackage.eINSTANCE.getSybaseASEColumnCheckConstraint());
                        inlineRule.setSearchCondition((SearchCondition)sc);
                        inlineRule.setName(checkName);
                        stmt = conn.prepareStatement("SELECT u.name FROM sysconstraints a, sysobjects o, sysusers u WHERE o.name=? AND u.uid=o.uid AND a.tableid = ? AND  a.status & 128 = 128 AND a.constrid in (select domain from syscolumns where id = ?) AND o.id = a.constrid");
                        stmt.setString(1, checkName);
                        stmt.setInt(2, ((ICatalogTable)this.getTable()).getTableId());
                        stmt.setInt(3, ((ICatalogTable)this.getTable()).getTableId());
                        rs = stmt.executeQuery();
                        Schema creator = null;
                        while (rs.next()) {
                            String creatorName = rs.getString(1);
                            SybaseASECatalog catalog = (SybaseASECatalog)this.getTable().getSchema().getCatalog();
                            creator = (Schema)ASEUtil.getSQLObject((Collection)catalog.getSchemas(), creatorName);
                        }
                        inlineRule.setCreator(creator);
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        super.setColumnCheck(inlineRule);
        this.eSetDeliver(deliver);
        this.columnCheckLoaded = Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SybaseASERule getBoundRule() {
        Boolean bl = this.bindedRuleLoaded;
        synchronized (bl) {
            if (!this.bindedRuleLoaded.booleanValue()) {
                this.loadBindedRule();
            }
        }
        return super.getBoundRule();
    }

    private void loadBindedRule() {
        boolean deliver;
        block6: {
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            Connection conn = this.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this.getTable().getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("(SELECT U.name, O.name FROM sysusers U, sysobjects O,sysprocedures P, syscolumns C WHERE C.domain<>0 and O.id=C.domain AND U.uid=O.uid AND P.sequence = 0 AND P.status & 4096 != 4096 AND P.id = O.id AND C.id = ? AND C.name like ?) UNION (SELECT U.name, O.name FROM sysusers U, sysobjects O,sysprocedures P, syscolumns C WHERE C.domain=0 AND O.id=C.accessrule AND U.uid=O.uid AND P.sequence = 0 AND P.status & 4096 != 4096 AND P.id = O.id AND C.id = ? AND C.name like ?)");
                    stmt.setInt(1, ((ICatalogTable)this.getTable()).getTableId());
                    stmt.setString(2, this.getName());
                    stmt.setInt(3, ((ICatalogTable)this.getTable()).getTableId());
                    stmt.setString(4, this.getName());
                    rs = stmt.executeQuery();
                    SybaseASERule offlineRule = null;
                    while (rs.next()) {
                        String ownerName = rs.getString(1);
                        String ruleName = rs.getString(2);
                        SybaseASESchema schema = (SybaseASESchema)ASEUtil.getSQLObject((Collection)this.getTable().getSchema().getCatalog().getSchemas(), ownerName);
                        offlineRule = (SybaseASERule)ASEUtil.getSQLObject((Collection)schema.getRules(), ruleName);
                    }
                    super.setBoundRule(offlineRule);
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        this.eSetDeliver(deliver);
        this.bindedRuleLoaded = Boolean.TRUE;
    }

    private String getComputedColExpression(String columnName, Connection conn) {
        StringBuffer sb;
        block8: {
            sb = new StringBuffer(128);
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this.getTable().getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("SELECT text from syscomments where id = (select computedcol from syscolumns where id = ? and name like ? )");
                    stmt.setInt(1, ((ICatalogTable)this.getTable()).getTableId());
                    stmt.setString(2, columnName);
                    rs = stmt.executeQuery();
                    block4: while (rs.next()) {
                        Pattern p1 = Pattern.compile("AS\\s+(.*)\\s+NOT\\s+MATERIALIZED");
                        Pattern p2 = Pattern.compile("AS\\s+(.*)\\s+MATERIALIZED");
                        Pattern p3 = Pattern.compile("AS\\s+(.*)");
                        Pattern[] p = new Pattern[]{p1, p2, p3};
                        int i = 0;
                        while (i < p.length) {
                            Matcher matcher = p[i].matcher(rs.getString(1) == null ? "" : rs.getString(1).trim());
                            if (matcher.matches()) {
                                sb.append(matcher.group(1).trim());
                                continue block4;
                            }
                            ++i;
                        }
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNullable() {
        Boolean bl = this.columnInfoLoaded;
        synchronized (bl) {
            if (!this.columnInfoLoaded.booleanValue()) {
                this.loadColumnInfo();
            }
        }
        return super.isNullable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentitySpecifier getIdentitySpecifier() {
        Boolean bl = this.columnInfoLoaded;
        synchronized (bl) {
            if (!this.columnInfoLoaded.booleanValue()) {
                this.loadColumnInfo();
            }
        }
        return super.getIdentitySpecifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMaterialized() {
        Boolean bl = this.columnInfoLoaded;
        synchronized (bl) {
            if (!this.columnInfoLoaded.booleanValue()) {
                this.loadColumnInfo();
            }
        }
        return super.isMaterialized();
    }

    private void loadColumnInfo() {
        boolean deliver;
        block10: {
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            Connection conn = this.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this.getTable().getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("SELECT C.status, C.status2 FROM syscolumns C where C.id = ? AND C.name like ?");
                    stmt.setInt(1, ((ICatalogTable)this.getTable()).getTableId());
                    stmt.setString(2, this.getName());
                    rs = stmt.executeQuery();
                    boolean nullable = false;
                    boolean isMaterialized = false;
                    IdentitySpecifier is = null;
                    while (rs.next()) {
                        boolean isIdentity;
                        int status = rs.getInt(1);
                        int status2 = rs.getInt(2);
                        nullable = (status & 8) == 8;
                        boolean bl = isIdentity = (status & 0x80) == 128;
                        if (isIdentity) {
                            is = (IdentitySpecifier)SQLSchemaFactoryImpl.init().create(SQLSchemaPackage.eINSTANCE.getIdentitySpecifier());
                        }
                        if (!((SybaseASEDatabase)this.getCatalogDatabase()).isComputedColApplicable() || (status2 & 0x10) != 16 || (status2 & 0x20) != 32) continue;
                        isMaterialized = true;
                    }
                    super.setNullable(nullable);
                    super.setIdentitySpecifier(is);
                    super.setMaterialized(isMaterialized);
                    SybaseASEDatabase db = (SybaseASEDatabase)this.getTable().getSchema().getCatalog().getDatabase();
                    if (db.isFunctionalBasedIndexMemApplicable()) {
                        stmt = conn.prepareStatement("SELECT isnull(status3,0),computedcol FROM syscolumns  WHERE name like ? AND id = object_id(?)");
                        stmt.setString(1, this.getName());
                        stmt.setString(2, ASEUtil.getFullQuatifiedName((SQLObject)this.getTable()));
                        rs = stmt.executeQuery();
                        while (rs.next()) {
                            int status3 = rs.getInt(1);
                            if ((status3 & 1) > 0) {
                                super.setHidden(true);
                                continue;
                            }
                            super.setHidden(false);
                        }
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        this.eSetDeliver(deliver);
        this.columnInfoLoaded = Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SybaseASEEncryptionKey getEncryptionKey() {
        Boolean bl = this.encryptionKeyLoaded;
        synchronized (bl) {
            if (!this.encryptionKeyLoaded.booleanValue()) {
                this.loadEncryptionKey();
            }
        }
        return super.getEncryptionKey();
    }

    private void loadEncryptionKey() {
        SybaseASEEncryptionKey key;
        boolean deliver;
        block8: {
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            key = null;
            SybaseASEDatabase database = (SybaseASEDatabase)this.getCatalogDatabase();
            if (database.isEncryptionKeyApplicable()) {
                Connection conn = this.getConnection();
                PreparedStatement stmt = null;
                ResultSet rs = null;
                String oldCatalog = null;
                try {
                    try {
                        oldCatalog = conn.getCatalog();
                        conn.setCatalog(this.getTable().getSchema().getCatalog().getName());
                        stmt = conn.prepareStatement("SELECT encrkey_id = isnull(C.encrkeyid,0), encrdb = C.encrkeydb FROM syscolumns C WHERE C.id = ? AND C.name like ?");
                        stmt.setInt(1, ((ICatalogTable)this.getTable()).getTableId());
                        stmt.setString(2, this.getName());
                        rs = stmt.executeQuery();
                        while (rs.next()) {
                            int encrypKeyId = rs.getInt(1);
                            if (encrypKeyId == 0) continue;
                            String db = rs.getString(2);
                            if (db == null || db.equals("")) {
                                db = this.getTable().getSchema().getCatalog().getName();
                            }
                            key = this.getEncryptionKey(db, encrypKeyId, conn);
                        }
                    }
                    catch (SQLException e) {
                        JDBCASEPlugin.getDefault().log(e);
                        SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    throw throwable;
                }
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
            }
        }
        super.setEncryptionKey(key);
        this.eSetDeliver(deliver);
        this.columnInfoLoaded = Boolean.TRUE;
    }

    private SybaseASEEncryptionKey getEncryptionKey(String dbName, int keyId, Connection conn) {
        SybaseASEEncryptionKey key;
        block6: {
            key = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(dbName);
                    stmt = conn.prepareStatement("select keyname = o.name, owner = u.name from  sysobjects o,  sysusers u  where o.id  = ?  and u.uid = o.uid");
                    stmt.setInt(1, keyId);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String keyName = rs.getString(1);
                        String ownerName = rs.getString(2);
                        Catalog catalog = (Catalog)ASEUtil.getSQLObject((Collection)this.getTable().getSchema().getDatabase().getCatalogs(), dbName);
                        Schema schema = (Schema)ASEUtil.getSQLObject((Collection)catalog.getSchemas(), ownerName);
                        key = (SybaseASEEncryptionKey)ASEUtil.getSQLObject((Collection)((SybaseASESchema)schema).getEncryptionKeys(), keyName);
                        if (key != null) continue;
                        key = (SybaseASEEncryptionKey)SybaseasesqlmodelFactoryImpl.init().create(SybaseasesqlmodelPackage.eINSTANCE.getSybaseASEEncryptionKey());
                        key.setName(keyName);
                        key.setSchema((SybaseASESchema)schema);
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        return key;
    }

    public EList getPrivileges() {
        EList privileges = super.getPrivileges();
        ArrayList<SybasePrivilege> tempList = new ArrayList<SybasePrivilege>();
        if (this.getTable() instanceof SybaseAuthorizedObject) {
            EList allPrivs = ((SybaseAuthorizedObject)this.getTable()).getPrivileges();
            for (SybasePrivilege p : allPrivs) {
                if (!p.getActionObjects().contains((Object)this)) continue;
                tempList.add(p);
            }
        }
        privileges.addAll(tempList);
        return privileges;
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }
}

