/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.ExpressionVariable;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;

public abstract class ValueExpression {
    protected static final String SPACE = " ";
    protected static final String LEFT_PARANTHESIS = "(";
    protected static final String RIGHT_PARANTHESIS = ")";
    protected static final String LEFT_CURLY_BRACKET = " {";
    protected static final String RIGHT_CURLY_BRACKET = "} ";
    private Integer m_odaDataTypeCode;

    public String getQualifiedId() {
        return this.getClass().getName();
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public ExpressionVariable.VariableType getVariableType() {
        return ExpressionVariable.VariableType.QUERY_EXPRESSION;
    }

    public Integer getOdaDataType() {
        return this.m_odaDataTypeCode;
    }

    public void setOdaDataType(Integer odaDataTypeCode) {
        this.m_odaDataTypeCode = odaDataTypeCode;
    }

    protected static final boolean equals(Object left, Object right) {
        return left == null ? right == null : right != null && left.equals(right);
    }

    public void validate() throws OdaException {
        this.validate(null);
    }

    public void validate(ValidationContext context) throws OdaException {
        this.validateSyntax(context);
        if (context != null && context.getValidator() != null) {
            context.getValidator().validate(this, context);
        }
    }

    public abstract void validateSyntax(ValidationContext var1) throws OdaException;

    public String toString() {
        StringBuffer buffer = new StringBuffer(String.valueOf(this.getName()) + SPACE + (Object)((Object)this.getVariableType()));
        return buffer.toString();
    }
}

