/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards.mq;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.actions.HgOperation;
import com.vectrace.MercurialEclipse.commands.extensions.mq.HgQRefreshClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import com.vectrace.MercurialEclipse.views.PatchQueueView;
import com.vectrace.MercurialEclipse.wizards.HgWizard;
import com.vectrace.MercurialEclipse.wizards.mq.Messages;
import com.vectrace.MercurialEclipse.wizards.mq.QNewWizardPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;

public class QRefreshWizard
extends HgWizard {
    private QNewWizardPage page = null;
    private IResource resource;

    public QRefreshWizard(IResource resource) {
        super(Messages.getString("QRefreshWizard.title"));
        this.resource = resource;
        this.setNeedsProgressMonitor(true);
        this.page = new QNewWizardPage(Messages.getString("QRefreshWizard.pageName"), Messages.getString("QRefreshWizard.pageTitle"), null, null, resource, false);
        this.initPage(Messages.getString("QRefreshWizard.pageDescription"), this.page);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        RefreshOperation refreshOperation = new RefreshOperation((IRunnableContext)this.getContainer());
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)refreshOperation);
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
            this.page.setErrorMessage(e.getLocalizedMessage());
            return false;
        }
        PatchQueueView.getView().populateTable();
        return true;
    }

    private class RefreshOperation
    extends HgOperation {
        public RefreshOperation(IRunnableContext context) {
            super(context);
        }

        protected String getActionDescription() {
            return Messages.getString("QRefreshWizard.actionDescription");
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.getString("QRefreshWizard.beginTask"), 2);
            monitor.worked(1);
            monitor.subTask(Messages.getString("QRefreshWizard.subTask.callMercurial"));
            try {
                HgQRefreshClient.refresh(QRefreshWizard.this.resource, QRefreshWizard.this.page.getCommitTextDocument().get(), QRefreshWizard.this.page.getForceCheckBox().getSelection(), QRefreshWizard.this.page.getGitCheckBox().getSelection(), QRefreshWizard.this.page.getIncludeTextField().getText(), QRefreshWizard.this.page.getExcludeTextField().getText(), QRefreshWizard.this.page.getUserTextField().getText(), QRefreshWizard.this.page.getDate().getText());
                monitor.worked(1);
                MercurialStatusCache.getInstance().refreshStatus((IResource)QRefreshWizard.this.resource.getProject(), monitor);
                monitor.done();
            }
            catch (HgException e) {
                throw new InvocationTargetException((Throwable)((Object)e), e.getLocalizedMessage());
            }
        }
    }
}

