/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards.mq;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.actions.HgOperation;
import com.vectrace.MercurialEclipse.commands.extensions.mq.HgQNewClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.views.PatchQueueView;
import com.vectrace.MercurialEclipse.wizards.HgWizard;
import com.vectrace.MercurialEclipse.wizards.mq.Messages;
import com.vectrace.MercurialEclipse.wizards.mq.QNewWizardPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;

public class QNewWizard
extends HgWizard {
    private QNewWizardPage page = null;
    private IResource resource;

    public QNewWizard(IResource resource) {
        super(Messages.getString("QNewWizard.title"));
        this.resource = resource;
        this.setNeedsProgressMonitor(true);
        this.page = new QNewWizardPage(Messages.getString("QNewWizard.pageName"), Messages.getString("QNewWizard.pageTitle"), null, null, resource, true);
        this.initPage(Messages.getString("QNewWizard.pageDescription"), this.page);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        NewOperation initOperation = new NewOperation((IRunnableContext)this.getContainer());
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)initOperation);
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
            this.page.setErrorMessage(e.getLocalizedMessage());
            return false;
        }
        PatchQueueView.getView().populateTable();
        return true;
    }

    private class NewOperation
    extends HgOperation {
        public NewOperation(IRunnableContext context) {
            super(context);
        }

        protected String getActionDescription() {
            return Messages.getString("QNewWizard.actionDescription");
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.getString("QNewWizard.beginTask"), 2);
            monitor.worked(1);
            monitor.subTask(Messages.getString("QNewWizard.subTask.callMercurial"));
            try {
                HgQNewClient.createNewPatch(QNewWizard.this.resource, QNewWizard.this.page.getCommitTextDocument().get(), QNewWizard.this.page.getForceCheckBox().getSelection(), QNewWizard.this.page.getGitCheckBox().getSelection(), QNewWizard.this.page.getIncludeTextField().getText(), QNewWizard.this.page.getExcludeTextField().getText(), QNewWizard.this.page.getUserTextField().getText(), QNewWizard.this.page.getDate().getText(), QNewWizard.this.page.getPatchNameTextField().getText());
                monitor.worked(1);
                monitor.done();
            }
            catch (HgException e) {
                throw new InvocationTargetException((Throwable)((Object)e), e.getLocalizedMessage());
            }
        }
    }
}

