/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards.mq;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.operations.QImportOperation;
import com.vectrace.MercurialEclipse.views.PatchQueueView;
import com.vectrace.MercurialEclipse.wizards.HgWizard;
import com.vectrace.MercurialEclipse.wizards.mq.Messages;
import com.vectrace.MercurialEclipse.wizards.mq.QImportWizardPage;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;

public class QImportWizard
extends HgWizard {
    private QImportWizardPage page = null;
    private IResource resource;

    public QImportWizard(IResource resource) {
        super(Messages.getString("QImportWizard.title"));
        this.resource = resource;
        this.setNeedsProgressMonitor(true);
        this.page = new QImportWizardPage(Messages.getString("QImportWizard.pageName"), Messages.getString("QImportWizard.page.title"), Messages.getString("QImportWizard.page.description"), resource, null);
        this.initPage(this.page.getDescription(), this.page);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.page.setErrorMessage(null);
        ChangeSet[] changesets = this.page.getRevisions();
        Path patchFile = null;
        if (changesets == null) {
            if (this.page.getPatchFile().getText().length() == 0) {
                this.page.setErrorMessage(Messages.getString("QImportWizard.page.error.mustSelectChangesetOrFile"));
                return false;
            }
            patchFile = new Path(this.page.getPatchFile().getText());
            if (!patchFile.toFile().exists()) {
                this.page.setErrorMessage(Messages.getString("QImportWizard.page.error.patchFileNotExists"));
                return false;
            }
        }
        boolean existing = this.page.isExisting();
        boolean git = this.page.getGitCheckBox().getSelection();
        boolean force = this.page.getForceCheckBox().getSelection();
        QImportOperation impOperation = new QImportOperation((IRunnableContext)this.getContainer(), (IPath)patchFile, changesets, existing, git, force, this.resource);
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)impOperation);
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
            this.page.setErrorMessage(e.getLocalizedMessage());
            return false;
        }
        PatchQueueView.getView().populateTable();
        return true;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }
}

