/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgBranchClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.Branch;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.cache.IncomingChangesetCache;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import com.vectrace.MercurialEclipse.ui.ChangesetTable;
import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import com.vectrace.MercurialEclipse.wizards.ConfigurationWizardMainPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransplantPage
extends ConfigurationWizardMainPage {
    private IProject project;
    private final List<String> nodeIds = new ArrayList<String>();
    private boolean branch;
    private String branchName;
    private boolean all;
    private ChangesetTable changesetTable;
    private Button branchCheckBox;
    private Combo branchNameCombo;
    private Button allCheckBox;
    private final SortedSet<ChangeSet> changesets = new TreeSet(Collections.reverseOrder());

    public TransplantPage(String pageName, String title, ImageDescriptor titleImage, IProject project) {
        super(pageName, title, titleImage);
        this.project = project;
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite composite = (Composite)this.getControl();
        ModifyListener urlModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    HgRepositoryLocation repoLocation = MercurialEclipsePlugin.getRepoManager().getRepoLocation(TransplantPage.this.getUrlCombo().getText());
                    TransplantPage.this.setErrorMessage(null);
                    SortedSet<ChangeSet> changes = IncomingChangesetCache.getInstance().getIncomingChangeSets((IResource)TransplantPage.this.project, repoLocation);
                    TransplantPage.this.changesets.clear();
                    TransplantPage.this.changesets.addAll(changes);
                    TransplantPage.this.populateChangesetTable();
                }
                catch (HgException e1) {
                    TransplantPage.this.setErrorMessage(Messages.getString("TransplantPage.errorLoadChangesets"));
                    MercurialEclipsePlugin.logError((Throwable)((Object)e1));
                }
                catch (URISyntaxException e1) {
                    TransplantPage.this.setErrorMessage(e1.getLocalizedMessage());
                }
            }
        };
        this.getUrlCombo().addModifyListener(urlModifyListener);
        this.addBranchGroup(composite);
        this.addChangesetGroup(composite);
    }

    @Override
    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage();
    }

    private void validatePage() {
        boolean valid = true;
        if (this.branch) {
            valid &= this.branchName != null;
            if (!this.all) {
                valid &= this.nodeIds.size() > 0;
            }
        } else {
            valid &= this.nodeIds.size() > 0;
        }
        this.setPageComplete(valid);
    }

    private void addBranchGroup(Composite composite) {
        Group branchGroup = SWTWidgetHelper.createGroup(composite, Messages.getString("TransplantPage.branchGroup.title"));
        this.createBranchCheckBox(branchGroup);
        this.createAllCheckBox(branchGroup);
        this.createBranchNameCombo(branchGroup);
    }

    private void createBranchNameCombo(Group branchGroup) {
        SWTWidgetHelper.createLabel((Composite)branchGroup, Messages.getString("TransplantPage.branchLabel.title"));
        this.branchNameCombo = SWTWidgetHelper.createCombo((Composite)branchGroup);
        this.branchNameCombo.setEnabled(false);
        this.populateBranchNameCombo();
        SelectionListener branchNameComboListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransplantPage.this.branchName = TransplantPage.this.branchNameCombo.getText();
                if (TransplantPage.this.branchName.equals("default")) {
                    TransplantPage.this.branchName = "";
                }
                try {
                    TransplantPage.this.changesets.clear();
                    TransplantPage.this.changesets.addAll(LocalChangesetCache.getInstance().getLocalChangeSetsByBranch(TransplantPage.this.project, TransplantPage.this.branchName));
                    TransplantPage.this.populateChangesetTable();
                }
                catch (HgException e1) {
                    TransplantPage.this.setErrorMessage(Messages.getString("TransplantPage.errorLoadChangesets"));
                    MercurialEclipsePlugin.logError((Throwable)((Object)e1));
                }
                TransplantPage.this.validatePage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.branchNameCombo.addSelectionListener(branchNameComboListener);
    }

    private void createAllCheckBox(Group branchGroup) {
        this.allCheckBox = SWTWidgetHelper.createCheckBox((Composite)branchGroup, String.valueOf(Messages.getString("TransplantPage.allCheckBox.title.1")) + Messages.getString("TransplantPage.allCheckBox.title.2"));
        this.allCheckBox.setEnabled(false);
        SelectionListener allCheckBoxListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TransplantPage.this.all = TransplantPage.this.allCheckBox.getSelection();
                TransplantPage.this.validatePage();
            }
        };
        this.allCheckBox.addSelectionListener(allCheckBoxListener);
    }

    private void createBranchCheckBox(Group branchGroup) {
        this.branchCheckBox = SWTWidgetHelper.createCheckBox((Composite)branchGroup, Messages.getString("TransplantPage.branchCheckBox.title"));
        SelectionListener branchCheckBoxListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransplantPage.this.getUrlCombo().setEnabled(!TransplantPage.this.branchCheckBox.getSelection());
                TransplantPage.this.getUserCombo().setEnabled(!TransplantPage.this.branchCheckBox.getSelection());
                TransplantPage.this.getPasswordText().setEnabled(!TransplantPage.this.branchCheckBox.getSelection());
                TransplantPage.this.allCheckBox.setEnabled(TransplantPage.this.branchCheckBox.getSelection());
                TransplantPage.this.branchNameCombo.setEnabled(TransplantPage.this.branchCheckBox.getSelection());
                TransplantPage.this.branch = TransplantPage.this.branchCheckBox.getSelection();
                if (TransplantPage.this.branch) {
                    TransplantPage.this.changesets.clear();
                    TransplantPage.this.branchNameCombo.deselectAll();
                } else {
                    TransplantPage.this.changesets.clear();
                    TransplantPage.this.getUrlCombo().deselectAll();
                }
                TransplantPage.this.validatePage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.branchCheckBox.addSelectionListener(branchCheckBoxListener);
    }

    private void addChangesetGroup(Composite composite) {
        Group changeSetGroup = SWTWidgetHelper.createGroup(composite, Messages.getString("TransplantPage.changesetGroup.title"), 1808);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        gridData.minimumHeight = 50;
        this.changesetTable = new ChangesetTable((Composite)changeSetGroup, 68354, (IResource)this.project, false);
        this.changesetTable.setLayoutData(gridData);
        this.changesetTable.setEnabled(true);
        SelectionListener changeSetTableListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ChangeSet[] changeSets = TransplantPage.this.changesetTable.getSelections();
                ChangeSet last = changeSets[0];
                TransplantPage.this.setErrorMessage(null);
                TransplantPage.this.nodeIds.clear();
                ChangeSet[] changeSetArray = changeSets;
                int n = changeSets.length;
                int n2 = 0;
                while (n2 < n) {
                    ChangeSet changeSet = changeSetArray[n2];
                    if (Math.abs(changeSet.getChangesetIndex() - last.getChangesetIndex()) > 1) {
                        TransplantPage.this.setErrorMessage(Messages.getString("TransplantPage.errorNotSequential"));
                        TransplantPage.this.setPageComplete(false);
                        break;
                    }
                    TransplantPage.this.nodeIds.add(changeSet.getChangeset());
                    last = changeSet;
                    ++n2;
                }
                TransplantPage.this.validatePage();
            }
        };
        this.changesetTable.addSelectionListener(changeSetTableListener);
        this.populateChangesetTable();
    }

    private void populateBranchNameCombo() {
        try {
            Branch[] branches;
            Branch[] branchArray = branches = HgBranchClient.getBranches(this.project);
            int n = branches.length;
            int n2 = 0;
            while (n2 < n) {
                Branch myBranch = branchArray[n2];
                this.branchNameCombo.add(myBranch.getName());
                ++n2;
            }
        }
        catch (HgException e) {
            MercurialEclipsePlugin.showError((Throwable)((Object)e));
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
        }
    }

    private void populateChangesetTable() {
        this.changesetTable.setChangesets(this.changesets.toArray(new ChangeSet[this.changesets.size()]));
    }

    @Override
    public boolean finish(IProgressMonitor monitor) {
        return super.finish(monitor);
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public boolean isBranch() {
        return this.branch;
    }

    public List<String> getNodeIds() {
        return this.nodeIds;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public boolean isAll() {
        return this.all;
    }

    public SortedSet<ChangeSet> getChangesets() {
        return this.changesets;
    }
}

