/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.actions.HgOperation;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.cache.OutgoingChangesetCache;
import com.vectrace.MercurialEclipse.wizards.IncomingPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutgoingPage
extends IncomingPage {
    private boolean svn;

    protected OutgoingPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString("OutgoingPage.title"));
        this.setDescription(String.valueOf(Messages.getString("OutgoingPage.description1")) + Messages.getString("OutgoingPage.description2"));
    }

    @Override
    public void setChangesets(SortedSet<ChangeSet> outgoingInternal) {
        super.setChangesets(outgoingInternal);
    }

    @Override
    public SortedSet<ChangeSet> getChangesets() {
        return super.getChangesets();
    }

    @Override
    protected void getInputForPage() throws InvocationTargetException, InterruptedException {
        this.getContainer().run(true, false, (IRunnableWithProgress)new GetOutgoingOperation((IRunnableContext)this.getContainer()));
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getRevisionCheckBox().setText(Messages.getString("OutgoingPage.option.pushUpTo"));
    }

    @Override
    public boolean isSvn() {
        return this.svn;
    }

    @Override
    public void setSvn(boolean svn) {
        this.svn = svn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetOutgoingOperation
    extends HgOperation {
        public GetOutgoingOperation(IRunnableContext context) {
            super(context);
        }

        @Override
        protected String getActionDescription() {
            return Messages.getString("OutgoingPage.getOutgoingOperation.description");
        }

        @Override
        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.getString("OutgoingPage.getOutgoingOperation.beginTask"), 1);
            monitor.subTask(Messages.getString("OutgoingPage.getOutgoingOperation.call"));
            OutgoingPage.this.setChangesets(this.getOutgoingInternal());
            monitor.worked(1);
            monitor.done();
        }

        private SortedSet<ChangeSet> getOutgoingInternal() {
            if (OutgoingPage.this.isSvn()) {
                return new TreeSet<ChangeSet>();
            }
            HgRepositoryLocation remote = OutgoingPage.this.getLocation();
            try {
                SortedSet<ChangeSet> changesets = OutgoingChangesetCache.getInstance().getOutgoingChangeSets((IResource)OutgoingPage.this.getProject(), remote);
                TreeSet<ChangeSet> revertedSet = new TreeSet<ChangeSet>(Collections.reverseOrder());
                revertedSet.addAll(changesets);
                return revertedSet;
            }
            catch (HgException e) {
                MercurialEclipsePlugin.showError((Throwable)((Object)e));
                return new TreeSet<ChangeSet>();
            }
        }
    }
}

