/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.ui.LocationChooser;
import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import com.vectrace.MercurialEclipse.wizards.HgWizardPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ImportPage
extends HgWizardPage
implements Listener {
    private LocationChooser locationChooser;
    private Text txtProject;
    private final IProject project;

    public ImportPage(IProject project) {
        super(Messages.getString("ImportWizard.pageName"), Messages.getString("ImportWizard.pageTitle"), null);
        this.project = project;
    }

    protected boolean validatePage() {
        String msg = this.locationChooser.validate();
        if (msg == null && this.project == null) {
            msg = Messages.getString("ImportPage.InvalidProject");
        }
        if (msg == null) {
            this.setMessage(null);
        }
        this.setErrorMessage(msg);
        this.setPageComplete(msg == null);
        return msg == null;
    }

    public void createControl(Composite parent) {
        Composite composite = SWTWidgetHelper.createComposite(parent, 2);
        Group group = SWTWidgetHelper.createGroup(composite, Messages.getString("ExportWizard.PathLocation"), 2, 768);
        this.locationChooser = new LocationChooser((Composite)group, false, this.getDialogSettings());
        this.locationChooser.addStateListener(this);
        this.locationChooser.setLayoutData(new GridData(768));
        SWTWidgetHelper.createLabel(composite, Messages.getString("ImportPage.ProjectName"));
        this.txtProject = SWTWidgetHelper.createTextField(composite);
        this.txtProject.setEditable(false);
        if (this.project != null) {
            this.txtProject.setText(this.project.getName());
        }
        this.setControl((Control)composite);
        this.validatePage();
    }

    public void handleEvent(Event event) {
        this.validatePage();
    }

    public LocationChooser.Location getLocation() {
        return this.locationChooser.getCheckedLocation();
    }

    public boolean finish(IProgressMonitor monitor) {
        this.locationChooser.saveSettings();
        return super.finish(monitor);
    }
}

