/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.model.HgFolder;
import com.vectrace.MercurialEclipse.operations.CloneOperation;
import com.vectrace.MercurialEclipse.operations.CreateProjectOperation;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.cache.RefreshJob;
import com.vectrace.MercurialEclipse.wizards.ClonePage;
import com.vectrace.MercurialEclipse.wizards.HgWizard;
import com.vectrace.MercurialEclipse.wizards.Messages;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class CloneRepoWizard
extends HgWizard
implements IImportWizard {
    private ClonePage clonePage;

    public CloneRepoWizard() {
        super(Messages.getString("CloneRepoWizard.title"));
    }

    public boolean performFinish() {
        HgRepositoryLocation repo;
        this.clonePage.finish(null);
        this.clonePage.setErrorMessage(null);
        IResource res = null;
        try {
            repo = MercurialEclipsePlugin.getRepoManager().fromProperties(this.clonePage.getProperties());
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString("CloneRepoWizard.malformedURL"), (String)e.getMessage());
            return false;
        }
        String cloneName = this.clonePage.getCloneNameTextField().getText();
        if (cloneName.length() == 0) {
            cloneName = repo.getUri() != null ? repo.getUri().getFragment() : null;
        }
        if (cloneName != null && cloneName.length() > 0) {
            res = ResourcesPlugin.getWorkspace().getRoot().findMember(cloneName);
        }
        if (res != null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error occurred while cloning", (String)(String.valueOf(Messages.getString("CloneRepoWizard.project")) + res.getName() + Messages.getString("CloneRepoWizard.alreadyExists")));
            return false;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String parentDirectory = this.clonePage.getDirectoryTextField().getText();
        if (parentDirectory.length() == 0) {
            parentDirectory = workspaceRoot.getLocation().toOSString();
        }
        File parDirFile = new File(parentDirectory);
        final File[] filesBefore = parDirFile.listFiles();
        boolean forest = false;
        if (this.clonePage.isShowForest()) {
            forest = this.clonePage.getForestCheckBox().getSelection();
        }
        boolean svn = false;
        if (this.clonePage.isShowSvn()) {
            svn = this.clonePage.getSvnCheckBox().getSelection();
        }
        try {
            CloneOperation cloneOperation = new CloneOperation((IRunnableContext)this.getContainer(), parentDirectory, repo, this.clonePage.getNoUpdateCheckBox().getSelection(), this.clonePage.getPullCheckBox().getSelection(), this.clonePage.getUncompressedCheckBox().getSelection(), this.clonePage.getTimeoutCheckBox().getSelection(), this.clonePage.getRevisionTextField().getText(), cloneName, forest, svn);
            this.getContainer().run(true, false, (IRunnableWithProgress)cloneOperation);
            File cloneDirectory = null;
            FileFilter filter = new FileFilter(){

                public boolean accept(File pathname) {
                    if (pathname.isFile()) {
                        return false;
                    }
                    boolean newFile = true;
                    File[] fileArray = filesBefore;
                    int n = filesBefore.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block5: {
                            File file = fileArray[n2];
                            try {
                                if (file.getCanonicalPath().equals(pathname.getCanonicalPath())) {
                                    newFile = false;
                                }
                                break block5;
                            }
                            catch (IOException e) {
                                MercurialEclipsePlugin.logError(e);
                                newFile = false;
                            }
                            break;
                        }
                        ++n2;
                    }
                    return newFile;
                }
            };
            File[] filesAfter = new File(parentDirectory).listFiles(filter);
            cloneDirectory = filesAfter[0];
            cloneName = cloneDirectory.getName();
            List<File> projectFiles = null;
            if (this.clonePage.getSearchProjectFilesCheckBox().getSelection()) {
                HgFolder folder = new HgFolder(cloneDirectory.getCanonicalPath());
                projectFiles = folder.getProjectFiles();
            }
            if (projectFiles == null || projectFiles.size() == 0) {
                CreateProjectOperation op = new CreateProjectOperation((IRunnableContext)this.getContainer(), cloneDirectory, null, repo, false, cloneName);
                this.getContainer().run(true, false, (IRunnableWithProgress)op);
                new RefreshJob(Messages.getString("CloneRepoWizard.refreshJob.name"), op.getProject()).schedule();
            } else {
                for (File file : projectFiles) {
                    CreateProjectOperation op = new CreateProjectOperation((IRunnableContext)this.getContainer(), file.getParentFile(), file, repo, true, null);
                    this.getContainer().run(true, false, (IRunnableWithProgress)op);
                    new RefreshJob(Messages.getString("CloneRepoWizard.refreshJob.name"), op.getProject()).schedule();
                }
            }
        }
        catch (InvocationTargetException e) {
            return this.handle(e);
        }
        catch (InterruptedException e) {
            return this.handle(e);
        }
        catch (IOException e) {
            return this.handle(e);
        }
        catch (CoreException e) {
            return this.handle((Exception)((Object)e));
        }
        return true;
    }

    private boolean handle(Exception e) {
        if (e.getCause() != null) {
            this.clonePage.setErrorMessage(e.getCause().getLocalizedMessage());
        } else {
            this.clonePage.setErrorMessage(e.getLocalizedMessage());
        }
        MercurialEclipsePlugin.logError(Messages.getString("CloneRepoWizard.cloneOperationFailed"), e);
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.getString("CloneRepoWizard.title"));
        this.setNeedsProgressMonitor(true);
        this.clonePage = new ClonePage(null, Messages.getString("CloneRepoWizard.pageName"), Messages.getString("CloneRepoWizard.pageTitle"), null);
        this.clonePage.setDescription(Messages.getString("CloneRepoWizard.pageDescription"));
        this.initPage(this.clonePage.getDescription(), this.clonePage);
        this.addPage((IWizardPage)this.clonePage);
    }
}

